// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// Billing20201105StatementResource Resource contains the running usage of a single resource, including all
// the line items from it.
//
// swagger:model billing_20201105StatementResource
type Billing20201105StatementResource struct {

	// active_from is the timestamp of when the billed resource became active.
	// Format: date-time
	ActiveFrom strfmt.DateTime `json:"active_from,omitempty"`

	// active_until is the timestamp of when the billed resource became inactive.
	// Format: date-time
	ActiveUntil strfmt.DateTime `json:"active_until,omitempty"`

	// amount is the sum of the amount of all line items.
	Amount string `json:"amount,omitempty"`

	// common_resource_attributes contains all the attributes that are
	// common to all the resource's line items.
	CommonResourceAttributes map[string]string `json:"common_resource_attributes,omitempty"`

	// fcp contains flexible consumption specific properties.
	FlexibleConsumptionMetadata *StatementResourceFlexibleConsumptionMetadata `json:"flexible_consumption_metadata,omitempty"`

	// geo defines on which geography the control-plane for this resource exists.
	Geo *Billing20201105Geo `json:"geo,omitempty"`

	// line_items is the list of line items as they would appear on an invoice.
	LineItems []*StatementResourceLineItem `json:"line_items"`

	// resource is a link to the Resource for which this line item charges.
	ResourceLink *LocationLink `json:"resource_link,omitempty"`
}

// Validate validates this billing 20201105 statement resource
func (m *Billing20201105StatementResource) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateActiveFrom(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateActiveUntil(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateFlexibleConsumptionMetadata(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateGeo(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLineItems(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateResourceLink(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *Billing20201105StatementResource) validateActiveFrom(formats strfmt.Registry) error {
	if swag.IsZero(m.ActiveFrom) { // not required
		return nil
	}

	if err := validate.FormatOf("active_from", "body", "date-time", m.ActiveFrom.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *Billing20201105StatementResource) validateActiveUntil(formats strfmt.Registry) error {
	if swag.IsZero(m.ActiveUntil) { // not required
		return nil
	}

	if err := validate.FormatOf("active_until", "body", "date-time", m.ActiveUntil.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *Billing20201105StatementResource) validateFlexibleConsumptionMetadata(formats strfmt.Registry) error {
	if swag.IsZero(m.FlexibleConsumptionMetadata) { // not required
		return nil
	}

	if m.FlexibleConsumptionMetadata != nil {
		if err := m.FlexibleConsumptionMetadata.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("flexible_consumption_metadata")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("flexible_consumption_metadata")
			}
			return err
		}
	}

	return nil
}

func (m *Billing20201105StatementResource) validateGeo(formats strfmt.Registry) error {
	if swag.IsZero(m.Geo) { // not required
		return nil
	}

	if m.Geo != nil {
		if err := m.Geo.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("geo")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("geo")
			}
			return err
		}
	}

	return nil
}

func (m *Billing20201105StatementResource) validateLineItems(formats strfmt.Registry) error {
	if swag.IsZero(m.LineItems) { // not required
		return nil
	}

	for i := 0; i < len(m.LineItems); i++ {
		if swag.IsZero(m.LineItems[i]) { // not required
			continue
		}

		if m.LineItems[i] != nil {
			if err := m.LineItems[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("line_items" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("line_items" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *Billing20201105StatementResource) validateResourceLink(formats strfmt.Registry) error {
	if swag.IsZero(m.ResourceLink) { // not required
		return nil
	}

	if m.ResourceLink != nil {
		if err := m.ResourceLink.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("resource_link")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("resource_link")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this billing 20201105 statement resource based on the context it is used
func (m *Billing20201105StatementResource) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateFlexibleConsumptionMetadata(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateGeo(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLineItems(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateResourceLink(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *Billing20201105StatementResource) contextValidateFlexibleConsumptionMetadata(ctx context.Context, formats strfmt.Registry) error {

	if m.FlexibleConsumptionMetadata != nil {

		if swag.IsZero(m.FlexibleConsumptionMetadata) { // not required
			return nil
		}

		if err := m.FlexibleConsumptionMetadata.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("flexible_consumption_metadata")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("flexible_consumption_metadata")
			}
			return err
		}
	}

	return nil
}

func (m *Billing20201105StatementResource) contextValidateGeo(ctx context.Context, formats strfmt.Registry) error {

	if m.Geo != nil {

		if swag.IsZero(m.Geo) { // not required
			return nil
		}

		if err := m.Geo.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("geo")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("geo")
			}
			return err
		}
	}

	return nil
}

func (m *Billing20201105StatementResource) contextValidateLineItems(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.LineItems); i++ {

		if m.LineItems[i] != nil {

			if swag.IsZero(m.LineItems[i]) { // not required
				return nil
			}

			if err := m.LineItems[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("line_items" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("line_items" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *Billing20201105StatementResource) contextValidateResourceLink(ctx context.Context, formats strfmt.Registry) error {

	if m.ResourceLink != nil {

		if swag.IsZero(m.ResourceLink) { // not required
			return nil
		}

		if err := m.ResourceLink.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("resource_link")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("resource_link")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *Billing20201105StatementResource) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *Billing20201105StatementResource) UnmarshalBinary(b []byte) error {
	var res Billing20201105StatementResource
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
