// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// HashicorpCloudWebhookWebhookRequest The information about the request made to deliver an event payload.
//
// swagger:model hashicorp.cloud.webhook.WebhookRequest
type HashicorpCloudWebhookWebhookRequest struct {

	// The request headers.
	Headers map[string]string `json:"headers,omitempty"`

	// The request body.
	Payload *HashicorpCloudWebhookWebhookPayload `json:"payload,omitempty"`

	// The UTC time the request was sent.
	// Format: date-time
	SentAt strfmt.DateTime `json:"sent_at,omitempty"`

	// The request's destination URL.
	URL string `json:"url,omitempty"`
}

// Validate validates this hashicorp cloud webhook webhook request
func (m *HashicorpCloudWebhookWebhookRequest) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validatePayload(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSentAt(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpCloudWebhookWebhookRequest) validatePayload(formats strfmt.Registry) error {
	if swag.IsZero(m.Payload) { // not required
		return nil
	}

	if m.Payload != nil {
		if err := m.Payload.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("payload")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("payload")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpCloudWebhookWebhookRequest) validateSentAt(formats strfmt.Registry) error {
	if swag.IsZero(m.SentAt) { // not required
		return nil
	}

	if err := validate.FormatOf("sent_at", "body", "date-time", m.SentAt.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this hashicorp cloud webhook webhook request based on the context it is used
func (m *HashicorpCloudWebhookWebhookRequest) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidatePayload(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpCloudWebhookWebhookRequest) contextValidatePayload(ctx context.Context, formats strfmt.Registry) error {

	if m.Payload != nil {

		if swag.IsZero(m.Payload) { // not required
			return nil
		}

		if err := m.Payload.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("payload")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("payload")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *HashicorpCloudWebhookWebhookRequest) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *HashicorpCloudWebhookWebhookRequest) UnmarshalBinary(b []byte) error {
	var res HashicorpCloudWebhookWebhookRequest
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
