// Code generated by go-swagger; DO NOT EDIT.

package waypoint_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
	"github.com/hashicorp/hcp-sdk-go/clients/cloud-waypoint-service/preview/2023-08-18/models"
)

// WaypointServiceRetrieveAgentOperationReader is a Reader for the WaypointServiceRetrieveAgentOperation structure.
type WaypointServiceRetrieveAgentOperationReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *WaypointServiceRetrieveAgentOperationReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewWaypointServiceRetrieveAgentOperationOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewWaypointServiceRetrieveAgentOperationDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewWaypointServiceRetrieveAgentOperationOK creates a WaypointServiceRetrieveAgentOperationOK with default headers values
func NewWaypointServiceRetrieveAgentOperationOK() *WaypointServiceRetrieveAgentOperationOK {
	return &WaypointServiceRetrieveAgentOperationOK{}
}

/*
WaypointServiceRetrieveAgentOperationOK describes a response with status code 200, with default header values.

A successful response.
*/
type WaypointServiceRetrieveAgentOperationOK struct {
	Payload *models.HashicorpCloudWaypointRetrieveAgentOperationResponse
}

// IsSuccess returns true when this waypoint service retrieve agent operation o k response has a 2xx status code
func (o *WaypointServiceRetrieveAgentOperationOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this waypoint service retrieve agent operation o k response has a 3xx status code
func (o *WaypointServiceRetrieveAgentOperationOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this waypoint service retrieve agent operation o k response has a 4xx status code
func (o *WaypointServiceRetrieveAgentOperationOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this waypoint service retrieve agent operation o k response has a 5xx status code
func (o *WaypointServiceRetrieveAgentOperationOK) IsServerError() bool {
	return false
}

// IsCode returns true when this waypoint service retrieve agent operation o k response a status code equal to that given
func (o *WaypointServiceRetrieveAgentOperationOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the waypoint service retrieve agent operation o k response
func (o *WaypointServiceRetrieveAgentOperationOK) Code() int {
	return 200
}

func (o *WaypointServiceRetrieveAgentOperationOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /waypoint/2023-08-18/namespace/{namespace.id}/agent/operation:retrieve][%d] waypointServiceRetrieveAgentOperationOK %s", 200, payload)
}

func (o *WaypointServiceRetrieveAgentOperationOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /waypoint/2023-08-18/namespace/{namespace.id}/agent/operation:retrieve][%d] waypointServiceRetrieveAgentOperationOK %s", 200, payload)
}

func (o *WaypointServiceRetrieveAgentOperationOK) GetPayload() *models.HashicorpCloudWaypointRetrieveAgentOperationResponse {
	return o.Payload
}

func (o *WaypointServiceRetrieveAgentOperationOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpCloudWaypointRetrieveAgentOperationResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewWaypointServiceRetrieveAgentOperationDefault creates a WaypointServiceRetrieveAgentOperationDefault with default headers values
func NewWaypointServiceRetrieveAgentOperationDefault(code int) *WaypointServiceRetrieveAgentOperationDefault {
	return &WaypointServiceRetrieveAgentOperationDefault{
		_statusCode: code,
	}
}

/*
WaypointServiceRetrieveAgentOperationDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type WaypointServiceRetrieveAgentOperationDefault struct {
	_statusCode int

	Payload *cloud.GoogleRPCStatus
}

// IsSuccess returns true when this waypoint service retrieve agent operation default response has a 2xx status code
func (o *WaypointServiceRetrieveAgentOperationDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this waypoint service retrieve agent operation default response has a 3xx status code
func (o *WaypointServiceRetrieveAgentOperationDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this waypoint service retrieve agent operation default response has a 4xx status code
func (o *WaypointServiceRetrieveAgentOperationDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this waypoint service retrieve agent operation default response has a 5xx status code
func (o *WaypointServiceRetrieveAgentOperationDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this waypoint service retrieve agent operation default response a status code equal to that given
func (o *WaypointServiceRetrieveAgentOperationDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the waypoint service retrieve agent operation default response
func (o *WaypointServiceRetrieveAgentOperationDefault) Code() int {
	return o._statusCode
}

func (o *WaypointServiceRetrieveAgentOperationDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /waypoint/2023-08-18/namespace/{namespace.id}/agent/operation:retrieve][%d] WaypointService_RetrieveAgentOperation default %s", o._statusCode, payload)
}

func (o *WaypointServiceRetrieveAgentOperationDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /waypoint/2023-08-18/namespace/{namespace.id}/agent/operation:retrieve][%d] WaypointService_RetrieveAgentOperation default %s", o._statusCode, payload)
}

func (o *WaypointServiceRetrieveAgentOperationDefault) GetPayload() *cloud.GoogleRPCStatus {
	return o.Payload
}

func (o *WaypointServiceRetrieveAgentOperationDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GoogleRPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
