// Code generated by go-swagger; DO NOT EDIT.

package secret_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-vault-secrets/stable/2023-11-28/models"
)

// GetRandomIntegrationReader is a Reader for the GetRandomIntegration structure.
type GetRandomIntegrationReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GetRandomIntegrationReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGetRandomIntegrationOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewGetRandomIntegrationDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewGetRandomIntegrationOK creates a GetRandomIntegrationOK with default headers values
func NewGetRandomIntegrationOK() *GetRandomIntegrationOK {
	return &GetRandomIntegrationOK{}
}

/*
GetRandomIntegrationOK describes a response with status code 200, with default header values.

A successful response.
*/
type GetRandomIntegrationOK struct {
	Payload *models.Secrets20231128GetRandomIntegrationResponse
}

// IsSuccess returns true when this get random integration o k response has a 2xx status code
func (o *GetRandomIntegrationOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get random integration o k response has a 3xx status code
func (o *GetRandomIntegrationOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get random integration o k response has a 4xx status code
func (o *GetRandomIntegrationOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this get random integration o k response has a 5xx status code
func (o *GetRandomIntegrationOK) IsServerError() bool {
	return false
}

// IsCode returns true when this get random integration o k response a status code equal to that given
func (o *GetRandomIntegrationOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the get random integration o k response
func (o *GetRandomIntegrationOK) Code() int {
	return 200
}

func (o *GetRandomIntegrationOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/integrations/random/config/{name}][%d] getRandomIntegrationOK %s", 200, payload)
}

func (o *GetRandomIntegrationOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/integrations/random/config/{name}][%d] getRandomIntegrationOK %s", 200, payload)
}

func (o *GetRandomIntegrationOK) GetPayload() *models.Secrets20231128GetRandomIntegrationResponse {
	return o.Payload
}

func (o *GetRandomIntegrationOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Secrets20231128GetRandomIntegrationResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetRandomIntegrationDefault creates a GetRandomIntegrationDefault with default headers values
func NewGetRandomIntegrationDefault(code int) *GetRandomIntegrationDefault {
	return &GetRandomIntegrationDefault{
		_statusCode: code,
	}
}

/*
GetRandomIntegrationDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type GetRandomIntegrationDefault struct {
	_statusCode int

	Payload *models.GooglerpcStatus
}

// IsSuccess returns true when this get random integration default response has a 2xx status code
func (o *GetRandomIntegrationDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this get random integration default response has a 3xx status code
func (o *GetRandomIntegrationDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this get random integration default response has a 4xx status code
func (o *GetRandomIntegrationDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this get random integration default response has a 5xx status code
func (o *GetRandomIntegrationDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this get random integration default response a status code equal to that given
func (o *GetRandomIntegrationDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the get random integration default response
func (o *GetRandomIntegrationDefault) Code() int {
	return o._statusCode
}

func (o *GetRandomIntegrationDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/integrations/random/config/{name}][%d] GetRandomIntegration default %s", o._statusCode, payload)
}

func (o *GetRandomIntegrationDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/integrations/random/config/{name}][%d] GetRandomIntegration default %s", o._statusCode, payload)
}

func (o *GetRandomIntegrationDefault) GetPayload() *models.GooglerpcStatus {
	return o.Payload
}

func (o *GetRandomIntegrationDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.GooglerpcStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
