// Code generated by go-swagger; DO NOT EDIT.

package registry_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewListArchitecturesParams creates a new ListArchitecturesParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewListArchitecturesParams() *ListArchitecturesParams {
	return &ListArchitecturesParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewListArchitecturesParamsWithTimeout creates a new ListArchitecturesParams object
// with the ability to set a timeout on a request.
func NewListArchitecturesParamsWithTimeout(timeout time.Duration) *ListArchitecturesParams {
	return &ListArchitecturesParams{
		timeout: timeout,
	}
}

// NewListArchitecturesParamsWithContext creates a new ListArchitecturesParams object
// with the ability to set a context for a request.
func NewListArchitecturesParamsWithContext(ctx context.Context) *ListArchitecturesParams {
	return &ListArchitecturesParams{
		Context: ctx,
	}
}

// NewListArchitecturesParamsWithHTTPClient creates a new ListArchitecturesParams object
// with the ability to set a custom HTTPClient for a request.
func NewListArchitecturesParamsWithHTTPClient(client *http.Client) *ListArchitecturesParams {
	return &ListArchitecturesParams{
		HTTPClient: client,
	}
}

/*
ListArchitecturesParams contains all the parameters to send to the API endpoint

	for the list architectures operation.

	Typically these are written to a http.Request.
*/
type ListArchitecturesParams struct {

	/* Box.

	     The name segment of the Box. As an example, this field would represent the
	"vagrant" in "hashicorp/vagrant".
	*/
	Box string

	/* PaginationNextPageToken.

	     Specifies a page token to use to retrieve the next page. Set this to the
	`next_page_token` returned by previous list requests to get the next page of
	results. If set, `previous_page_token` must not be set.
	*/
	PaginationNextPageToken *string

	/* PaginationPageSize.

	     The max number of results per page that should be returned. If the number
	of available results is larger than `page_size`, a `next_page_token` is
	returned which can be used to get the next page of results in subsequent
	requests. A value of zero will cause `page_size` to be defaulted.

	     Format: int64
	*/
	PaginationPageSize *int64

	/* PaginationPreviousPageToken.

	     Specifies a page token to use to retrieve the previous page. Set this to
	the `previous_page_token` returned by previous list requests to get the
	previous page of results. If set, `next_page_token` must not be set.
	*/
	PaginationPreviousPageToken *string

	/* Provider.

	   The name of the Provider to look up Architectures in.
	*/
	Provider string

	/* Registry.

	     The Registry segment of the Box. As an example, this field would represent
	the "hashicorp" in "hashicorp/vagrant".
	*/
	Registry string

	/* Version.

	   The name of the Version.
	*/
	Version string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the list architectures params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ListArchitecturesParams) WithDefaults() *ListArchitecturesParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the list architectures params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ListArchitecturesParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the list architectures params
func (o *ListArchitecturesParams) WithTimeout(timeout time.Duration) *ListArchitecturesParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the list architectures params
func (o *ListArchitecturesParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the list architectures params
func (o *ListArchitecturesParams) WithContext(ctx context.Context) *ListArchitecturesParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the list architectures params
func (o *ListArchitecturesParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the list architectures params
func (o *ListArchitecturesParams) WithHTTPClient(client *http.Client) *ListArchitecturesParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the list architectures params
func (o *ListArchitecturesParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBox adds the box to the list architectures params
func (o *ListArchitecturesParams) WithBox(box string) *ListArchitecturesParams {
	o.SetBox(box)
	return o
}

// SetBox adds the box to the list architectures params
func (o *ListArchitecturesParams) SetBox(box string) {
	o.Box = box
}

// WithPaginationNextPageToken adds the paginationNextPageToken to the list architectures params
func (o *ListArchitecturesParams) WithPaginationNextPageToken(paginationNextPageToken *string) *ListArchitecturesParams {
	o.SetPaginationNextPageToken(paginationNextPageToken)
	return o
}

// SetPaginationNextPageToken adds the paginationNextPageToken to the list architectures params
func (o *ListArchitecturesParams) SetPaginationNextPageToken(paginationNextPageToken *string) {
	o.PaginationNextPageToken = paginationNextPageToken
}

// WithPaginationPageSize adds the paginationPageSize to the list architectures params
func (o *ListArchitecturesParams) WithPaginationPageSize(paginationPageSize *int64) *ListArchitecturesParams {
	o.SetPaginationPageSize(paginationPageSize)
	return o
}

// SetPaginationPageSize adds the paginationPageSize to the list architectures params
func (o *ListArchitecturesParams) SetPaginationPageSize(paginationPageSize *int64) {
	o.PaginationPageSize = paginationPageSize
}

// WithPaginationPreviousPageToken adds the paginationPreviousPageToken to the list architectures params
func (o *ListArchitecturesParams) WithPaginationPreviousPageToken(paginationPreviousPageToken *string) *ListArchitecturesParams {
	o.SetPaginationPreviousPageToken(paginationPreviousPageToken)
	return o
}

// SetPaginationPreviousPageToken adds the paginationPreviousPageToken to the list architectures params
func (o *ListArchitecturesParams) SetPaginationPreviousPageToken(paginationPreviousPageToken *string) {
	o.PaginationPreviousPageToken = paginationPreviousPageToken
}

// WithProvider adds the provider to the list architectures params
func (o *ListArchitecturesParams) WithProvider(provider string) *ListArchitecturesParams {
	o.SetProvider(provider)
	return o
}

// SetProvider adds the provider to the list architectures params
func (o *ListArchitecturesParams) SetProvider(provider string) {
	o.Provider = provider
}

// WithRegistry adds the registry to the list architectures params
func (o *ListArchitecturesParams) WithRegistry(registry string) *ListArchitecturesParams {
	o.SetRegistry(registry)
	return o
}

// SetRegistry adds the registry to the list architectures params
func (o *ListArchitecturesParams) SetRegistry(registry string) {
	o.Registry = registry
}

// WithVersion adds the version to the list architectures params
func (o *ListArchitecturesParams) WithVersion(version string) *ListArchitecturesParams {
	o.SetVersion(version)
	return o
}

// SetVersion adds the version to the list architectures params
func (o *ListArchitecturesParams) SetVersion(version string) {
	o.Version = version
}

// WriteToRequest writes these params to a swagger request
func (o *ListArchitecturesParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param box
	if err := r.SetPathParam("box", o.Box); err != nil {
		return err
	}

	if o.PaginationNextPageToken != nil {

		// query param pagination.next_page_token
		var qrPaginationNextPageToken string

		if o.PaginationNextPageToken != nil {
			qrPaginationNextPageToken = *o.PaginationNextPageToken
		}
		qPaginationNextPageToken := qrPaginationNextPageToken
		if qPaginationNextPageToken != "" {

			if err := r.SetQueryParam("pagination.next_page_token", qPaginationNextPageToken); err != nil {
				return err
			}
		}
	}

	if o.PaginationPageSize != nil {

		// query param pagination.page_size
		var qrPaginationPageSize int64

		if o.PaginationPageSize != nil {
			qrPaginationPageSize = *o.PaginationPageSize
		}
		qPaginationPageSize := swag.FormatInt64(qrPaginationPageSize)
		if qPaginationPageSize != "" {

			if err := r.SetQueryParam("pagination.page_size", qPaginationPageSize); err != nil {
				return err
			}
		}
	}

	if o.PaginationPreviousPageToken != nil {

		// query param pagination.previous_page_token
		var qrPaginationPreviousPageToken string

		if o.PaginationPreviousPageToken != nil {
			qrPaginationPreviousPageToken = *o.PaginationPreviousPageToken
		}
		qPaginationPreviousPageToken := qrPaginationPreviousPageToken
		if qPaginationPreviousPageToken != "" {

			if err := r.SetQueryParam("pagination.previous_page_token", qPaginationPreviousPageToken); err != nil {
				return err
			}
		}
	}

	// path param provider
	if err := r.SetPathParam("provider", o.Provider); err != nil {
		return err
	}

	// path param registry
	if err := r.SetPathParam("registry", o.Registry); err != nil {
		return err
	}

	// path param version
	if err := r.SetPathParam("version", o.Version); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
