// Code generated by go-swagger; DO NOT EDIT.

package s_s_o_management_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"github.com/go-openapi/runtime"
	httptransport "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// New creates a new s s o management service API client.
func New(transport runtime.ClientTransport, formats strfmt.Registry) ClientService {
	return &Client{transport: transport, formats: formats}
}

// New creates a new s s o management service API client with basic auth credentials.
// It takes the following parameters:
// - host: http host (github.com).
// - basePath: any base path for the API client ("/v1", "/v3").
// - scheme: http scheme ("http", "https").
// - user: user for basic authentication header.
// - password: password for basic authentication header.
func NewClientWithBasicAuth(host, basePath, scheme, user, password string) ClientService {
	transport := httptransport.New(host, basePath, []string{scheme})
	transport.DefaultAuthentication = httptransport.BasicAuth(user, password)
	return &Client{transport: transport, formats: strfmt.Default}
}

// New creates a new s s o management service API client with a bearer token for authentication.
// It takes the following parameters:
// - host: http host (github.com).
// - basePath: any base path for the API client ("/v1", "/v3").
// - scheme: http scheme ("http", "https").
// - bearerToken: bearer token for Bearer authentication header.
func NewClientWithBearerToken(host, basePath, scheme, bearerToken string) ClientService {
	transport := httptransport.New(host, basePath, []string{scheme})
	transport.DefaultAuthentication = httptransport.BearerToken(bearerToken)
	return &Client{transport: transport, formats: strfmt.Default}
}

/*
Client for s s o management service API
*/
type Client struct {
	transport runtime.ClientTransport
	formats   strfmt.Registry
}

// ClientOption may be used to customize the behavior of Client methods.
type ClientOption func(*runtime.ClientOperation)

// ClientService is the interface for Client methods
type ClientService interface {
	SSOManagementServiceCreateSSOConfiguration(params *SSOManagementServiceCreateSSOConfigurationParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SSOManagementServiceCreateSSOConfigurationOK, error)

	SSOManagementServiceDeleteSSOConfiguration(params *SSOManagementServiceDeleteSSOConfigurationParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SSOManagementServiceDeleteSSOConfigurationOK, error)

	SSOManagementServiceGetPreconfigurationData(params *SSOManagementServiceGetPreconfigurationDataParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SSOManagementServiceGetPreconfigurationDataOK, error)

	SSOManagementServiceGetSSOConfiguration(params *SSOManagementServiceGetSSOConfigurationParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SSOManagementServiceGetSSOConfigurationOK, error)

	SSOManagementServiceGetSSOType(params *SSOManagementServiceGetSSOTypeParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SSOManagementServiceGetSSOTypeOK, error)

	SSOManagementServiceListSSOConfigurations(params *SSOManagementServiceListSSOConfigurationsParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SSOManagementServiceListSSOConfigurationsOK, error)

	SSOManagementServiceUpdateSSOConfiguration(params *SSOManagementServiceUpdateSSOConfigurationParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SSOManagementServiceUpdateSSOConfigurationOK, error)

	SSOManagementServiceVerifyDomainOwnership(params *SSOManagementServiceVerifyDomainOwnershipParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SSOManagementServiceVerifyDomainOwnershipOK, error)

	SSOManagementServiceVerifySSODomainOwnership(params *SSOManagementServiceVerifySSODomainOwnershipParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SSOManagementServiceVerifySSODomainOwnershipOK, error)

	SetTransport(transport runtime.ClientTransport)
}

/*
SSOManagementServiceCreateSSOConfiguration creates s s o configuration creates a new s s o configuration for an organization
*/
func (a *Client) SSOManagementServiceCreateSSOConfiguration(params *SSOManagementServiceCreateSSOConfigurationParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SSOManagementServiceCreateSSOConfigurationOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSSOManagementServiceCreateSSOConfigurationParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "SSOManagementService_CreateSSOConfiguration",
		Method:             "POST",
		PathPattern:        "/iam/2019-12-10/organizations/{organization_id}/sso-configurations",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &SSOManagementServiceCreateSSOConfigurationReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SSOManagementServiceCreateSSOConfigurationOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SSOManagementServiceCreateSSOConfigurationDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
SSOManagementServiceDeleteSSOConfiguration deletes s s o configuration deletes an existing s s o configuration
*/
func (a *Client) SSOManagementServiceDeleteSSOConfiguration(params *SSOManagementServiceDeleteSSOConfigurationParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SSOManagementServiceDeleteSSOConfigurationOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSSOManagementServiceDeleteSSOConfigurationParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "SSOManagementService_DeleteSSOConfiguration",
		Method:             "DELETE",
		PathPattern:        "/iam/2019-12-10/organizations/{organization_id}/sso-configurations/{type}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &SSOManagementServiceDeleteSSOConfigurationReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SSOManagementServiceDeleteSSOConfigurationOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SSOManagementServiceDeleteSSOConfigurationDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
SSOManagementServiceGetPreconfigurationData gets preconfiguration data returns data needed prior to an s s o configuration being created
*/
func (a *Client) SSOManagementServiceGetPreconfigurationData(params *SSOManagementServiceGetPreconfigurationDataParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SSOManagementServiceGetPreconfigurationDataOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSSOManagementServiceGetPreconfigurationDataParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "SSOManagementService_GetPreconfigurationData",
		Method:             "GET",
		PathPattern:        "/iam/2019-12-10/organizations/{organization_id}/sso-preconfiguration-data",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &SSOManagementServiceGetPreconfigurationDataReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SSOManagementServiceGetPreconfigurationDataOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SSOManagementServiceGetPreconfigurationDataDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
SSOManagementServiceGetSSOConfiguration gets s s o configuration retrieves a specific s s o configuration for an organization
*/
func (a *Client) SSOManagementServiceGetSSOConfiguration(params *SSOManagementServiceGetSSOConfigurationParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SSOManagementServiceGetSSOConfigurationOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSSOManagementServiceGetSSOConfigurationParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "SSOManagementService_GetSSOConfiguration",
		Method:             "GET",
		PathPattern:        "/iam/2019-12-10/organizations/{organization_id}/sso-configurations/{type}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &SSOManagementServiceGetSSOConfigurationReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SSOManagementServiceGetSSOConfigurationOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SSOManagementServiceGetSSOConfigurationDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
SSOManagementServiceGetSSOType gets s s o type returns the type of s s o that is configured for an organization
*/
func (a *Client) SSOManagementServiceGetSSOType(params *SSOManagementServiceGetSSOTypeParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SSOManagementServiceGetSSOTypeOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSSOManagementServiceGetSSOTypeParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "SSOManagementService_GetSSOType",
		Method:             "GET",
		PathPattern:        "/iam/2019-12-10/organizations/{organization_id}/sso-type",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &SSOManagementServiceGetSSOTypeReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SSOManagementServiceGetSSOTypeOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SSOManagementServiceGetSSOTypeDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
SSOManagementServiceListSSOConfigurations lists s s o configurations retrieves the s s o configurations for an organization
*/
func (a *Client) SSOManagementServiceListSSOConfigurations(params *SSOManagementServiceListSSOConfigurationsParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SSOManagementServiceListSSOConfigurationsOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSSOManagementServiceListSSOConfigurationsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "SSOManagementService_ListSSOConfigurations",
		Method:             "GET",
		PathPattern:        "/iam/2019-12-10/organizations/{organization_id}/sso-configurations",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &SSOManagementServiceListSSOConfigurationsReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SSOManagementServiceListSSOConfigurationsOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SSOManagementServiceListSSOConfigurationsDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
SSOManagementServiceUpdateSSOConfiguration updates s s o configuration updates an existing s s o configuration
*/
func (a *Client) SSOManagementServiceUpdateSSOConfiguration(params *SSOManagementServiceUpdateSSOConfigurationParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SSOManagementServiceUpdateSSOConfigurationOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSSOManagementServiceUpdateSSOConfigurationParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "SSOManagementService_UpdateSSOConfiguration",
		Method:             "PUT",
		PathPattern:        "/iam/2019-12-10/organizations/{organization_id}/sso-configurations/{type}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &SSOManagementServiceUpdateSSOConfigurationReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SSOManagementServiceUpdateSSOConfigurationOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SSOManagementServiceUpdateSSOConfigurationDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SSOManagementServiceVerifyDomainOwnership verifies domain ownership checks whether the organization has proven their ownership control of the given domain by adding the required t x t record

	It is intended to be used to provide early feedback to the user; we check

ownership "for real" in CreateSSOConfiguration and UpdateSSOConfiguration.
*/
func (a *Client) SSOManagementServiceVerifyDomainOwnership(params *SSOManagementServiceVerifyDomainOwnershipParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SSOManagementServiceVerifyDomainOwnershipOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSSOManagementServiceVerifyDomainOwnershipParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "SSOManagementService_VerifyDomainOwnership",
		Method:             "POST",
		PathPattern:        "/iam/2019-12-10/organizations/{organization_id}/verify-domain-ownership",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &SSOManagementServiceVerifyDomainOwnershipReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SSOManagementServiceVerifyDomainOwnershipOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SSOManagementServiceVerifyDomainOwnershipDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SSOManagementServiceVerifySSODomainOwnership verifies s s o domain ownership checks whether the organization has proven their ownership control of the given domain by adding the required t x t record

	This endpoint differs from the one above because it is intended to be used

for HashiCorp SSO domain ownership verification and not Auth0 SAML SSO. It
is intended to be used to provide early feedback to the user; we check
domain ownership in cloud-idp.
*/
func (a *Client) SSOManagementServiceVerifySSODomainOwnership(params *SSOManagementServiceVerifySSODomainOwnershipParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SSOManagementServiceVerifySSODomainOwnershipOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSSOManagementServiceVerifySSODomainOwnershipParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "SSOManagementService_VerifySSODomainOwnership",
		Method:             "POST",
		PathPattern:        "/iam/2019-12-10/organizations/{organization_id}/verify-sso-domain-ownership",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &SSOManagementServiceVerifySSODomainOwnershipReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SSOManagementServiceVerifySSODomainOwnershipOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SSOManagementServiceVerifySSODomainOwnershipDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

// SetTransport changes the transport on the client
func (a *Client) SetTransport(transport runtime.ClientTransport) {
	a.transport = transport
}
