// Code generated by go-swagger; DO NOT EDIT.

package billing_account_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewBillingAccountServiceGetPricingModelTransitionsParams creates a new BillingAccountServiceGetPricingModelTransitionsParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewBillingAccountServiceGetPricingModelTransitionsParams() *BillingAccountServiceGetPricingModelTransitionsParams {
	return &BillingAccountServiceGetPricingModelTransitionsParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewBillingAccountServiceGetPricingModelTransitionsParamsWithTimeout creates a new BillingAccountServiceGetPricingModelTransitionsParams object
// with the ability to set a timeout on a request.
func NewBillingAccountServiceGetPricingModelTransitionsParamsWithTimeout(timeout time.Duration) *BillingAccountServiceGetPricingModelTransitionsParams {
	return &BillingAccountServiceGetPricingModelTransitionsParams{
		timeout: timeout,
	}
}

// NewBillingAccountServiceGetPricingModelTransitionsParamsWithContext creates a new BillingAccountServiceGetPricingModelTransitionsParams object
// with the ability to set a context for a request.
func NewBillingAccountServiceGetPricingModelTransitionsParamsWithContext(ctx context.Context) *BillingAccountServiceGetPricingModelTransitionsParams {
	return &BillingAccountServiceGetPricingModelTransitionsParams{
		Context: ctx,
	}
}

// NewBillingAccountServiceGetPricingModelTransitionsParamsWithHTTPClient creates a new BillingAccountServiceGetPricingModelTransitionsParams object
// with the ability to set a custom HTTPClient for a request.
func NewBillingAccountServiceGetPricingModelTransitionsParamsWithHTTPClient(client *http.Client) *BillingAccountServiceGetPricingModelTransitionsParams {
	return &BillingAccountServiceGetPricingModelTransitionsParams{
		HTTPClient: client,
	}
}

/*
BillingAccountServiceGetPricingModelTransitionsParams contains all the parameters to send to the API endpoint

	for the billing account service get pricing model transitions operation.

	Typically these are written to a http.Request.
*/
type BillingAccountServiceGetPricingModelTransitionsParams struct {

	/* BillingAccountID.

	   billing_account_id is the public ID of the billing account.
	*/
	BillingAccountID string

	/* End.

	   end is the exclusive upper bound timestamp for which to get pricing model transitions.

	   Format: date-time
	*/
	End *strfmt.DateTime

	/* OrganizationID.

	   organization_id is the ID of the organization to which the billing account belongs.
	*/
	OrganizationID string

	/* Start.

	   start is the inclusive lower bound timestamp for which to get pricing model transitions.

	   Format: date-time
	*/
	Start *strfmt.DateTime

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the billing account service get pricing model transitions params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *BillingAccountServiceGetPricingModelTransitionsParams) WithDefaults() *BillingAccountServiceGetPricingModelTransitionsParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the billing account service get pricing model transitions params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *BillingAccountServiceGetPricingModelTransitionsParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the billing account service get pricing model transitions params
func (o *BillingAccountServiceGetPricingModelTransitionsParams) WithTimeout(timeout time.Duration) *BillingAccountServiceGetPricingModelTransitionsParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the billing account service get pricing model transitions params
func (o *BillingAccountServiceGetPricingModelTransitionsParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the billing account service get pricing model transitions params
func (o *BillingAccountServiceGetPricingModelTransitionsParams) WithContext(ctx context.Context) *BillingAccountServiceGetPricingModelTransitionsParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the billing account service get pricing model transitions params
func (o *BillingAccountServiceGetPricingModelTransitionsParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the billing account service get pricing model transitions params
func (o *BillingAccountServiceGetPricingModelTransitionsParams) WithHTTPClient(client *http.Client) *BillingAccountServiceGetPricingModelTransitionsParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the billing account service get pricing model transitions params
func (o *BillingAccountServiceGetPricingModelTransitionsParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBillingAccountID adds the billingAccountID to the billing account service get pricing model transitions params
func (o *BillingAccountServiceGetPricingModelTransitionsParams) WithBillingAccountID(billingAccountID string) *BillingAccountServiceGetPricingModelTransitionsParams {
	o.SetBillingAccountID(billingAccountID)
	return o
}

// SetBillingAccountID adds the billingAccountId to the billing account service get pricing model transitions params
func (o *BillingAccountServiceGetPricingModelTransitionsParams) SetBillingAccountID(billingAccountID string) {
	o.BillingAccountID = billingAccountID
}

// WithEnd adds the end to the billing account service get pricing model transitions params
func (o *BillingAccountServiceGetPricingModelTransitionsParams) WithEnd(end *strfmt.DateTime) *BillingAccountServiceGetPricingModelTransitionsParams {
	o.SetEnd(end)
	return o
}

// SetEnd adds the end to the billing account service get pricing model transitions params
func (o *BillingAccountServiceGetPricingModelTransitionsParams) SetEnd(end *strfmt.DateTime) {
	o.End = end
}

// WithOrganizationID adds the organizationID to the billing account service get pricing model transitions params
func (o *BillingAccountServiceGetPricingModelTransitionsParams) WithOrganizationID(organizationID string) *BillingAccountServiceGetPricingModelTransitionsParams {
	o.SetOrganizationID(organizationID)
	return o
}

// SetOrganizationID adds the organizationId to the billing account service get pricing model transitions params
func (o *BillingAccountServiceGetPricingModelTransitionsParams) SetOrganizationID(organizationID string) {
	o.OrganizationID = organizationID
}

// WithStart adds the start to the billing account service get pricing model transitions params
func (o *BillingAccountServiceGetPricingModelTransitionsParams) WithStart(start *strfmt.DateTime) *BillingAccountServiceGetPricingModelTransitionsParams {
	o.SetStart(start)
	return o
}

// SetStart adds the start to the billing account service get pricing model transitions params
func (o *BillingAccountServiceGetPricingModelTransitionsParams) SetStart(start *strfmt.DateTime) {
	o.Start = start
}

// WriteToRequest writes these params to a swagger request
func (o *BillingAccountServiceGetPricingModelTransitionsParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param billing_account_id
	if err := r.SetPathParam("billing_account_id", o.BillingAccountID); err != nil {
		return err
	}

	if o.End != nil {

		// query param end
		var qrEnd strfmt.DateTime

		if o.End != nil {
			qrEnd = *o.End
		}
		qEnd := qrEnd.String()
		if qEnd != "" {

			if err := r.SetQueryParam("end", qEnd); err != nil {
				return err
			}
		}
	}

	// path param organization_id
	if err := r.SetPathParam("organization_id", o.OrganizationID); err != nil {
		return err
	}

	if o.Start != nil {

		// query param start
		var qrStart strfmt.DateTime

		if o.Start != nil {
			qrStart = *o.Start
		}
		qStart := qrStart.String()
		if qStart != "" {

			if err := r.SetQueryParam("start", qStart); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
