/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder;

import java.util.Set;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.EdgeState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.MessageBuilderHelper;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.ModuleResolveState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.SelectorState;
import org.gradle.api.internal.attributes.AttributeMergingException;
import org.gradle.internal.component.model.DependencyMetadata;
import org.gradle.internal.logging.text.TreeFormatter;

class IncompatibleDependencyAttributesMessageBuilder {
    IncompatibleDependencyAttributesMessageBuilder() {
    }

    static String buildMergeErrorMessage(ModuleResolveState module, AttributeMergingException e) {
        Attribute attribute = e.getAttribute();
        TreeFormatter fmt = new TreeFormatter();
        fmt.node("Cannot select a variant of '" + module.getId());
        fmt.append((CharSequence)"' because different values for attribute '");
        fmt.append((CharSequence)attribute.toString());
        fmt.append((CharSequence)"' are requested");
        fmt.startChildren();
        Set<EdgeState> incomingEdges = module.getIncomingEdges();
        incomingEdges.addAll(module.getUnattachedDependencies());
        for (EdgeState incomingEdge : incomingEdges) {
            SelectorState selector = incomingEdge.getSelector();
            for (String path : MessageBuilderHelper.pathTo(incomingEdge, false)) {
                String requestedAttribute = IncompatibleDependencyAttributesMessageBuilder.formatAttributeQuery(selector, attribute);
                fmt.node(path + " " + requestedAttribute);
            }
        }
        fmt.endChildren();
        return fmt.toString();
    }

    private static String formatAttributeQuery(SelectorState state, Attribute<?> attribute) {
        DependencyMetadata dependencyMetadata = state.getDependencyMetadata();
        ComponentSelector selector = dependencyMetadata.getSelector();
        if (selector instanceof ModuleComponentSelector) {
            StringBuilder sb = new StringBuilder("wants '" + state.getRequested() + "' with attribute " + attribute.getName() + " = ");
            sb.append(selector.getAttributes().getAttribute(attribute));
            return sb.toString();
        }
        return "doesn't provide any value for attribute " + attribute.getName();
    }
}

