## Moloch

[![CI](https://github.com/jolars/moloch/actions/workflows/ci.yml/badge.svg)](https://github.com/jolars/moloch/actions/workflows/ci.yml)

Moloch is a simple Beamer theme suitable for anyone to use. It is
a fork of the [Metropolis Theme](https://github.com/matze/mtheme).

The fork was created for the following reasons:

- To fix some outstanding issues that had not been addressed for a long time.
- To remove some of the more opinionated design choices, such as special handling of the Fira family of fonts.
- To strip away some features that added complexity to the code base without achieving valuable functionality for the majority of users, such as special code block designs and the pgfplots theme.

Do not expect this theme to be backwards compatible with the Metropolis theme.

## Installation

A CTAN release is planned, but for now you can install the theme manually from source. You need a working LaTeX installation with `l3build` installed. Then just follow these steps:

1. Clone the repository: `git clone https://github.com/jolars/moloch.git`
2. Install the package: `l3build install`

## Usage

The following code shows a minimal example of a Beamer presentation using
Moloch.

```latex
\documentclass{beamer}
\usetheme{moloch}
\title{A minimal example}
\date{\today}
\author{Johan Larsson}
\institute{Centre for Modern Beamer Themes}
\begin{document}
  \maketitle
  \section{First Section}
  \begin{frame}{First Frame}
    Hello, world!
  \end{frame}
\end{document}
```

## License

The theme itself is licensed under a [Creative Commons Attribution-ShareAlike
4.0 International License](http://creativecommons.org/licenses/by-sa/4.0/). This
means that if you change the theme and re-distribute it, you _must_ retain the
copyright notice header and license it under the same CC-BY-SA license. This
does not affect the presentation that you create with the theme.

## Contributing

Contributions are welcome, but we are generally not interested in changes that can be easily added through the standard Beamer interface.

Also, when writing commit messages, please use the [conventional commits format](https://www.conventionalcommits.org/en/v1.0.0/).

## Versioning

The project uses [semantic versioning](https://semver.org).
