/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.diagram.structurizr;

import com.structurizr.Workspace;
import com.structurizr.dsl.StructurizrDslParser;
import com.structurizr.dsl.StructurizrDslParserException;
import com.structurizr.export.AbstractDiagramExporter;
import com.structurizr.export.Diagram;
import com.structurizr.export.dot.DOTExporter;
import com.structurizr.export.mermaid.MermaidDiagramExporter;
import com.structurizr.export.plantuml.C4PlantUMLExporter;
import com.structurizr.export.plantuml.StructurizrPlantUMLExporter;
import com.structurizr.io.WorkspaceReaderException;
import com.structurizr.io.json.JsonReader;
import com.structurizr.view.ComponentView;
import com.structurizr.view.ContainerView;
import com.structurizr.view.CustomView;
import com.structurizr.view.DeploymentView;
import com.structurizr.view.DynamicView;
import com.structurizr.view.SystemContextView;
import com.structurizr.view.SystemLandscapeView;
import com.structurizr.view.ThemeUtils;
import com.structurizr.view.View;
import com.structurizr.view.ViewSet;
import io.github.goto1134.structurizr.export.d2.D2Exporter;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.asciidoctor.diagram.DiagramGeneratorFunction;
import org.asciidoctor.diagram.HTTPHeader;
import org.asciidoctor.diagram.MimeType;
import org.asciidoctor.diagram.Request;
import org.asciidoctor.diagram.ResponseData;

public class Structurizr
implements DiagramGeneratorFunction {
    private static final ParseDsl PARSE = Structurizr.createParseDsl();
    static final String VIEW_HEADER = "X-Structurizr-View";
    static final MimeType PLANTUML = MimeType.parse((String)"text/x-plantuml");
    static final MimeType PLANTUML_C4 = MimeType.parse((String)"text/x-plantuml-c4");
    static final MimeType MERMAID = MimeType.parse((String)"text/x-mermaid");
    static final MimeType GRAPHVIZ = MimeType.parse((String)"text/vnd.graphviz");
    static final MimeType D2 = MimeType.parse((String)"text/x-d2");
    private static final MimeType DEFAULT_OUTPUT_FORMAT = PLANTUML;
    private static final Pattern DSL = Pattern.compile("^\\s*workspace", 2);

    static ParseDsl createParseDsl() {
        Class<StructurizrDslParser> parserClass = StructurizrDslParser.class;
        try {
            Method parseString = parserClass.getDeclaredMethod("parse", String.class, File.class);
            return (parser, dsl, file) -> {
                try {
                    parseString.invoke((Object)parser, dsl, file);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
                catch (InvocationTargetException e) {
                    Throwable targetException = e.getTargetException();
                    if (targetException instanceof StructurizrDslParserException) {
                        throw (StructurizrDslParserException)targetException;
                    }
                    throw new RuntimeException(e);
                }
            };
        }
        catch (ReflectiveOperationException | RuntimeException parseString) {
            try {
                Method parseString2 = parserClass.getDeclaredMethod("parse", List.class, File.class);
                parseString2.setAccessible(true);
                return (parser, dsl, file) -> {
                    List<String> lines = Arrays.asList(dsl.split("\\r?\\n"));
                    try {
                        parseString2.invoke((Object)parser, lines, file);
                    }
                    catch (IllegalAccessException e) {
                        throw new RuntimeException(e);
                    }
                    catch (InvocationTargetException e) {
                        Throwable targetException = e.getTargetException();
                        if (targetException instanceof StructurizrDslParserException) {
                            throw (StructurizrDslParserException)targetException;
                        }
                        throw new RuntimeException(e);
                    }
                };
            }
            catch (ReflectiveOperationException | RuntimeException exception) {
                throw new IllegalStateException("Could not find DSL parsing method");
            }
        }
    }

    public ResponseData generate(Request request) throws IOException {
        Charset charset;
        C4PlantUMLExporter exporter;
        MimeType format = (MimeType)request.headers.getValue(HTTPHeader.ACCEPT);
        if (format == null) {
            format = DEFAULT_OUTPUT_FORMAT;
        }
        if (format.isSameType(PLANTUML_C4)) {
            exporter = new C4PlantUMLExporter();
        } else if (format.isSameType(GRAPHVIZ)) {
            exporter = new DOTExporter();
        } else if (format.isSameType(MERMAID)) {
            exporter = new MermaidDiagramExporter();
        } else if (format.isSameType(PLANTUML)) {
            exporter = new StructurizrPlantUMLExporter();
        } else if (format.isSameType(D2)) {
            exporter = new D2Exporter();
        } else {
            throw new IOException("Unsupported output format: " + format);
        }
        String charsetName = (String)format.parameters.get("charset");
        if (charsetName == null) {
            charset = StandardCharsets.UTF_8;
            charsetName = "utf-8";
        } else {
            charset = Charset.forName(charsetName);
        }
        String viewKey = request.headers.getValue(VIEW_HEADER);
        String includeDir = request.headers.getValue("X-Structurizr-IncludeDir");
        try {
            Workspace workspace = this.parseWorkspace(request, includeDir);
            Structurizr.prepareWorkspaceForExport(workspace);
            View view = this.findView(workspace, viewKey);
            Diagram diagram = this.exportView((AbstractDiagramExporter)exporter, view);
            return new ResponseData(format.withParameter("charset", charsetName), diagram.getDefinition().getBytes(charset));
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    private Workspace parseWorkspace(Request request, String includeDir) throws StructurizrDslParserException, IOException, WorkspaceReaderException {
        String content = request.asString();
        if (DSL.matcher(content).find()) {
            return Structurizr.parseDsl(content, includeDir);
        }
        return Structurizr.parseJson(content);
    }

    private static Workspace parseDsl(String content, String includeDir) throws StructurizrDslParserException {
        File baseDir = includeDir != null ? new File(includeDir) : new File(System.getProperty("user.dir"));
        StructurizrDslParser structurizrDslParser = new StructurizrDslParser();
        PARSE.parse(structurizrDslParser, content, new File(baseDir, "stdin"));
        return structurizrDslParser.getWorkspace();
    }

    private static Workspace parseJson(String content) throws WorkspaceReaderException, IOException {
        return new JsonReader().read((Reader)new StringReader(content));
    }

    private static void prepareWorkspaceForExport(Workspace workspace) throws Exception {
        ThemeUtils.loadThemes((Workspace)workspace);
        if (workspace.getViews().isEmpty()) {
            workspace.getViews().createDefaultViews();
        }
    }

    private View findView(Workspace workspace, String viewKey) throws IOException {
        ViewSet viewSet = workspace.getViews();
        if (viewKey != null) {
            return viewSet.getViewWithKey(viewKey);
        }
        Stream<? extends View> views = this.concatStreams(viewSet.getCustomViews().stream(), viewSet.getSystemLandscapeViews().stream(), viewSet.getSystemContextViews().stream(), viewSet.getContainerViews().stream(), viewSet.getComponentViews().stream(), viewSet.getDynamicViews().stream(), viewSet.getDeploymentViews().stream());
        return views.min(Comparator.comparing(View::getKey)).orElseThrow(() -> new IOException("Could not find view"));
    }

    @SafeVarargs
    private final Stream<? extends View> concatStreams(Stream<? extends View> stream, Stream<? extends View> ... streams) {
        Stream<? extends View> s = stream;
        for (Stream<? extends View> other : streams) {
            s = Stream.concat(s, other);
        }
        return s;
    }

    private Diagram exportView(AbstractDiagramExporter exporter, View view) throws IOException {
        if (view instanceof CustomView) {
            return exporter.export((CustomView)view);
        }
        if (view instanceof SystemLandscapeView) {
            return exporter.export((SystemLandscapeView)view);
        }
        if (view instanceof SystemContextView) {
            return exporter.export((SystemContextView)view);
        }
        if (view instanceof ContainerView) {
            return exporter.export((ContainerView)view);
        }
        if (view instanceof ComponentView) {
            return exporter.export((ComponentView)view);
        }
        if (view instanceof DynamicView) {
            return exporter.export((DynamicView)view);
        }
        if (view instanceof DeploymentView) {
            return exporter.export((DeploymentView)view);
        }
        throw new IOException("Cannot export diagram of type " + view.getClass());
    }

    @FunctionalInterface
    static interface ParseDsl {
        public void parse(StructurizrDslParser var1, String var2, File var3) throws StructurizrDslParserException;
    }
}

