/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.instance;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Range;
import weka.core.RevisionUtils;
import weka.core.SingleIndex;
import weka.core.UnsupportedAttributeTypeException;
import weka.core.Utils;
import weka.core.WeightedAttributesHandler;
import weka.core.WeightedInstancesHandler;
import weka.filters.Filter;
import weka.filters.StreamableFilter;
import weka.filters.UnsupervisedFilter;

public class RemoveWithValues
extends Filter
implements UnsupervisedFilter,
StreamableFilter,
OptionHandler,
WeightedInstancesHandler,
WeightedAttributesHandler {
    static final long serialVersionUID = 4752870193679263361L;
    private final SingleIndex m_AttIndex = new SingleIndex("last");
    protected Range m_Values = new Range("first-last");
    protected double m_Value = 0.0;
    protected boolean m_MatchMissingValues = false;
    protected boolean m_ModifyHeader = false;
    protected int[] m_NominalMapping;
    protected boolean m_dontFilterAfterFirstBatch = false;

    public String globalInfo() {
        return "Filters instances according to the value of an attribute.";
    }

    public RemoveWithValues() {
        this.m_Values.setInvert(true);
    }

    @Override
    public Enumeration<Option> listOptions() {
        Vector<Option> newVector = new Vector<Option>(7);
        newVector.addElement(new Option("\tChoose attribute to be used for selection.", "C", 1, "-C <num>"));
        newVector.addElement(new Option("\tNumeric value to be used for selection on numeric\n\tattribute.\n\tInstances with values smaller than given value will\n\tbe selected. (default 0)", "S", 1, "-S <num>"));
        newVector.addElement(new Option("\tRange of label indices to be used for selection on\n\tnominal attribute.\n\tFirst and last are valid indexes. (default all values)", "L", 1, "-L <index1,index2-index4,...>"));
        newVector.addElement(new Option("\tMissing values count as a match. This setting is\n\tindependent of the -V option.\n\t(default missing values don't match)", "M", 0, "-M"));
        newVector.addElement(new Option("\tInvert matching sense.", "V", 0, "-V"));
        newVector.addElement(new Option("\tWhen selecting on nominal attributes, removes header\n\treferences to excluded values.", "H", 0, "-H"));
        newVector.addElement(new Option("\tDo not apply the filter to instances that arrive after the first\n\t(training) batch. The default is to apply the filter (i.e.\n\tthe filter may not return an instance if it matches the remove criteria)", "F", 0, "-F"));
        return newVector.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String attIndex = Utils.getOption('C', options);
        if (attIndex.length() != 0) {
            this.setAttributeIndex(attIndex);
        } else {
            this.setAttributeIndex("last");
        }
        String splitPoint = Utils.getOption('S', options);
        if (splitPoint.length() != 0) {
            this.setSplitPoint(new Double(splitPoint));
        } else {
            this.setSplitPoint(0.0);
        }
        String convertList = Utils.getOption('L', options);
        if (convertList.length() != 0) {
            this.setNominalIndices(convertList);
        } else {
            this.setNominalIndices("first-last");
        }
        this.setInvertSelection(Utils.getFlag('V', options));
        this.setMatchMissingValues(Utils.getFlag('M', options));
        this.setModifyHeader(Utils.getFlag('H', options));
        this.setDontFilterAfterFirstBatch(Utils.getFlag('F', options));
        if (this.getInputFormat() != null) {
            this.setInputFormat(this.getInputFormat());
        }
        Utils.checkForRemainingOptions(options);
    }

    @Override
    public String[] getOptions() {
        Vector<String> options = new Vector<String>();
        options.add("-S");
        options.add("" + this.getSplitPoint());
        options.add("-C");
        options.add("" + this.getAttributeIndex());
        if (!this.getNominalIndices().equals("")) {
            options.add("-L");
            options.add(this.getNominalIndices());
        }
        if (this.getInvertSelection()) {
            options.add("-V");
        }
        if (this.getMatchMissingValues()) {
            options.add("-M");
        }
        if (this.getModifyHeader()) {
            options.add("-H");
        }
        if (this.getDontFilterAfterFirstBatch()) {
            options.add("-F");
        }
        return options.toArray(new String[0]);
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enableAllAttributes();
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enableAllClasses();
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.enable(Capabilities.Capability.NO_CLASS);
        return result;
    }

    @Override
    public boolean setInputFormat(Instances instanceInfo) throws Exception {
        super.setInputFormat(instanceInfo);
        this.m_AttIndex.setUpper(instanceInfo.numAttributes() - 1);
        if (!this.isNumeric() && !this.isNominal()) {
            throw new UnsupportedAttributeTypeException("Can only handle numeric or nominal attributes.");
        }
        this.m_Values.setUpper(instanceInfo.attribute(this.m_AttIndex.getIndex()).numValues() - 1);
        if (this.isNominal() && this.m_ModifyHeader) {
            instanceInfo = new Instances(instanceInfo, 0);
            Attribute oldAtt = instanceInfo.attribute(this.m_AttIndex.getIndex());
            int[] selection = this.m_Values.getSelection();
            ArrayList<String> newVals = new ArrayList<String>();
            for (int element : selection) {
                newVals.add(oldAtt.value(element));
            }
            Attribute newAtt = new Attribute(oldAtt.name(), newVals);
            newAtt.setWeight(oldAtt.weight());
            instanceInfo.replaceAttributeAt(newAtt, this.m_AttIndex.getIndex());
            this.m_NominalMapping = new int[oldAtt.numValues()];
            for (int i = 0; i < this.m_NominalMapping.length; ++i) {
                boolean found = false;
                for (int j = 0; j < selection.length; ++j) {
                    if (selection[j] != i) continue;
                    this.m_NominalMapping[i] = j;
                    found = true;
                    break;
                }
                if (found) continue;
                this.m_NominalMapping[i] = -1;
            }
        }
        this.setOutputFormat(instanceInfo);
        return true;
    }

    @Override
    public boolean input(Instance instance) {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (this.m_NewBatch) {
            this.resetQueue();
            this.m_NewBatch = false;
        }
        if (this.isFirstBatchDone() && this.m_dontFilterAfterFirstBatch) {
            this.push((Instance)instance.copy(), false);
            return true;
        }
        if (instance.isMissing(this.m_AttIndex.getIndex())) {
            if (!this.getMatchMissingValues()) {
                this.push((Instance)instance.copy(), false);
                return true;
            }
            return false;
        }
        if (this.isNumeric()) {
            if (!this.m_Values.getInvert()) {
                if (instance.value(this.m_AttIndex.getIndex()) < this.m_Value) {
                    this.push((Instance)instance.copy(), false);
                    return true;
                }
            } else if (instance.value(this.m_AttIndex.getIndex()) >= this.m_Value) {
                this.push((Instance)instance.copy(), false);
                return true;
            }
        }
        if (this.isNominal() && this.m_Values.isInRange((int)instance.value(this.m_AttIndex.getIndex()))) {
            Instance temp = (Instance)instance.copy();
            if (this.getModifyHeader()) {
                temp.setValue(this.m_AttIndex.getIndex(), (double)this.m_NominalMapping[(int)instance.value(this.m_AttIndex.getIndex())]);
            }
            this.push(temp, false);
            return true;
        }
        return false;
    }

    @Override
    public boolean mayRemoveInstanceAfterFirstBatchDone() {
        return true;
    }

    public boolean isNominal() {
        if (this.getInputFormat() == null) {
            return false;
        }
        return this.getInputFormat().attribute(this.m_AttIndex.getIndex()).isNominal();
    }

    public boolean isNumeric() {
        if (this.getInputFormat() == null) {
            return false;
        }
        return this.getInputFormat().attribute(this.m_AttIndex.getIndex()).isNumeric();
    }

    public String modifyHeaderTipText() {
        return "When selecting on nominal attributes, removes header references to excluded values.";
    }

    public boolean getModifyHeader() {
        return this.m_ModifyHeader;
    }

    public void setModifyHeader(boolean newModifyHeader) {
        this.m_ModifyHeader = newModifyHeader;
    }

    public String attributeIndexTipText() {
        return "Choose attribute to be used for selection (default last).";
    }

    public String getAttributeIndex() {
        return this.m_AttIndex.getSingleIndex();
    }

    public void setAttributeIndex(String attIndex) {
        this.m_AttIndex.setSingleIndex(attIndex);
    }

    public String splitPointTipText() {
        return "Numeric value to be used for selection on numeric attribute. Instances with values smaller than given value will be selected.";
    }

    public double getSplitPoint() {
        return this.m_Value;
    }

    public void setSplitPoint(double value) {
        this.m_Value = value;
    }

    public String matchMissingValuesTipText() {
        return "Missing values count as a match. This setting is independent of the invertSelection option.";
    }

    public boolean getMatchMissingValues() {
        return this.m_MatchMissingValues;
    }

    public void setMatchMissingValues(boolean newMatchMissingValues) {
        this.m_MatchMissingValues = newMatchMissingValues;
    }

    public String invertSelectionTipText() {
        return "Invert matching sense.";
    }

    public boolean getInvertSelection() {
        return !this.m_Values.getInvert();
    }

    public void setInvertSelection(boolean invert) {
        this.m_Values.setInvert(!invert);
    }

    public String nominalIndicesTipText() {
        return "Range of label indices to be used for selection on nominal attribute. First and last are valid indexes.";
    }

    public String getNominalIndices() {
        return this.m_Values.getRanges();
    }

    public void setNominalIndices(String rangeList) {
        this.m_Values.setRanges(rangeList);
    }

    public void setDontFilterAfterFirstBatch(boolean b) {
        this.m_dontFilterAfterFirstBatch = b;
    }

    public boolean getDontFilterAfterFirstBatch() {
        return this.m_dontFilterAfterFirstBatch;
    }

    public String dontFilterAfterFirstBatchTipText() {
        return "Whether to apply the filtering process to instances that are input after the first (training) batch. The default is false so instances in subsequent batches can potentially get 'consumed' by the filter.";
    }

    public void setNominalIndicesArr(int[] values) {
        String rangeList = "";
        for (int i = 0; i < values.length; ++i) {
            rangeList = i == 0 ? "" + (values[i] + 1) : rangeList + "," + (values[i] + 1);
        }
        this.setNominalIndices(rangeList);
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 14534 $");
    }

    public static void main(String[] argv) {
        RemoveWithValues.runFilter(new RemoveWithValues(), argv);
    }
}

