/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.hash;

import com.google.common.base.Preconditions;
import com.google.common.hash.ElementTypesAreNonnullByDefault;
import com.google.common.hash.Funnel;
import com.google.common.hash.Hasher;
import com.google.common.hash.Java8Compatibility;
import com.google.common.hash.ParametricNullness;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;

@ElementTypesAreNonnullByDefault
@CanIgnoreReturnValue
abstract class AbstractHasher
implements Hasher {
    AbstractHasher() {
    }

    @Override
    public final Hasher putBoolean(boolean b11) {
        return this.putByte(b11 ? (byte)1 : 0);
    }

    @Override
    public final Hasher putDouble(double d11) {
        return this.putLong(Double.doubleToRawLongBits(d11));
    }

    @Override
    public final Hasher putFloat(float f11) {
        return this.putInt(Float.floatToRawIntBits(f11));
    }

    @Override
    public Hasher putUnencodedChars(CharSequence charSequence) {
        int len = charSequence.length();
        for (int i11 = 0; i11 < len; ++i11) {
            this.putChar(charSequence.charAt(i11));
        }
        return this;
    }

    @Override
    public Hasher putString(CharSequence charSequence, Charset charset) {
        return this.putBytes(charSequence.toString().getBytes(charset));
    }

    @Override
    public Hasher putBytes(byte[] bytes) {
        return this.putBytes(bytes, 0, bytes.length);
    }

    @Override
    public Hasher putBytes(byte[] bytes, int off, int len) {
        Preconditions.checkPositionIndexes(off, off + len, bytes.length);
        for (int i11 = 0; i11 < len; ++i11) {
            this.putByte(bytes[off + i11]);
        }
        return this;
    }

    @Override
    public Hasher putBytes(ByteBuffer b11) {
        if (b11.hasArray()) {
            this.putBytes(b11.array(), b11.arrayOffset() + b11.position(), b11.remaining());
            Java8Compatibility.position(b11, b11.limit());
        } else {
            for (int remaining = b11.remaining(); remaining > 0; --remaining) {
                this.putByte(b11.get());
            }
        }
        return this;
    }

    @Override
    public Hasher putShort(short s11) {
        this.putByte((byte)s11);
        this.putByte((byte)(s11 >>> 8));
        return this;
    }

    @Override
    public Hasher putInt(int i11) {
        this.putByte((byte)i11);
        this.putByte((byte)(i11 >>> 8));
        this.putByte((byte)(i11 >>> 16));
        this.putByte((byte)(i11 >>> 24));
        return this;
    }

    @Override
    public Hasher putLong(long l11) {
        for (int i11 = 0; i11 < 64; i11 += 8) {
            this.putByte((byte)(l11 >>> i11));
        }
        return this;
    }

    @Override
    public Hasher putChar(char c11) {
        this.putByte((byte)c11);
        this.putByte((byte)(c11 >>> 8));
        return this;
    }

    @Override
    public <T> Hasher putObject(@ParametricNullness T instance, Funnel<? super T> funnel) {
        funnel.funnel(instance, this);
        return this;
    }
}

