/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.model;

import com.android.aapt.Resources;
import com.android.bundle.Commands;
import com.android.bundle.Config;
import com.android.bundle.Files;
import com.android.bundle.RuntimeEnabledSdkConfigProto;
import com.android.bundle.SdkModulesConfigOuterClass;
import com.android.bundle.Targeting;
import com.android.tools.build.bundletool.model.$AutoValue_BundleModule;
import com.android.tools.build.bundletool.model.AndroidManifest;
import com.android.tools.build.bundletool.model.BundleModuleName;
import com.android.tools.build.bundletool.model.ManifestDeliveryElement;
import com.android.tools.build.bundletool.model.ModuleConditions;
import com.android.tools.build.bundletool.model.ModuleDeliveryType;
import com.android.tools.build.bundletool.model.ModuleEntry;
import com.android.tools.build.bundletool.model.ZipPath;
import com.android.tools.build.bundletool.model.exceptions.InvalidBundleException;
import com.android.tools.build.bundletool.model.utils.TargetingProtoUtils;
import com.android.tools.build.bundletool.model.version.Version;
import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Immutable;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;

@Immutable
@AutoValue
@AutoValue.CopyAnnotations
public abstract class BundleModule {
    public static final String MANIFEST_FILENAME = "AndroidManifest.xml";
    public static final ZipPath ASSETS_DIRECTORY = ZipPath.create("assets");
    public static final ZipPath DEX_DIRECTORY = ZipPath.create("dex");
    public static final ZipPath LIB_DIRECTORY = ZipPath.create("lib");
    public static final ZipPath MANIFEST_DIRECTORY = ZipPath.create("manifest");
    public static final ZipPath RESOURCES_DIRECTORY = ZipPath.create("res");
    public static final ZipPath ROOT_DIRECTORY = ZipPath.create("root");
    public static final ZipPath DRAWABLE_RESOURCE_DIRECTORY = ZipPath.create("res/drawable");
    public static final ZipPath APEX_DIRECTORY = ZipPath.create("apex");
    public static final String APEX_IMAGE_SUFFIX = "img";
    public static final String BUILD_INFO_SUFFIX = "build_info.pb";
    public static final ZipPath APEX_MANIFEST_PATH = ZipPath.create("root/apex_manifest.pb");
    public static final ZipPath APEX_MANIFEST_JSON_PATH = ZipPath.create("root/apex_manifest.json");
    public static final ZipPath APEX_PUBKEY_PATH = ZipPath.create("root/apex_pubkey");
    public static final ZipPath APEX_NOTICE_PATH = ZipPath.create("assets/NOTICE.html.gz");
    public static final Splitter ABI_SPLITTER = Splitter.on(".").omitEmptyStrings();

    public abstract BundleModuleName getName();

    public abstract Config.BundleConfig.BundleType getBundleType();

    public abstract Version getBundletoolVersion();

    public abstract Resources.XmlNode getAndroidManifestProto();

    public AndroidManifest getAndroidManifest() {
        return AndroidManifest.create(this.getAndroidManifestProto(), this.getBundletoolVersion());
    }

    public abstract Optional<Config.ApexConfig> getBundleApexConfig();

    public abstract Optional<Resources.ResourceTable> getResourceTable();

    public abstract Optional<Files.Assets> getAssetsConfig();

    public abstract Optional<Files.NativeLibraries> getNativeConfig();

    public abstract Optional<Files.ApexImages> getApexConfig();

    public abstract Optional<RuntimeEnabledSdkConfigProto.RuntimeEnabledSdkConfig> getRuntimeEnabledSdkConfig();

    public abstract Optional<SdkModulesConfigOuterClass.SdkModulesConfig> getSdkModulesConfig();

    abstract ImmutableMap<ZipPath, ModuleEntry> getEntryMap();

    public abstract ModuleType getModuleType();

    public ImmutableCollection<ModuleEntry> getEntries() {
        return this.getEntryMap().values();
    }

    public boolean isBaseModule() {
        return BundleModuleName.BASE_MODULE_NAME.equals(this.getName());
    }

    public ModuleDeliveryType getDeliveryType() {
        return this.getAndroidManifest().getModuleDeliveryType();
    }

    public Optional<ModuleDeliveryType> getInstantDeliveryType() {
        if (!this.isInstantModule()) {
            return Optional.empty();
        }
        return Optional.of(this.getAndroidManifest().getInstantModuleDeliveryType());
    }

    public boolean isIncludedInFusing() {
        return this.isBaseModule() || this.getAndroidManifest().getIsModuleIncludedInFusing().orElseThrow(() -> InvalidBundleException.createWithUserMessage("Unable to determine if module should be fused: missing <dist:fusing> tag inside <dist:module> in AndroidManifest.xml")) != false;
    }

    public boolean isInstantModule() {
        Optional<Boolean> isInstantModule = this.getAndroidManifest().isInstantModule();
        return isInstantModule.orElse(false);
    }

    public boolean hasRenderscript32Bitcode() {
        return this.findEntries(zipPath -> zipPath.toString().endsWith(".bc")).findFirst().isPresent();
    }

    public ImmutableList<String> getDependencies() {
        return this.getAndroidManifest().getUsesSplits();
    }

    private Targeting.ModuleTargeting getModuleTargeting() {
        return this.getAndroidManifest().getManifestDeliveryElement().map(ManifestDeliveryElement::getModuleConditions).map(ModuleConditions::toTargeting).map(this::applyMinSdkVersion).orElse(Targeting.ModuleTargeting.getDefaultInstance());
    }

    private Targeting.ModuleTargeting applyMinSdkVersion(Targeting.ModuleTargeting moduleTargeting) {
        Optional<Integer> minSdkVersion = this.getAndroidManifest().getMinSdkVersion();
        if (moduleTargeting.equals(Targeting.ModuleTargeting.getDefaultInstance()) || moduleTargeting.hasSdkVersionTargeting() || !minSdkVersion.isPresent()) {
            return moduleTargeting;
        }
        return moduleTargeting.toBuilder().setSdkVersionTargeting(TargetingProtoUtils.sdkVersionTargeting(TargetingProtoUtils.sdkVersionFrom(minSdkVersion.get()))).build();
    }

    public Stream<ModuleEntry> findEntries(Predicate<ZipPath> pathPredicate) {
        return this.getEntries().stream().filter(entry -> pathPredicate.test(entry.getPath()));
    }

    public Stream<ModuleEntry> findEntriesUnderPath(ZipPath path) {
        return this.findEntries(p11 -> p11.startsWith(path));
    }

    public Optional<ModuleEntry> getEntry(ZipPath path) {
        return Optional.ofNullable(this.getEntryMap().get(path));
    }

    public Commands.ModuleMetadata getModuleMetadata() {
        return this.getModuleMetadata(false);
    }

    public Commands.ModuleMetadata getModuleMetadata(boolean isSdkRuntimeVariant) {
        Commands.ModuleMetadata.Builder moduleMetadata = Commands.ModuleMetadata.newBuilder().setName(this.getName().getName()).setIsInstant(this.isInstantModule()).addAllDependencies(this.getDependencies()).setTargeting(this.getModuleTargeting()).setDeliveryType(BundleModule.moduleDeliveryTypeToDeliveryType(this.getDeliveryType()));
        BundleModule.moduleTypeToFeatureModuleType(this.getModuleType()).ifPresent(moduleMetadata::setModuleType);
        this.getSdkModulesConfig().ifPresent(sdkModulesConfig -> moduleMetadata.setSdkModuleMetadata(BundleModule.sdkModulesConfigToSdkModuleMetadata(sdkModulesConfig)));
        if (isSdkRuntimeVariant) {
            this.getRuntimeEnabledSdkConfig().ifPresent(runtimeEnabledSdkConfig -> moduleMetadata.addAllRuntimeEnabledSdkDependencies(BundleModule.runtimeEnabledDependenciesFromConfig(runtimeEnabledSdkConfig)));
        }
        return moduleMetadata.build();
    }

    private static ImmutableSet<Commands.RuntimeEnabledSdkDependency> runtimeEnabledDependenciesFromConfig(RuntimeEnabledSdkConfigProto.RuntimeEnabledSdkConfig runtimeEnabledSdkConfig) {
        return runtimeEnabledSdkConfig.getRuntimeEnabledSdkList().stream().map(runtimeEnabledSdk -> Commands.RuntimeEnabledSdkDependency.newBuilder().setPackageName(runtimeEnabledSdk.getPackageName()).setMajorVersion(runtimeEnabledSdk.getVersionMajor()).setMinorVersion(runtimeEnabledSdk.getVersionMinor()).build()).collect(ImmutableSet.toImmutableSet());
    }

    private static Commands.DeliveryType moduleDeliveryTypeToDeliveryType(ModuleDeliveryType moduleDeliveryType) {
        switch (moduleDeliveryType) {
            case ALWAYS_INITIAL_INSTALL: 
            case CONDITIONAL_INITIAL_INSTALL: {
                return Commands.DeliveryType.INSTALL_TIME;
            }
            case NO_INITIAL_INSTALL: {
                return Commands.DeliveryType.ON_DEMAND;
            }
        }
        throw new IllegalArgumentException("Unknown module delivery type: " + (Object)((Object)moduleDeliveryType));
    }

    private static Optional<Commands.FeatureModuleType> moduleTypeToFeatureModuleType(ModuleType moduleType) {
        switch (moduleType) {
            case FEATURE_MODULE: {
                return Optional.of(Commands.FeatureModuleType.FEATURE_MODULE);
            }
            case SDK_DEPENDENCY_MODULE: {
                return Optional.of(Commands.FeatureModuleType.SDK_MODULE);
            }
            case ML_MODULE: {
                return Optional.of(Commands.FeatureModuleType.ML_MODULE);
            }
            case ASSET_MODULE: 
            case UNKNOWN_MODULE_TYPE: {
                return Optional.empty();
            }
        }
        throw new IllegalArgumentException("Unknown module type: " + (Object)((Object)moduleType));
    }

    private static Commands.SdkModuleMetadata sdkModulesConfigToSdkModuleMetadata(SdkModulesConfigOuterClass.SdkModulesConfig sdkModulesConfig) {
        return Commands.SdkModuleMetadata.newBuilder().setSdkPackageName(sdkModulesConfig.getSdkPackageName()).setSdkModuleVersion(BundleModule.runtimeEnabledSdkVersionToModuleMetadataConverter(sdkModulesConfig.getSdkVersion())).build();
    }

    private static Commands.SdkModuleVersion runtimeEnabledSdkVersionToModuleMetadataConverter(SdkModulesConfigOuterClass.RuntimeEnabledSdkVersion runtimeEnabledSdkVersion) {
        return Commands.SdkModuleVersion.newBuilder().setMajor(runtimeEnabledSdkVersion.getMajor()).setMinor(runtimeEnabledSdkVersion.getMinor()).setPatch(runtimeEnabledSdkVersion.getPatch()).build();
    }

    public static Builder builder() {
        return new $AutoValue_BundleModule.Builder().setModuleType(ModuleType.UNKNOWN_MODULE_TYPE);
    }

    public abstract Builder toBuilder();

    public static enum SpecialModuleEntry {
        ANDROID_MANIFEST("manifest/AndroidManifest.xml"){

            @Override
            void addToModule(Builder module, InputStream inputStream) throws IOException {
                module.setAndroidManifestProto(Resources.XmlNode.parseFrom(inputStream));
            }
        }
        ,
        RESOURCE_TABLE("resources.pb"){

            @Override
            void addToModule(Builder module, InputStream inputStream) throws IOException {
                module.setResourceTable(Resources.ResourceTable.parseFrom(inputStream));
            }
        }
        ,
        ASSETS_TABLE("assets.pb"){

            @Override
            void addToModule(Builder module, InputStream inputStream) throws IOException {
                module.setAssetsConfig(Files.Assets.parseFrom(inputStream));
            }
        }
        ,
        NATIVE_LIBS_TABLE("native.pb"){

            @Override
            void addToModule(Builder module, InputStream inputStream) throws IOException {
                module.setNativeConfig(Files.NativeLibraries.parseFrom(inputStream));
            }
        }
        ,
        APEX_TABLE("apex.pb"){

            @Override
            void addToModule(Builder module, InputStream inputStream) throws IOException {
                module.setApexConfig(Files.ApexImages.parseFrom(inputStream));
            }
        }
        ,
        RUNTIME_ENABLED_SDK_CONFIG("runtime_enabled_sdk_config.pb"){

            @Override
            void addToModule(Builder module, InputStream inputStream) throws IOException {
                module.setRuntimeEnabledSdkConfig(RuntimeEnabledSdkConfigProto.RuntimeEnabledSdkConfig.parseFrom(inputStream));
            }
        };

        private static final ImmutableMap<ZipPath, SpecialModuleEntry> SPECIAL_ENTRY_BY_PATH;
        private final ZipPath entryPath;

        abstract void addToModule(Builder var1, InputStream var2) throws IOException;

        public static Optional<SpecialModuleEntry> getSpecialEntry(ZipPath entryPath) {
            return Optional.ofNullable(SPECIAL_ENTRY_BY_PATH.get(entryPath));
        }

        private SpecialModuleEntry(String entryPath) {
            this.entryPath = ZipPath.create(entryPath);
        }

        public ZipPath getPath() {
            return this.entryPath;
        }

        static {
            SPECIAL_ENTRY_BY_PATH = Arrays.stream(SpecialModuleEntry.values()).collect(ImmutableMap.toImmutableMap(SpecialModuleEntry::getPath, Function.identity()));
        }
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setName(BundleModuleName var1);

        public abstract Builder setBundleType(Config.BundleConfig.BundleType var1);

        public abstract Builder setBundletoolVersion(Version var1);

        public abstract Builder setBundleApexConfig(Config.ApexConfig var1);

        public abstract Builder setResourceTable(Resources.ResourceTable var1);

        public Builder setAndroidManifest(AndroidManifest androidManifest) {
            return this.setAndroidManifestProto(androidManifest.getManifestRoot().getProto());
        }

        public abstract Builder setAndroidManifestProto(Resources.XmlNode var1);

        public abstract Builder setAssetsConfig(Files.Assets var1);

        public abstract Builder setNativeConfig(Files.NativeLibraries var1);

        public abstract Builder setApexConfig(Files.ApexImages var1);

        public abstract Builder setRuntimeEnabledSdkConfig(RuntimeEnabledSdkConfigProto.RuntimeEnabledSdkConfig var1);

        public abstract Builder setSdkModulesConfig(SdkModulesConfigOuterClass.SdkModulesConfig var1);

        public abstract Builder setModuleType(ModuleType var1);

        abstract ImmutableMap.Builder<ZipPath, ModuleEntry> entryMapBuilder();

        abstract Builder setEntryMap(ImmutableMap<ZipPath, ModuleEntry> var1);

        @CanIgnoreReturnValue
        public Builder setRawEntries(Collection<ModuleEntry> entries) {
            entries.forEach(entry -> Preconditions.checkArgument(!SpecialModuleEntry.getSpecialEntry(entry.getPath()).isPresent(), "Cannot add special entry '%s' using method setRawEntries.", (Object)entry.getPath()));
            this.setEntryMap(entries.stream().collect(ImmutableMap.toImmutableMap(ModuleEntry::getPath, Function.identity())));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addEntries(Collection<ModuleEntry> entries) {
            for (ModuleEntry entry : entries) {
                this.addEntry(entry);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addEntry(ModuleEntry moduleEntry) {
            block9: {
                Optional<SpecialModuleEntry> specialEntry = SpecialModuleEntry.getSpecialEntry(moduleEntry.getPath());
                if (specialEntry.isPresent()) {
                    try (InputStream inputStream = moduleEntry.getContent().openStream();){
                        specialEntry.get().addToModule(this, inputStream);
                        break block9;
                    }
                    catch (IOException e11) {
                        throw new UncheckedIOException(e11);
                    }
                }
                this.entryMapBuilder().put(moduleEntry.getPath(), moduleEntry);
            }
            return this;
        }

        abstract Optional<Resources.XmlNode> getAndroidManifestProto();

        public boolean hasAndroidManifest() {
            return this.getAndroidManifestProto().isPresent();
        }

        public abstract BundleModuleName getName();

        abstract BundleModule autoBuild();

        public final BundleModule build() {
            BundleModule bundleModule = this.autoBuild();
            if (bundleModule.getModuleType().equals((Object)ModuleType.UNKNOWN_MODULE_TYPE)) {
                bundleModule = bundleModule.toBuilder().setModuleType(bundleModule.getAndroidManifest().getModuleType()).build();
            }
            Preconditions.checkState(!bundleModule.getModuleType().equals((Object)ModuleType.SDK_DEPENDENCY_MODULE) || bundleModule.getSdkModulesConfig().isPresent(), "BundleModule of type SDK_DEPENDENCY_MODULE can not have empty SdkModulesConfig.");
            return bundleModule;
        }
    }

    public static enum ModuleType {
        UNKNOWN_MODULE_TYPE(false),
        FEATURE_MODULE(true),
        ASSET_MODULE(false),
        ML_MODULE(true),
        SDK_DEPENDENCY_MODULE(true);

        private final boolean isFeatureModule;

        private ModuleType(boolean isFeatureModule) {
            this.isFeatureModule = isFeatureModule;
        }

        public boolean isFeatureModule() {
            return this.isFeatureModule;
        }
    }
}

