// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package workspacesthinclientiface provides an interface to enable mocking the Amazon WorkSpaces Thin Client service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package workspacesthinclientiface

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/service/workspacesthinclient"
)

// WorkSpacesThinClientAPI provides an interface to enable mocking the
// workspacesthinclient.WorkSpacesThinClient service client's API operation,
// paginators, and waiters. This make unit testing your code that calls out
// to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//	// myFunc uses an SDK service client to make a request to
//	// Amazon WorkSpaces Thin Client.
//	func myFunc(svc workspacesthinclientiface.WorkSpacesThinClientAPI) bool {
//	    // Make svc.CreateEnvironment request
//	}
//
//	func main() {
//	    sess := session.New()
//	    svc := workspacesthinclient.New(sess)
//
//	    myFunc(svc)
//	}
//
// In your _test.go file:
//
//	// Define a mock struct to be used in your unit tests of myFunc.
//	type mockWorkSpacesThinClientClient struct {
//	    workspacesthinclientiface.WorkSpacesThinClientAPI
//	}
//	func (m *mockWorkSpacesThinClientClient) CreateEnvironment(input *workspacesthinclient.CreateEnvironmentInput) (*workspacesthinclient.CreateEnvironmentOutput, error) {
//	    // mock response/functionality
//	}
//
//	func TestMyFunc(t *testing.T) {
//	    // Setup Test
//	    mockSvc := &mockWorkSpacesThinClientClient{}
//
//	    myfunc(mockSvc)
//
//	    // Verify myFunc's functionality
//	}
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type WorkSpacesThinClientAPI interface {
	CreateEnvironment(*workspacesthinclient.CreateEnvironmentInput) (*workspacesthinclient.CreateEnvironmentOutput, error)
	CreateEnvironmentWithContext(aws.Context, *workspacesthinclient.CreateEnvironmentInput, ...request.Option) (*workspacesthinclient.CreateEnvironmentOutput, error)
	CreateEnvironmentRequest(*workspacesthinclient.CreateEnvironmentInput) (*request.Request, *workspacesthinclient.CreateEnvironmentOutput)

	DeleteDevice(*workspacesthinclient.DeleteDeviceInput) (*workspacesthinclient.DeleteDeviceOutput, error)
	DeleteDeviceWithContext(aws.Context, *workspacesthinclient.DeleteDeviceInput, ...request.Option) (*workspacesthinclient.DeleteDeviceOutput, error)
	DeleteDeviceRequest(*workspacesthinclient.DeleteDeviceInput) (*request.Request, *workspacesthinclient.DeleteDeviceOutput)

	DeleteEnvironment(*workspacesthinclient.DeleteEnvironmentInput) (*workspacesthinclient.DeleteEnvironmentOutput, error)
	DeleteEnvironmentWithContext(aws.Context, *workspacesthinclient.DeleteEnvironmentInput, ...request.Option) (*workspacesthinclient.DeleteEnvironmentOutput, error)
	DeleteEnvironmentRequest(*workspacesthinclient.DeleteEnvironmentInput) (*request.Request, *workspacesthinclient.DeleteEnvironmentOutput)

	DeregisterDevice(*workspacesthinclient.DeregisterDeviceInput) (*workspacesthinclient.DeregisterDeviceOutput, error)
	DeregisterDeviceWithContext(aws.Context, *workspacesthinclient.DeregisterDeviceInput, ...request.Option) (*workspacesthinclient.DeregisterDeviceOutput, error)
	DeregisterDeviceRequest(*workspacesthinclient.DeregisterDeviceInput) (*request.Request, *workspacesthinclient.DeregisterDeviceOutput)

	GetDevice(*workspacesthinclient.GetDeviceInput) (*workspacesthinclient.GetDeviceOutput, error)
	GetDeviceWithContext(aws.Context, *workspacesthinclient.GetDeviceInput, ...request.Option) (*workspacesthinclient.GetDeviceOutput, error)
	GetDeviceRequest(*workspacesthinclient.GetDeviceInput) (*request.Request, *workspacesthinclient.GetDeviceOutput)

	GetEnvironment(*workspacesthinclient.GetEnvironmentInput) (*workspacesthinclient.GetEnvironmentOutput, error)
	GetEnvironmentWithContext(aws.Context, *workspacesthinclient.GetEnvironmentInput, ...request.Option) (*workspacesthinclient.GetEnvironmentOutput, error)
	GetEnvironmentRequest(*workspacesthinclient.GetEnvironmentInput) (*request.Request, *workspacesthinclient.GetEnvironmentOutput)

	GetSoftwareSet(*workspacesthinclient.GetSoftwareSetInput) (*workspacesthinclient.GetSoftwareSetOutput, error)
	GetSoftwareSetWithContext(aws.Context, *workspacesthinclient.GetSoftwareSetInput, ...request.Option) (*workspacesthinclient.GetSoftwareSetOutput, error)
	GetSoftwareSetRequest(*workspacesthinclient.GetSoftwareSetInput) (*request.Request, *workspacesthinclient.GetSoftwareSetOutput)

	ListDevices(*workspacesthinclient.ListDevicesInput) (*workspacesthinclient.ListDevicesOutput, error)
	ListDevicesWithContext(aws.Context, *workspacesthinclient.ListDevicesInput, ...request.Option) (*workspacesthinclient.ListDevicesOutput, error)
	ListDevicesRequest(*workspacesthinclient.ListDevicesInput) (*request.Request, *workspacesthinclient.ListDevicesOutput)

	ListDevicesPages(*workspacesthinclient.ListDevicesInput, func(*workspacesthinclient.ListDevicesOutput, bool) bool) error
	ListDevicesPagesWithContext(aws.Context, *workspacesthinclient.ListDevicesInput, func(*workspacesthinclient.ListDevicesOutput, bool) bool, ...request.Option) error

	ListEnvironments(*workspacesthinclient.ListEnvironmentsInput) (*workspacesthinclient.ListEnvironmentsOutput, error)
	ListEnvironmentsWithContext(aws.Context, *workspacesthinclient.ListEnvironmentsInput, ...request.Option) (*workspacesthinclient.ListEnvironmentsOutput, error)
	ListEnvironmentsRequest(*workspacesthinclient.ListEnvironmentsInput) (*request.Request, *workspacesthinclient.ListEnvironmentsOutput)

	ListEnvironmentsPages(*workspacesthinclient.ListEnvironmentsInput, func(*workspacesthinclient.ListEnvironmentsOutput, bool) bool) error
	ListEnvironmentsPagesWithContext(aws.Context, *workspacesthinclient.ListEnvironmentsInput, func(*workspacesthinclient.ListEnvironmentsOutput, bool) bool, ...request.Option) error

	ListSoftwareSets(*workspacesthinclient.ListSoftwareSetsInput) (*workspacesthinclient.ListSoftwareSetsOutput, error)
	ListSoftwareSetsWithContext(aws.Context, *workspacesthinclient.ListSoftwareSetsInput, ...request.Option) (*workspacesthinclient.ListSoftwareSetsOutput, error)
	ListSoftwareSetsRequest(*workspacesthinclient.ListSoftwareSetsInput) (*request.Request, *workspacesthinclient.ListSoftwareSetsOutput)

	ListSoftwareSetsPages(*workspacesthinclient.ListSoftwareSetsInput, func(*workspacesthinclient.ListSoftwareSetsOutput, bool) bool) error
	ListSoftwareSetsPagesWithContext(aws.Context, *workspacesthinclient.ListSoftwareSetsInput, func(*workspacesthinclient.ListSoftwareSetsOutput, bool) bool, ...request.Option) error

	ListTagsForResource(*workspacesthinclient.ListTagsForResourceInput) (*workspacesthinclient.ListTagsForResourceOutput, error)
	ListTagsForResourceWithContext(aws.Context, *workspacesthinclient.ListTagsForResourceInput, ...request.Option) (*workspacesthinclient.ListTagsForResourceOutput, error)
	ListTagsForResourceRequest(*workspacesthinclient.ListTagsForResourceInput) (*request.Request, *workspacesthinclient.ListTagsForResourceOutput)

	TagResource(*workspacesthinclient.TagResourceInput) (*workspacesthinclient.TagResourceOutput, error)
	TagResourceWithContext(aws.Context, *workspacesthinclient.TagResourceInput, ...request.Option) (*workspacesthinclient.TagResourceOutput, error)
	TagResourceRequest(*workspacesthinclient.TagResourceInput) (*request.Request, *workspacesthinclient.TagResourceOutput)

	UntagResource(*workspacesthinclient.UntagResourceInput) (*workspacesthinclient.UntagResourceOutput, error)
	UntagResourceWithContext(aws.Context, *workspacesthinclient.UntagResourceInput, ...request.Option) (*workspacesthinclient.UntagResourceOutput, error)
	UntagResourceRequest(*workspacesthinclient.UntagResourceInput) (*request.Request, *workspacesthinclient.UntagResourceOutput)

	UpdateDevice(*workspacesthinclient.UpdateDeviceInput) (*workspacesthinclient.UpdateDeviceOutput, error)
	UpdateDeviceWithContext(aws.Context, *workspacesthinclient.UpdateDeviceInput, ...request.Option) (*workspacesthinclient.UpdateDeviceOutput, error)
	UpdateDeviceRequest(*workspacesthinclient.UpdateDeviceInput) (*request.Request, *workspacesthinclient.UpdateDeviceOutput)

	UpdateEnvironment(*workspacesthinclient.UpdateEnvironmentInput) (*workspacesthinclient.UpdateEnvironmentOutput, error)
	UpdateEnvironmentWithContext(aws.Context, *workspacesthinclient.UpdateEnvironmentInput, ...request.Option) (*workspacesthinclient.UpdateEnvironmentOutput, error)
	UpdateEnvironmentRequest(*workspacesthinclient.UpdateEnvironmentInput) (*request.Request, *workspacesthinclient.UpdateEnvironmentOutput)

	UpdateSoftwareSet(*workspacesthinclient.UpdateSoftwareSetInput) (*workspacesthinclient.UpdateSoftwareSetOutput, error)
	UpdateSoftwareSetWithContext(aws.Context, *workspacesthinclient.UpdateSoftwareSetInput, ...request.Option) (*workspacesthinclient.UpdateSoftwareSetOutput, error)
	UpdateSoftwareSetRequest(*workspacesthinclient.UpdateSoftwareSetInput) (*request.Request, *workspacesthinclient.UpdateSoftwareSetOutput)
}

var _ WorkSpacesThinClientAPI = (*workspacesthinclient.WorkSpacesThinClient)(nil)
