// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/workstations/v1/workstations.proto

#include "google/cloud/workstations/v1/internal/workstations_stub.h"
#include "google/cloud/grpc_error_delegate.h"
#include "google/cloud/status_or.h"
#include <google/cloud/workstations/v1/workstations.grpc.pb.h>
#include <google/longrunning/operations.grpc.pb.h>
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace workstations_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

WorkstationsStub::~WorkstationsStub() = default;

StatusOr<google::cloud::workstations::v1::WorkstationCluster>
DefaultWorkstationsStub::GetWorkstationCluster(
    grpc::ClientContext& context, Options const&,
    google::cloud::workstations::v1::GetWorkstationClusterRequest const&
        request) {
  google::cloud::workstations::v1::WorkstationCluster response;
  auto status = grpc_stub_->GetWorkstationCluster(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::workstations::v1::ListWorkstationClustersResponse>
DefaultWorkstationsStub::ListWorkstationClusters(
    grpc::ClientContext& context, Options const&,
    google::cloud::workstations::v1::ListWorkstationClustersRequest const&
        request) {
  google::cloud::workstations::v1::ListWorkstationClustersResponse response;
  auto status =
      grpc_stub_->ListWorkstationClusters(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

future<StatusOr<google::longrunning::Operation>>
DefaultWorkstationsStub::AsyncCreateWorkstationCluster(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions,
    google::cloud::workstations::v1::CreateWorkstationClusterRequest const&
        request) {
  return internal::MakeUnaryRpcImpl<
      google::cloud::workstations::v1::CreateWorkstationClusterRequest,
      google::longrunning::Operation>(
      cq,
      [this](grpc::ClientContext* context,
             google::cloud::workstations::v1::
                 CreateWorkstationClusterRequest const& request,
             grpc::CompletionQueue* cq) {
        return grpc_stub_->AsyncCreateWorkstationCluster(context, request, cq);
      },
      request, std::move(context));
}

StatusOr<google::longrunning::Operation>
DefaultWorkstationsStub::CreateWorkstationCluster(
    grpc::ClientContext& context, Options,
    google::cloud::workstations::v1::CreateWorkstationClusterRequest const&
        request) {
  google::longrunning::Operation response;
  auto status =
      grpc_stub_->CreateWorkstationCluster(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

future<StatusOr<google::longrunning::Operation>>
DefaultWorkstationsStub::AsyncUpdateWorkstationCluster(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions,
    google::cloud::workstations::v1::UpdateWorkstationClusterRequest const&
        request) {
  return internal::MakeUnaryRpcImpl<
      google::cloud::workstations::v1::UpdateWorkstationClusterRequest,
      google::longrunning::Operation>(
      cq,
      [this](grpc::ClientContext* context,
             google::cloud::workstations::v1::
                 UpdateWorkstationClusterRequest const& request,
             grpc::CompletionQueue* cq) {
        return grpc_stub_->AsyncUpdateWorkstationCluster(context, request, cq);
      },
      request, std::move(context));
}

StatusOr<google::longrunning::Operation>
DefaultWorkstationsStub::UpdateWorkstationCluster(
    grpc::ClientContext& context, Options,
    google::cloud::workstations::v1::UpdateWorkstationClusterRequest const&
        request) {
  google::longrunning::Operation response;
  auto status =
      grpc_stub_->UpdateWorkstationCluster(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

future<StatusOr<google::longrunning::Operation>>
DefaultWorkstationsStub::AsyncDeleteWorkstationCluster(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions,
    google::cloud::workstations::v1::DeleteWorkstationClusterRequest const&
        request) {
  return internal::MakeUnaryRpcImpl<
      google::cloud::workstations::v1::DeleteWorkstationClusterRequest,
      google::longrunning::Operation>(
      cq,
      [this](grpc::ClientContext* context,
             google::cloud::workstations::v1::
                 DeleteWorkstationClusterRequest const& request,
             grpc::CompletionQueue* cq) {
        return grpc_stub_->AsyncDeleteWorkstationCluster(context, request, cq);
      },
      request, std::move(context));
}

StatusOr<google::longrunning::Operation>
DefaultWorkstationsStub::DeleteWorkstationCluster(
    grpc::ClientContext& context, Options,
    google::cloud::workstations::v1::DeleteWorkstationClusterRequest const&
        request) {
  google::longrunning::Operation response;
  auto status =
      grpc_stub_->DeleteWorkstationCluster(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::workstations::v1::WorkstationConfig>
DefaultWorkstationsStub::GetWorkstationConfig(
    grpc::ClientContext& context, Options const&,
    google::cloud::workstations::v1::GetWorkstationConfigRequest const&
        request) {
  google::cloud::workstations::v1::WorkstationConfig response;
  auto status = grpc_stub_->GetWorkstationConfig(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::workstations::v1::ListWorkstationConfigsResponse>
DefaultWorkstationsStub::ListWorkstationConfigs(
    grpc::ClientContext& context, Options const&,
    google::cloud::workstations::v1::ListWorkstationConfigsRequest const&
        request) {
  google::cloud::workstations::v1::ListWorkstationConfigsResponse response;
  auto status =
      grpc_stub_->ListWorkstationConfigs(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::workstations::v1::ListUsableWorkstationConfigsResponse>
DefaultWorkstationsStub::ListUsableWorkstationConfigs(
    grpc::ClientContext& context, Options const&,
    google::cloud::workstations::v1::ListUsableWorkstationConfigsRequest const&
        request) {
  google::cloud::workstations::v1::ListUsableWorkstationConfigsResponse
      response;
  auto status =
      grpc_stub_->ListUsableWorkstationConfigs(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

future<StatusOr<google::longrunning::Operation>>
DefaultWorkstationsStub::AsyncCreateWorkstationConfig(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions,
    google::cloud::workstations::v1::CreateWorkstationConfigRequest const&
        request) {
  return internal::MakeUnaryRpcImpl<
      google::cloud::workstations::v1::CreateWorkstationConfigRequest,
      google::longrunning::Operation>(
      cq,
      [this](
          grpc::ClientContext* context,
          google::cloud::workstations::v1::CreateWorkstationConfigRequest const&
              request,
          grpc::CompletionQueue* cq) {
        return grpc_stub_->AsyncCreateWorkstationConfig(context, request, cq);
      },
      request, std::move(context));
}

StatusOr<google::longrunning::Operation>
DefaultWorkstationsStub::CreateWorkstationConfig(
    grpc::ClientContext& context, Options,
    google::cloud::workstations::v1::CreateWorkstationConfigRequest const&
        request) {
  google::longrunning::Operation response;
  auto status =
      grpc_stub_->CreateWorkstationConfig(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

future<StatusOr<google::longrunning::Operation>>
DefaultWorkstationsStub::AsyncUpdateWorkstationConfig(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions,
    google::cloud::workstations::v1::UpdateWorkstationConfigRequest const&
        request) {
  return internal::MakeUnaryRpcImpl<
      google::cloud::workstations::v1::UpdateWorkstationConfigRequest,
      google::longrunning::Operation>(
      cq,
      [this](
          grpc::ClientContext* context,
          google::cloud::workstations::v1::UpdateWorkstationConfigRequest const&
              request,
          grpc::CompletionQueue* cq) {
        return grpc_stub_->AsyncUpdateWorkstationConfig(context, request, cq);
      },
      request, std::move(context));
}

StatusOr<google::longrunning::Operation>
DefaultWorkstationsStub::UpdateWorkstationConfig(
    grpc::ClientContext& context, Options,
    google::cloud::workstations::v1::UpdateWorkstationConfigRequest const&
        request) {
  google::longrunning::Operation response;
  auto status =
      grpc_stub_->UpdateWorkstationConfig(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

future<StatusOr<google::longrunning::Operation>>
DefaultWorkstationsStub::AsyncDeleteWorkstationConfig(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions,
    google::cloud::workstations::v1::DeleteWorkstationConfigRequest const&
        request) {
  return internal::MakeUnaryRpcImpl<
      google::cloud::workstations::v1::DeleteWorkstationConfigRequest,
      google::longrunning::Operation>(
      cq,
      [this](
          grpc::ClientContext* context,
          google::cloud::workstations::v1::DeleteWorkstationConfigRequest const&
              request,
          grpc::CompletionQueue* cq) {
        return grpc_stub_->AsyncDeleteWorkstationConfig(context, request, cq);
      },
      request, std::move(context));
}

StatusOr<google::longrunning::Operation>
DefaultWorkstationsStub::DeleteWorkstationConfig(
    grpc::ClientContext& context, Options,
    google::cloud::workstations::v1::DeleteWorkstationConfigRequest const&
        request) {
  google::longrunning::Operation response;
  auto status =
      grpc_stub_->DeleteWorkstationConfig(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::workstations::v1::Workstation>
DefaultWorkstationsStub::GetWorkstation(
    grpc::ClientContext& context, Options const&,
    google::cloud::workstations::v1::GetWorkstationRequest const& request) {
  google::cloud::workstations::v1::Workstation response;
  auto status = grpc_stub_->GetWorkstation(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::workstations::v1::ListWorkstationsResponse>
DefaultWorkstationsStub::ListWorkstations(
    grpc::ClientContext& context, Options const&,
    google::cloud::workstations::v1::ListWorkstationsRequest const& request) {
  google::cloud::workstations::v1::ListWorkstationsResponse response;
  auto status = grpc_stub_->ListWorkstations(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::workstations::v1::ListUsableWorkstationsResponse>
DefaultWorkstationsStub::ListUsableWorkstations(
    grpc::ClientContext& context, Options const&,
    google::cloud::workstations::v1::ListUsableWorkstationsRequest const&
        request) {
  google::cloud::workstations::v1::ListUsableWorkstationsResponse response;
  auto status =
      grpc_stub_->ListUsableWorkstations(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

future<StatusOr<google::longrunning::Operation>>
DefaultWorkstationsStub::AsyncCreateWorkstation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions,
    google::cloud::workstations::v1::CreateWorkstationRequest const& request) {
  return internal::MakeUnaryRpcImpl<
      google::cloud::workstations::v1::CreateWorkstationRequest,
      google::longrunning::Operation>(
      cq,
      [this](grpc::ClientContext* context,
             google::cloud::workstations::v1::CreateWorkstationRequest const&
                 request,
             grpc::CompletionQueue* cq) {
        return grpc_stub_->AsyncCreateWorkstation(context, request, cq);
      },
      request, std::move(context));
}

StatusOr<google::longrunning::Operation>
DefaultWorkstationsStub::CreateWorkstation(
    grpc::ClientContext& context, Options,
    google::cloud::workstations::v1::CreateWorkstationRequest const& request) {
  google::longrunning::Operation response;
  auto status = grpc_stub_->CreateWorkstation(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

future<StatusOr<google::longrunning::Operation>>
DefaultWorkstationsStub::AsyncUpdateWorkstation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions,
    google::cloud::workstations::v1::UpdateWorkstationRequest const& request) {
  return internal::MakeUnaryRpcImpl<
      google::cloud::workstations::v1::UpdateWorkstationRequest,
      google::longrunning::Operation>(
      cq,
      [this](grpc::ClientContext* context,
             google::cloud::workstations::v1::UpdateWorkstationRequest const&
                 request,
             grpc::CompletionQueue* cq) {
        return grpc_stub_->AsyncUpdateWorkstation(context, request, cq);
      },
      request, std::move(context));
}

StatusOr<google::longrunning::Operation>
DefaultWorkstationsStub::UpdateWorkstation(
    grpc::ClientContext& context, Options,
    google::cloud::workstations::v1::UpdateWorkstationRequest const& request) {
  google::longrunning::Operation response;
  auto status = grpc_stub_->UpdateWorkstation(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

future<StatusOr<google::longrunning::Operation>>
DefaultWorkstationsStub::AsyncDeleteWorkstation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions,
    google::cloud::workstations::v1::DeleteWorkstationRequest const& request) {
  return internal::MakeUnaryRpcImpl<
      google::cloud::workstations::v1::DeleteWorkstationRequest,
      google::longrunning::Operation>(
      cq,
      [this](grpc::ClientContext* context,
             google::cloud::workstations::v1::DeleteWorkstationRequest const&
                 request,
             grpc::CompletionQueue* cq) {
        return grpc_stub_->AsyncDeleteWorkstation(context, request, cq);
      },
      request, std::move(context));
}

StatusOr<google::longrunning::Operation>
DefaultWorkstationsStub::DeleteWorkstation(
    grpc::ClientContext& context, Options,
    google::cloud::workstations::v1::DeleteWorkstationRequest const& request) {
  google::longrunning::Operation response;
  auto status = grpc_stub_->DeleteWorkstation(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

future<StatusOr<google::longrunning::Operation>>
DefaultWorkstationsStub::AsyncStartWorkstation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions,
    google::cloud::workstations::v1::StartWorkstationRequest const& request) {
  return internal::MakeUnaryRpcImpl<
      google::cloud::workstations::v1::StartWorkstationRequest,
      google::longrunning::Operation>(
      cq,
      [this](grpc::ClientContext* context,
             google::cloud::workstations::v1::StartWorkstationRequest const&
                 request,
             grpc::CompletionQueue* cq) {
        return grpc_stub_->AsyncStartWorkstation(context, request, cq);
      },
      request, std::move(context));
}

StatusOr<google::longrunning::Operation>
DefaultWorkstationsStub::StartWorkstation(
    grpc::ClientContext& context, Options,
    google::cloud::workstations::v1::StartWorkstationRequest const& request) {
  google::longrunning::Operation response;
  auto status = grpc_stub_->StartWorkstation(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

future<StatusOr<google::longrunning::Operation>>
DefaultWorkstationsStub::AsyncStopWorkstation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions,
    google::cloud::workstations::v1::StopWorkstationRequest const& request) {
  return internal::MakeUnaryRpcImpl<
      google::cloud::workstations::v1::StopWorkstationRequest,
      google::longrunning::Operation>(
      cq,
      [this](grpc::ClientContext* context,
             google::cloud::workstations::v1::StopWorkstationRequest const&
                 request,
             grpc::CompletionQueue* cq) {
        return grpc_stub_->AsyncStopWorkstation(context, request, cq);
      },
      request, std::move(context));
}

StatusOr<google::longrunning::Operation>
DefaultWorkstationsStub::StopWorkstation(
    grpc::ClientContext& context, Options,
    google::cloud::workstations::v1::StopWorkstationRequest const& request) {
  google::longrunning::Operation response;
  auto status = grpc_stub_->StopWorkstation(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::workstations::v1::GenerateAccessTokenResponse>
DefaultWorkstationsStub::GenerateAccessToken(
    grpc::ClientContext& context, Options const&,
    google::cloud::workstations::v1::GenerateAccessTokenRequest const&
        request) {
  google::cloud::workstations::v1::GenerateAccessTokenResponse response;
  auto status = grpc_stub_->GenerateAccessToken(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

future<StatusOr<google::longrunning::Operation>>
DefaultWorkstationsStub::AsyncGetOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    // NOLINTNEXTLINE(performance-unnecessary-value-param)
    google::cloud::internal::ImmutableOptions,
    google::longrunning::GetOperationRequest const& request) {
  return internal::MakeUnaryRpcImpl<google::longrunning::GetOperationRequest,
                                    google::longrunning::Operation>(
      cq,
      [this](grpc::ClientContext* context,
             google::longrunning::GetOperationRequest const& request,
             grpc::CompletionQueue* cq) {
        return operations_->AsyncGetOperation(context, request, cq);
      },
      request, std::move(context));
}

future<Status> DefaultWorkstationsStub::AsyncCancelOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    // NOLINTNEXTLINE(performance-unnecessary-value-param)
    google::cloud::internal::ImmutableOptions,
    google::longrunning::CancelOperationRequest const& request) {
  return internal::MakeUnaryRpcImpl<google::longrunning::CancelOperationRequest,
                                    google::protobuf::Empty>(
             cq,
             [this](grpc::ClientContext* context,
                    google::longrunning::CancelOperationRequest const& request,
                    grpc::CompletionQueue* cq) {
               return operations_->AsyncCancelOperation(context, request, cq);
             },
             request, std::move(context))
      .then([](future<StatusOr<google::protobuf::Empty>> f) {
        return f.get().status();
      });
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace workstations_v1_internal
}  // namespace cloud
}  // namespace google
