// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/logging/v2/logging_metrics.proto

#include "google/cloud/logging/v2/metrics_service_v2_connection_idempotency_policy.h"
#include <memory>

namespace google {
namespace cloud {
namespace logging_v2 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

MetricsServiceV2ConnectionIdempotencyPolicy::
    ~MetricsServiceV2ConnectionIdempotencyPolicy() = default;

std::unique_ptr<MetricsServiceV2ConnectionIdempotencyPolicy>
MetricsServiceV2ConnectionIdempotencyPolicy::clone() const {
  return std::make_unique<MetricsServiceV2ConnectionIdempotencyPolicy>(*this);
}

Idempotency MetricsServiceV2ConnectionIdempotencyPolicy::ListLogMetrics(
    google::logging::v2::ListLogMetricsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency MetricsServiceV2ConnectionIdempotencyPolicy::GetLogMetric(
    google::logging::v2::GetLogMetricRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency MetricsServiceV2ConnectionIdempotencyPolicy::CreateLogMetric(
    google::logging::v2::CreateLogMetricRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency MetricsServiceV2ConnectionIdempotencyPolicy::UpdateLogMetric(
    google::logging::v2::UpdateLogMetricRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency MetricsServiceV2ConnectionIdempotencyPolicy::DeleteLogMetric(
    google::logging::v2::DeleteLogMetricRequest const&) {
  return Idempotency::kNonIdempotent;
}

std::unique_ptr<MetricsServiceV2ConnectionIdempotencyPolicy>
MakeDefaultMetricsServiceV2ConnectionIdempotencyPolicy() {
  return std::make_unique<MetricsServiceV2ConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace logging_v2
}  // namespace cloud
}  // namespace google
