// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/iap/v1/service.proto

#include "google/cloud/iap/v1/internal/identity_aware_proxy_o_auth_metadata_decorator.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/absl_str_cat_quiet.h"
#include "google/cloud/internal/api_client_header.h"
#include "google/cloud/internal/url_encode.h"
#include "google/cloud/status_or.h"
#include <google/cloud/iap/v1/service.grpc.pb.h>
#include <memory>
#include <string>
#include <utility>
#include <vector>

namespace google {
namespace cloud {
namespace iap_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

IdentityAwareProxyOAuthServiceMetadata::IdentityAwareProxyOAuthServiceMetadata(
    std::shared_ptr<IdentityAwareProxyOAuthServiceStub> child,
    std::multimap<std::string, std::string> fixed_metadata,
    std::string api_client_header)
    : child_(std::move(child)),
      fixed_metadata_(std::move(fixed_metadata)),
      api_client_header_(
          api_client_header.empty()
              ? google::cloud::internal::GeneratedLibClientHeader()
              : std::move(api_client_header)) {}

StatusOr<google::cloud::iap::v1::ListBrandsResponse>
IdentityAwareProxyOAuthServiceMetadata::ListBrands(
    grpc::ClientContext& context, Options const& options,
    google::cloud::iap::v1::ListBrandsRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->ListBrands(context, options, request);
}

StatusOr<google::cloud::iap::v1::Brand>
IdentityAwareProxyOAuthServiceMetadata::CreateBrand(
    grpc::ClientContext& context, Options const& options,
    google::cloud::iap::v1::CreateBrandRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->CreateBrand(context, options, request);
}

StatusOr<google::cloud::iap::v1::Brand>
IdentityAwareProxyOAuthServiceMetadata::GetBrand(
    grpc::ClientContext& context, Options const& options,
    google::cloud::iap::v1::GetBrandRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->GetBrand(context, options, request);
}

StatusOr<google::cloud::iap::v1::IdentityAwareProxyClient>
IdentityAwareProxyOAuthServiceMetadata::CreateIdentityAwareProxyClient(
    grpc::ClientContext& context, Options const& options,
    google::cloud::iap::v1::CreateIdentityAwareProxyClientRequest const&
        request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->CreateIdentityAwareProxyClient(context, options, request);
}

StatusOr<google::cloud::iap::v1::ListIdentityAwareProxyClientsResponse>
IdentityAwareProxyOAuthServiceMetadata::ListIdentityAwareProxyClients(
    grpc::ClientContext& context, Options const& options,
    google::cloud::iap::v1::ListIdentityAwareProxyClientsRequest const&
        request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->ListIdentityAwareProxyClients(context, options, request);
}

StatusOr<google::cloud::iap::v1::IdentityAwareProxyClient>
IdentityAwareProxyOAuthServiceMetadata::GetIdentityAwareProxyClient(
    grpc::ClientContext& context, Options const& options,
    google::cloud::iap::v1::GetIdentityAwareProxyClientRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->GetIdentityAwareProxyClient(context, options, request);
}

StatusOr<google::cloud::iap::v1::IdentityAwareProxyClient>
IdentityAwareProxyOAuthServiceMetadata::ResetIdentityAwareProxyClientSecret(
    grpc::ClientContext& context, Options const& options,
    google::cloud::iap::v1::ResetIdentityAwareProxyClientSecretRequest const&
        request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->ResetIdentityAwareProxyClientSecret(context, options, request);
}

Status IdentityAwareProxyOAuthServiceMetadata::DeleteIdentityAwareProxyClient(
    grpc::ClientContext& context, Options const& options,
    google::cloud::iap::v1::DeleteIdentityAwareProxyClientRequest const&
        request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->DeleteIdentityAwareProxyClient(context, options, request);
}

void IdentityAwareProxyOAuthServiceMetadata::SetMetadata(
    grpc::ClientContext& context, Options const& options,
    std::string const& request_params) {
  context.AddMetadata("x-goog-request-params", request_params);
  SetMetadata(context, options);
}

void IdentityAwareProxyOAuthServiceMetadata::SetMetadata(
    grpc::ClientContext& context, Options const& options) {
  google::cloud::internal::SetMetadata(context, options, fixed_metadata_,
                                       api_client_header_);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace iap_v1_internal
}  // namespace cloud
}  // namespace google
