// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/dialogflow/v2/document.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DIALOGFLOW_ES_DOCUMENTS_CLIENT_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DIALOGFLOW_ES_DOCUMENTS_CLIENT_H

#include "google/cloud/dialogflow_es/documents_connection.h"
#include "google/cloud/future.h"
#include "google/cloud/no_await_tag.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <google/longrunning/operations.grpc.pb.h>
#include <map>
#include <memory>
#include <string>

namespace google {
namespace cloud {
namespace dialogflow_es {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

///
/// Service for managing knowledge
/// [Documents][google.cloud.dialogflow.v2.Document].
///
/// @par Equality
///
/// Instances of this class created via copy-construction or copy-assignment
/// always compare equal. Instances created with equal
/// `std::shared_ptr<*Connection>` objects compare equal. Objects that compare
/// equal share the same underlying resources.
///
/// @par Performance
///
/// Creating a new instance of this class is a relatively expensive operation,
/// new objects establish new connections to the service. In contrast,
/// copy-construction, move-construction, and the corresponding assignment
/// operations are relatively efficient as the copies share all underlying
/// resources.
///
/// @par Thread Safety
///
/// Concurrent access to different instances of this class, even if they compare
/// equal, is guaranteed to work. Two or more threads operating on the same
/// instance of this class is not guaranteed to work. Since copy-construction
/// and move-construction is a relatively efficient operation, consider using
/// such a copy when using this class from multiple threads.
///
/// [google.cloud.dialogflow.v2.Document]:
/// @googleapis_reference_link{google/cloud/dialogflow/v2/document.proto#L261}
///
class DocumentsClient {
 public:
  explicit DocumentsClient(std::shared_ptr<DocumentsConnection> connection,
                           Options opts = {});
  ~DocumentsClient();

  ///@{
  /// @name Copy and move support
  DocumentsClient(DocumentsClient const&) = default;
  DocumentsClient& operator=(DocumentsClient const&) = default;
  DocumentsClient(DocumentsClient&&) = default;
  DocumentsClient& operator=(DocumentsClient&&) = default;
  ///@}

  ///@{
  /// @name Equality
  friend bool operator==(DocumentsClient const& a, DocumentsClient const& b) {
    return a.connection_ == b.connection_;
  }
  friend bool operator!=(DocumentsClient const& a, DocumentsClient const& b) {
    return !(a == b);
  }
  ///@}

  // clang-format off
  ///
  /// Returns the list of all documents of the knowledge base.
  ///
  /// @param parent  Required. The knowledge base to list all documents for.
  ///  Format: `projects/<Project ID>/locations/<Location ID>/knowledgeBases/<Knowledge Base ID>`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.dialogflow.v2.Document], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.dialogflow.v2.Document]: @googleapis_reference_link{google/cloud/dialogflow/v2/document.proto#L261}
  /// [google.cloud.dialogflow.v2.ListDocumentsRequest]: @googleapis_reference_link{google/cloud/dialogflow/v2/document.proto#L411}
  ///
  // clang-format on
  StreamRange<google::cloud::dialogflow::v2::Document> ListDocuments(
      std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Returns the list of all documents of the knowledge base.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.dialogflow.v2.ListDocumentsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.dialogflow.v2.Document], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.dialogflow.v2.Document]: @googleapis_reference_link{google/cloud/dialogflow/v2/document.proto#L261}
  /// [google.cloud.dialogflow.v2.ListDocumentsRequest]: @googleapis_reference_link{google/cloud/dialogflow/v2/document.proto#L411}
  ///
  // clang-format on
  StreamRange<google::cloud::dialogflow::v2::Document> ListDocuments(
      google::cloud::dialogflow::v2::ListDocumentsRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Retrieves the specified document.
  ///
  /// @param name  Required. The name of the document to retrieve.
  ///  Format `projects/<Project ID>/locations/<Location ID>/knowledgeBases/<Knowledge Base ID>/documents/<Document ID>`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.dialogflow.v2.Document])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.dialogflow.v2.Document]: @googleapis_reference_link{google/cloud/dialogflow/v2/document.proto#L261}
  /// [google.cloud.dialogflow.v2.GetDocumentRequest]: @googleapis_reference_link{google/cloud/dialogflow/v2/document.proto#L397}
  ///
  // clang-format on
  StatusOr<google::cloud::dialogflow::v2::Document> GetDocument(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Retrieves the specified document.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.dialogflow.v2.GetDocumentRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.dialogflow.v2.Document])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.dialogflow.v2.Document]: @googleapis_reference_link{google/cloud/dialogflow/v2/document.proto#L261}
  /// [google.cloud.dialogflow.v2.GetDocumentRequest]: @googleapis_reference_link{google/cloud/dialogflow/v2/document.proto#L397}
  ///
  // clang-format on
  StatusOr<google::cloud::dialogflow::v2::Document> GetDocument(
      google::cloud::dialogflow::v2::GetDocumentRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Creates a new document.
  ///
  /// This method is a [long-running
  /// operation](https://cloud.google.com/dialogflow/cx/docs/how/long-running-operation).
  /// The returned `Operation` type has the following method-specific fields:
  ///
  /// - `metadata`:
  /// [KnowledgeOperationMetadata][google.cloud.dialogflow.v2.KnowledgeOperationMetadata]
  /// - `response`: [Document][google.cloud.dialogflow.v2.Document]
  ///
  /// @param parent  Required. The knowledge base to create a document for.
  ///  Format: `projects/<Project ID>/locations/<Location ID>/knowledgeBases/<Knowledge Base ID>`.
  /// @param document  Required. The document to create.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.dialogflow.v2.Document] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.dialogflow.v2.CreateDocumentRequest]: @googleapis_reference_link{google/cloud/dialogflow/v2/document.proto#L466}
  /// [google.cloud.dialogflow.v2.Document]: @googleapis_reference_link{google/cloud/dialogflow/v2/document.proto#L261}
  /// [google.cloud.dialogflow.v2.KnowledgeOperationMetadata]: @googleapis_reference_link{google/cloud/dialogflow/v2/document.proto#L646}
  ///
  // clang-format on
  future<StatusOr<google::cloud::dialogflow::v2::Document>> CreateDocument(
      std::string const& parent,
      google::cloud::dialogflow::v2::Document const& document,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateDocument
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateDocument(
      NoAwaitTag, std::string const& parent,
      google::cloud::dialogflow::v2::Document const& document,
      Options opts = {});

  // clang-format off
  ///
  /// Creates a new document.
  ///
  /// This method is a [long-running
  /// operation](https://cloud.google.com/dialogflow/cx/docs/how/long-running-operation).
  /// The returned `Operation` type has the following method-specific fields:
  ///
  /// - `metadata`:
  /// [KnowledgeOperationMetadata][google.cloud.dialogflow.v2.KnowledgeOperationMetadata]
  /// - `response`: [Document][google.cloud.dialogflow.v2.Document]
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.dialogflow.v2.CreateDocumentRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.dialogflow.v2.Document] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.dialogflow.v2.CreateDocumentRequest]: @googleapis_reference_link{google/cloud/dialogflow/v2/document.proto#L466}
  /// [google.cloud.dialogflow.v2.Document]: @googleapis_reference_link{google/cloud/dialogflow/v2/document.proto#L261}
  /// [google.cloud.dialogflow.v2.KnowledgeOperationMetadata]: @googleapis_reference_link{google/cloud/dialogflow/v2/document.proto#L646}
  ///
  // clang-format on
  future<StatusOr<google::cloud::dialogflow::v2::Document>> CreateDocument(
      google::cloud::dialogflow::v2::CreateDocumentRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateDocument
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateDocument(
      NoAwaitTag,
      google::cloud::dialogflow::v2::CreateDocumentRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateDocument
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::dialogflow::v2::Document>> CreateDocument(
      google::longrunning::Operation const& operation, Options opts = {});

  // clang-format off
  ///
  /// Creates documents by importing data from external sources.
  /// Dialogflow supports up to 350 documents in each request. If you try to
  /// import more, Dialogflow will return an error.
  ///
  /// This method is a [long-running
  /// operation](https://cloud.google.com/dialogflow/cx/docs/how/long-running-operation).
  /// The returned `Operation` type has the following method-specific fields:
  ///
  /// - `metadata`:
  /// [KnowledgeOperationMetadata][google.cloud.dialogflow.v2.KnowledgeOperationMetadata]
  /// - `response`:
  /// [ImportDocumentsResponse][google.cloud.dialogflow.v2.ImportDocumentsResponse]
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.dialogflow.v2.ImportDocumentsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.dialogflow.v2.ImportDocumentsResponse] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.dialogflow.v2.ImportDocumentsRequest]: @googleapis_reference_link{google/cloud/dialogflow/v2/document.proto#L483}
  /// [google.cloud.dialogflow.v2.ImportDocumentsResponse]: @googleapis_reference_link{google/cloud/dialogflow/v2/document.proto#L539}
  /// [google.cloud.dialogflow.v2.KnowledgeOperationMetadata]: @googleapis_reference_link{google/cloud/dialogflow/v2/document.proto#L646}
  ///
  // clang-format on
  future<StatusOr<google::cloud::dialogflow::v2::ImportDocumentsResponse>>
  ImportDocuments(
      google::cloud::dialogflow::v2::ImportDocumentsRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief ImportDocuments
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> ImportDocuments(
      NoAwaitTag,
      google::cloud::dialogflow::v2::ImportDocumentsRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief ImportDocuments
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::dialogflow::v2::ImportDocumentsResponse>>
  ImportDocuments(google::longrunning::Operation const& operation,
                  Options opts = {});

  // clang-format off
  ///
  /// Deletes the specified document.
  ///
  /// This method is a [long-running
  /// operation](https://cloud.google.com/dialogflow/cx/docs/how/long-running-operation).
  /// The returned `Operation` type has the following method-specific fields:
  ///
  /// - `metadata`:
  /// [KnowledgeOperationMetadata][google.cloud.dialogflow.v2.KnowledgeOperationMetadata]
  /// - `response`: An [Empty
  ///   message](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#empty)
  ///
  /// @param name  Required. The name of the document to delete.
  ///  Format: `projects/<Project ID>/locations/<Location ID>/knowledgeBases/<Knowledge Base ID>/documents/<Document ID>`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.dialogflow.v2.KnowledgeOperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.dialogflow.v2.DeleteDocumentRequest]: @googleapis_reference_link{google/cloud/dialogflow/v2/document.proto#L546}
  /// [google.cloud.dialogflow.v2.KnowledgeOperationMetadata]: @googleapis_reference_link{google/cloud/dialogflow/v2/document.proto#L646}
  ///
  // clang-format on
  future<StatusOr<google::cloud::dialogflow::v2::KnowledgeOperationMetadata>>
  DeleteDocument(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteDocument
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteDocument(
      NoAwaitTag, std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Deletes the specified document.
  ///
  /// This method is a [long-running
  /// operation](https://cloud.google.com/dialogflow/cx/docs/how/long-running-operation).
  /// The returned `Operation` type has the following method-specific fields:
  ///
  /// - `metadata`:
  /// [KnowledgeOperationMetadata][google.cloud.dialogflow.v2.KnowledgeOperationMetadata]
  /// - `response`: An [Empty
  ///   message](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#empty)
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.dialogflow.v2.DeleteDocumentRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.dialogflow.v2.KnowledgeOperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.dialogflow.v2.DeleteDocumentRequest]: @googleapis_reference_link{google/cloud/dialogflow/v2/document.proto#L546}
  /// [google.cloud.dialogflow.v2.KnowledgeOperationMetadata]: @googleapis_reference_link{google/cloud/dialogflow/v2/document.proto#L646}
  ///
  // clang-format on
  future<StatusOr<google::cloud::dialogflow::v2::KnowledgeOperationMetadata>>
  DeleteDocument(
      google::cloud::dialogflow::v2::DeleteDocumentRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteDocument
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteDocument(
      NoAwaitTag,
      google::cloud::dialogflow::v2::DeleteDocumentRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteDocument
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::dialogflow::v2::KnowledgeOperationMetadata>>
  DeleteDocument(google::longrunning::Operation const& operation,
                 Options opts = {});

  // clang-format off
  ///
  /// Updates the specified document.
  ///
  /// This method is a [long-running
  /// operation](https://cloud.google.com/dialogflow/cx/docs/how/long-running-operation).
  /// The returned `Operation` type has the following method-specific fields:
  ///
  /// - `metadata`:
  /// [KnowledgeOperationMetadata][google.cloud.dialogflow.v2.KnowledgeOperationMetadata]
  /// - `response`: [Document][google.cloud.dialogflow.v2.Document]
  ///
  /// @param document  Required. The document to update.
  /// @param update_mask  Optional. Not specified means `update all`.
  ///  Currently, only `display_name` can be updated, an InvalidArgument will be
  ///  returned for attempting to update other fields.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.dialogflow.v2.Document] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.dialogflow.v2.Document]: @googleapis_reference_link{google/cloud/dialogflow/v2/document.proto#L261}
  /// [google.cloud.dialogflow.v2.KnowledgeOperationMetadata]: @googleapis_reference_link{google/cloud/dialogflow/v2/document.proto#L646}
  /// [google.cloud.dialogflow.v2.UpdateDocumentRequest]: @googleapis_reference_link{google/cloud/dialogflow/v2/document.proto#L560}
  ///
  // clang-format on
  future<StatusOr<google::cloud::dialogflow::v2::Document>> UpdateDocument(
      google::cloud::dialogflow::v2::Document const& document,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateDocument
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UpdateDocument(
      NoAwaitTag, google::cloud::dialogflow::v2::Document const& document,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// Updates the specified document.
  ///
  /// This method is a [long-running
  /// operation](https://cloud.google.com/dialogflow/cx/docs/how/long-running-operation).
  /// The returned `Operation` type has the following method-specific fields:
  ///
  /// - `metadata`:
  /// [KnowledgeOperationMetadata][google.cloud.dialogflow.v2.KnowledgeOperationMetadata]
  /// - `response`: [Document][google.cloud.dialogflow.v2.Document]
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.dialogflow.v2.UpdateDocumentRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.dialogflow.v2.Document] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.dialogflow.v2.Document]: @googleapis_reference_link{google/cloud/dialogflow/v2/document.proto#L261}
  /// [google.cloud.dialogflow.v2.KnowledgeOperationMetadata]: @googleapis_reference_link{google/cloud/dialogflow/v2/document.proto#L646}
  /// [google.cloud.dialogflow.v2.UpdateDocumentRequest]: @googleapis_reference_link{google/cloud/dialogflow/v2/document.proto#L560}
  ///
  // clang-format on
  future<StatusOr<google::cloud::dialogflow::v2::Document>> UpdateDocument(
      google::cloud::dialogflow::v2::UpdateDocumentRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateDocument
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UpdateDocument(
      NoAwaitTag,
      google::cloud::dialogflow::v2::UpdateDocumentRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateDocument
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::dialogflow::v2::Document>> UpdateDocument(
      google::longrunning::Operation const& operation, Options opts = {});

  // clang-format off
  ///
  /// Reloads the specified document from its specified source, content_uri or
  /// content. The previously loaded content of the document will be deleted.
  /// Note: Even when the content of the document has not changed, there still
  /// may be side effects because of internal implementation changes.
  ///
  /// This method is a [long-running
  /// operation](https://cloud.google.com/dialogflow/cx/docs/how/long-running-operation).
  /// The returned `Operation` type has the following method-specific fields:
  ///
  /// - `metadata`:
  /// [KnowledgeOperationMetadata][google.cloud.dialogflow.v2.KnowledgeOperationMetadata]
  /// - `response`: [Document][google.cloud.dialogflow.v2.Document]
  ///
  /// Note: The `projects.agent.knowledgeBases.documents` resource is deprecated;
  /// only use `projects.knowledgeBases.documents`.
  ///
  /// @param name  Required. The name of the document to reload.
  ///  Format: `projects/<Project ID>/locations/<Location ID>/knowledgeBases/<Knowledge Base ID>/documents/<Document ID>`
  /// @param content_uri  Optional. The path of gcs source file for reloading document content. For
  ///  now, only gcs uri is supported.
  ///  @n
  ///  For documents stored in Google Cloud Storage, these URIs must have
  ///  the form `gs://<bucket-name>/<object-name>`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.dialogflow.v2.Document] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.dialogflow.v2.Document]: @googleapis_reference_link{google/cloud/dialogflow/v2/document.proto#L261}
  /// [google.cloud.dialogflow.v2.KnowledgeOperationMetadata]: @googleapis_reference_link{google/cloud/dialogflow/v2/document.proto#L646}
  /// [google.cloud.dialogflow.v2.ReloadDocumentRequest]: @googleapis_reference_link{google/cloud/dialogflow/v2/document.proto#L573}
  ///
  // clang-format on
  future<StatusOr<google::cloud::dialogflow::v2::Document>> ReloadDocument(
      std::string const& name, std::string const& content_uri,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief ReloadDocument
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> ReloadDocument(
      NoAwaitTag, std::string const& name, std::string const& content_uri,
      Options opts = {});

  // clang-format off
  ///
  /// Reloads the specified document from its specified source, content_uri or
  /// content. The previously loaded content of the document will be deleted.
  /// Note: Even when the content of the document has not changed, there still
  /// may be side effects because of internal implementation changes.
  ///
  /// This method is a [long-running
  /// operation](https://cloud.google.com/dialogflow/cx/docs/how/long-running-operation).
  /// The returned `Operation` type has the following method-specific fields:
  ///
  /// - `metadata`:
  /// [KnowledgeOperationMetadata][google.cloud.dialogflow.v2.KnowledgeOperationMetadata]
  /// - `response`: [Document][google.cloud.dialogflow.v2.Document]
  ///
  /// Note: The `projects.agent.knowledgeBases.documents` resource is deprecated;
  /// only use `projects.knowledgeBases.documents`.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.dialogflow.v2.ReloadDocumentRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.dialogflow.v2.Document] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.dialogflow.v2.Document]: @googleapis_reference_link{google/cloud/dialogflow/v2/document.proto#L261}
  /// [google.cloud.dialogflow.v2.KnowledgeOperationMetadata]: @googleapis_reference_link{google/cloud/dialogflow/v2/document.proto#L646}
  /// [google.cloud.dialogflow.v2.ReloadDocumentRequest]: @googleapis_reference_link{google/cloud/dialogflow/v2/document.proto#L573}
  ///
  // clang-format on
  future<StatusOr<google::cloud::dialogflow::v2::Document>> ReloadDocument(
      google::cloud::dialogflow::v2::ReloadDocumentRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief ReloadDocument
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> ReloadDocument(
      NoAwaitTag,
      google::cloud::dialogflow::v2::ReloadDocumentRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief ReloadDocument
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::dialogflow::v2::Document>> ReloadDocument(
      google::longrunning::Operation const& operation, Options opts = {});

  // clang-format off
  ///
  /// Exports a smart messaging candidate document into the specified
  /// destination.
  ///
  /// This method is a [long-running
  /// operation](https://cloud.google.com/dialogflow/cx/docs/how/long-running-operation).
  /// The returned `Operation` type has the following method-specific fields:
  ///
  /// - `metadata`:
  /// [KnowledgeOperationMetadata][google.cloud.dialogflow.v2.KnowledgeOperationMetadata]
  /// - `response`: [Document][google.cloud.dialogflow.v2.Document]
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.dialogflow.v2.ExportDocumentRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.dialogflow.v2.Document] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.dialogflow.v2.Document]: @googleapis_reference_link{google/cloud/dialogflow/v2/document.proto#L261}
  /// [google.cloud.dialogflow.v2.ExportDocumentRequest]: @googleapis_reference_link{google/cloud/dialogflow/v2/document.proto#L613}
  /// [google.cloud.dialogflow.v2.KnowledgeOperationMetadata]: @googleapis_reference_link{google/cloud/dialogflow/v2/document.proto#L646}
  ///
  // clang-format on
  future<StatusOr<google::cloud::dialogflow::v2::Document>> ExportDocument(
      google::cloud::dialogflow::v2::ExportDocumentRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief ExportDocument
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> ExportDocument(
      NoAwaitTag,
      google::cloud::dialogflow::v2::ExportDocumentRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief ExportDocument
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::dialogflow::v2::Document>> ExportDocument(
      google::longrunning::Operation const& operation, Options opts = {});

 private:
  std::shared_ptr<DocumentsConnection> connection_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace dialogflow_es
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DIALOGFLOW_ES_DOCUMENTS_CLIENT_H
