// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/dataproc/v1/session_templates.proto

#include "google/cloud/dataproc/v1/internal/session_template_controller_stub.h"
#include "google/cloud/grpc_error_delegate.h"
#include "google/cloud/status_or.h"
#include <google/cloud/dataproc/v1/session_templates.grpc.pb.h>
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace dataproc_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

SessionTemplateControllerStub::~SessionTemplateControllerStub() = default;

StatusOr<google::cloud::dataproc::v1::SessionTemplate>
DefaultSessionTemplateControllerStub::CreateSessionTemplate(
    grpc::ClientContext& context, Options const&,
    google::cloud::dataproc::v1::CreateSessionTemplateRequest const& request) {
  google::cloud::dataproc::v1::SessionTemplate response;
  auto status = grpc_stub_->CreateSessionTemplate(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::dataproc::v1::SessionTemplate>
DefaultSessionTemplateControllerStub::UpdateSessionTemplate(
    grpc::ClientContext& context, Options const&,
    google::cloud::dataproc::v1::UpdateSessionTemplateRequest const& request) {
  google::cloud::dataproc::v1::SessionTemplate response;
  auto status = grpc_stub_->UpdateSessionTemplate(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::dataproc::v1::SessionTemplate>
DefaultSessionTemplateControllerStub::GetSessionTemplate(
    grpc::ClientContext& context, Options const&,
    google::cloud::dataproc::v1::GetSessionTemplateRequest const& request) {
  google::cloud::dataproc::v1::SessionTemplate response;
  auto status = grpc_stub_->GetSessionTemplate(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::dataproc::v1::ListSessionTemplatesResponse>
DefaultSessionTemplateControllerStub::ListSessionTemplates(
    grpc::ClientContext& context, Options const&,
    google::cloud::dataproc::v1::ListSessionTemplatesRequest const& request) {
  google::cloud::dataproc::v1::ListSessionTemplatesResponse response;
  auto status = grpc_stub_->ListSessionTemplates(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

Status DefaultSessionTemplateControllerStub::DeleteSessionTemplate(
    grpc::ClientContext& context, Options const&,
    google::cloud::dataproc::v1::DeleteSessionTemplateRequest const& request) {
  google::protobuf::Empty response;
  auto status = grpc_stub_->DeleteSessionTemplate(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return google::cloud::Status();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace dataproc_v1_internal
}  // namespace cloud
}  // namespace google
