// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/dataplex/v1/catalog.proto

#include "google/cloud/dataplex/v1/internal/catalog_connection_impl.h"
#include "google/cloud/dataplex/v1/internal/catalog_option_defaults.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/async_long_running_operation.h"
#include "google/cloud/internal/pagination_range.h"
#include "google/cloud/internal/retry_loop.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace dataplex_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN
namespace {

std::unique_ptr<dataplex_v1::CatalogServiceRetryPolicy> retry_policy(
    Options const& options) {
  return options.get<dataplex_v1::CatalogServiceRetryPolicyOption>()->clone();
}

std::unique_ptr<BackoffPolicy> backoff_policy(Options const& options) {
  return options.get<dataplex_v1::CatalogServiceBackoffPolicyOption>()->clone();
}

std::unique_ptr<dataplex_v1::CatalogServiceConnectionIdempotencyPolicy>
idempotency_policy(Options const& options) {
  return options
      .get<dataplex_v1::CatalogServiceConnectionIdempotencyPolicyOption>()
      ->clone();
}

std::unique_ptr<PollingPolicy> polling_policy(Options const& options) {
  return options.get<dataplex_v1::CatalogServicePollingPolicyOption>()->clone();
}

}  // namespace

CatalogServiceConnectionImpl::CatalogServiceConnectionImpl(
    std::unique_ptr<google::cloud::BackgroundThreads> background,
    std::shared_ptr<dataplex_v1_internal::CatalogServiceStub> stub,
    Options options)
    : background_(std::move(background)),
      stub_(std::move(stub)),
      options_(internal::MergeOptions(std::move(options),
                                      CatalogServiceConnection::options())) {}

future<StatusOr<google::cloud::dataplex::v1::EntryType>>
CatalogServiceConnectionImpl::CreateEntryType(
    google::cloud::dataplex::v1::CreateEntryTypeRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto request_copy = request;
  auto const idempotent =
      idempotency_policy(*current)->CreateEntryType(request_copy);
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::dataplex::v1::EntryType>(
      background_->cq(), current, std::move(request_copy),
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::cloud::dataplex::v1::CreateEntryTypeRequest const& request) {
        return stub->AsyncCreateEntryType(cq, std::move(context),
                                          std::move(options), request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::dataplex::v1::EntryType>,
      retry_policy(*current), backoff_policy(*current), idempotent,
      polling_policy(*current), __func__);
}

StatusOr<google::longrunning::Operation>
CatalogServiceConnectionImpl::CreateEntryType(
    NoAwaitTag,
    google::cloud::dataplex::v1::CreateEntryTypeRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CreateEntryType(request),
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::dataplex::v1::CreateEntryTypeRequest const& request) {
        return stub_->CreateEntryType(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<google::cloud::dataplex::v1::EntryType>>
CatalogServiceConnectionImpl::CreateEntryType(
    google::longrunning::Operation const& operation) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  if (!operation.metadata()
           .Is<typename google::cloud::dataplex::v1::OperationMetadata>()) {
    return make_ready_future<StatusOr<google::cloud::dataplex::v1::EntryType>>(
        internal::InvalidArgumentError(
            "operation does not correspond to CreateEntryType",
            GCP_ERROR_INFO().WithMetadata("operation",
                                          operation.metadata().DebugString())));
  }

  return google::cloud::internal::AsyncAwaitLongRunningOperation<
      google::cloud::dataplex::v1::EntryType>(
      background_->cq(), current, operation,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::dataplex::v1::EntryType>,
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::dataplex::v1::EntryType>>
CatalogServiceConnectionImpl::UpdateEntryType(
    google::cloud::dataplex::v1::UpdateEntryTypeRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto request_copy = request;
  auto const idempotent =
      idempotency_policy(*current)->UpdateEntryType(request_copy);
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::dataplex::v1::EntryType>(
      background_->cq(), current, std::move(request_copy),
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::cloud::dataplex::v1::UpdateEntryTypeRequest const& request) {
        return stub->AsyncUpdateEntryType(cq, std::move(context),
                                          std::move(options), request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::dataplex::v1::EntryType>,
      retry_policy(*current), backoff_policy(*current), idempotent,
      polling_policy(*current), __func__);
}

StatusOr<google::longrunning::Operation>
CatalogServiceConnectionImpl::UpdateEntryType(
    NoAwaitTag,
    google::cloud::dataplex::v1::UpdateEntryTypeRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->UpdateEntryType(request),
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::dataplex::v1::UpdateEntryTypeRequest const& request) {
        return stub_->UpdateEntryType(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<google::cloud::dataplex::v1::EntryType>>
CatalogServiceConnectionImpl::UpdateEntryType(
    google::longrunning::Operation const& operation) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  if (!operation.metadata()
           .Is<typename google::cloud::dataplex::v1::OperationMetadata>()) {
    return make_ready_future<StatusOr<google::cloud::dataplex::v1::EntryType>>(
        internal::InvalidArgumentError(
            "operation does not correspond to UpdateEntryType",
            GCP_ERROR_INFO().WithMetadata("operation",
                                          operation.metadata().DebugString())));
  }

  return google::cloud::internal::AsyncAwaitLongRunningOperation<
      google::cloud::dataplex::v1::EntryType>(
      background_->cq(), current, operation,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::dataplex::v1::EntryType>,
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::dataplex::v1::OperationMetadata>>
CatalogServiceConnectionImpl::DeleteEntryType(
    google::cloud::dataplex::v1::DeleteEntryTypeRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto request_copy = request;
  auto const idempotent =
      idempotency_policy(*current)->DeleteEntryType(request_copy);
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::dataplex::v1::OperationMetadata>(
      background_->cq(), current, std::move(request_copy),
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::cloud::dataplex::v1::DeleteEntryTypeRequest const& request) {
        return stub->AsyncDeleteEntryType(cq, std::move(context),
                                          std::move(options), request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultMetadata<
          google::cloud::dataplex::v1::OperationMetadata>,
      retry_policy(*current), backoff_policy(*current), idempotent,
      polling_policy(*current), __func__);
}

StatusOr<google::longrunning::Operation>
CatalogServiceConnectionImpl::DeleteEntryType(
    NoAwaitTag,
    google::cloud::dataplex::v1::DeleteEntryTypeRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeleteEntryType(request),
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::dataplex::v1::DeleteEntryTypeRequest const& request) {
        return stub_->DeleteEntryType(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<google::cloud::dataplex::v1::OperationMetadata>>
CatalogServiceConnectionImpl::DeleteEntryType(
    google::longrunning::Operation const& operation) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  if (!operation.metadata()
           .Is<typename google::cloud::dataplex::v1::OperationMetadata>()) {
    return make_ready_future<
        StatusOr<google::cloud::dataplex::v1::OperationMetadata>>(
        internal::InvalidArgumentError(
            "operation does not correspond to DeleteEntryType",
            GCP_ERROR_INFO().WithMetadata("operation",
                                          operation.metadata().DebugString())));
  }

  return google::cloud::internal::AsyncAwaitLongRunningOperation<
      google::cloud::dataplex::v1::OperationMetadata>(
      background_->cq(), current, operation,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultMetadata<
          google::cloud::dataplex::v1::OperationMetadata>,
      polling_policy(*current), __func__);
}

StreamRange<google::cloud::dataplex::v1::EntryType>
CatalogServiceConnectionImpl::ListEntryTypes(
    google::cloud::dataplex::v1::ListEntryTypesRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListEntryTypes(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::dataplex::v1::EntryType>>(
      current, std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<dataplex_v1::CatalogServiceRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          Options const& options,
          google::cloud::dataplex::v1::ListEntryTypesRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context, Options const& options,
                   google::cloud::dataplex::v1::ListEntryTypesRequest const&
                       request) {
              return stub->ListEntryTypes(context, options, request);
            },
            options, r, function_name);
      },
      [](google::cloud::dataplex::v1::ListEntryTypesResponse r) {
        std::vector<google::cloud::dataplex::v1::EntryType> result(
            r.entry_types().size());
        auto& messages = *r.mutable_entry_types();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::cloud::dataplex::v1::EntryType>
CatalogServiceConnectionImpl::GetEntryType(
    google::cloud::dataplex::v1::GetEntryTypeRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetEntryType(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::dataplex::v1::GetEntryTypeRequest const& request) {
        return stub_->GetEntryType(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<google::cloud::dataplex::v1::AspectType>>
CatalogServiceConnectionImpl::CreateAspectType(
    google::cloud::dataplex::v1::CreateAspectTypeRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto request_copy = request;
  auto const idempotent =
      idempotency_policy(*current)->CreateAspectType(request_copy);
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::dataplex::v1::AspectType>(
      background_->cq(), current, std::move(request_copy),
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::cloud::dataplex::v1::CreateAspectTypeRequest const& request) {
        return stub->AsyncCreateAspectType(cq, std::move(context),
                                           std::move(options), request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::dataplex::v1::AspectType>,
      retry_policy(*current), backoff_policy(*current), idempotent,
      polling_policy(*current), __func__);
}

StatusOr<google::longrunning::Operation>
CatalogServiceConnectionImpl::CreateAspectType(
    NoAwaitTag,
    google::cloud::dataplex::v1::CreateAspectTypeRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CreateAspectType(request),
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::dataplex::v1::CreateAspectTypeRequest const& request) {
        return stub_->CreateAspectType(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<google::cloud::dataplex::v1::AspectType>>
CatalogServiceConnectionImpl::CreateAspectType(
    google::longrunning::Operation const& operation) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  if (!operation.metadata()
           .Is<typename google::cloud::dataplex::v1::OperationMetadata>()) {
    return make_ready_future<StatusOr<google::cloud::dataplex::v1::AspectType>>(
        internal::InvalidArgumentError(
            "operation does not correspond to CreateAspectType",
            GCP_ERROR_INFO().WithMetadata("operation",
                                          operation.metadata().DebugString())));
  }

  return google::cloud::internal::AsyncAwaitLongRunningOperation<
      google::cloud::dataplex::v1::AspectType>(
      background_->cq(), current, operation,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::dataplex::v1::AspectType>,
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::dataplex::v1::AspectType>>
CatalogServiceConnectionImpl::UpdateAspectType(
    google::cloud::dataplex::v1::UpdateAspectTypeRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto request_copy = request;
  auto const idempotent =
      idempotency_policy(*current)->UpdateAspectType(request_copy);
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::dataplex::v1::AspectType>(
      background_->cq(), current, std::move(request_copy),
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::cloud::dataplex::v1::UpdateAspectTypeRequest const& request) {
        return stub->AsyncUpdateAspectType(cq, std::move(context),
                                           std::move(options), request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::dataplex::v1::AspectType>,
      retry_policy(*current), backoff_policy(*current), idempotent,
      polling_policy(*current), __func__);
}

StatusOr<google::longrunning::Operation>
CatalogServiceConnectionImpl::UpdateAspectType(
    NoAwaitTag,
    google::cloud::dataplex::v1::UpdateAspectTypeRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->UpdateAspectType(request),
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::dataplex::v1::UpdateAspectTypeRequest const& request) {
        return stub_->UpdateAspectType(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<google::cloud::dataplex::v1::AspectType>>
CatalogServiceConnectionImpl::UpdateAspectType(
    google::longrunning::Operation const& operation) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  if (!operation.metadata()
           .Is<typename google::cloud::dataplex::v1::OperationMetadata>()) {
    return make_ready_future<StatusOr<google::cloud::dataplex::v1::AspectType>>(
        internal::InvalidArgumentError(
            "operation does not correspond to UpdateAspectType",
            GCP_ERROR_INFO().WithMetadata("operation",
                                          operation.metadata().DebugString())));
  }

  return google::cloud::internal::AsyncAwaitLongRunningOperation<
      google::cloud::dataplex::v1::AspectType>(
      background_->cq(), current, operation,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::dataplex::v1::AspectType>,
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::dataplex::v1::OperationMetadata>>
CatalogServiceConnectionImpl::DeleteAspectType(
    google::cloud::dataplex::v1::DeleteAspectTypeRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto request_copy = request;
  auto const idempotent =
      idempotency_policy(*current)->DeleteAspectType(request_copy);
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::dataplex::v1::OperationMetadata>(
      background_->cq(), current, std::move(request_copy),
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::cloud::dataplex::v1::DeleteAspectTypeRequest const& request) {
        return stub->AsyncDeleteAspectType(cq, std::move(context),
                                           std::move(options), request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultMetadata<
          google::cloud::dataplex::v1::OperationMetadata>,
      retry_policy(*current), backoff_policy(*current), idempotent,
      polling_policy(*current), __func__);
}

StatusOr<google::longrunning::Operation>
CatalogServiceConnectionImpl::DeleteAspectType(
    NoAwaitTag,
    google::cloud::dataplex::v1::DeleteAspectTypeRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeleteAspectType(request),
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::dataplex::v1::DeleteAspectTypeRequest const& request) {
        return stub_->DeleteAspectType(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<google::cloud::dataplex::v1::OperationMetadata>>
CatalogServiceConnectionImpl::DeleteAspectType(
    google::longrunning::Operation const& operation) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  if (!operation.metadata()
           .Is<typename google::cloud::dataplex::v1::OperationMetadata>()) {
    return make_ready_future<
        StatusOr<google::cloud::dataplex::v1::OperationMetadata>>(
        internal::InvalidArgumentError(
            "operation does not correspond to DeleteAspectType",
            GCP_ERROR_INFO().WithMetadata("operation",
                                          operation.metadata().DebugString())));
  }

  return google::cloud::internal::AsyncAwaitLongRunningOperation<
      google::cloud::dataplex::v1::OperationMetadata>(
      background_->cq(), current, operation,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultMetadata<
          google::cloud::dataplex::v1::OperationMetadata>,
      polling_policy(*current), __func__);
}

StreamRange<google::cloud::dataplex::v1::AspectType>
CatalogServiceConnectionImpl::ListAspectTypes(
    google::cloud::dataplex::v1::ListAspectTypesRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListAspectTypes(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::dataplex::v1::AspectType>>(
      current, std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<dataplex_v1::CatalogServiceRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          Options const& options,
          google::cloud::dataplex::v1::ListAspectTypesRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context, Options const& options,
                   google::cloud::dataplex::v1::ListAspectTypesRequest const&
                       request) {
              return stub->ListAspectTypes(context, options, request);
            },
            options, r, function_name);
      },
      [](google::cloud::dataplex::v1::ListAspectTypesResponse r) {
        std::vector<google::cloud::dataplex::v1::AspectType> result(
            r.aspect_types().size());
        auto& messages = *r.mutable_aspect_types();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::cloud::dataplex::v1::AspectType>
CatalogServiceConnectionImpl::GetAspectType(
    google::cloud::dataplex::v1::GetAspectTypeRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetAspectType(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::dataplex::v1::GetAspectTypeRequest const& request) {
        return stub_->GetAspectType(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<google::cloud::dataplex::v1::EntryGroup>>
CatalogServiceConnectionImpl::CreateEntryGroup(
    google::cloud::dataplex::v1::CreateEntryGroupRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto request_copy = request;
  auto const idempotent =
      idempotency_policy(*current)->CreateEntryGroup(request_copy);
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::dataplex::v1::EntryGroup>(
      background_->cq(), current, std::move(request_copy),
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::cloud::dataplex::v1::CreateEntryGroupRequest const& request) {
        return stub->AsyncCreateEntryGroup(cq, std::move(context),
                                           std::move(options), request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::dataplex::v1::EntryGroup>,
      retry_policy(*current), backoff_policy(*current), idempotent,
      polling_policy(*current), __func__);
}

StatusOr<google::longrunning::Operation>
CatalogServiceConnectionImpl::CreateEntryGroup(
    NoAwaitTag,
    google::cloud::dataplex::v1::CreateEntryGroupRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CreateEntryGroup(request),
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::dataplex::v1::CreateEntryGroupRequest const& request) {
        return stub_->CreateEntryGroup(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<google::cloud::dataplex::v1::EntryGroup>>
CatalogServiceConnectionImpl::CreateEntryGroup(
    google::longrunning::Operation const& operation) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  if (!operation.metadata()
           .Is<typename google::cloud::dataplex::v1::OperationMetadata>()) {
    return make_ready_future<StatusOr<google::cloud::dataplex::v1::EntryGroup>>(
        internal::InvalidArgumentError(
            "operation does not correspond to CreateEntryGroup",
            GCP_ERROR_INFO().WithMetadata("operation",
                                          operation.metadata().DebugString())));
  }

  return google::cloud::internal::AsyncAwaitLongRunningOperation<
      google::cloud::dataplex::v1::EntryGroup>(
      background_->cq(), current, operation,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::dataplex::v1::EntryGroup>,
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::dataplex::v1::EntryGroup>>
CatalogServiceConnectionImpl::UpdateEntryGroup(
    google::cloud::dataplex::v1::UpdateEntryGroupRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto request_copy = request;
  auto const idempotent =
      idempotency_policy(*current)->UpdateEntryGroup(request_copy);
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::dataplex::v1::EntryGroup>(
      background_->cq(), current, std::move(request_copy),
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::cloud::dataplex::v1::UpdateEntryGroupRequest const& request) {
        return stub->AsyncUpdateEntryGroup(cq, std::move(context),
                                           std::move(options), request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::dataplex::v1::EntryGroup>,
      retry_policy(*current), backoff_policy(*current), idempotent,
      polling_policy(*current), __func__);
}

StatusOr<google::longrunning::Operation>
CatalogServiceConnectionImpl::UpdateEntryGroup(
    NoAwaitTag,
    google::cloud::dataplex::v1::UpdateEntryGroupRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->UpdateEntryGroup(request),
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::dataplex::v1::UpdateEntryGroupRequest const& request) {
        return stub_->UpdateEntryGroup(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<google::cloud::dataplex::v1::EntryGroup>>
CatalogServiceConnectionImpl::UpdateEntryGroup(
    google::longrunning::Operation const& operation) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  if (!operation.metadata()
           .Is<typename google::cloud::dataplex::v1::OperationMetadata>()) {
    return make_ready_future<StatusOr<google::cloud::dataplex::v1::EntryGroup>>(
        internal::InvalidArgumentError(
            "operation does not correspond to UpdateEntryGroup",
            GCP_ERROR_INFO().WithMetadata("operation",
                                          operation.metadata().DebugString())));
  }

  return google::cloud::internal::AsyncAwaitLongRunningOperation<
      google::cloud::dataplex::v1::EntryGroup>(
      background_->cq(), current, operation,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::dataplex::v1::EntryGroup>,
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::dataplex::v1::OperationMetadata>>
CatalogServiceConnectionImpl::DeleteEntryGroup(
    google::cloud::dataplex::v1::DeleteEntryGroupRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto request_copy = request;
  auto const idempotent =
      idempotency_policy(*current)->DeleteEntryGroup(request_copy);
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::dataplex::v1::OperationMetadata>(
      background_->cq(), current, std::move(request_copy),
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::cloud::dataplex::v1::DeleteEntryGroupRequest const& request) {
        return stub->AsyncDeleteEntryGroup(cq, std::move(context),
                                           std::move(options), request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultMetadata<
          google::cloud::dataplex::v1::OperationMetadata>,
      retry_policy(*current), backoff_policy(*current), idempotent,
      polling_policy(*current), __func__);
}

StatusOr<google::longrunning::Operation>
CatalogServiceConnectionImpl::DeleteEntryGroup(
    NoAwaitTag,
    google::cloud::dataplex::v1::DeleteEntryGroupRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeleteEntryGroup(request),
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::dataplex::v1::DeleteEntryGroupRequest const& request) {
        return stub_->DeleteEntryGroup(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<google::cloud::dataplex::v1::OperationMetadata>>
CatalogServiceConnectionImpl::DeleteEntryGroup(
    google::longrunning::Operation const& operation) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  if (!operation.metadata()
           .Is<typename google::cloud::dataplex::v1::OperationMetadata>()) {
    return make_ready_future<
        StatusOr<google::cloud::dataplex::v1::OperationMetadata>>(
        internal::InvalidArgumentError(
            "operation does not correspond to DeleteEntryGroup",
            GCP_ERROR_INFO().WithMetadata("operation",
                                          operation.metadata().DebugString())));
  }

  return google::cloud::internal::AsyncAwaitLongRunningOperation<
      google::cloud::dataplex::v1::OperationMetadata>(
      background_->cq(), current, operation,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultMetadata<
          google::cloud::dataplex::v1::OperationMetadata>,
      polling_policy(*current), __func__);
}

StreamRange<google::cloud::dataplex::v1::EntryGroup>
CatalogServiceConnectionImpl::ListEntryGroups(
    google::cloud::dataplex::v1::ListEntryGroupsRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListEntryGroups(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::dataplex::v1::EntryGroup>>(
      current, std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<dataplex_v1::CatalogServiceRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          Options const& options,
          google::cloud::dataplex::v1::ListEntryGroupsRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context, Options const& options,
                   google::cloud::dataplex::v1::ListEntryGroupsRequest const&
                       request) {
              return stub->ListEntryGroups(context, options, request);
            },
            options, r, function_name);
      },
      [](google::cloud::dataplex::v1::ListEntryGroupsResponse r) {
        std::vector<google::cloud::dataplex::v1::EntryGroup> result(
            r.entry_groups().size());
        auto& messages = *r.mutable_entry_groups();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::cloud::dataplex::v1::EntryGroup>
CatalogServiceConnectionImpl::GetEntryGroup(
    google::cloud::dataplex::v1::GetEntryGroupRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetEntryGroup(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::dataplex::v1::GetEntryGroupRequest const& request) {
        return stub_->GetEntryGroup(context, options, request);
      },
      *current, request, __func__);
}

StatusOr<google::cloud::dataplex::v1::Entry>
CatalogServiceConnectionImpl::CreateEntry(
    google::cloud::dataplex::v1::CreateEntryRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CreateEntry(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::dataplex::v1::CreateEntryRequest const& request) {
        return stub_->CreateEntry(context, options, request);
      },
      *current, request, __func__);
}

StatusOr<google::cloud::dataplex::v1::Entry>
CatalogServiceConnectionImpl::UpdateEntry(
    google::cloud::dataplex::v1::UpdateEntryRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->UpdateEntry(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::dataplex::v1::UpdateEntryRequest const& request) {
        return stub_->UpdateEntry(context, options, request);
      },
      *current, request, __func__);
}

StatusOr<google::cloud::dataplex::v1::Entry>
CatalogServiceConnectionImpl::DeleteEntry(
    google::cloud::dataplex::v1::DeleteEntryRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeleteEntry(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::dataplex::v1::DeleteEntryRequest const& request) {
        return stub_->DeleteEntry(context, options, request);
      },
      *current, request, __func__);
}

StreamRange<google::cloud::dataplex::v1::Entry>
CatalogServiceConnectionImpl::ListEntries(
    google::cloud::dataplex::v1::ListEntriesRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListEntries(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::dataplex::v1::Entry>>(
      current, std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<dataplex_v1::CatalogServiceRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          Options const& options,
          google::cloud::dataplex::v1::ListEntriesRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context, Options const& options,
                   google::cloud::dataplex::v1::ListEntriesRequest const&
                       request) {
              return stub->ListEntries(context, options, request);
            },
            options, r, function_name);
      },
      [](google::cloud::dataplex::v1::ListEntriesResponse r) {
        std::vector<google::cloud::dataplex::v1::Entry> result(
            r.entries().size());
        auto& messages = *r.mutable_entries();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::cloud::dataplex::v1::Entry>
CatalogServiceConnectionImpl::GetEntry(
    google::cloud::dataplex::v1::GetEntryRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetEntry(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::dataplex::v1::GetEntryRequest const& request) {
        return stub_->GetEntry(context, options, request);
      },
      *current, request, __func__);
}

StatusOr<google::cloud::dataplex::v1::Entry>
CatalogServiceConnectionImpl::LookupEntry(
    google::cloud::dataplex::v1::LookupEntryRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->LookupEntry(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::dataplex::v1::LookupEntryRequest const& request) {
        return stub_->LookupEntry(context, options, request);
      },
      *current, request, __func__);
}

StreamRange<google::cloud::dataplex::v1::SearchEntriesResult>
CatalogServiceConnectionImpl::SearchEntries(
    google::cloud::dataplex::v1::SearchEntriesRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->SearchEntries(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::dataplex::v1::SearchEntriesResult>>(
      current, std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<dataplex_v1::CatalogServiceRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          Options const& options,
          google::cloud::dataplex::v1::SearchEntriesRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context, Options const& options,
                   google::cloud::dataplex::v1::SearchEntriesRequest const&
                       request) {
              return stub->SearchEntries(context, options, request);
            },
            options, r, function_name);
      },
      [](google::cloud::dataplex::v1::SearchEntriesResponse r) {
        std::vector<google::cloud::dataplex::v1::SearchEntriesResult> result(
            r.results().size());
        auto& messages = *r.mutable_results();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace dataplex_v1_internal
}  // namespace cloud
}  // namespace google
