// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/contentwarehouse/v1/document_service.proto

#include "google/cloud/contentwarehouse/v1/internal/document_stub.h"
#include "google/cloud/grpc_error_delegate.h"
#include "google/cloud/status_or.h"
#include <google/cloud/contentwarehouse/v1/document_service.grpc.pb.h>
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace contentwarehouse_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

DocumentServiceStub::~DocumentServiceStub() = default;

StatusOr<google::cloud::contentwarehouse::v1::CreateDocumentResponse>
DefaultDocumentServiceStub::CreateDocument(
    grpc::ClientContext& context, Options const&,
    google::cloud::contentwarehouse::v1::CreateDocumentRequest const& request) {
  google::cloud::contentwarehouse::v1::CreateDocumentResponse response;
  auto status = grpc_stub_->CreateDocument(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::contentwarehouse::v1::Document>
DefaultDocumentServiceStub::GetDocument(
    grpc::ClientContext& context, Options const&,
    google::cloud::contentwarehouse::v1::GetDocumentRequest const& request) {
  google::cloud::contentwarehouse::v1::Document response;
  auto status = grpc_stub_->GetDocument(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::contentwarehouse::v1::UpdateDocumentResponse>
DefaultDocumentServiceStub::UpdateDocument(
    grpc::ClientContext& context, Options const&,
    google::cloud::contentwarehouse::v1::UpdateDocumentRequest const& request) {
  google::cloud::contentwarehouse::v1::UpdateDocumentResponse response;
  auto status = grpc_stub_->UpdateDocument(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

Status DefaultDocumentServiceStub::DeleteDocument(
    grpc::ClientContext& context, Options const&,
    google::cloud::contentwarehouse::v1::DeleteDocumentRequest const& request) {
  google::protobuf::Empty response;
  auto status = grpc_stub_->DeleteDocument(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return google::cloud::Status();
}

StatusOr<google::cloud::contentwarehouse::v1::SearchDocumentsResponse>
DefaultDocumentServiceStub::SearchDocuments(
    grpc::ClientContext& context, Options const&,
    google::cloud::contentwarehouse::v1::SearchDocumentsRequest const&
        request) {
  google::cloud::contentwarehouse::v1::SearchDocumentsResponse response;
  auto status = grpc_stub_->SearchDocuments(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::contentwarehouse::v1::Document>
DefaultDocumentServiceStub::LockDocument(
    grpc::ClientContext& context, Options const&,
    google::cloud::contentwarehouse::v1::LockDocumentRequest const& request) {
  google::cloud::contentwarehouse::v1::Document response;
  auto status = grpc_stub_->LockDocument(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::contentwarehouse::v1::FetchAclResponse>
DefaultDocumentServiceStub::FetchAcl(
    grpc::ClientContext& context, Options const&,
    google::cloud::contentwarehouse::v1::FetchAclRequest const& request) {
  google::cloud::contentwarehouse::v1::FetchAclResponse response;
  auto status = grpc_stub_->FetchAcl(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::contentwarehouse::v1::SetAclResponse>
DefaultDocumentServiceStub::SetAcl(
    grpc::ClientContext& context, Options const&,
    google::cloud::contentwarehouse::v1::SetAclRequest const& request) {
  google::cloud::contentwarehouse::v1::SetAclResponse response;
  auto status = grpc_stub_->SetAcl(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace contentwarehouse_v1_internal
}  // namespace cloud
}  // namespace google
