// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source:
// google/cloud/compute/region_instant_snapshots/v1/region_instant_snapshots.proto

#include "google/cloud/compute/region_instant_snapshots/v1/region_instant_snapshots_client.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace compute_region_instant_snapshots_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

RegionInstantSnapshotsClient::RegionInstantSnapshotsClient(
    std::shared_ptr<RegionInstantSnapshotsConnection> connection, Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
RegionInstantSnapshotsClient::~RegionInstantSnapshotsClient() = default;

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
RegionInstantSnapshotsClient::DeleteInstantSnapshot(
    std::string const& project, std::string const& region,
    std::string const& instant_snapshot, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::region_instant_snapshots::v1::
      DeleteInstantSnapshotRequest request;
  request.set_project(project);
  request.set_region(region);
  request.set_instant_snapshot(instant_snapshot);
  return connection_->DeleteInstantSnapshot(request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
RegionInstantSnapshotsClient::DeleteInstantSnapshot(
    NoAwaitTag, std::string const& project, std::string const& region,
    std::string const& instant_snapshot, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::region_instant_snapshots::v1::
      DeleteInstantSnapshotRequest request;
  request.set_project(project);
  request.set_region(region);
  request.set_instant_snapshot(instant_snapshot);
  return connection_->DeleteInstantSnapshot(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
RegionInstantSnapshotsClient::DeleteInstantSnapshot(
    google::cloud::cpp::compute::region_instant_snapshots::v1::
        DeleteInstantSnapshotRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteInstantSnapshot(request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
RegionInstantSnapshotsClient::DeleteInstantSnapshot(
    NoAwaitTag,
    google::cloud::cpp::compute::region_instant_snapshots::v1::
        DeleteInstantSnapshotRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteInstantSnapshot(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
RegionInstantSnapshotsClient::DeleteInstantSnapshot(
    google::cloud::cpp::compute::v1::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteInstantSnapshot(operation);
}

StatusOr<google::cloud::cpp::compute::v1::InstantSnapshot>
RegionInstantSnapshotsClient::GetInstantSnapshot(
    std::string const& project, std::string const& region,
    std::string const& instant_snapshot, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::region_instant_snapshots::v1::
      GetInstantSnapshotRequest request;
  request.set_project(project);
  request.set_region(region);
  request.set_instant_snapshot(instant_snapshot);
  return connection_->GetInstantSnapshot(request);
}

StatusOr<google::cloud::cpp::compute::v1::InstantSnapshot>
RegionInstantSnapshotsClient::GetInstantSnapshot(
    google::cloud::cpp::compute::region_instant_snapshots::v1::
        GetInstantSnapshotRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetInstantSnapshot(request);
}

StatusOr<google::cloud::cpp::compute::v1::Policy>
RegionInstantSnapshotsClient::GetIamPolicy(std::string const& project,
                                           std::string const& region,
                                           std::string const& resource,
                                           Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::region_instant_snapshots::v1::GetIamPolicyRequest
      request;
  request.set_project(project);
  request.set_region(region);
  request.set_resource(resource);
  return connection_->GetIamPolicy(request);
}

StatusOr<google::cloud::cpp::compute::v1::Policy>
RegionInstantSnapshotsClient::GetIamPolicy(
    google::cloud::cpp::compute::region_instant_snapshots::v1::
        GetIamPolicyRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetIamPolicy(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
RegionInstantSnapshotsClient::InsertInstantSnapshot(
    std::string const& project, std::string const& region,
    google::cloud::cpp::compute::v1::InstantSnapshot const&
        instant_snapshot_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::region_instant_snapshots::v1::
      InsertInstantSnapshotRequest request;
  request.set_project(project);
  request.set_region(region);
  *request.mutable_instant_snapshot_resource() = instant_snapshot_resource;
  return connection_->InsertInstantSnapshot(request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
RegionInstantSnapshotsClient::InsertInstantSnapshot(
    NoAwaitTag, std::string const& project, std::string const& region,
    google::cloud::cpp::compute::v1::InstantSnapshot const&
        instant_snapshot_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::region_instant_snapshots::v1::
      InsertInstantSnapshotRequest request;
  request.set_project(project);
  request.set_region(region);
  *request.mutable_instant_snapshot_resource() = instant_snapshot_resource;
  return connection_->InsertInstantSnapshot(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
RegionInstantSnapshotsClient::InsertInstantSnapshot(
    google::cloud::cpp::compute::region_instant_snapshots::v1::
        InsertInstantSnapshotRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->InsertInstantSnapshot(request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
RegionInstantSnapshotsClient::InsertInstantSnapshot(
    NoAwaitTag,
    google::cloud::cpp::compute::region_instant_snapshots::v1::
        InsertInstantSnapshotRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->InsertInstantSnapshot(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
RegionInstantSnapshotsClient::InsertInstantSnapshot(
    google::cloud::cpp::compute::v1::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->InsertInstantSnapshot(operation);
}

StreamRange<google::cloud::cpp::compute::v1::InstantSnapshot>
RegionInstantSnapshotsClient::ListRegionInstantSnapshots(
    std::string const& project, std::string const& region, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::region_instant_snapshots::v1::
      ListRegionInstantSnapshotsRequest request;
  request.set_project(project);
  request.set_region(region);
  return connection_->ListRegionInstantSnapshots(request);
}

StreamRange<google::cloud::cpp::compute::v1::InstantSnapshot>
RegionInstantSnapshotsClient::ListRegionInstantSnapshots(
    google::cloud::cpp::compute::region_instant_snapshots::v1::
        ListRegionInstantSnapshotsRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListRegionInstantSnapshots(std::move(request));
}

StatusOr<google::cloud::cpp::compute::v1::Policy>
RegionInstantSnapshotsClient::SetIamPolicy(
    std::string const& project, std::string const& region,
    std::string const& resource,
    google::cloud::cpp::compute::v1::RegionSetPolicyRequest const&
        region_set_policy_request_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::region_instant_snapshots::v1::SetIamPolicyRequest
      request;
  request.set_project(project);
  request.set_region(region);
  request.set_resource(resource);
  *request.mutable_region_set_policy_request_resource() =
      region_set_policy_request_resource;
  return connection_->SetIamPolicy(request);
}

StatusOr<google::cloud::cpp::compute::v1::Policy>
RegionInstantSnapshotsClient::SetIamPolicy(
    google::cloud::cpp::compute::region_instant_snapshots::v1::
        SetIamPolicyRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->SetIamPolicy(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
RegionInstantSnapshotsClient::SetLabels(
    std::string const& project, std::string const& region,
    std::string const& resource,
    google::cloud::cpp::compute::v1::RegionSetLabelsRequest const&
        region_set_labels_request_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::region_instant_snapshots::v1::SetLabelsRequest
      request;
  request.set_project(project);
  request.set_region(region);
  request.set_resource(resource);
  *request.mutable_region_set_labels_request_resource() =
      region_set_labels_request_resource;
  return connection_->SetLabels(request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
RegionInstantSnapshotsClient::SetLabels(
    NoAwaitTag, std::string const& project, std::string const& region,
    std::string const& resource,
    google::cloud::cpp::compute::v1::RegionSetLabelsRequest const&
        region_set_labels_request_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::region_instant_snapshots::v1::SetLabelsRequest
      request;
  request.set_project(project);
  request.set_region(region);
  request.set_resource(resource);
  *request.mutable_region_set_labels_request_resource() =
      region_set_labels_request_resource;
  return connection_->SetLabels(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
RegionInstantSnapshotsClient::SetLabels(
    google::cloud::cpp::compute::region_instant_snapshots::v1::
        SetLabelsRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->SetLabels(request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
RegionInstantSnapshotsClient::SetLabels(
    NoAwaitTag,
    google::cloud::cpp::compute::region_instant_snapshots::v1::
        SetLabelsRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->SetLabels(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
RegionInstantSnapshotsClient::SetLabels(
    google::cloud::cpp::compute::v1::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->SetLabels(operation);
}

StatusOr<google::cloud::cpp::compute::v1::TestPermissionsResponse>
RegionInstantSnapshotsClient::TestIamPermissions(
    std::string const& project, std::string const& region,
    std::string const& resource,
    google::cloud::cpp::compute::v1::TestPermissionsRequest const&
        test_permissions_request_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::region_instant_snapshots::v1::
      TestIamPermissionsRequest request;
  request.set_project(project);
  request.set_region(region);
  request.set_resource(resource);
  *request.mutable_test_permissions_request_resource() =
      test_permissions_request_resource;
  return connection_->TestIamPermissions(request);
}

StatusOr<google::cloud::cpp::compute::v1::TestPermissionsResponse>
RegionInstantSnapshotsClient::TestIamPermissions(
    google::cloud::cpp::compute::region_instant_snapshots::v1::
        TestIamPermissionsRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->TestIamPermissions(request);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace compute_region_instant_snapshots_v1
}  // namespace cloud
}  // namespace google
