// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/compute/future_reservations/v1/future_reservations.proto

#include "google/cloud/compute/future_reservations/v1/internal/future_reservations_rest_metadata_decorator.h"
#include "google/cloud/internal/absl_str_cat_quiet.h"
#include "google/cloud/internal/api_client_header.h"
#include "google/cloud/internal/rest_set_metadata.h"
#include "google/cloud/status_or.h"
#include "absl/strings/str_format.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace compute_future_reservations_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

FutureReservationsRestMetadata::FutureReservationsRestMetadata(
    std::shared_ptr<FutureReservationsRestStub> child,
    std::string api_client_header)
    : child_(std::move(child)),
      api_client_header_(
          api_client_header.empty()
              ? google::cloud::internal::GeneratedLibClientHeader()
              : std::move(api_client_header)) {}

StatusOr<
    google::cloud::cpp::compute::v1::FutureReservationsAggregatedListResponse>
FutureReservationsRestMetadata::AggregatedListFutureReservations(
    rest_internal::RestContext& rest_context, Options const& options,
    google::cloud::cpp::compute::future_reservations::v1::
        AggregatedListFutureReservationsRequest const& request) {
  SetMetadata(rest_context, options);
  return child_->AggregatedListFutureReservations(rest_context, options,
                                                  request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
FutureReservationsRestMetadata::AsyncCancel(
    CompletionQueue& cq,
    std::unique_ptr<rest_internal::RestContext> rest_context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::cpp::compute::future_reservations::v1::CancelRequest const&
        request) {
  SetMetadata(*rest_context, *options);
  return child_->AsyncCancel(cq, std::move(rest_context), std::move(options),
                             request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
FutureReservationsRestMetadata::Cancel(
    rest_internal::RestContext& rest_context, Options const& options,
    google::cloud::cpp::compute::future_reservations::v1::CancelRequest const&
        request) {
  SetMetadata(rest_context, options);
  return child_->Cancel(rest_context, options, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
FutureReservationsRestMetadata::AsyncDeleteFutureReservation(
    CompletionQueue& cq,
    std::unique_ptr<rest_internal::RestContext> rest_context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::cpp::compute::future_reservations::v1::
        DeleteFutureReservationRequest const& request) {
  SetMetadata(*rest_context, *options);
  return child_->AsyncDeleteFutureReservation(cq, std::move(rest_context),
                                              std::move(options), request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
FutureReservationsRestMetadata::DeleteFutureReservation(
    rest_internal::RestContext& rest_context, Options const& options,
    google::cloud::cpp::compute::future_reservations::v1::
        DeleteFutureReservationRequest const& request) {
  SetMetadata(rest_context, options);
  return child_->DeleteFutureReservation(rest_context, options, request);
}

StatusOr<google::cloud::cpp::compute::v1::FutureReservation>
FutureReservationsRestMetadata::GetFutureReservation(
    rest_internal::RestContext& rest_context, Options const& options,
    google::cloud::cpp::compute::future_reservations::v1::
        GetFutureReservationRequest const& request) {
  SetMetadata(rest_context, options);
  return child_->GetFutureReservation(rest_context, options, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
FutureReservationsRestMetadata::AsyncInsertFutureReservation(
    CompletionQueue& cq,
    std::unique_ptr<rest_internal::RestContext> rest_context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::cpp::compute::future_reservations::v1::
        InsertFutureReservationRequest const& request) {
  SetMetadata(*rest_context, *options);
  return child_->AsyncInsertFutureReservation(cq, std::move(rest_context),
                                              std::move(options), request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
FutureReservationsRestMetadata::InsertFutureReservation(
    rest_internal::RestContext& rest_context, Options const& options,
    google::cloud::cpp::compute::future_reservations::v1::
        InsertFutureReservationRequest const& request) {
  SetMetadata(rest_context, options);
  return child_->InsertFutureReservation(rest_context, options, request);
}

StatusOr<google::cloud::cpp::compute::v1::FutureReservationsListResponse>
FutureReservationsRestMetadata::ListFutureReservations(
    rest_internal::RestContext& rest_context, Options const& options,
    google::cloud::cpp::compute::future_reservations::v1::
        ListFutureReservationsRequest const& request) {
  SetMetadata(rest_context, options);
  return child_->ListFutureReservations(rest_context, options, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
FutureReservationsRestMetadata::AsyncUpdateFutureReservation(
    CompletionQueue& cq,
    std::unique_ptr<rest_internal::RestContext> rest_context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::cpp::compute::future_reservations::v1::
        UpdateFutureReservationRequest const& request) {
  SetMetadata(*rest_context, *options);
  return child_->AsyncUpdateFutureReservation(cq, std::move(rest_context),
                                              std::move(options), request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
FutureReservationsRestMetadata::UpdateFutureReservation(
    rest_internal::RestContext& rest_context, Options const& options,
    google::cloud::cpp::compute::future_reservations::v1::
        UpdateFutureReservationRequest const& request) {
  SetMetadata(rest_context, options);
  return child_->UpdateFutureReservation(rest_context, options, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
FutureReservationsRestMetadata::AsyncGetOperation(
    google::cloud::CompletionQueue& cq,
    std::unique_ptr<rest_internal::RestContext> rest_context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::cpp::compute::zone_operations::v1::GetOperationRequest const&
        request) {
  SetMetadata(*rest_context, *options);
  return child_->AsyncGetOperation(cq, std::move(rest_context),
                                   std::move(options), request);
}

future<Status> FutureReservationsRestMetadata::AsyncCancelOperation(
    google::cloud::CompletionQueue& cq,
    std::unique_ptr<rest_internal::RestContext> rest_context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::cpp::compute::zone_operations::v1::
        DeleteOperationRequest const& request) {
  SetMetadata(*rest_context, *options);
  return child_->AsyncCancelOperation(cq, std::move(rest_context),
                                      std::move(options), request);
}

void FutureReservationsRestMetadata::SetMetadata(
    rest_internal::RestContext& rest_context, Options const& options,
    std::vector<std::string> const& params) {
  google::cloud::rest_internal::SetMetadata(rest_context, options, params,
                                            api_client_header_);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace compute_future_reservations_v1_internal
}  // namespace cloud
}  // namespace google
