// @Prolog: #include "stdinc.h"
// @Prolog: #include <airdcpp/core/localization/ResourceManager.h>
// @Strings: std::string dcpp::ResourceManager::strings[]
// @Names: std::string dcpp::ResourceManager::names[]

enum Strings { // @DontAdd
	ACTION, // "Action"
	ACTIONS_DOTS, // "Actions..."
	ACTIVE, // "Active"
	ACTIVE_FOR, // "Active for %1%"
	ACTIVE_MODE, // "Active mode"
	ACTIVE_SEARCH_STRING, // "Enabled / Search string"
	ADD, // "Add"
	ADDED, // "Added"
	ADDING_SHARED_DIR, // "Adding the directory %1% in share..."
	ADDING_X_SHARED_DIRS, // "Adding %1% directories in share..."
	ADDITIONAL_UP_LIMITS, // "Additional upload limits"
	ADD_AS_SOURCE, // "Add as source"
	ADD_AUTO_SEARCH_DIR, // "Add directory to auto search"
	ADD_AUTO_SEARCH_DISABLED, // "Add disabled auto search"
	ADD_AUTO_SEARCH_FILE, // "Add file to auto search"
	ADD_BUNDLE_ERRORS_OCC, // "The following error(s) occurred when queueing the bundle %1% from a user %2%: %3%"
	ADD_DIRECTORIES_QUEUED, // "%1% directories have queued to be added in share"
	ADD_DIRECTORY_QUEUED, // "The directory %1% has been queued to be added in share"
	ADD_DLG_DESC, // "Add also in the following profiles"
	ADD_EMPTY, // "Can't add an empty string"
	ADD_FILE_ERROR, // "Failed to queue the file %1% from a user %2%: %3%"
	ADD_IN_ALL_PROFILES, // "Add this directory in all profiles"
	ADD_PROFILE_DOTS, // "Add profile..."
	ADD_THIS_PROFILE, // "Add in this profile"
	ADD_TO_FAVORITES, // "Add to favorites"
	ADD_TO_QUEUE, // "Add to queue"
	ADDRESS_KEYPRINT, // "Address (with keyprint)"
	ADLSEARCH_IN_PROGRESS, // "The ADL search list can't be modified while matching is in progress!"
	ADLS_DESTINATION, // "Destination directory"
	ADLS_DISCARD, // "Discard"
	ADLS_DOWNLOAD, // "Download matches"
	ADLS_FULL_PATH, // "Full path"
	ADLS_PROPERTIES, // "ADL search properties"
	ADLS_SIZE_MAX, // "Max filesize"
	ADLS_SIZE_MIN, // "Min filesize"
	ADLS_TYPE, // "Search type"
	ADLS_UNITS, // "Size type"
	ADL_DL_FULL_LIST, // "Do you want to switch to full file list before matching the ADL search?"
	ADL_SEARCH, // "Automatic Directory Listing search"
	ALL, // "All"
	ALLOW_AUTO_DETECT_V4, // "Let AirDC++ determine the best IPv4 connectivity settings"
	ALLOW_AUTO_DETECT_V6, // "Let AirDC++ determine the best IPv6 connectivity settings"
	ALL_DOWNLOAD_SLOTS_TAKEN, // "All download slots taken"
	ALL_FILES, // "All files"
	ALREADY_IGNORED, // "Pattern is already in the list"
	ALREADY_UPDATING, // "An update is already being downloaded!"
	ALTERNATE_LIMITING, // "Alternate limiting"
	ALWAYS, // "Always"
	ALWAYS_CCPM, // "Always attempt to establish direct encrypted private message channels"
	AM, // " AM"
	ANTI_PASSIVE_SEARCH, // "-- WARNING --\r\n-- You are in active mode, but have activated passive search. --\r\n-- Don't use passive search if you have search results without this option --\r\n-- because you don't get search result from passive clients !!! --\r\n-- Turn it off in settings => AirDC++ => Always use passive mode for search --\r\n"
	ANY, // "Any"
	APPLICATION, // "Application"
	ASCH_SUPPORT_COUNT, // "Users with Advanced Search support: %1%/%2%"
	AS_ADD_DUPE_CONFIRM, // "Do you want to continue with adding this item anyway?"
	AS_END_GREATER, // "End time must be greater than the start time!"
	AS_ERROR, // "%1%: %2% (on %3% from a user %4%)"
	AS_INC_DESC, // "The number will be incremented only after the previous bundle has finished downloading, only one bundle can be queued at time."
	AS_MAX_NUMBER_HELP, // "The search item will expire after a bundle with this number has been downloaded."
	AS_NEXT_SEARCH_IN, // "Next search in"
	AS_NUM_LEN_HELP, // "If the number string is shorter than this value, the length will be filled by adding zeroes in front of the current number."
	AS_OVER_MAX_NUMBER, // "The current number can't be bigger than the maximum number!"
	AS_REPORT, // "Report hit in main chat"
	AS_TIMEVAR_AVAILABLE, // "Available time variables"
	AS_TIMEVAR_HELP, // "In addition to incrementing numbers, you may also insert time variables in the search string. Note that the parameters can also be used in the custom matcher."
	AS_USER_MATCH, // "Users with nick matching: (wildcards, | separate)"
	AS_X_FOUND_FROM, // "A %1% %2% was found from a user %3%"
	ATTEMPT_AUTO_UPDATE, // "AirDC++ will now attempt to update your installation automatically"
	AT_LEAST, // "At least"
	AT_MOST, // "At most"
	AUDIO, // "Audio"
	AUTO, // "Auto"
	AUTODETECT, // "Detect automatically"
	AUTOSEARCH_ADDED, // "A new item %1% has been added"
	AUTOSEARCH_ADDED_SEARCHED, // "A new item %1% has been added and it has been searched for"
	AUTOSEARCH_ADDED_SEARCHED_IN, // "A new item %1% has been added and it will be searched for in %2% seconds"
	AUTOSEARCH_ADD_FAILED, // "Failed to add the item %1%: %2%"
	AUTOSEARCH_CHECK_QUEUED, // "Don't download directories already in queue"
	AUTOSEARCH_CHECK_SHARED, // "Don't download directories already in share"
	AUTOSEARCH_DEFAULT_FAILED_GROUP, // "Default group for failed bundle items"
	AUTOSEARCH_DLG, // "Add/Change auto search"
	AUTOSEARCH_EVERY_INTERVAL, // "Minimum search interval between items (in minutes)"
	AUTOSEARCH_EXPIRY_DAYS, // "Auto search expiry days"
	AUTOSEARCH_GROUP, // "Auto search group: "
	AUTOSEARCH_MINIMUM_SEARCH_INTERVAL, // "Minimum search interval for the item to be searched again"
	AUTO_ADD_SOURCE, // "Automatically add download sources from search"
	AUTO_CONNECT, // "Auto connect / Name"
	AUTO_CONNECTIVITY_DETECTION, // "Automatic connectivity detection"
	AUTO_GRANT, // "Auto grant slot / Nick"
	AUTO_GRANT_SLOT, // "Auto grant slot"
	AUTO_REMOVE, // "Auto remove"
	AUTO_SEARCH, // "Auto search"
	AVERAGE, // "Average/s: "
	AWAY, // "AWAY"
	AWAY_IDLE_TIME_BEGIN, // "Automatically set away mode after"
	AWAY_IDLE_TIME_END, // "minutes of inactivity (0 = disable)"
	AWAY_MODE, // "Away mode"
	AWAY_MODE_OFF, // "Away mode off"
	AWAY_MODE_ON, // "Away mode on: "
	AWAY_OFF, // "Away mode OFF - click to adjust"
	AWAY_ON, // "Away mode ON - click to adjust"
	B, // "B"
	BACK, // "Back"
	BACKGROUND, // "Background"
	BACKGROUND_IMAGE, // "Background image"
	BACKGROUND_UPDATER_START, // "Starting to download a new client version (%1%)..."
	BAD_REGEXP, // "Badly formatted regular expression"
	BALLOON_POPUPS, // "Popups"
	BAR_DEPTH, // "3d depth"
	BEGIN, // "Begin"
	BIG_FILE_NOT_SHARED, // "File size exceeds the configured maximum limit"
	BIND_ADDRESS_MISSING, // "The %1% bind address %2% doesn't appear to be available. Do you want to switch to listen to all interfaces?"
	BLEND_COLOR, // "Blend color"
	BLEND_TABS, // "Blend tabs instead of using bold font"
	BLOOM_MODE, // "Bloom filter mode"
	BOLD, // "Bold"
	BOLD_HUB_TABS_ON_KICK, // "Bold hub tabs on kick messages"
	BROWSE, // "Browse..."
	BROWSE_FILE_LIST, // "Browse file list"
	BROWSE_VIA, // "Browse via"
	BUMPED, // "Bumped"
	BUNDLE, // "Bundle"
	BUNDLES, // "Bundles"
	BUNDLES_QUEUED, // "Queued bundle files"
	BUNDLES_REMOVE_EXIT, // "Remove finished bundles on exit"
	BUNDLE_ALT_SEARCH, // "Searching the bundle %1% for alternatives, %2% search(es) queued."
	BUNDLE_ALT_SEARCH_RECENT, // "Searching alternates for a RECENT bundle %1%, %2% search(es) queued."
	BUNDLE_CREATED, // "The bundle %1% has been created with %2% items"
	BUNDLE_CREATION_FAILED, // "Failed to create the bundle %1%: %2%"
	BUNDLE_FILENAME, // "Bundle / Filename"
	BUNDLE_ITEM_ADDED, // "The file %1% was added into an existing bundle %2%"
	BUNDLE_LOAD_FAILED, // "Failed to load the bundle %1%: %2%. The bundle file has been deleted."
	BUNDLE_MERGED, // "The directory %1% has been merged into an existing bundle %2% (%3% items were merged)"
	BUNDLE_READDED, // "The bundle %1% has been re-added for downloading"
	BUNDLE_REMOVED, // "Bundle removed"
	BUNDLE_REMOVED_AS, // "There's an auto search with the same name associated to the bundle %1%.\r\n\r\nDo you want to remove the auto search item as well?"
	BUNDLE_SHARING_FAILED, // "Failed to add the bundle %1% in share"
	BUNDLE_ERROR_SUBBUNDLES, // "There are %1% items queued inside the path %2%: %3%"
	BUNDLE_X_QUEUED, // "%1% (queued)"
	BUNDLE_X_REMOVED,  // "The bundle %1% has been removed from the queue"
	BUNDLE_X_SHARED, // "The bundle %1% has been added in share"
	BUNDLE_X_FINISHED_WARNING, // "There are %1% finished bundles in queue, please consider removing some of the bundles"
	CANCEL, // "Cancel"
	CANT_OPEN_EMPTY_FILE, // "A zero-byte file can't be opened"
	CANT_OPEN_SFV, // "Failed to open the SFV file"
	CASE_SENSITIVE, // "Case sensitive"
	CCPM_BLOCKED_WARNING, // "The hub %1% has chosen not to allow direct encrypted private message channels, which means that the text is being analyzed by the hub and possibly being read by its operators."
	OTHER_MEANS_COMMUNICATION, // "It's recommended that you use other means of communication for transferring sensitive information."
	OTHER_CCPM_SUPPORTED, // "However, you can establish direct encrypted messaging channel via other common hubs for transferring sensitive information."
	CCPM_DISCONNECTED, // "The direct encrypted channel has been disconnected"
	CCPM_DISCONNECTING, // "Disconnecting the direct encrypted channel..."
	CCPM_ESTABLISHED, // "A direct encrypted channel has been established"
	CCPM_ESTABLISHING, // "Establishing a direct encrypted channel..."
	CCPM_NOT_SUPPORTED, // "The user does not support the CCPM ADC extension"
	CCPM_NOT_SUPPORTED_NMDC, // "A secure ADC hub is required; this feature is not supported on NMDC hubs"
	CCPM_TIMEOUT, // "Failed to establish encrypted channel : Connection timeout"
	CERTIFICATE_GENERATED, // "Generated new TLS certificate"
	CERTIFICATE_GENERATION_FAILED, // "TLS disabled, failed to generate certificate:"
	CERTIFICATE_NOT_TRUSTED, // "Certificate not trusted"
	CHANGE_PASSWORD, // "Change password"
	CHANGE_TAB_COLOR, // "Change tab color"
	CHANNEL_BETA, // "Stable and beta versions"
	CHANNEL_NIGHTLY, // "Nightly builds"
	CHANNEL_STABLE, // "Stable versions only"
	CHAT, // "Chat"
	CHATDBLCLICKACTION, // "Chat double click on user action"
	CHAT_NOTIFY, // "Show notify icon on main chat messages"
	CHOOSE_FOLDER, // "Choose folder"
	CID, // "CID"
	CIPHER, // "Cipher"
	CLEAN, // "Clean"
	CLEAR, // "Clear"
	CLEAR_CHAT, // "Clear chat"
	CLEAR_ERROR, // "Clear error"
	CLEAR_EXIT, // "Clear on exit"
	CLEAR_FINISHED_PATHS, // "Clear finished paths"
	CLEAR_HISTORY, // "Clear history"
	CLEAR_MESSAGES, // "Clear messages"
	CLIENT_VERSION, // "Client version"
	CLOSE, // "Close"
	CLOSE_CONNECTION, // "Close connection"
	CLOSE_MINIMIZES, // "Close button minimizes AirDC"
	CLOSING_CONNECTIONS, // "Closing connections"
	CLOSING_WAIT, // "Closing, please wait..."
	CLOSING_WINDOWS, // "Closing windows"
	COLLAPSE_ALL, // "Collapse all"
	COLLECTING_RESULTS, // "Collecting results"
	COLORS_AND_TEXT_STYLES, // "Colors and text styles"
	COLOR_FONT, // "Color && font"
	COLOR_OP, // "User is OP"
	COMMAND, // "Command"
	COMMAND_TOO_LONG, // "Maximum command length exceeded"
	COMMENT, // "Comment"
	COMPACTING_X, // "Compacting %1%..."
	COMPLETE_ITEM_X_REMOVED, // "A completed item %1% has been removed"
	COMPRESSED, // "Compressed"
	COMPRESSION_ERROR, // "Error during compression"
	CONFIGURE, // "Configure"
	CONFIGURED_HUB_LISTS, // "Configured public hub lists"
	CONFIRM_FILE_DELETIONS, // "Confirm file deletions"
	CONFIRM_NEW, // "Confirm new"
	CONFIRM_PROFILE_REMOVAL, // "Are you sure that you want to remove the profile %1%?"
	CONFIRM_REMOVE_DIR_BUNDLE, // "Are you sure you want to remove the bundle %1%?"
	CONFIRM_REMOVE_DIR_FINISHED, // "Are you sure you want to remove the bundle %1% and its finished files?"
	CONFIRM_REMOVE_DIR_FINISHED_MULTIPLE, // "Are you sure you want to remove %1% bundles and all their finished files?"
	CONFIRM_REMOVE_DIR_MULTIPLE, // "Are you sure you want to remove %1% bundles?"
	CONFIRM_REMOVE_HUBS_FAV_GROUP, // "The group %1% contains %2% hubs, remove all of the hubs as well?\n\nIf you select 'Yes', all of these hubs are going to be deleted!\n\nIf you select 'No', these hubs will simply be moved to the main default group."
	CONFIRM_SIZE_WARNING, // "There is only %1% remaining in the directory %2% while %3% is needed. Do you want to continue?"
	CONNECT, // "Connect"
	CONNECTED, // "Connected"
	CONNECTING, // "Connecting..."
	CONNECTING_FORCED, // "Connecting (forced)..."
	CONNECTING_IN_PROGRESS, // "Connecting to the hub in progress"
	CONNECTING_TO, // "Connecting to"
	CONNECTION, // "Connection"
	CONNECTION_CLOSED, // "Connection closed"
	CONNECTION_DETECTION, // "Enable automatic incoming connection type detection"
	CONNECTION_IPV6_UNSUPPORTED, // "IPv6 is not supported for this connection"
	CONNECTION_SPEED, // "Connection speed"
	CONNECTION_TIMEOUT, // "Connection timeout"
	CONNECTIVITY, // "Connectivity"
	CONNECT_ALL, // "Connect to all users"
	CONNECT_FAVUSER_HUB, // "Connect to hub"
	CONNECT_REQUEST_SPAM_FROM, // "Connect request spam detected from %1% (%2%)"
	CONN_ACTIVE_FAILED, // "Active mode could not be achieved; a manual configuration is recommended for better connectivity"
	CONN_DETECT_FINISHED, // "Automatic connectivity detection finished. Click \"Next\" to continue to the next step."
	CONN_DETERMINING, // "Determining the best connectivity settings..."
	CONN_DIRECT_DETECTED, // "Public IP address detected, selecting active mode with direct connection"
	CONN_NAT_DETECTED, // "Local network with possible NAT detected, trying to map the ports..."
	CONN_PORT_X_FAILED, // "Unable to open %1% port(s); connectivity settings must be configured manually"
	CONN_USE_MANUAL_CONFIG, // "I want to configure connectivity settings manually"
	CONTEXT, // "Context"
	CONTINUE_SEARCH, // "Continue search"
	COPY, // "Copy"
	COPY_ALL, // "Copy all"
	COPY_DIRECTORY, // "Copy directory"
	COPY_FROM_THIS_DOTS, // "Copy from this..."
	COPY_HUB, // "Copy address to clipboard"
	COPY_LINE, // "Copy actual line"
	COPY_PROFILE, // "Copy profile"
	COULD_NOT_OPEN_TARGET_FILE, // "Could not open target file: "
	COUNT, // "Count"
	COUNTRY, // "Country"
	COUNTRY_INFORMATION, // "Country information"
	CREATING_MAGNET_FOR, // "Creating magnet link for a file %1%..."
	CREATING_MAGNET_FOR_X, // "Creating magnet links for %1% files..."
	CURRENT_NUMBER, // "Current number"
	CURRENT_VALUE_X, // "Current value: %1%"
	CURRENT_VERSION, // "Current version"
	CUSTOM, // "Custom..."
	CUSTOM_AWAY_MESSAGE, // "Custom away message"
	CUSTOM_SEARCH_TIMES, // "Search only on specific times"
	DATA_PARSING_FAILED, // "Failed to parse the data"
	DATE, // "Date Modified"
	DAY, // "Day"
	DAYS, // "Days"
	DB_ERROR_HINT, // "You can set the database to be verified and repaired from the \"%1%\" tab in Settings (if needed)"
	DB_OPEN_FAILED, // "Failed to open %1%: %2%\r\n\r\n%3% will now exit."
	DB_OPEN_FAILED_IO, // "Failed to open %1%: %2%\r\n\r\nMake sure that there isn't another instance of %3% using the same settings directory and that the directory %4% is accessible. %5% will now exit."
	DB_OPEN_FAILED_REPAIR, // "Failed to open %1%: %2%\r\n\r\n%3% will now attempt to repair it automatically."
	DB_REPAIR_FAILED, // "Failed to repair %1%: %2%\r\n\r\nMake sure that the path %3% is accessible and there isn't another instance of %4% using the same settings directory. Remove the directory in case the error can't be fixed."
	DB_X_REPAIRED, // "%1% has been verified and repaired successfully. Detailed information about the process has been saved in %2%"
	DECODING_ERROR, // "Received data could not be parsed with encoding %1%"
	DECOMPRESSION_ERROR, // "Error during decompression"
	DECREASE_NUM, // "Decrease current number"
	DEFAULT, // "Default"
	DELETE_FILE, // "Delete file"
	DELETE_FILE_CONFIRM, // "Are you sure you want to delete the file %1%?"
	DESCRIPTION, // "Description"
	DESTINATION, // "Destination"
	DETECT_NOW, // "Detect now"
	DEVICE_REMOVED, // "Device removed"
	DIRECTORIES_ADDED, // "%1% directories have been added in share"
	DIRECTORY, // "Directory"
	DIRECTORY_ADDED, // "The directory %1% has been added in share"
	DIRECTORY_IS_HIDDEN, // "Directory is hidden"
	DIRECTORY_LOADED, // "The directory %1% has been loaded"
	DIRECTORY_NOT_FOUND, // "Directory not shared"
	DIRECTORY_NOT_REMOVED,  // "The directory %1% isn't empty, not removed"
	DIRECTORY_SUBDIRS_SHARED, // "Subdirectories of the directory are already shared in the following profiles: %1%"
	DIRECTORY_PARENT_SHARED, // "Parent of the directory is already shared in the following profiles: %1%"
	DIRECTORY_REFRESHED, // "The directory %1% has been refreshed"
	DIRECTORY_REFRESH_QUEUED, // "The directory %1% has been queued for refreshing"
	DIRECTORY_SHARED, // "Directory already shared"
	DIRECT_ENCRYPTED_CHANNEL, // "Direct encrypted channel"
	DIR_EMPTY, // "The directory is empty"
	DIR_HISTORY, // "Download locations"
	DIR_QUEUED_ALREADY, // "The directory exists in queue: %1%"
	DIR_REFRESH_FAILED, // "Failed to refresh the directory %1%: %2%"
	DIR_SHARED_ALREADY, // "The directory exists in share: %1%"
	DISABLE, // "Disable"
	DISABLED, // "Disabled"
	DISABLE_AUTOSEARCH, // "Disable item(s)"
	DISABLE_RSS, // "Disable auto update"
	DISALLOW_CONNECTION_TO_PASSED_HUBS, // "Automatically disconnect hubs if not registered"
	DISCONNECTED, // "Disconnected"
	DISCONNECTED_USER, // "Disconnected user leaving the hub: "
	DISCONNECT_ALL, // "Disconnect all users"
	DISCONNECT_BUNDLE_SPEED, // "And the bundle speed exceeds"
	DISCONNECT_CCPM, // "Disconnect the direct encrypted channel"
	DISCONNECT_RUNNING_DOWNLOADS, // "And the minimum number of bundle downloads is"
	DISCONNECT_USER, // "Disconnect user(s)"
	DISKS_MISSING, // "Disks missing :"
	DL_BUNDLE_FINISHED, // "The bundle %1% has finished downloading"
	DL_STATUS_POPUP, // "Download speed - click to adjust limiter value"
	DOCUMENT, // "Document"
	DONE, // "Done"
	DONE_CHUNKS, // "Done chunks"
	DONT_ASK_AGAIN, // "Don't ask me again"
	DONT_SHARE_APP_DIRECTORY, // "Application directories cannot be shared because they may contain passwords and other sensitive information"
	DONT_SHARE_BIGGER_THAN, // "Don't share files bigger than (0 = disable)"
	DONT_SHARE_DOWNLOAD_DIRECTORY, // "The download directory cannot be shared"
	DONT_SHARE_EMPTY_DIRS, // "Don't share empty directories"
	DONT_SHOW_AGAIN, // "Don't show this again"
	DOWN, // "Down"
	DOWNLOAD, // "Download"
	DOWNLOADED, // "Downloaded"
	DOWNLOADED_BYTES, // "Downloaded %s (%.01f%%) in %s"
	DOWNLOADED_FROM, // " downloaded from "
	DOWNLOADED_PARTS, // "Downloaded parts"
	DOWNLOADING, // "Downloading..."
	DOWNLOADING_HUB_LIST, // "Downloading public hub list..."
	DOWNLOADING_LIST, // "Downloading list..."
	DOWNLOADS_RUNNING, // "Downloads running, please disconnect them"
	DOWNLOAD_BEGINS, // "Download begins"
	DOWNLOAD_FAILED, // "Download failed: "
	DOWNLOAD_FINISHED, // "Download finished"
	DOWNLOAD_FINISHED_IDLE, // "Download finished, idle..."
	DOWNLOAD_LIMIT, // "Download limit"
	DOWNLOAD_LIMITS, // "Download limits"
	DOWNLOAD_LIMIT_DISABLED, // "Download limit disabled"
	DOWNLOAD_LIMIT_SET_TO, // "Download limit set to %1% KiB/s"
	DOWNLOAD_OPEN, // "Download and open"
	DOWNLOAD_QUEUE, // "Download queue"
	DOWNLOAD_SIGN_FAILED, // "Could not download the digital signature (%1%)"
	DOWNLOAD_STARTING, // "Download starting..."
	DOWNLOAD_TO, // "Download to..."
	DOWNLOAD_VERSION_FAILED, // "Could not download the version file (%1%)"
	DOWNLOAD_WHOLE_DIR, // "Download whole directory"
	DOWNLOAD_WHOLE_DIR_TO, // "Download whole directory to..."
	DOWNLOAD_WITH_PRIORITY, // "Download with priority..."
	DUPLICATE, // "Duplicate"
	DUPLICATE_FILES_DETECTED, // "%1% duplicate files were detected when generating file list from directories %2%"
	DUPLICATE_SOURCE, // "Duplicate source"
	EDIT_ACCEL, // "Edit"
	EDIT_PROFILES, // "Edit profiles..."
	ELEVATED_WARNING, // "You appear to run the client with administrative privileges. This may disable the following client functionality:\r\n\r\n- Clicking on web links in chat doesn't work\r\n- All drives aren't shown in the sharing settings\r\n- Drag and drop functionality can't be used\r\n\r\nYou may also notice other unexcepted behaviour, so it is heavily recommended that you switch the client to run with normal privileges."
	EMAIL, // "E-Mail"
	EMOTICONS_PACK, // "Emoticons pack"
	ENABLE, // "Enable"
	ENABLED, // "Enabled"
	ENABLE_AUTOSEARCH, // "Enable item(s)"
	ENABLE_CONNECTIVITY, // "Enable %1% connectivity"
	ENABLE_MULTI_SOURCE, // "Enable segmented downloads"
	ENABLE_PARAMETERS, // "Enable parameters"
	ENABLE_RSS, // "Enable auto update"
	ENCRYPTED_TRANSFER, // "Encrypted transfer"
	ENCRYPTION, // "Encryption"
	ENCRYPTION_DISABLED, // "Client encryption disabled"
	ENCRYPTION_FORCED, // "Enabled (forced in ADC hubs)"
	END, // "End"
	ENDLESS_REDIRECTION_LOOP, // "Endless redirection loop (%1%)"
	END_TIME, // "End time"
	ENTER_NICK, // "Please enter a nickname in the settings dialog!"
	ENTER_PASSWORD, // "Please enter a password"
	ENTER_SEARCH_STRING, // "Enter search string"
	ERRORS, // "Errors"
	ERROR_CODE_X, // "%1% (code: %2%)"
	ERROR_CREATING_REGISTRY_KEY_ADC, // "Error creating adc registry key"
	ERROR_CREATING_REGISTRY_KEY_DCHUB, // "Error creating dchub registry key"
	ERROR_CREATING_REGISTRY_KEY_MAGNET, // "Error creating magnet registry key"
	ERROR_HASHING, // "Error hashing "
	ERROR_HASHING_CRC32, // "calculated CRC32 does not match the one found in SFV file."
	ERROR_TLS_PORT, // "The encrypted transfers port (TLS/TCP) cannot be the same as the transfers port (TCP)"
	ERROR_UPDATING_FEED, // "Error updating the feed : %1%"
	EXACT_MATCH, // "Exact match"
	EXACT_SHARED, // "Exact share"
	EXACT_SIZE, // "Exact size"
	EXCLUDED_SEARCH_WORDS, // "Excluded search words"
	EXCLUDED_WORDS_DESC, // "Excluded words (separate with space)"
	EXCLUDE_DOTS, // "Exclude..."
	EXCLUDE_MATCHES, // "Exclude matches"
	EXECUTABLE, // "Executable"
	EXPANDED_RESULTS, // "Expand search results"
	EXPAND_ALL, // "Expand all"
	EXPIRATION, // "Expiration"
	EXPIRED, // "Expired"
	EXPIRED_AS_DISABLED, // "An expired item %1% has been disabled"
	EXPIRED_AS_REMOVED, // "An expired item %1% has been removed"
	EXPORT_THEME, // "Export theme"
	EXTENSIONS, // "Extensions"
	EXTENSION_DATA, // "Extension data"
	EXTENSION_INSTALLING_X, // "Installing extension %1%..."
	EXTENSION_UPDATING_X, // "Updating extension %1%..."
	EXTENSION_CATALOG, // "Extension catalog"
	EXTENSION_CATALOG_DOWNLOADING, // "Downloading extension catalog..."
	EXTENSION_CATALOG_DOWNLOADED, // "Extension catalog downloaded"
	EXTENSION_WEB_CFG_DESC, // "The value of this setting can currently be configured only from the web user interface"
	EXTENSIONS_EMPTY, // "No extensions have been defined"
	EXTENSIONS_DEV_HELP, // "How to write a new extension?"
	EXTENSIONS_INSTALL_URL, // "Install extensions from URL..."
	EXTRA_SLOTS_SET, // "Extra slots set"
	EiB, // "EiB"
	FAILED, // "Failed"
	FAILED_BUNDLE_SEARCHED, // "A failed bundle %1% has been searched for"
	FAILED_BUNDLE_SEARCHED_IN, // "A failed bundle %1% will be searched for in %2% seconds"
	FAILED_TO_LOAD_CERTIFICATE, // "Failed to load certificate file"
	FAILED_TO_LOAD_PRIVATE_KEY, // "Failed to load private key"
	FAILED_TO_READ, // "Failed to read %1%: %2%"
	FAILED_TO_SHUTDOWN, // "Failed to shutdown!"
	FAILED_TO_OPEN_FILE, // "Failed to open the file %1%: %2%"
	FAVDIRS_SHOW_SHARED, // "Show shared directories in the \"Download to\" menu"
	FAVORITE, // "Favorite"
	FAVORITE_DIR_NAME, // "Favorite name"
	FAVORITE_HUBS, // "Favorite hubs"
	FAVORITE_HUB_ADDED, // "Favorite hub added"
	FAVORITE_HUB_ALREADY_EXISTS, // "A favorite hub with the same address exists already"
	FAVORITE_HUB_DOES_NOT_EXIST, // "This hub is not a favorite hub"
	FAVORITE_HUB_IDENTITY, // "Identification (leave blank for defaults)"
	FAVORITE_HUB_PROPERTIES, // "Favorite hub properties"
	FAVORITE_HUB_REMOVED, // "Favorite hub removed"
	FAVORITE_USERS, // "Favorite users"
	FAVORITE_USER_ADDED, // "Favorite user added"
	FAVUSER_ONLINE, // "Favorite user online"
	FAV_DL_SPEED, // "Add user to favorites if download speed is over"
	FAV_JOIN_SHOWING_OFF, // "Join/part of favorite users showing off"
	FAV_JOIN_SHOWING_ON, // "Join/part of favorite users showing on"
	FAV_LOG_CHAT, // "Log main chat"
	FAV_SHOW_JOIN, // "Show user joins / parts"
	FEEDS, // "Feed(s)"
	FEED_NAME, // "Feed name"
	FILE, // "File"
	FILELIST, // "File list"
	FILELIST_LOADED_IN, // "File list has been loaded in %1%"
	FILELIST_ON_DISK, // "File list on disk"
	FILENAME, // "Filename"
	FILES, // "Files"
	FILES_ADDED_FOR_HASH, // "(%1% of files have been added for hashing; they won't be visible in the file list until they have finished hashing)"
	FILES_ADDED_FOR_HASH_STARTUP, // "%1% of shared files have been added for hashing as no previous hash information was found for them"
	FILES_LEFT, // "files left"
	FILES_PER_HOUR, // "files/h"
	FILE_ALREADY_FINISHED, // "File is already finished"
	FILE_ALREADY_QUEUED, // "A file with the same hash exists in a queued directory %1%"
	FILE_ALREADY_SHARED, // "Trying to download file already shared! File: "
	FILE_ALREADY_VIEWED, // "The file %1% is being viewed already"
	FILE_CORRUPTION_FOUND, // "%1% of corrupted segments were found"
	FILE_DATE_FORMAT, // "File date format"
	FILE_INDEX, // "File index"
	FILE_INDEX_SIZE, // "File index size:"
	FILE_LISTS, // "File lists"
	FILE_LIST_DIFF, // "Subtract list"
	FILE_LIST_REFRESH_FAILED, // "File list refresh failed: "
	FILE_LIST_REFRESH_FINISHED, // "File list refresh finished"
	FILE_LIST_REFRESH_INITIATED, // "File list refresh initiated"
	FILE_LIST_REFRESH_INITIATED_INCOMING, // "File list refresh initiated for the incoming directories"
	FILE_LIST_REFRESH_INITIATED_RPATH, // "File list refresh initiated for the path %1%"
	FILE_LIST_REFRESH_INITIATED_VPATH, // "File list refresh initiated for the virtual directory \"%1%\""
	FILE_LIST_REFRESH_INITIATED_X_PATHS, // "File list refresh initiated for %1% directories"
	FILE_MISSING, // "FILE MISSING: "
	FILE_NOT_AVAILABLE, // "File not available"
	FILE_NOT_FOUND, // "File not found"
	FILE_SEGMENT, // "Bundle file / Segment"
	FILE_TYPE, // "File type"
	FILE_WITH_DIFFERENT_SIZE, // "A file with a different size already exists in the queue"
	FILE_WITH_DIFFERENT_TTH, // "A file with different TTH root already exists in the queue"
	FILE_X_QUEUED, // "The file %1% has been added in queue (%2%)"
	FILTER, // "Filter"
	FILTERED, // "Filtered"
	FILTER_DOTS, // "Filter..."
	FIND, // "Find"
	FIND_TEXT, // "Find text"
	FINISHED, // "Finished"
	FINISHED_BUNDLES, // "Finished bundles"
	FINISHED_DOWNLOAD, // "Download finished: %s"
	FINISHED_DOWNLOADS, // "Finished downloads"
	FINISHED_UPLOAD, // "Upload finished: %s To: %s"
	FINISHED_UPLOADS, // "Finished uploads"
	FLASH_WINDOW_ON_MYNICK, // "Flash window on my nick in PM/Hub"
	FLASH_WINDOW_ON_NEW_PM, // "Flash window on PM only if it's from a new user"
	FLASH_WINDOW_ON_PM, // "Flash window on PM"
	FOLDER, // "Folder"
	FOLLOW_SYMLINKS, // "Follow symbolic links"
	FONT, // "Font"
	FORBIDDEN_FILE_EXT, // "Forbidden file extension"
	FORCE_ATTEMPT, // "Force attempt"
	FORCE_SHARING, // "Force in share"
	FORMAT_RELEASE, // "Format release names as links in chat"
	FORWARD, // "Forward"
	FRIDAY, // "Friday"
	FULL_LIST_DL_LIMIT, // "Maximum number of files for getting full file list with \"Get/Browse file list\""
	GBITS, // "Gbit/s"
	GENERATE_CERTIFICATES, // "Generate certificates"
	GENERATE_CERTS_NOTE, // "Note: you need to restart the client to load the new certificates"
	GENERIC, // "Generic"
	GEOIP_UPDATED, // "Country IP database has been successfully updated"
	GEOIP_UPDATING, // "Updating country IP database..."
	GEOIP_UPDATING_FAILED, // "Country IP database could not be updated"
	GET_BROWSE_LIST, // "Get/browse file list"
	GET_FILE_LIST, // "Get file list"
	GET_FULL_LIST, // "Get full list"
	GET_IP, // "Get IP"
	GLOBAL_SETTING_OVERRIDES, // "Overrides for global settings"
	GO_TO_DIRECTORY, // "Go to directory"
	GRANT_EXTRA_SLOT, // "Grant extra slot (10 min)"
	GRANT_EXTRA_SLOT_DAY, // "Grant extra slot (day)"
	GRANT_EXTRA_SLOT_HOUR, // "Grant extra slot (hour)"
	GRANT_EXTRA_SLOT_WEEK, // "Grant extra slot (week)"
	GRANT_SLOTS_MENU, // "Extra slots"
	GROUP, // "Group"
	GROUP_REMOVE_ITEMS, // "Remove all items in the group as well?"
	GiB, // "GiB"
	HASHDB_MAINTENANCE_FAILED, // "Failed to complete the hash database maintenance"
	HASHDB_MAINTENANCE_NO_UNUSED, // "Hash database maintenance finished, no unused entries were found"
	HASHDB_MAINTENANCE_STARTED, // "Hash database maintenance started..."
	HASHDB_MAINTENANCE_UNUSED, // "Hash database maintenance completed: %1% unused file entries and %2% unused tree entries have been removed"
	HASHER_X, // "Hasher #%1%"
	HASHER_X_CREATED, // "Hasher #%1% created"
	HASHING, // "Hashing"
	HASHING_FAILED_X, // "Hashing failed: %1%"
	HASHING_FINISHED, // "Hashing finished"
	HASHING_FINISHED_DIR,  // "The directory %1% has finished hashing: %2% files (%3%) have been hashed in %4% (%5%)"
	HASHING_FINISHED_FILE,  // "The file %1% (%2%) has finished hashing in %3% (%4%)"
	HASHING_FINISHED_TOTAL,  // "Hashing finished: %1% files (%2%) in %3% directories have been hashed in %4% (%5%)"
	HASHING_FINISHED_X, // "Finished hashing: %1%"
	HASHING_OPTIONS, // "Hashing options"
	HASHING_X_LEFT, // "Hashing %1%, %2% left"
	HASH_DATA, // "Hash data"
	HASH_DATABASE, // "Hash database"
	HASH_DATA_SIZE, // "Hash data size:"
	HASH_PROGRESS, // "Creating file index..."
	HASH_PROGRESS_BACKGROUND, // "Run in background"
	HASH_PROGRESS_STATS, // "Statistics"
	HASH_PROGRESS_TEXT, // "Please wait while AirDC++ indexes your files (they won't be shared until they've been indexed)..."
	HASH_READ_FAILED, // "Unable to read hash data file"
	HBRI_VALIDATING_X, // "Validating the %1% address..."
	HBRI_VALIDATION_FAILED, // "Validation failed: %1%. %2% connectivity has been disabled in this hub."
	HIBERNATE, // "Hibernate"
	HIDE_SHARE, // "Hide share in this hub"
	HIGH, // "High"
	HIGHEST, // "Highest"
	HIGHLIGHTLIST_HEADER, // "String to match"
	HIGHLIGHTS_IN_THEME, // "The selected theme has highlight color settings, \r\nloading them will override your old highlights, \r\nwould you still like to load them?"
	HIGHLIGHT_ACTIONS, // "Actions"
	HIGHLIGHT_ADD, // "Add..."
	HIGHLIGHT_CHANGE, // "Change..."
	HIGHLIGHT_DIALOG_TITLE, // "Highlight settings"
	HIGHLIGHT_MATCH_OPTIONS, // "Match options"
	HIGHLIGHT_MATCH_TYPES, // "Begins,Contains,Ends,Equals"
	HIGHLIGHT_TEXT_STYLES, // "Text styles"
	HIGHLIGHT_TEXT_TO_MATCH, // "Text to match"
	HISTORIES, // "Histories"
	HISTORY, // "History"
	HIT_COUNT, // "Hits"
	HIT_RATIO, // "Hit ratio: "
	HL_REGEXP, // "Use $Re: for regexp"
	HOUR, // "Hour"
	HOURS, // "Hours"
	HOURS_LOWER, // "hours"
	HUB, // "Hub"
	HUBLIST_CACHE_CORRUPTED, // "Cached hub list is corrupted or unsupported..."
	HUBLIST_DOWNLOAD_CORRUPTED, // "Downloaded hub list is corrupted or unsupported..."
	HUBS, // "Hubs"
	HUB_ADDRESS, // "Address"
	HUB_BOLD_TABS, // "Make tabs bold on status messages in hubs"
	HUB_CONNECTED, // "Hub connected"
	HUB_DISCONNECTED, // "Hub disconnected"
	HUB_DDOS_DISCONNECT, // "%1%. The hub will be disconnected in order to preserve system resources. If you continue receiving this error, it may indicate that the hub utilizes its users in a DDoS attack."
	HUB_LIST, // "Hublist"
	HUB_LIST_DOWNLOADED, // "Hub list downloaded..."
	HUB_LIST_EDIT, // "Edit the hublist"
	HUB_LIST_LOADED_FROM_CACHE, // "Hub list loaded from cache..."
	HUB_NOT_PROTECTED, // "No password was required/provided at login, disconnecting hub. (Setting @ MiscPage)"
	HUB_SEGMENTS, // "Hub / Connections"
	HUB_TOPIC, // "Hub topic :"
	HUB_UNKNOWN, // "No known hub"
	ICONS_DEFAULT, // "Default icons"
	ICONS_IN_THEME, // "The selected theme has custom icons, do you wish to load them?\r\n You will need to restart AirDC++ for the icons to load."
	ICONS_RESTORE, // "Restore default icons?\r\n You will need to restart AirDC++ for the icons to load."
	IGNORED_MESSAGE, // "Ignored message: "
	IGNORED_USERS, // "Ignored users"
	IGNORE_HELP, // "Note: Nick pattern or text pattern can be empty.\r\nIf the nick pattern is empty, the text pattern is used, only incoming message will be matched with text pattern. \r\nIf both patterns are set the message is ignored only if both matches are found. "
	IGNORE_NICK_MATCH, // "Nick match pattern"
	IGNORE_NO_CONTEXT, // "No context selected, you need to select at least one of: private chat / main chat"
	IGNORE_TEXT_MATCH, // "Text match pattern"
	IGNORE_TTH_SEARCHES, // "Ignore TTH searches"
	IGNORE_USER, // "Ignore user"
	IMPORT_THEME, // "Import theme"
	INACTIVE, // "Inactive"
	INACTIVE_QUEUED, // "Inactive (files queued)"
	INCOMING, // "Incoming"
	INCOMING_REFRESHED, // "Incoming directories have been refreshed"
	INCOMING_REFRESH_QUEUED, // "Incoming directories have been queued for refreshing"
	INCOMING_CONNECT_FLOOD_FROM, // "Incoming connection flood detected from %1%"
	INCOMPLETE_FAV_HUB, // "Hub address cannot be empty."
	INCREASE_NUM, // "Increase current number"
	INCREMENTING_NUMBERS, // "Incrementing numbers"
	INFO, // "Info"
	INSERT_EMOTICON, // "Insert emoticon"
	INSERT_IN_SEARCHSTRING, // "Insert in the search string"
	INSTALL, // "Install"
	INSTALLED, // "Installed"
	INSTALL_RAR_SKIPLIST, // "Install the RAR profile share skiplist to avoid sharing of unwanted files"
	INTEGRITY_CHECK, // "Integrity check: %1% ( %2% )"
	INTEGRITY_CHECK_FAILED, // "File integrity check failed"
	INTEGRITY_CHECK_FINISHED_BUNDLE, // "Integrity check finished for the bundle %1%: %2% of failed segments were found"
	INTEGRITY_CHECK_FINISHED_FILES, // "Integrity check finished: %1% of failed segments were found"
	INTEGRITY_CHECK_START_BUNDLE, // "Integrity check for the bundle %1% started (total bytes to check: %2%)"
	INTEGRITY_CHECK_START_FILES, // "Integrity check for %1% files started..."
	INVALID_ENCODING, // "The encoding %1% is invalid or not supported by the system"
	INVALID_EXTENSION, // "Invalid extension: %1%"
	INVALID_HUB_RESPONSE, // "The hub returned an invalid response"
	INVALID_LISTNAME, // "Invalid file list name"
	INVALID_MODIFICATION_DATE, // "Invalid modification date"
	INVALID_NUMBER_OF_SLOTS, // "Invalid number of slots"
	INVALID_PASSWORD, // "Invalid password"
	INVALID_PATH, // "Invalid path: %1%"
	INVALID_PATTERN, // "Invalid pattern: %1%"
	INVALID_REGEXP, // "Invalid regexp!"
	NO_VALID_LINES, // "No valid lines were found"
	INVALID_SIZE, // "Invalid size"
	INVALID_TARGET_FILE, // "Invalid target file (missing directory, check default download directory setting)"
	INVALID_TREE, // "Full tree does not match TTH root"
	INVALID_TTH_SEARCH, // "Invalid input value for TTH search"
	INVALID_PORTS, // "Invalid value: TLS port cannot be the same as the TCP port"
	IP, // "IP: "
	IPV6_NO_PUBLIC_IP, // "IPv6 connectivity has been disabled as no public IPv6 address was detected"
	IP_BARE, // "IP"
	IP_UPDATE_FAILED, // "Failed to update the IP address"
	IP_V4, // "IP (v4)"
	IP_V6, // "IP (v6)"
	ITALIC, // "Italic"
	ITEMS, // "Items"
	ITEMS_X, // "%1% item(s)"
	ITEM_NAME_EXISTS, // "An item with the same name exists already"
	ITEM_URL_EXISTS, // "An item with the same url exists already"
	ITEM_SEARCHED, // "%1% has been searched for"
	ITEM_SEARCHED_IN, // "%1% will be searched in %2% seconds"
	ITEM_SEARCHED_RECENT, // "Recent item %1% has been searched for"
	ITEM_SEARCHED_IN_RECENT, // "Recent item %1% will be searched in %2% seconds"
	ITUNES_HELP, // "/itunes - For iTunes media spamming\r\n- %[version]	Numerical Version (ex: 7.0.2.16)\r\n- %[album]	Name of the album the current track is from\r\n- %[artist]	Artist of the current track\r\n- %[title]		Name of the currently playing track\r\n- %[genre]	Genre of the currently playing track\r\n- %[elapsed]	Time elapsed in minutes:seconds\r\n- %[percent]	Time elapsed presented as percentage from total length\r\n- %[bar]		ASCII progress bar, 10 characters wide no including brackets (ex. [----|-----])\r\n- %[length]	Total length of the current track\r\n- %[bitrate]	Bitrate for the playing track (kbps)\r\n- %[frequency]	Frequency for the currently playing track (kHz)\r\n- %[year]	Year of publication/recording of the current track\r\n- %[size]		Size of the currently playing file\r\n- %[state]	Current state of iTunes (playing/stopped)\r\n\r\nEmpty = Default String -> +me playing: %[title] at %[bitrate] <iTunes %[version]>"
	ITUNES_HELP_DESC, // "iTunes help"
	JOINS, // "Joins"
	JOIN_SHOWING_OFF, // "Join/part showing off"
	JOIN_SHOWING_ON, // "Join/part showing on"
	KBITS, // "Kbit/s"
	KEY, // "Key"
	KEY_IN_USE, // "Key already in use"
	KEYPRINT_MISMATCH, // "Keyprint mismatch"
	KICK_USER, // "Kick user(s)"
	KICK_USER_FILE, // "Kick user(s) with filename"
	KiB, // "KiB"
	KiBS, // "KiB/s"
	LANGDOWNLOAD, // "Download language"
	LANGUAGE_NOTE, // "Note: you need to restart the client for the new language to take effect.\nIt is only the latest version of AirDC that has full multilingual support."
	LANGUAGE_UPDATED, // "The language \"%1%\" has been successfully updated. Changes will take effect after restarting the client."
	LANGUAGE_UPDATE_FAILED, // "Failed to update the language \"%1%\" (%2%)"
	LANGUAGE_VERSION, // "Language version"
	LAN_DISABLE_ENCRYPTION, // "Disable transfer encryption (reduces resource usage with high speed transfers)"
	LAN_HUBS, // "LAN/WAN hubs"
	LAST_CHANGE, // "Last change: "
	LAST_ERROR, // "Last error"
	LAST_HUB, // "Hub(s) (last seen on if offline)"
	LAST_MESSAGE_RECEIVED, // "Last message received"
	LAST_MESSAGE_SENT, // "Last message sent"
	LAST_NUMBER_TO_SEARCH, // "Last number to search for (0 = disable)"
	LAST_SEARCH, // "Last search"
	LAST_SEEN, // "Time last seen"
	LATEST_VERSION, // "Latest version"
	LEAVE_OTHER_PROFILES, // "Remove only from the current profile"
	LEFT, // "left"
	LEFT_COLOR, // "Left color"
	LEVEL_UP, // "Up one level"
	LIB_CRASH, // "Application ""%s"" caused an unhandled exception in AirDC++. Please uninstall it, upgrade it or use an alternate product."
	LIMIT, // "Upload limit"
	LINE_EMPTY, // "Line must not be empty"
	LINE_EMPTY_OR_TOO_SHORT, // "Search string empty or too short! (min. 5 chars allowed)"
	LINE_SPEED, // "Line speed"
	LINE_SPEED_NOTE, // "Note: You can type your line speed manually if none of the values suit you"
	LINK, // "Link"
	LISTENER_FAILED, // "Listening socket failed (you need to restart AirDC++): "
	LIST_ALREADY_QUEUED, // "The file list is queued already"
	LIST_HL_EXAMPLE, // "Example, *NORDIC* (this may slow down file list loading...)"
	LIST_HL_TEXT, // "Highlight matches in file lists (wildcards, | separate)"
	LIST_LOAD_FAILED, // "Failed to load the file list %1%: %2%"
	LIST_SIZE_DIFF_NOTE, // "The share size in hub %1% (%2%) is different than in the current hub %3% (%4%). Do you want to reload the list?"
	LIST_TEXTSTYLE, // "Font used in list views (User list, Search, Queue, Transfers...)"
	LIST_VIEW_COLORS, // "List view colors"
	LOADING, // "Loading AirDC++, please wait..."
	LOADING_FILE_LIST, // "Loading file list, this may take a while if the list is large."
	LOADING_GUI, // "Loading the user interface"
	LOAD_FAILED_X, // "Failed to load the file %1%: %2%"
	LOCATIONS, // "Locations"
	LOCATION_TYPE, // "Location type"
	LOCK, // "Lock"
	LOCK_TB, // "Lock toolbars\tCtrl+6"
	LOG_COMBINE_ADC_PM, // "Use a single log file per CID for ADC users"
	LOG_HASHING, // "Show each hashed file"
	LOG_OFF, // "Log off"
	LOG_SHARE_SCAN, // "Save the results to a log file when scanning the share"
	LOG_SHARE_SCAN_PATH, // "Log filename (relative to the global log directory)"
	LOW, // "Low"
	LOWEST, // "Lowest"
	LOWEST_PRIO_ERR_BUNDLES, // "Bundles with lowest priority will start when no other bundles are running"
	LOWEST_PRIO_ERR_FILES, // "Files with lowest priority will start when no other bundle downloads are running"
	MAGNET_ASK, // "Ask for MAGNET action"
	MAGNET_CREATED_FOR, // "Magnet link was created for a file %1%"
	MAGNET_CREATED_FOR_X, // "Magnet links were created for %1% files"
	MAGNET_DLG_REMEMBER, // "Do the same action next time without asking"
	MAGNET_DLG_SEARCH, // "Start a search for this file"
	MAGNET_DLG_TEXT_BAD, // "A MAGNET link was given to AirDC++, but it didn't contain a valid file hash for use on the Direct Connect network.  No action will be taken."
	MAGNET_DLG_TITLE, // "MAGNET Link detected"
	MAGNET_HANDLER_DESC, // "Download files from the Direct Connect network"
	MAGNET_INFOTEXT, // "A magnet link was detected for a file \"%1%\" (%2%). Please choose the action to perform."
	MAGNET_LINK, // "MAGNET link"
	MAGNET_SHELL_DESC, // "URL:MAGNET URI"
	MAINTENANCE, // "Maintenance"
	MAINTENANCE_STARTED_SETTINGS, // "Database maintenance started. Results are shown in the system log when the operation finishes."
	MAIN_CHAT, // "Main chat"
	HUB_PERMISSION_DENIED, // "Action rejected by the hub"
	MALFORMED_DATA, // "Malformed data"
	MANAGE_GROUPS, // "Manage groups"
	MANDATORY_UPDATE, // "Mandatory update"
	MANUALLY_CONFIGURED_DETECTED, // "Manually configured settings were detected"
	MANUALLY_CONFIGURED_MSG, // "There are %1% settings that have manually set values. Do you want to replace those with the predefined values used by the profile %2%?"
	MANUAL_CONNECTIVITY_SETUP, // "Manual connectivity setup"
	MANUAL_REFRESHES, // "Manual refreshes only"
	MANUAL_UPDATE_MSG, // "You will be forwarded to the downloading page as automatic updating can't be performed"
	MAPPER_CREATING_FAILED, // "Failed to create port mappings"
	MAPPER_CREATING_SUCCESS, // "Successfully created port mappings on the %1% device with the %2% interface"
	MAPPER_CREATING_SUCCESS_LONG, // "Successfully created port mappings (Transfers: %1%, Search: %3%, Encrypted transfers: %2%) on the %4% device with the %5% interface"
	MAPPER_INIT_FAILED, // "Failed to initialize the %1% interface"
	MAPPER_INTERFACE_FAILED, // "Failed to map the %1% port (%2% %3%) with the %4% interface"
	MAPPER_IN_PROGRESS, // "Another port mapping attempt is in progress..."
	MAPPER_IP_FAILED, // "Failed to get external IP"
	MAPPER_NO_INTERFACE, // "No port mapping interface available"
	MAPPER_REMOVING_FAILED, // "Failed to remove port mappings from the %1% device with the %2% interface"
	MAPPER_REMOVING_SUCCESS, // "Successfully removed port mappings from the %1% device with the %2% interface"
	MAPPER_X_PORT_X, // "%1% %2% port (%3% %4%)"
	MATCH, // "Match"
	MATCHED_FILES_BUNDLE, // "Matched %1% file(s) in the bundle %2%, of which %3% were new"
	MATCHED_FILES_X_BUNDLES, // "Matched %1% file(s) in %2% bundles, of which %3% were new"
	MATCHING_ADL, // "Matching file list with ADL search, this might take a while if the list is large..."
	MATCHING_FILE_LIST, // "Matching file lists, this may take a while if the lists are large."
	MATCHING_MANUAL, // "Matching only (manual search)"
	MATCH_ADL, // "ADL search"
	MATCH_AUTOSEARCH, // "Match auto search"
	MATCH_COLUMN, // "Match column"
	MATCH_FILTERS, // "Match filters"
	MATCH_FULL_PATH, // "Find matches from the full path instead of the file/directory name"
	MATCH_PARTIAL, // "Match partial list"
	MATCH_QUEUE, // "Match queue"
	MATCH_SOURCE_ADDED, // "Added as source for %1% items in the bundle %2%"
	MAXIMUM_AGE, // "Maximum age"
	MAX_BUNDLES_RUNNING, // "Maximum number of bundles running already"
	MAX_CHAT_RESIZE_LINES, // "Max lines to resize the message box on multiline messages"
	MAX_DL_SPEED_REACHED, // "Wanted total download speed reached"
	MAX_DOWNLOAD_RATE, // "Maximum download rate (0 = infinite)"
	MAX_HASHING_THREADS, // "Maximum number of hashing threads"
	MAX_HUBS, // "Max hubs"
	MAX_LOG_LINES, // "Max view history lines"
	MAX_MSG_LENGTH, // "Max length"
	MAX_PM_HISTORY_LINES, // "Max lines to show in PM history"
	MAX_RUNNING_BUNDLES, // "Maximum number of running bundles (0 = infinite)"
	MAX_SIZE, // "Max size"
	MAX_UPLOAD_RATE, // "Maximum upload rate (0 = infinite)"
	MAX_USERS, // "Max users"
	MAX_VOL_HASHERS, // "Maximum number of hashers per volume"
	MBITS, // "Mbit/s"
	MBITSPS, // "MBits/s"
	MBPS, // "MB/s"
	MC_MESSAGE_FILTERED, // "Main chat message filtered from user: "
	MC_MESSAGE_IGNORED, // "Main chat message from ignored user: "
	MENUBAR, // "Menu bar"
	MENU_ABOUT, // "About AirDC++"
	MENU_ADL_SEARCH, // "ADL search"
	MENU_ARRANGE, // "Arrange icons"
	MENU_BROWSE_OWN_LIST, // "Browse own list\tCtrl+O"
	MENU_BUG_TRACKER, // "Issue tracker"
	MENU_CASCADE, // "Cascade"
	MENU_CDMDEBUG_MESSAGES, // "CDM debug messages"
	MENU_CLOSE_ALL_DIR_LIST, // "Close all file list windows"
	MENU_CLOSE_ALL_OFFLINE_PM, // "Close all offline PM windows"
	MENU_CLOSE_ALL_PM, // "Close all PM windows"
	MENU_CLOSE_ALL_SEARCHFRAME, // "Close all search windows"
	MENU_CLOSE_DISCONNECTED, // "Close disconnected"
	MENU_CUSTOMIZE, // "Download customizations"
	MENU_DISCUSS, // "Discussion forum"
	MENU_DONATE, // "Donate"
	MENU_DOWNLOAD_QUEUE, // "Download queue\tCtrl+D"
	MENU_EXIT, // "Exit"
	MENU_FAQ, // "Frequently asked questions"
	MENU_FAVORITE_HUBS, // "Favorite hubs\tCtrl+H"
	MENU_FAVORITE_USERS, // "Users\tCtrl+U"
	MENU_FILE, // "File"
	MENU_FOLLOW_REDIRECT, // "Follow last redirect\tCtrl+T"
	MENU_GUIDES, // "Guides"
	MENU_HASH_PROGRESS, // "Indexing progress"
	MENU_HELP, // "Help"
	MENU_HELP_TRANSLATIONS, // "Translations"
	MENU_HIDE, // "Hide"
	MENU_HOMEPAGE, // "AirDC++ homepage"
	MENU_HORIZONTAL_TILE, // "Horizontal tile"
	MENU_MINIMIZE_ALL, // "Minimize all"
	MENU_NOTEPAD, // "Notepad\tCtrl+N"
	MENU_OPEN_DOWNLOADS_DIR, // "Open downloads directory"
	MENU_OPEN_FILE_LIST, // "Open file list...\tCtrl+L"
	MENU_OPEN_MATCH_ALL, // "Match downloaded lists"
	MENU_OPEN_SYSTEMLOG, // "Open system log"
	MENU_PUBLIC_HUBS, // "Public hubs\tCtrl+P"
	MENU_QUICK_CONNECT, // "Quick connect...\tCtrl+Q"
	MENU_RECONNECT, // "Reconnect\tCtrl+R"
	MENU_RECONNECT_DISCONNECTED, // "Reconnect disconnected"
	MENU_MARK_AS_READ, // "Mark all windows as read (unbold tabs)"
	MENU_REFRESH_FILE_LIST, // "Refresh file list\tCtrl+E"
	MENU_RESTORE_ALL, // "Restore all"
	MENU_SEARCH, // "Search\tCtrl+S"
	MENU_SEARCH_SPY, // "Search spy"
	MENU_SETTINGS, // "Settings...\tCtrl+I"
	MENU_SHOW, // "Show"
	MENU_STATUS_BAR, // "Status bar\tCtrl+2"
	MENU_TOOLBAR, // "Toolbar\tCtrl+1"
	MENU_TRANSFERS, // "Transfers"
	MENU_TRANSFER_VIEW, // "Transfers\tCtrl+3"
	MENU_TTH, // "Get TTH for file..."
	MENU_VERTICAL_TILE, // "Vertical tile"
	MENU_VIEW, // "View"
	MENU_WINDOW, // "Window"
	MESSAGES_SENT_THROUGH, // "Messages are now sent through the hub %1%"
	MESSAGES_SENT_THROUGH_REMOTE, // "Messages are now sent through the hub %1% (changed by the remote users)"
	MESSAGE_SEEN, // "Message seen"
	MIDNIGHT, // "Midnight"
	MINIMUM_LEN, // "Minimum length"
	MINIMUM_SEARCH_INTERVAL, // "Minimum search interval"
	MINIMUM_UPDATE_INTERVAL_MIN, // "Minimum update interval (in minutes)"
	MINSHARE, // "Min share"
	MINSLOTS, // "Min slots"
	MINUTE, // "Minute"
	MINUTES_LOWER, // "minutes"
	MIN_DUPE_CHECK_SIZE, // "No dupe check for files smaller than"
	MIN_SHARE, // "Min share"
	MIN_SLOTS, // "Min slots"
	MODE, // "Mode"
	MODE_V4, // "Mode (IPv4)"
	MODE_V6, // "Mode (IPv6)"
	MONDAY, // "Monday"
	MONTH, // "Month"
	MONTHS, // "Months"
	MORE_INFORMATION, // "More information..."
	MOVE, // "Move"
	MOVE_DOWN, // "Move down"
	MOVE_FILE_FAILED, // "Failed to move the file %1% to %2% (%3%)"
	MOVE_UP, // "Move up"
	MPC_HELP, // "/mpc - For Media Player Classic media spamming\r\n- %[filename]	Name of the file currently playing\r\n- %[title]		Name of the currently playing item (without file extension)\r\n- %[size]		Size of the file currently playing\r\n- %[state]	Current state of Media Player Classic (playing/paused/stopped)\r\n- %[elapsed]	Time elapsed in minutes:seconds\r\n- %[percent]	Time elapsed presented as percentage from total length\r\n- %[bar]		ASCII progress bar, 10 characters wide no including brackets (ex. [----|-----])\r\n- %[length]	Total length of the current file\r\n\r\nEmpty = Default string -> +me playing: %[title] <Media Player Classic>"
	MPC_HELP_DESC, // "Media Player Classic help"
	MULTILINE_INPUT, // "Multiline input area"
	MULTITHREADED_REFRESH, // "Multithreaded file list refresh"
	MYNICK_IN_CHAT, // "My nick in main chat"
	MiB, // "MiB"
	NAME, // "Name"
	NAME_IN_USE, // "Name already in use"
	NAME_REQUIRED, // "Name required"
	NEVER, // "Never"
	NEW, // "New"
	NEW_DISCONNECT, // "Remove user from queue, if speed is below"
	NEW_DOTS, // "New..."
	NEW_LIMIT, // "New limit (KiB/s) (0 = infinite)"
	NEW_PROFILE, // "New profile"
	NEW_PROFILE_DOTS, // "New profile..."
	NEW_TEXT_STYLE_APPLIED, // "New Font & TextStyles Applied, TextMatching colors will apply after this line"
	NEW_VERSION_AVAILABLE, // "A new version is available"
	NEXT, // "Next"
	NEXT_NUMBER_TO_SEARCH_FOR, // "Next number to search for"
	NEXT_RECENT_SEARCH_IN, // "Next recent search in %1% minutes"
	NEXT_SEARCH_IN, // "Next search in %1% minutes"
	NICK, // "Nick"
	NICK_TAKEN, // "Your nick was already taken, please change to something else!"
	NICK_UNKNOWN, // " (Nick unknown)"
	NMDC_ENCODING, // "NMDC encoding"
	NMDC_MAGNET_WARNING, // "In NMDC hubs the file will be shared so everyone can access it, continue?"
	NO, // "No"
	NONE, // "None"
	NOON, // "Noon"
	NORMAL, // "Normal"
	NOTE, // "Note; If you disable password protection your password will be reset!"
	NOTEPAD, // "Notepad"
	NOTIFY, // "Use chat notify icon"
	NOT_IN_SHARED_DIR, // "The bundle %1% isn't in a shared folder, please add it in share manually"
	NOT_INSTALLED, // "Not installed"
	NOT_LISTENING, // "Not listening for connections - please restart AirDC++"
	NO_ACCESS_ONLINE_HUBS, // "No access to this file via any online hub"
	NO_ADDITIONAL_MATCHES, // "There are no additional matches available"
	NO_ASCH_NOTE, // "This user doesn't support the advanced searching features in partial lists, which may result in lower hit counts."
	NO_CERTIFICATE_FILE_SET, // "TLS disabled, no certificate file set"
	NO_DIRECTORY_SPECIFIED, // "No directory specified"
	NO_DOWNLOADS_FROM_SELF, // "You're trying to download from yourself!"
	NO_ERRORS, // "No errors"
	NO_FILES_AVAILABLE, // "No files to download"
	NO_FILES_FROM_FILE, // "No files were loaded from this file"
	NO_FILES_WERE_LOADED, // "No files were loaded for %1%"
	NO_FILE_ACCESS, // "You don't have access to this file"
	NO_FREE_BLOCK, // "No free block"
	NO_FULL_TREE, // "No full tree available"
	NO_HUBS_TO_SEARCH_FROM, // "No hubs to search from"
	NO_INCOMING_CONFIGURED, // "You don't have any incoming directories configured!"
	NO_LOG_EXISTS, // "No log file exist"
	NO_LOG_FOR_HUB, // "Hub log does not exist"
	NO_LOG_FOR_USER, // "User log does not exist"
	NO_MATCHED_FILES, // "No matching files were found!"
	NO_MEDIA_SPAM, // "Selected player doesn't support media spams"
	NO_NATT_SUPPORT, // "The remote user doesn't support passive-passive connections"
	NO_NEEDED_PART, // "No needed part"
	NO_NFO_FOUND, // "No NFO files found!"
	NO_PARTIAL_SUPPORT, // "The remote client doesn't support this feature"
	NO_RESULTS_FOUND, // "No results were found"
	NO_RESULTS_SPECIFIED_TIME, // "No results were received in the specified time"
	NO_SLOTS_AVAILABLE, // "No slots available"
	NO_SYSTEM_LOG, // "No system log exists"
	OFFLINE, // "Offline"
	OLD, // "Old"
	ONLINE, // "Online"
	ONLINE_NICKS, // "Online nicks"
	ONLY_FREE_SLOTS, // "Only users with free slots"
	ONLY_WHERE_OP, // "Only where I'm OP"
	OPEN, // "Open"
	OPEN_FILE_LIST, // "Open file list"
	OPEN_FIRST, // "Open first X hubs at startup"
	OPEN_FOLDER, // "Open folder"
	OPEN_HOMEPAGE, // "Open homepage"
	OPEN_HUB_FILELIST, // "Open hub file list (%1%)"
	OPEN_HUB_LOG, // "Open hub log"
	OPEN_IN_BROWSER, // "Open in browser"
	OPEN_LINK, // "Open link"
	OPEN_LOGS_INTERNAL, // "Open log files internally (performance may decrease when opening huge log files)"
	OPEN_LOG_DIR, // "Open log directory"
	OPEN_NFO_EXTERNAL, // "Open .nfo files externally"
	OPEN_SETTINGS_DIR, // "Open settings directory\tCtrl+Y"
	OPEN_SYSTEM_LOG, // "Open system log"
	OPEN_USER_LOG, // "Open user log"
	OPEN_WEB_UI, // "Open web user interface"
	OPTIMIZE_CONFIRMATION, // "This operation will delete all hash information for files that aren't currently in share. If you are sharing files from network disks or from a removable storage, make sure that the files are currently shown in share (otherwise they have to be rehashed).\r\n\r\nDo you want to continue?"
	OPTIMIZE_DB, // "Optimize databases"
	OPTIMIZE_DB_HELP, // "This will remove the database entries for files and trees that aren't shared anymore."
	OPTIMIZE_VERIFY_DB, // "Optimize and check the integrity of the databases"
	OPTIMIZE_VERIFY_DB_HELP, // "This will perform a normal optimization and additionally check the integrity for all tree entries in case of data corruption. Corrupted database entries will be deleted. This action is recommended if you receive notifications about corrupted entries."
	OPTIONAL_BRACKETS, // "(optional)"
	OPTIONS_DOTS, // "Options..."
	OTHER_PROFILES, // "Other profiles"
	OUT_OF_MEMORY, // "Out of memory"
	OVERLAPPED_SLOW_SEGMENT, // "Overlapped by faster user"
	OVERRIDE_LIMITER, // "Override limiter"
	OWN_CERTIFICATE, // "Own certificate"
	OWN_CERTIFICATE_FILE, // "Own certificate file"
	OWN_FILELIST, // "Own file list"
	PARAMS, // "Params"
	PARTIAL_DUPES_EQUAL, // "Treat partial dupes similar to exact dupes"
	PARTIAL_FILELIST, // "Partial file list"
	PARTIAL_LIST_LOADED, // "Partial list has been loaded"
	PARTIAL_MATCH, // "Partial match"
	PARTIAL_SCH_NMDC_NOTE, // "Searching from the whole share via partial list isn't supported in NMDC hubs. It's recommended to use the full list instead."
	PARTIAL_SHARING, // "Enable partial bundle/file sharing"
	PARTS, // "Parts"
	PASSIVE_MODE, // "Passive mode"
	PASSIVE_USER, // "Passive user"
	PASSWD_PROTECT_CHCKBOX, // "Enable password protection"
	PASSWD_PROTECT_STATIC, // "Client protection"
	PASSWD_PROTECT_TRAY_CHCKBOX, // "Protect tray"
	PASSWORD, // "Password"
	PASSWORD_DESC, // "Please enter password:"
	PASSWORD_TITLE, // "Authentication required to preform this action"
	PASS_NO_MATCH, // "Passwords did not match"
	PASTE, // "Paste"
	PATH, // "Path"
	PATH_NOT_SHARED, // "Path is not inside a shared directory"
	PATH_ALREADY_EXCLUDED, // "Path is excluded already"
	PATTERN, // "Pattern"
	PATTERN_EMPTY, // "Pattern empty"
	PATTERN_EXISTS, // "An item with the same pattern already exists"
	PAUSE, // "Pause"
	PAUSE_BUNDLE_FOR, // "Pause bundle for"
	PAUSE_TIME, // "Pause time (minutes)"
	PAUSED, // "Paused"
	PAUSED_FORCED, // "Paused (forced)"
	PAUSED_PCT, // "Paused (%.01f%%)"
	PAUSED_UNTIL_X, // "Paused until %1%"
	PAUSE_SEARCH, // "Pause search"
	PBITS, // "Pbit/s"
	PERFORM_X_REMAINING, // "Perform this action for %1% remaining items"
	PERMISSION_DENIED_HUB, // "Permission denied by the hub"
	PICTURE, // "Picture"
	PLAIN_TEXT, // "Plain text"
	PLAY, // "Play"
	PM, // " PM"
	PM_IGNORE_INFO, // "Note: you will continue receiving messages from this ignored user as long as there is an open chat session"
	PM_MAGNET_SHARED_WARNING, // "The download destination %1% is a shared directory. Files sent in private chat may contain sensitive information that you or the sender don't want to be made available for other user.\r\n\r\nDo you want to use this destination anyway?"
	PM_MESSAGE_FILTERED, // "Private chat message filtered from user: "
	PM_MESSAGE_IGNORED, // "Private chat message from ignored user: "
	PM_PREVIEW, // "Show preview of private message on popup"
	POPUP_BACK_COLOR, // "Back color"
	POPUP_BALOON, // "Balloon popup"
	POPUP_COLORS, // "Popup colors"
	POPUP_CUSTOM, // "Custom popup"
	POPUP_DOWNLOAD_FAILED, // "Show popup on download failed"
	POPUP_DOWNLOAD_FINISHED, // "Show popup on download finished"
	POPUP_DOWNLOAD_START, // "Show popup on download begins"
	POPUP_FAVORITE_CONNECTED, // "Show popup on favorite user connected"
	POPUP_FONT, // "Msg text"
	POPUP_HUB_CONNECTED, // "Show popup on hub connected"
	POPUP_HUB_DISCONNECTED, // "Show popup on hub disconnected"
	POPUP_IMAGE, // "Popup image"
	POPUP_NEW_PM, // "Show popup on new private message"
	POPUP_PM, // "Show popup on private message"
	POPUP_SPLASH, // "Splash popup"
	POPUP_TIME, // "Popup time"
	POPUP_TITLE_FONT, // "Title text"
	POPUP_TYPE, // "Popup type"
	POPUP_UPLOAD_FINISHED, // "Show popup on upload finished"
	POPUP_WINDOW, // "Window popup"
	PORT, // "Port"
	PORT_BYSY, // "Unable to open %1% port. Searching or file transfers will not work correctly until you change settings or turn off any application that might be using that port."
	PORT_MAPPING, // "Port mapping"
	POST_SEARCHING, // "Searching for proper"
	POWER_OFF, // "Power off"
	PREDEFINED, // "Predefined"
	PREFERRED_MAPPER, // "Preferred port mapping interface"
	PRESET, // "Presets"
	PRESET_ADD_ALL, // "Add all"
	PRESET_RELEASES, // "Releases"
	PRESET_WINAMP_SPAM, // "Winamp spam"
	PRESS_FOLLOW, // "Press the follow redirect button to connect to "
	PREVIEW, // "Preview"
	PREVIEW_ARGUMENTS, // "Arguments: (%[file] %[dir] available)"
	PREVIEW_DLG, // "Add/Change preview command"
	PREVIEW_EXTENSION, // "Apply to extensions: (avi;mov;divx)"
	PREVIOUS_FOLDERS, // "Previous folders"
	PREVIOUS_SHORT, // "Prev"
	PRIOPAGE_BALANCE_QIS, // "Also prioritize the order among bundle files"
	PRIOPAGE_ORDER_BALANCED, // "Balanced (based on sources and their speeds)"
	PRIOPAGE_ORDER_PROGRESS, // "Set priorities automatically based on the progress"
	PRIORITIES, // "Priorities"
	PRIORITY, // "Priority"
	PRIVATE_CHAT, // "Private chat"
	PRIVATE_KEY_FILE, // "Private key file"
	PRIVATE_MESSAGE, // "Private message"
	PRIVATE_MESSAGE_FROM, // "Private message from "
	PROCESSING, // "Processing, please wait..."
	PROFILES_NOTE, // "Custom share profiles can only be set for ADC hubs"
	PROFILE_EXISTS, // "A profile with the same name exists already"
	PROFILE_LAN_DESC, // "The client is used for transferring files in local network (e.g. LAN parties) or in another closed network (e.g. university network)."
	PROFILE_NAME, // "Profile name"
	PROFILE_NAME_DESC, // "Enter a display name for the profile"
	PROFILE_NORMAL_DESC, // "The client is used in normal private/public hubs for transferring files via internet. Use this profile if unsure."
	PROFILE_RAR_DESC, // "The client is used for transferring files that are split in RAR archives (or in other small-sized formats)."
	PROFILE_VALUE_X, // "Profile value: %1%"
	PROGRESS_ODC_STYLE, // "Use oDC style of progressbar"
	PROPERTIES, // "Properties"
	PROPPAGE_DUPE_MSG, // "Release.Example-AIRDC"
	PROPPAGE_DUPE_QUEUE_TEXT, // "Dupe queue folders/files"
	PROPPAGE_DUPE_SHARE_TEXT, // "Dupe share folders/files"
	PROPPAGE_FAV_USER, // "Favorite user"
	PROPPAGE_GENERAL_CHAT_TEXT, // "General chat text"
	PROPPAGE_GENERAL_TEXT, // "General text"
	PROPPAGE_MY_NICK, // "My nick"
	PROPPAGE_MY_OWN_MSG, // "My own message"
	PROPPAGE_NORM, // "Other users"
	PROPPAGE_OPERATOR, // "Operator"
	PROPPAGE_PRIVATE_MSG, // "Private message"
	PROPPAGE_SERVER_MSG, // "Server message"
	PROPPAGE_STYLE_TIMESTAMP, // "The style for timestamp"
	PROPPAGE_SYSTEM_MSG, // "System message"
	PROPPAGE_TIMESTAMP, // "Timestamp"
	PROPPAGE_UNDERLINE_DUPES, // "Underline dupes"
	PROPPAGE_UNDERLINE_LINKS, // "Underline links"
	PROPPAGE_URL, // "URL"
	PROTOCOL_OPTIONS, // "Protocol options"
	PROXIES, // "Proxies"
	PUBLIC_HUBS, // "Public hubs"
	PURGE, // "Purge"
	PiB, // "PiB"
	QUEUED, // "Queued"
	QUEUED_BUNDLES, // "Queued bundles"
	QUEUED_DUPE_PATHS, // "Dupe paths (queue)"
	QUEUE_SIZE, // "Queue size"
	QUICK_CONNECT, // "Quick connect"
	RAR_HUBS, // "RAR hubs"
	RATING, // "Rating"
	RATIO, // "Ratio"
	RAW, // "Raw"
	READD_ALL, // "Re-add all sources"
	READD_SOURCE, // "Re-add source"
	READ_FAILED_X, // "Failed to read from %1%: %2%"
	REALLY_CLOSE, // "Really close?"
	REALLY_EXIT, // "Really exit?"
	REALLY_REMOVE, // "Really remove?"
	REASON, // "Reason"
	REBOOT, // "Reboot"
	REBUILD_FAILED_ENTRIES_OPTIMIZE, // "%1% shared TTHs without a corresponding hash tree entry were found"
	REBUILD_FAILED_ENTRIES_VERIFY, // "There were %1% shared TTHs without a corresponding hash tree entry and %2% invalid tree entries that couldn't be loaded"
	REBUILD_REFRESH_PROMPT, // "It's recommended to refresh your share as those files (total of %1%) must be rehashed if they are still shared"
	RECENT, // "Recent"
	RECENTS, // "Recents"
	RECHECKING, // "Rechecking"
	RECHECK_INTEGRITY, // "Recheck integrity"
	REDIRECT_ALREADY_CONNECTED, // "Redirect request received to a hub that's already connected"
	REDIRECT_USER, // "Redirect user(s)"
	REFRESH, // "Refresh"
	REFRESHING_SHARE, // "Refreshing share"
	REFRESH_FILE_LIST, // "Refresh file list"
	REFRESH_IN_SHARE, // "Refresh in share"
	REFRESH_OPTIONS, // "Refreshing options"
	REFRESH_QUEUED, // "File list refresh has been queued"
	REGEXP, // "Regexp"
	REGEXP_MATCH, // "It's a match!"
	REGEXP_MISMATCH, // "It's not a match."
	REGEXP_TESTER, // "Regexp tester"
	REGULAR_EXPRESSION, // "RegEx"
	RELEASE, // "Release"
	RELEVANCE, // "Relevance"
	RELIABILITY, // "Reliability"
	RELOAD, // "Reload"
	REMOTE, // "Remote"
	REMOTE_PROTOCOL_UNSUPPORTED, // "The remote user doesn't support %1% protocol"
	REMOVE, // "Remove"
	REMOVE_AFTER_COMPLETED, // "Remove after completed"
	REMOVE_ALL, // "Remove all"
	REMOVE_BUNDLE, // "Remove bundle from queue"
	REMOVE_BUNDLE_SOURCE, // "Remove user from this bundle"
	REMOVE_EXPIRED_AS, // "Remove expired auto search items instead of disabling them"
	REMOVE_EXTRA_SLOT, // "Remove extra slot"
	REMOVE_FAVORITE_USER, // "Remove favorite user"
	REMOVE_FILE, // "Remove file from queue"
	REMOVE_FINISHED, // "Remove finished bundles"
	REMOVE_FROM_ALL, // "Remove user from queue"
	REMOVE_GROUP, // "Remove group"
	REMOVE_OFFLINE, // "Remove offline users"
	REMOVE_OTHER_PROFILES, // "Remove this path from all profiles"
	REMOVE_PROFILE, // "Remove profile"
	REMOVE_SOURCE, // "Remove source"
	REMOVE_SOURCE_FROM, // "Remove the source from"
	REMOVE_WITH_FILES, // "Remove and delete data"
	RENAME, // "Rename"
	RENAME_DLG_DESC, // "Rename also in the following profiles"
	REPAIRING_X, // "Repairing %1%"
	REPORT, // "Report user"
	REPORT_ALTERNATES, // "Show auto search for alternates"
	REPORT_DUPLICATE_FILES, // "Report duplicate files when generating file lists"
	REPORT_IGNORED, // "Report ignored and spam filtered chat messages"
	REPORT_BLOCKED_SHARE, // "Report files blocked from share during filelist refresh"
	REQUESTING, // "Requesting"
	REQUESTING_LIST, // "Requesting file list"
	REQUIRED_BRACKETS, // "(required)"
	REQUIRE_EXACT_MATCH, // "Require an exact match"
	RESCAN_BUNDLE, // "Rescan bundle"
	RESET_EXTENSIONS_CONFIRM, // "This will delete all defined search types and restore the default ones. Do you want to continue?"
	RESET_FOLDER_CHANGE, // "Reset the string when switching directory"
	RESET_NEW_SEARCH, // "Reset the string on new search"
	RESET_TO_DEFAULTS, // "Reset to defaults"
	RESUME, // "Resume"
	RIGHT_COLOR, // "Right color"
	RSS_CONFIG, // "RSS config"
	RSS_MATCH_PATTERN, // "Match pattern"
	RSS_FEEDS, // "RSS feeds"
	RSS_FORMAT_TIME_PARAMS, // "Format time params (ex. %m %d) for location before adding to auto search"
	RUNNING_HOOKS, // "Running external hooks"
	RUNNING_PCT, // "Running (%.01f%%)"
	SAMPLE_TEXT, // "Sample text"
	SATURDAY, // "Saturday"
	SAVE_DEFAULT, // "Save in the default download directory"
	SAVE_FAILED_X, // "Failed to save the file %1%: %2%"
	SAVE_HUBS_STATE, // "Remember previously enabled hubs in search window"
	SAVE_LAST_STATE, // "Remember previously open windows"
	SAVING_HASH_DATA, // "Saving hash data"
	SAVING_SETTINGS, // "Saving settings"
	SAVING_SHARE, // "Saving the share cache"
	SB_MINISLOTS, // "Minislots"
	SEARCH, // "Search"
	SEARCHING, // "Searching..."
	SEARCHING_FOR, // "Searching for "
	SEARCHING_STATUS, // "Searching status"
	SEARCH_BUNDLE_ALT, // "Search bundle for alternatives"
	SEARCH_CUR_DIR, // "Search within the current directory"
	SEARCH_DIRECTORY, // "Search directory"
	SEARCH_DISABLED_X, // "Search disabled: %1%"
	SEARCH_FILENAME, // "Search filename"
	SEARCH_FOR, // "Search for"
	SEARCH_FOREGROUND, // "Search (foreground)"
	SEARCH_FOR_ALTERNATES, // "Search for alternates"
	SEARCH_FOR_FILE, // "Search for file"
	SEARCH_GOOGLE_FULL, // "Google (full release name)"
	SEARCH_GOOGLE_TITLE, // "Google (title only)"
	SEARCH_IMDB, // "IMDB"
	SEARCH_METACRITIC, // "Metacritic"
	SEARCH_OPTIONS, // "Search options"
	SEARCH_PORT, // "Search (UDP)"
	SEARCH_SPAM_FROM, // "Search spam detected from %1% (%2%)"
	SEARCH_SPY, // "Search spy"
	SEARCH_STRING, // "Search string"
	SEARCH_STRINGS, // "Search strings"
	SEARCH_SUPPORTED_ONLY, // "Search only from supported clients"
	SEARCH_TIMED_OUT, // "Search timed out"
	SEARCH_TIMES, // "Search times"
	SEARCH_TTH, // "Search by TTH"
	SEARCH_TVCOM, // "TV.com"
	SEARCH_TYPES, // "Search types"
	SEARCH_TYPES_NOTE, // "Note; Custom search types will only be applied to ADC hubs! On NMDC hubs, using a predefined search type will only search for a set of predefined, unconfigurable extensions; using a custom type will default to searching for any extension."
	SEARCH_QUEUE_OVERFLOW, // "Search queue overflow"
	SECOND, // "Second"
	SECONDS_LOWER, // "seconds"
	SEE_SYSLOG_FOR_RESULTS, // "Open system log to see the scan results"
	SEGMENT, // "Segment"
	SEGMENTS, // "Segments"
	SELECT, // "Select"
	SELECT_ALL, // "Select all"
	SELECT_DIRECTORY, // "Select directory"
	SELECT_THEME, // "Select theme"
	SELECT_USER_LIST, // "Select user in list"
	SEND_FILE_HUB, // "Send a file (it will be available to all users)"
	SEND_FILE_PM, // "Send a file (it will be available only to this user)"
	SEND_MESSAGE, // "Send message"
	SEND_PM_VIA, // "Messages are sent via"
	SEND_PRIVATE_MESSAGE, // "Send private message"
	SEND_PUBLIC_MESSAGE, // "Send public message"
	SEPARATOR, // "Separator"
	SERVER, // "Server"
	SERVER_STATE, // "Server state"
	SETCZDC_BACK_COLOR, // "Back color"
	SETCZDC_DEFAULT_STYLE, // "Default style"
	SETCZDC_DISCONNECTING_ENABLE, // "Enable slow downloads disconnecting"
	SETCZDC_DOWNLOAD_SPEED, // "Download speed"
	SETCZDC_ERROR_COLOR, // "Error color"
	SETCZDC_I_DOWN_SPEED, // "Disconnect download if speed is below"
	SETCZDC_MAGNET_URI_HANDLER, // "Install MAGNET URI handler on startup"
	SETCZDC_MIN_FILE_SIZE, // "And file size is more than"
	SETCZDC_PASSIVE_SEARCH, // "Always use passive mode for search (use only if you know what this doing!)"
	SETCZDC_PRIVATE_SOUND, // "Private message sound"
	SETCZDC_PROGRESSBAR_COLORS, // "Progressbar colors"
	SETCZDC_PROGRESSBAR_TEXT, // "Progressbar text colors"
	SETCZDC_REMOVE_FORBIDDEN, // "Remove forbidden (unfinished Kazaa, Win MX, GetRight, eMule, AirDC++)"
	SETCZDC_SLOW_DISCONNECT, // "Disconnecting slow downloads"
	SETCZDC_SMALL_FILES, // "Small file size"
	SETCZDC_STYLES, // "Available styles"
	SETCZDC_TEXT_COLOR, // "Text color"
	SETCZDC_TEXT_STYLE, // "Text style"
	SETCZDC_TIME_DOWN, // "More than"
	SETCZDC_TO, // "to"
	SETCZDC_UPLOAD, // "Upload"
	SETCZDC_UPLOAD_SPEED, // "Upload speed"
	SETCZDC_WINAMP, // "Media toolbar settings"
	SETCZDC_WINAMP_PATH, // "Media player path:"
	SETSTRONGDC_PARTIAL_SLOTS, // "Extra slots for uploading partially downloaded files"
	SETTINGS, // "Settings"
	SETTINGS_ACTIVE, // "Active mode (no router or manual router configuration)"
	SETTINGS_ACTIVE_UPNP, // "Active mode with NAT-PMP / UPnP (let the client configure my router)"
	SETTINGS_ADD_FOLDER, // "Add folder"
	SETTINGS_ADLS_BREAK_ON_FIRST, // "Break on first ADL search match"
	SETTINGS_ADVANCED, // "Advanced"
	SETTINGS_ADVANCED3, // "Experts only"
	SETTINGS_AIRAPPEARANCEPAGE, // "AirAppearance"
	SETTINGS_AIRDOWNLOADS, // "Download options"
	SETTINGS_AIRDOWNLOADS_SEGMENT, // "Segments"
	SETTINGS_AIRDOWNLOADS_SEGMENT_SIZE, // "Minimum segment size"
	SETTINGS_AIRSEARCH, // "Search"
	SETTINGS_AIR_HIGHLIGHTPAGE, // "Highlight"
	SETTINGS_AIR_TABSPAGE, // "Tabs"
	SETTINGS_ALLOW_MATCH_FULL_LIST, // "Allow matching full file lists in NMDC hubs"
	SETTINGS_ALLOW_UNTRUSTED_CLIENTS, // "Allow TLS connections to clients without trusted certificate"
	SETTINGS_ALLOW_UNTRUSTED_HUBS, // "Allow TLS connections to hubs without trusted certificate"
	SETTINGS_APPEARANCE, // "Appearance"
	SETTINGS_ARGUMENT, // "Arguments"
	SETTINGS_AUTOPRIO, // "Auto priority settings"
	SETTINGS_AUTOPRIO_FILES, // "Calculate priorities also for individual files"
	SETTINGS_AUTO_BUNDLE_SEARCH, // "Automatically search for alternative bundle sources"
	SETTINGS_AUTO_COMPLETE_BUNDLES, // "Try to complete bundles with missing files automatically"
	SETTINGS_AUTO_DETECTION_USE_LIMITED, // "Use the limiter values when setting the auto detected speed and slot limits"
	SETTINGS_AUTO_DROP_SLOW_SOURCES, // "Use slow speed disconnecting by default for new bundles"
	SETTINGS_AUTO_FOLLOW, // "Automatically follow redirects"
	SETTINGS_AUTO_KICK, // "Automatically disconnect users who leave the hub"
	SETTINGS_AUTO_KICK_NO_FAVS, // "Don't automatically disconnect favorite users who leave the hub"
	SETTINGS_AUTO_OPEN, // "Auto-open at startup"
	SETTINGS_AUTO_PRIORITY_DEFAULT, // "Use auto priority by default"
	SETTINGS_AUTO_REFRESH_TIME, // "Auto refresh time (0 = disable)"
	SETTINGS_AUTO_SEARCH_LIMIT, // "Max sources for auto search"
	SETTINGS_AUTO_SLOTS, // "Maximum auto opened"
	SETTINGS_AVIPREVIEW, // "File preview"
	SETTINGS_BIND_ADDRESS, // "Bind address"
	SETTINGS_BIND_ADDRESS_HELP, // "Network interface for all connections"
	SETTINGS_BOLD_OPTIONS, // "Tab bolding on content change"
	SETTINGS_BTN_BGCOLOR, // "Background color"
	SETTINGS_BTN_COLOR, // "Select color"
	SETTINGS_BTN_TEXTCOLOR, // "Text color"
	SETTINGS_BUNDLE_DL_POPUP, // "Show popup on bundle download finished"
	SETTINGS_BUNDLE_UL_POPUP, // "Show popup on bundle upload finished"
	SETTINGS_CALCULATE_EVERY, // "Calculate priorities every"
	SETTINGS_CALCULATE_PRIO_AUTO, // "Calculate bundle priorities automatically"
	SETTINGS_CHANGE, // "Change"
	SETTINGS_CHATFILTER, // "Message filter"
	SETTINGS_CLEAR_SEARCH, // "Clear search box after each search"
	SETTINGS_COLORS, // "Other colors"
	SETTINGS_COLOR_ALTERNATE, // "Search alternate"
	SETTINGS_COLOR_IGNORED, // "Ignored"
	SETTINGS_COLOR_RESERVED, // "Has reserved slot"
	SETTINGS_COMPRESS_TRANSFERS, // "Enable safe and compressed transfers"
	SETTINGS_CONFIGURE_HUB_LISTS, // "Configure public hub lists"
	SETTINGS_CONFIRM_AS_REMOVE, // "Confirm item removal in auto search"
	SETTINGS_CONFIRM_DIALOG_OPTIONS, // "Confirm dialog options"
	SETTINGS_CONFIRM_EXIT, // "Confirm application exit"
	SETTINGS_CONFIRM_HUB_CLOSE, // "Confirm hub closing"
	SETTINGS_CONFIRM_HUB_REMOVAL, // "Confirm favorite hub removal"
	SETTINGS_CONFIRM_ITEM_REMOVAL, // "Confirm item removal in download queue"
	SETTINGS_CONTEXT_FILELIST, // "Highlight for directories in file list (wildcards or $Re: for regexp)"
	SETTINGS_CONTEXT_SEARCH, // "Highlight for results in search window (wildcards or $Re: for regexp)"
	SETTINGS_COUNTRY_FORMAT, // "Country format"
	SETTINGS_COUNTRY_FORMAT_HELP, // "This box allows customization of the way user country information is displayed throughout the interface. Default: %1% \r\n\r\n  Available variables: \r\n  %%[2code] gets replaced by a 2-letters country code (eg DE, FR). \r\n  %%[3code] gets replaced by a 3-letters country code (eg DEU, FRA). \r\n  %%[continent] gets replaced by a continent code (AF, AS, EU, NA, OC, SA for Africa, Asia, Europe, North America, Oceania and South America). \r\n  %%[engname] gets replaced by the English country friendly name (eg Germany, France). \r\n  %%[name] gets replaced by the localized country friendly name (eg Germany, France on an English operating system). \r\n  %%[officialname] gets replaced by the localized country official name (eg Federal Republic of Germany, French Republic on an English operating system)."
	SETTINGS_COUNTRY_FORMAT_HELP_DESC, // "Country format help"
	SETTINGS_CZDC_EXTRA_DOWNLOADS, // "Highest priority extra download slots"
	SETTINGS_DB_REPAIR, // "Verify and repair the hash database on next startup\n(use in case of fatal errors only)"
	SETTINGS_DEFAULT_AWAY_MSG, // "Default away message"
	SETTINGS_DELAY_HOURS, // "Hours to search for PROPER when using incrementation"
	SETTINGS_DIRECT, // "Direct connection"
	SETTINGS_DIRECTORIES, // "Directories"
	SETTINGS_DISPLAY_DC_UPDATE, // "Don't announce new AirDC++ versions (version.xml is still downloaded)"
	SETTINGS_DONT_DL_ALREADY_SHARED, // "Don't download files already in share"
	SETTINGS_DOWNCONN, // "Download attempts/second"
	SETTINGS_DOWNLOADS, // "Downloads"
	SETTINGS_DOWNLOADS_MAX, // "Maximum simultaneous downloads (0 = infinite)"
	SETTINGS_DOWNLOADS_SPEED_PAUSE, // "No new downloads if speed exceeds (0 = disable)"
	SETTINGS_DOWNLOAD_DIRECTORY, // "Default download directory"
	SETTINGS_DOWNLOAD_LINE_SPEED, // "Line Speed (download)"
	SETTINGS_DOWNLOAD_LOCATIONS, // "Download locations"
	SETTINGS_DUPES, // "Dupe settings"
	SETTINGS_DUPE_CHAT, // "Use dupe color in chat"
	SETTINGS_DUPE_DESCRIPTION, // "Background color used in file lists to show files that are already shared"
	SETTINGS_DUPE_FILELIST, // "Use dupe color in file lists"
	SETTINGS_DUPE_SEARCH, // "Use dupe color in search"
	SETTINGS_DUPE_TEXT, // "Use dupe color for text instead of background"
	SETTINGS_ENTIRE_WORD, // "Entire word"
	SETTINGS_EXPAND_BUNDLES, // "Automatically expand bundles in transfer view"
	SETTINGS_EXPIRY_DAYS, // "The default expiry days for items (0 = won't expire)"
	SETTINGS_EXTENSIONS, // "File extensions"
	SETTINGS_EXTERNAL_IP, // "External / WAN IP"
	SETTINGS_FAVORITE_DIRS, // "Favorite download directories"
	SETTINGS_FAVORITE_DIRS_PAGE, // "Favorites"
	SETTINGS_FAV_SHOW_JOINS, // "Only show joins / parts for favorite users"
	SETTINGS_FILE_NAME, // "Filename"
	SETTINGS_FILTER_MESSAGES, // "Filter kick and NMDC debug messages"
	SETTINGS_FLASH_WINDOW, // "Flash window"
	SETTINGS_FORMAT, // "Format"
	SETTINGS_FORMAT_REMOTE_TIME, // "Use the date of the remote directory for time parameters"
	SETTINGS_GENERAL, // "General"
	SETTINGS_GET_USER_COUNTRY, // "Get user country"
	SETTINGS_SHOW_IP_COUNTRY_CHAT, // "Show user IP and country in chat when available"
	SETTINGS_HIGH_PRIO_FILES, // "High priority files (separate files with '|', wildcards allowed)"
	SETTINGS_HTTP_PROXY, // "HTTP Proxy"
	SETTINGS_HUB_USER_COMMANDS, // "Accept custom user commands from hub"
	SETTINGS_IGNORE, // "Ignore"
	SETTINGS_INCLUDE_NICKLIST, // "Highlight for nicklist (wildcards or $Re: for regexp)"
	SETTINGS_INCOMING, // "Incoming connection settings"
	SETTINGS_INCOMING_REFRESH_TIME, // "Incoming refresh time (0 = disable)"
	SETTINGS_KEEP_LISTS, // "Don't delete file lists when exiting"
	SETTINGS_LANGUAGE, // "Language"
	SETTINGS_LANGUAGE_FILE, // "Language file"
	SETTINGS_LIMITS_ADVANCED, // "Limits & advanced"
	SETTINGS_LNOR, // "Norwegian"
	SETTINGS_LOGGING, // "Logging"
	SETTINGS_LOGS, // "Logs"
	SETTINGS_LOG_DIR, // "Log directory"
	SETTINGS_LOG_DOWNLOADS, // "Log downloads"
	SETTINGS_LOG_FILELIST_TRANSFERS, // "Log file list transfers"
	SETTINGS_LOG_MAIN_CHAT, // "Log main chat"
	SETTINGS_LOG_PRIVATE_CHAT, // "Log private chat"
	SETTINGS_LOG_SCHEDULED_REFRESHES, // "Show scheduled file list refreshes"
	SETTINGS_LOG_STATUS_MESSAGES, // "Log status messages"
	SETTINGS_LOG_SYSTEM_MESSAGES, // "Log system messages"
	SETTINGS_LOG_UPLOADS, // "Log uploads"
	SETTINGS_LRUS, // "Russian"
	SETTINGS_MANUAL_CONFIG, // "Manual router/firewall configuration"
	SETTINGS_MAX_COMPRESS, // "Max compression level"
	SETTINGS_MAX_HASHER_SPEED, // "Maximum speed per hasher (0 = unlimited)"
	SETTINGS_MAX_MCN_DL, // "Max downloads per user"
	SETTINGS_MAX_MCN_UL, // "Max uploads per user"
	SETTINGS_MAX_TAB_ROWS, // "Max tab rows"
	SETTINGS_MCNSLOTS, // "Per user limits (only used in ADC hubs)"
	SETTINGS_MCN_NOTE, // "* Lowering the upload connections from the default value will result the download connections to be set to the same value"
	SETTINGS_MINIMIZE_ON_STARTUP, // "Minimize at program startup"
	SETTINGS_MINIMIZE_TRAY, // "Minimize to tray"
	SETTINGS_MISC, // "Miscellaneous"
	SETTINGS_MOUSE_OVER, // "Mouse over"
	SETTINGS_NETWORK, // "Connection settings"
	SETTINGS_NMDC_MAGNET_WARNING, // "Warn me about sending files in private chat via NMDC hubs"
	SETTINGS_NORMAL, // "Normal"
	SETTINGS_NO_AWAYMSG_TO_BOTS, // "Don't send the away message to bots"
	SETTINGS_NO_ZERO_BYTE, // "Don't share 0 byte files"
	SETTINGS_ODC_SHUTDOWNTIMEOUT, // "timeout"
	SETTINGS_OPERACOLORS, // "Progress bar colors"
	SETTINGS_OPTIONS, // "Options"
	SETTINGS_OUTGOING, // "Outgoing connection settings"
	SETTINGS_OVERLAP_SLOW_SOURCES, // "Allow fast users to overlap slower ones if there is nothing else to download"
	SETTINGS_OVERRIDE, // "Don't allow hub/UPnP to override"
	SETTINGS_PASSIVE, // "Passive mode (last resort - has serious limitations)"
	SETTINGS_PERSONAL_INFORMATION, // "Personal information"
	SETTINGS_PLAY_SOUND, // "Play sound"
	SETTINGS_PM_BEEP, // "Make an annoying sound every time a private message is received"
	SETTINGS_PM_BEEP_OPEN, // "Make an annoying sound when a private message window is opened"
	SETTINGS_POPUNDER_FULL_LIST, // "Open new full file lists in the background"
	SETTINGS_POPUNDER_PARTIAL_LIST, // "Open new partial file lists in the background"
	SETTINGS_POPUNDER_PM, // "Open new private message windows in the background"
	SETTINGS_POPUNDER_TEXT, // "Open new text files in the background"
	SETTINGS_POPUP, // "Display popup"
	SETTINGS_POPUP_BOT_PMS, // "Open private messages from the hub in their own window"
	SETTINGS_POPUP_HUB_PMS, // "Open private messages from bots in their own window"
	SETTINGS_PORTS, // "Ports"
	SETTINGS_PRIO_AUTOPRIO, // "Priority settings - has higher priority than auto priority"
	SETTINGS_PRIO_HIGH, // "High prio max size"
	SETTINGS_PRIO_HIGHEST, // "Highest prio max size"
	SETTINGS_PRIO_LOW, // "Low prio max size"
	SETTINGS_PRIO_LOWEST, // "Set lowest prio for newly added files larger than low prio size"
	SETTINGS_PRIO_NORMAL, // "Normal prio max size"
	SETTINGS_PROFILE, // "Settings profile"
	SETTINGS_PROMPT_PASSWORD, // "Popup box to input password for hubs"
	SETTINGS_PUBLIC_HUB_LIST, // "Public hubs list"
	SETTINGS_PUBLIC_HUB_LIST_URL, // "Public hubs list URL"
	SETTINGS_QUEUE, // "Queue"
	SETTINGS_RECENT_HOURS, // "Maximum age for a bundle to consider it as recent"
	SETTINGS_REPORT_ADDED_SOURCES, // "Show added bundle sources"
	SETTINGS_REQUIRES_RESTART, // "Note; most of these options require that you restart AirDC++"
	SETTINGS_RESET, // "Reset"
	SETTINGS_SB_DIRTY_BLEND, // "Blending"
	SETTINGS_SB_MAX_SOURCES, // "Max sources for match queue"
	SETTINGS_SB_TAB_COLORS, // "Tab colors"
	SETTINGS_SB_TAB_SIZE, // "Size of string to display in tabs"
	SETTINGS_SEARCHING_OPTIONS, // "Searching options"
	SETTINGS_SEARCH_MATCHING, // "Search matching"
	SETTINGS_SEGMENTED_DOWNLOADS, // "Segmented downloads"
	SETTINGS_SELECT_COLOR, // "Select color"
	SETTINGS_SELECT_SOUND, // "Select sound file"
	SETTINGS_SELECT_TEXT_FACE, // "General text style"
	SETTINGS_SELECT_WINDOW_COLOR, // "Window color"
	SETTINGS_SERVER_COMMANDS, // "Show server commands as status messages"
	SETTINGS_SHARED_DIRECTORIES, // "Shared directories"
	SETTINGS_SHARE_HIDDEN, // "Share hidden files"
	SETTINGS_SHARE_PROFILE_NOTE, // "Note; Added share profiles can only be used in ADC hubs. NMDC hubs are forced to use the default profile."
	SETTINGS_SHARINGPAGE, // "Sharing"
	SETTINGS_SHARING_OPTIONS, // "Sharing options"
	SETTINGS_SHOW_INFO_TIPS, // "Show infotips in lists"
	SETTINGS_SHOW_JOINS, // "Show joins / parts in chat by default"
	SETTINGS_SHOW_PROGRESS_BARS, // "Show progress bars for transfers (uses some CPU)"
	SETTINGS_SHOW_QUEUE_BARS, // "Show progress bars in queue"
	SETTINGS_SKIPLIST_DOWNLOAD, // "Download skiplist (separate files with '|', wildcards allowed)"
	SETTINGS_SKIPPING_OPTIONS, // "Skipping options"
	SETTINGS_SOCKET_IN_BUFFER, // "Socket read buffer (0 = system default)"
	SETTINGS_SOCKET_OUT_BUFFER, // "Socket write buffer (0 = system default)"
	SETTINGS_SOCKS5, // "SOCKS5"
	SETTINGS_SOCKS5_IP, // "Socks IP"
	SETTINGS_SOCKS5_RESOLVE, // "Use SOCKS5 server to resolve host names"
	SETTINGS_SOCKS5_USERNAME, // "Login"
	SETTINGS_SORT_FAVUSERS_FIRST, // "Sort favorite users first"
	SETTINGS_SOUNDS, // "Sounds"
	SETTINGS_SPEED_SLOTS, // "Speed & slots"
	SETTINGS_STARTUP_REFRESH, // "Refresh the share after client startup"
	SETTINGS_STATUS_IN_CHAT, // "View status messages in main chat"
	SETTINGS_ST_MATCH_TYPE, // "Match type"
	SETTINGS_TAB_COLOR, // "Change tabcolor"
	SETTINGS_TCP_PORT, // "TCP (0 = auto)"
	SETTINGS_TEXT_STYLES, // "Colors & fonts"
	SETTINGS_TIME_STAMPS, // "Show timestamps in chat by default"
	SETTINGS_TIME_STAMPS_FORMAT, // "Set timestamps"
	SETTINGS_TLS_PORT, // "TLS/TCP (0 = auto)"
	SETTINGS_TOGGLE_ACTIVE_WINDOW, // "Toggle window when selecting an active tab"
	SETTINGS_TOOLBAR, // "Toolbar"
	SETTINGS_TOOLBAR_ADD, // "Add -->"
	SETTINGS_TOOLBAR_IMAGE, // "Toolbar images"
	SETTINGS_TOOLBAR_NOTE, // "Note! Changing toolbar icon size require a client restart to take effect."
	SETTINGS_TOOLBAR_REMOVE, // "<-- Remove"
	SETTINGS_TOOLBAR_SIZE, // "Toolbar icon size"
	SETTINGS_UDP_PORT, // "UDP (0 = auto)"
	SETTINGS_UPLOADS_MIN_SPEED, // "Open an extra slot if speed is below (0 = disable)"
	SETTINGS_UPLOADS_SLOTS, // "Upload slots"
	SETTINGS_UPLOAD_LINE_SPEED, // "Line speed (upload)"
	SETTINGS_URL_HANDLER, // "Install URL handler on startup (to handle dchub:// links)"
	SETTINGS_USER_COLORS, // "User list colors"
	SETTINGS_USER_COMMANDS, // "User commands"
	SETTINGS_USER_MENU, // "User menu items"
	SETTINGS_USE_ADLS, // "Always match other users' file lists with ADL search"
	SETTINGS_USE_CTRL_FOR_LINE_HISTORY, // "Use CTRL for line history"
	SETTINGS_USE_HIGHEST_LIST, // "Set highest priority for files matching the high priority list"
	SETTINGS_USE_SPACE_WARNING, // "Warn me about insufficient space left on target drive"
	SETTINGS_USE_SYSTEM_ICONS, // "Use system icons when browsing files (slows browsing down a bit)"
	SETTINGS_VALUE, // "Value"
	SETTINGS_WHOLE_LINE, // "Whole line"
	SETTINGS_WINDOWS, // "Windows"
	SETTINGS_WINDOWS_OPTIONS, // "Window options"
	SETTINGS_WRITE_BUFFER, // "Write buffer size"
	SETTINGS_WTOOLBAR_SIZE, // "Media toolbar icon size"
	SETTINGS_ZDC_PROGRESS_OVERRIDE, // "Override system colors"
	SETTING_FILE_RECOVERED, // "Settings were recovered from the file %1% that was saved on %2%. The corrupted file has been renamed to %3% (it can safely be removed). Some recent changes may have been lost."
	SETTING_DONT_DL_ALREADY_QUEUED, // "Don't download files already in queue"
	SETTING_NAME_X, // "Setting name: %1%"
	SETUP_PASS, // "Setup password"
	SET_ALTERNATE_LIMITING, // "Use alternate limiting from"
	SET_AWAY_MESSAGE, // "Set away message"
	SET_BUNDLE_PRIORITIES, // "Set the bundle priorities"
	SET_BUNDLE_PRIORITY, // "Set the bundle priority"
	SET_CLIENT_COMMANDS, // "Show client commands as status messages"
	SET_FILE_PRIORITIES, // "Set the file priorities"
	SET_FILE_PRIORITY, // "Set the file priority"
	SET_TRANSFER_LIMITING, // "Limit transfer speeds"
	SEVERE, // "Severe"
	SFV_READER, // "SFV reader"
	SFV_TOO_LARGE, // "The SFV file is too large to be loaded (%1%)"
	SHARED, // "Shared"
	SHARED_DIR_REMOVED, // "The directory %1% has been removed from the share"
	SHARED_DUPE_PATHS, // "Dupe paths (share)"
	SHARED_FILES, // "Shared files"
	SHARED_FILE_ADDED, // "The file %1% has been added in share"
	SHARE, // "Share"
	SHARE_CACHE_FILE_MISSING, // "Cache file missing for root %1%"
	SHARE_FILES_BLOCKED, // "Some of the files from directory %1% won't be shared: %2%"
	SHARE_DIRECTORY_BLOCKED, // "Directory %1% won't be shared: %2%"
	SHARE_HIDDEN, // "Share hidden"
	SHARE_PROFILE, // "Share profile"
	SHARE_PROFILES, // "Share profiles"
	SHELL_MENU, // "Shell menu"
	SHELL_MENUS, // "Shell menus"
	SHELL_MENU_FAILED, // "Failed to load the menu for %1%"
	SHOW_CONFLICTING, // "Show conflicting settings"
	SHOW_DIRECTORY_TREE, // "Show directory tree"
	SHOW_EMOTICON_BUTTON, // "Show emoticon button in chat windows"
	SHOW_FINISHED, // "Show finished downloads"
	SHOW_HIDE_INFORMATION, // "Show/Hide user information"
	SHOW_MAGNET_BUTTON, // "Show MAGNET button in chat windows"
	SHOW_MULTILINE_BUTTON, // "Show multiline message button in chat windows"
	SHOW_ON_TOP, // "Show above the list"
	SHOW_OTHER_PROFILES, // "Show other profiles"
	SHOW_POPUP_AWAY, // "Display popup in away mode only"
	SHOW_POPUP_MINIMIZED, // "Display popup when minimized only"
	SHOW_SEND_MESSAGE_BUTTON, // "Show send message button in chat windows"
	SHOW_USERLIST, // "Show/Hide user list"
	SHUTDOWN, // "Shutdown computer"
	SHUTDOWN_ACTION, // "Shutdown action"
	SHUTDOWN_OFF, // "Shutdown sequence deactivated..."
	SHUTDOWN_ON, // "Shutdown sequence activated..."
	SHUTTING_DOWN, // "Shutting down."
	SINGLE_CLICK_TRAY, // "Single click on tray icon to open"
	SIZE, // "Size"
	SIZE_EXACT, // "Exactly"
	SIZE_MIN, // "Min Size"
	SIZE_MISMATCH, // "Size of the file on disk doesn't match the one in queue"
	SKIPLIST_SHARE_MATCH, // "File matches the share skiplist"
	SKIPLIST_DOWNLOAD_MATCH, // "File matches the download skiplist"
	SKIP_DUPES, // "Skip dupes (already shared/queued)"
	SKIP_RENAME, // "New virtual name matches old name, skipping..."
	SKIP_SUBTRACT_TEXT, // "Subtract list: Skip dirs with ONLY 2 or less files smaller than"
	SLOTS, // "Slots"
	SLOTS_SET, // "Slots set"
	SLOT_GRANTED, // "Slot granted"
	SLOW_USER, // "Slow user"
	SMALL_FILE_SIZE_SET, // "Small file size set"
	SMALL_UP_SLOTS, // "Small upload slots (slots for file lists and small files)"
	SOCKS_AUTH_FAILED, // "Socks server authentication failed (bad login / password?)"
	SOCKS_AUTH_UNSUPPORTED, // "The socks server doesn't support login / password authentication"
	SOCKS_FAILED, // "The socks server failed establish a connection"
	SOCKS_NEEDS_AUTH, // "The socks server requires authentication"
	SOCKS_UNSUPPORTED_RESPONSE, // "Unsupported response received from the socks server"
	SOCKS_SETUP_ERROR, // "Failed to initialize UDP connectivity for SOCKS5 (%1%). The configured SOCKS5 server may not support UDP connectivity. WARNING: UDP traffic will be sent directly to other users without the proxy server."
	SORT_DIRS, // "Sort directories first in search window"
	SOUND_EXCEPTION, // "Unhandled exception"
	SOUND_SOURCE_ADDED, // "Alternate source added"
	SOUND_TYPING_NOTIFY, // "Typing sound"
	SOUND_UPLOAD_FINISHED, // "Upload finished"
	SOURCES, // "Sources"
	SOURCE_NO_ENCRYPTION, // "Remote ADC client does not use TLS encryption"
	SOURCE_TOO_OLD, // "Remote client does not fully support TTH - cannot download"
	SOURCE_TYPE, // "Source type"
	SOURCE_ADD_ERROR, // "Failed to add source (%1%)"
	SPECIFY_SEARCH_STRING, // "Specify a search string"
	SPECIFY_SERVER, // "Specify a server to connect to"
	SPEED, // "Speed"
	SPOTIFY_ALBUM, // "View this album on Spotify"
	SPOTIFY_ARTIST, // "View this artist on Spotify"
	SPOTIFY_HELP, // "/spotify - For Spotify media spamming\r\n- %[title]		Artist and the title of the currently playing item\r\n- %[link]		Spotify link to the track being played\r\n\r\nEmpty = Default String -> /me playing on Spotify: %[title] %[link]"
	SPOTIFY_HELP_DESC, // "Spotify help"
	SPOTIFY_TRACK, // "Play this track on Spotify"
	START, // "Start"
	START_CCPM, // "Start a direct encrypted channel"
	START_TIME, // "Start time"
	STATUS, // "Status"
	STOP, // "Stop"
	STOP_SHARING, // "Stop sharing"
	STORED_PASSWORD_SENT, // "Stored password sent..."
	STRIKEOUT, // "Strikeout"
	ST_MINISLOTS_EXT, // "Grant minislot automatically for the following file extensions (separate extensions with '|', wildcards allowed):"
	ST_SKIPLIST_SHARE, // "Don't share the following files (separate files with '|', wildcards allowed):"
	ST_SKIPLIST_SHARE_BORDER, // "Skiplist share"
	SUNDAY, // "Sunday"
	SUSPEND, // "Suspend"
	SYSTEM_DEFAULT, // "System default"
	SYSTEM_LOG, // "System log"
	SYSTEM_SHOW_FINISHED_DOWNLOADS, // "Show finished downloads"
	SYSTEM_SHOW_FINISHED_UPLOADS, // "Show finished uploads"
	TABS_ON_TOP, // "Tabs on top"
	TAB_ACTIVE_BG, // "Active background"
	TAB_ACTIVE_BORDER, // "Active border"
	TAB_ACTIVE_TEXT, // "Active text"
	TAB_INACTIVE_BG, // "Inactive background"
	TAB_INACTIVE_BG_DISCONNECTED, // "Disconnected/Offline PM"
	TAB_INACTIVE_BG_NOTIFY, // "Inactive notification"
	TAB_INACTIVE_BORDER, // "Inactive border"
	TAB_INACTIVE_TEXT, // "Inactive text"
	TAB_SHOW_ICONS, // "Show icons in tabs"
	TAG, // "Tag"
	TARGET_FILENAME_TOO_LONG, // "Target filename too long"
	TARGET_FILE_EXISTS, // "File exists on the disk already"
	TARGET_FILE_MISSING, // "Target file is missing or wrong size"
	TARGET_REMOVED, // "Target removed"
	TBITS, // "Tbit/s"
	TEMP_ITEMS, // "Temp items"
	TEST_SPEED_ONLINE, // "Test your speed online"
	TEST_WRITE, // "Test write to AirDC++ folders on startup"
	TEXT, // "Text"
	TEXT_MANUAL, // "Manual settings of number of segments"
	THEME_TEXT, // "Themes: "
	THURSDAY, // "Thursday"
	TIME, // "Time"
	TIMESTAMP_HELP, // "\r\n- %a - Abbreviated weekday name\r\n- %A - Full weekday name\r\n- %b - Abbreviated month name\r\n- %B - Full month name\r\n- %c - Date and time representation appropriate for locale\r\n- %d - Day of month as decimal number (01 - 31)\r\n- %H - Hour in 24-hour format (00 - 23)\r\n- %I - Hour in 12-hour format (01 - 12)\r\n- %j - Day of year as decimal number (001 - 366)\r\n- %m - Month as decimal number (01 - 12)\r\n- %M - Minute as decimal number (00 - 59)\r\n- %p - Current locale's A.M./P.M. indicator for 12-hour clock\r\n- %S - Second as decimal number (00 - 59)\r\n- %U - Week of year as decimal number, with Sunday as first day of week (00 - 53)\r\n- %w - Weekday as decimal number (0 - 6; Sunday is 0)\r\n- %W - Week of year as decimal number, with Monday as first day of week (00 - 53)\r\n- %x - Date representation for current locale\r\n- %X - Time representation for current locale\r\n- %y - Year without century, as decimal number (00 - 99)\r\n- %Y - Year with century, as decimal number\r\n- %z, %Z - Either the time-zone name or time zone abbreviation, depending on registry settings; no characters if time zone is unknown\r\n- %% - Percent sign\r\n\r\nDefault: %H:%M:%S"
	TIMESTAMP_HELP_DESC, // "Timestamps help"
	TIME_ADDED, // "Time added"
	TIME_FINISHED, // "Time finished"
	TIME_LEFT, // "Time left"
	TITLE, // "Title"
	TLS_ERROR, // "TLS error"
	TOGGLE_TBSTATUS, // "Toolbar progressbar\tCtrl+5"
	TOGGLE_TOOLBAR, // "Media toolbar\tCtrl+4"
	TOOLBAR_ORDER, // "Toolbar Order"
	TOOLBAR_PROGRESS_STYLE, // "Toolbar progress bar text styles"
	TOO_MUCH_DATA, // "More data was sent than was expected"
	TOTAL, // "Total: "
	TOTAL_FILES, // "Total files: %1%"
	TOTAL_SIZE, // "Total size: %1%"
	TRANSFER, // "Transfer"
	TRANSFERLISTDBLCLICKACTION, // "Transfer list double click action"
	TRANSFERRED, // "Transferred"
	TRANSFER_ENCRYPTION, // "Transfer encryption"
	TRANSFER_PORT, // "Transfer (TCP)"
	TRASFER_RATE_LIMITING, // "Transfer rate limiting"
	TREE_LOAD_FAILED, // "Failed to load hash data for a TTH root %1%: %2% (consider verifying the hash database by typing /verifydb)"
	TREE_LOAD_FAILED_DB, // "Failed to load hash data for a TTH root %1%: %2% (consider verifying your databases by typing %3%)"
	TRUSTED_CERTIFICATES, // "Trusted certificates"
	TRUSTED_CERTIFICATES_PATH, // "Trusted certificates path"
	TRUSTED_CERT_NOTE, // "WARNING: Don't change the trusted certificate settings unless you know what you are doing"
	TTH_ALREADY_SHARED, // "A file with the same hash exists in a shared directory %1%"
	TTH_INCONSISTENCY, // "TTH inconsistency"
	TTH_ROOT, // "TTH root"
	TUESDAY, // "Tuesday"
	TWO_COLORS, // "Two colors"
	TYPE, // "Type"
	TYPE_CONTENT, // "Type/Content"
	TYPE_FILE_LIST, // "file list"
	TYPE_FILE_LIST_PARTIAL, // "file list partial"
	TYPE_TTHLIST, // "tth list"
	TiB, // "TiB"
	UC_SUBMENU, // "Place user commands to submenu"
	UL_STATUS_POPUP, // "Upload speed - click to adjust limiter value"
	UNABLE_CONNECT_USER, // "Unable to download from this user"
	UNABLE_TO_CREATE_THREAD, // "Unable to create thread"
	UNABLE_TO_RENAME, // "Unable to rename %1%: %2%"
	UNABLE_TO_SEND_FILE, // "Unable to send file "
	UNDERLINE, // "Underline"
	UNFINISHED_FILE_NOT_FOUND, // "Unfinished file not found"
	UNFINISHED_FILE_TOO_SMALL, // "Unfinished file too small"
	UNIGNORE_USER, // "Unignore user"
	UNINSTALL, // "Uninstall"
	UNKNOWN, // "Unknown"
	UNKNOWN_ERROR, // "Unknown error"
	UNKNOWN_USER, // "Unknown user"
	UNLOCK, // "Unlock"
	UPDATE, // "Update"
	UPDATED_ON_X, // "Updated on: %1%"
	UPDATER, // "AirDC++ updater"
	UPDATER_IN_PROGRESS, // "Updating in progress, please wait a while for it to complete and try again."
	UPDATER_RESTART, // "Update installation successful. Would you like to restart AirDC++ now to complete the update process?"
	UPDATER_START, // "Update is being downloaded and installed, you'll be notified again when your attention is required."
	UPDATER_WRITE_FAILED, // "Failed to write the update file"
	UPDATE_ALREADY_DOWNLOADED, // "This version has already been downloaded. Please restart the client to apply the changes."
	UPDATE_CHANNEL, // "Update channel"
	UPDATE_CHECK, // "Update check"
	UPDATE_DOWNLOADED, // "The update has been downloaded successfully and it will be installed on next startup"
	UPDATE_FAILED, // "Failed to install the update (see %1% for more details)"
	UPDATE_IP, // "Update IP on startup"
	UPDATE_IP_EVERY, // "Update the IP address once per hour (enable only if you need this)"
	UPDATE_SUCCEEDED, // "Application was updated successfully"
	UPDATING, // "Updating"
	UPDATING_FAILED, // "Updating failed: %1%"
	UPDATING_VIEW, // "Updating the view..."
	UPLOADED, // "Uploaded"
	UPLOADED_BYTES, // "Uploaded %s (%.01f%%) in %s"
	UPLOADED_TO, // " uploaded to "
	UPLOAD_FINISHED_IDLE, // "Upload finished, idle..."
	UPLOAD_LIMIT, // "Upload limit"
	UPLOAD_LIMITS, // "Upload limits"
	UPLOAD_LIMITS_ADD, // "Upload limits (manually set)"
	UPLOAD_LIMIT_DISABLED, // "Upload limit disabled"
	UPLOAD_LIMIT_SET_TO, // "Upload limit set to %1% KiB/s"
	UPLOAD_QUEUE, // "Upload queue"
	UPLOAD_STARTING, // "Upload starting..."
	UPNP_NO_IMPLEMENTATION, // "No UPnP implementation available"
	UPNP_REMOVED_MAPPINGS, // "Successfully removed port mappings"
	UPNP_SUCCESSFULLY_CREATED_MAPPINGS, // "Successfully created port mappings"
	URL_REQUIRED, // "Url required"
	USER, // "User"
	USERNAME, // "Username"
	USERLISTDBLCLICKACTION, // "Userlist double click action"
	USERLIST_ICONS, // "Userlist icons"
	USERS, // "Users"
	USERS_ONLINE, // "%1%/%2% online"
	USER_CLOSED_WINDOW, // "User closed the window"
	USER_CMD_DESCRIPTION, // "Command Types:\r\nSeparator: Adds a separator to the menu\r\nRaw: Sends raw command to the hub (experts only, end it with '|'!)\r\nChat: Sends command as if you were typing it in the chat\r\nPM: Sends command as if you sent it by pm\r\nContexts determine where the command is shown:\r\nHub menu: Hub tab (at the bottom of the screen) right-click menu\r\nChat menu: User right-click menu in chat and PM tab menu\r\nSearch menu: Search right-click menu\r\nParameters:\r\nName: Name (use '/' to create submenus)\r\nCommand: Command text (may contain parameters)\r\nHub: Hub IP as typed when connecting (empty = all hubs, \"op\" = hubs where you're op)\r\nTo: PM recipient\r\nOnly once: Send only once per user from search frame\r\nIn the parameters, you can use %[xxx] variables and date/time specifiers (%Y, %m, ...). The following are available:\r\n%[myNI]: your own nick\r\n%[userNI]: the users nick (user && search context only)\r\n%[userTAG]: user tag (user && search context only)\r\n%[userDE]: user description (user && search context only)\r\n%[userEM]: user email (user && search context only)\r\n%[userSS]: user shared bytes (exact) (user && search context only)\r\n%[userSSshort]: user shared bytes (formatted) (user && search context only)\r\n%[userI4]: user ip (if supported by hub)\r\n%[fileFN]: filename (search context only)\r\n%[line:reason]: opens up a window asking for \"reason\""
	USER_CMD_FILELIST_MENU, // "File list menu"
	USER_CMD_HUB, // "Hub IP / DNS (empty = all, 'op' = where operator)"
	USER_CMD_HUB_MENU, // "Hub menu"
	USER_CMD_ONCE, // "Send once per nick"
	USER_CMD_PARAMETERS, // "Parameters"
	USER_CMD_PM, // "PM"
	USER_CMD_PREVIEW, // "Text sent to hub"
	USER_CMD_SEARCH_MENU, // "Search menu"
	USER_CMD_TO, // "To"
	USER_CMD_TYPE, // "Command type"
	USER_CMD_USER_MENU, // "User menu"
	USER_CMD_WINDOW, // "Create / modify command"
	USER_DESCRIPTION, // "User description"
	USER_LIST, // "User list"
	USER_MATCH, // "User match"
	USER_OFFLINE, // "User offline"
	USER_OFFLINE_PM_CHANGE, // "User went offline in %1%, messages are now sent through the hub %2%"
	USER_ONLINE, // "User online"
	USER_PROFILE_PLAIN, // "User profile"
	USER_PROFILE_SEL, // "User profile selection"
	USER_TYPING, // "User is typing..."
	USER_WENT_OFFLINE, // "User went offline"
	USER_WENT_ONLINE, // "User went online"
	USE_CURRENT_SETTINGS, // "Keep my current settings"
	USE_CUSTOM_MATCHER, // "Use a custom matcher for the search results"
	USE_DEFAULT, // "Use default"
	USE_DEFAULT_CERT_PATHS, // "Store in the default location"
	USE_EXPIRY_DAY, // "Use an expiry day for this item"
	USE_EXPLORER_THEME, // "Use Explorer theme in listviews and treeviews"
	USE_HIGHLIGHT, // "Use highlights"
	USE_PROFILE_SETTINGS, // "Use the profile settings"
	USE_REGEXP, // "Use regexp"
	USE_REGEXP_OR_WC, // "Use regexp or wildcards"
	USE_SEQ_ORDER, // "Use sequential order"
	USING_LATEST, // "You are already using the latest version"
	UTF_VALIDATION_ERROR, // "UTF-8 validation failed for the received data"
	VALIDATING_CONTENT, // "Validating content"
	VALIDATION_SUCCEEDED, // "Validation succeeded"
	VERIFY_CERT_FAILED, // "Certificate verification for subject: %1% failed with error: %2% (certificate keyprint: %3%)"
	VERSION, // "Version"
	VERSION_CHECK_FAILED, // "Failed to check for new version: %1%"
	VERSION_PARSING_FAILED,  // "Could not parse the version data (%1%)"
	VERSION_VERIFY_FAILED,  // "Could not verify the version data"
	VIDEO, // "Video"
	VIEWED_FILE_TOO_BIG, // "The file %1% is too big to be viewed in the client (the file size is %2% while the limit is 1 MiB)"
	VIEW_AS_TEXT, // "View as text"
	VIEW_HISTORY, // "View chat history"
	VIEW_NFO, // "Find and view NFO"
	VIRTUAL_DIRECTORY_REFRESHED, // "The virtual directory %1% has been refreshed"
	VIRTUAL_NAME, // "Virtual name"
	VIRTUAL_NAME_LONG, // "Name under which the others see the directory"
	VIRTUAL_REFRESH_QUEUED, // "The virtual directory %1% has been queued for refreshing"
	WAITING, // "Waiting"
	WAITING_LEFT, // "Waiting (%1% left)"
	WAITING_PCT, // "Waiting (%.01f%%)"
	WAITING_TIME, // "Waiting time"
	WANT_CONTINUE, // "Do you want to continue?"
	WEB_SERVER, // "Web server"
	WEB_SERVER_STARTED, // "Web server started"
	WEB_SERVER_RUNNING, // "Web server running"
	WEB_SERVER_PORT, // "Port (0 = disabled)"
	WEB_SERVER_STOPPED, // "Web server stopped"
	WEB_SERVER_START_FAILED, // "Failed to start web server: %1%"
	WEB_SERVER_HELP, // "Web server enables managing the client via web browser and running scripts via AirDC++ Web API"
	WEB_SERVER_INVALID_CONFIG, // "No valid configuration was found (ensure that the ports are valid and that there is at least one administrative account)"
	WEB_ACCOUNTS_NOTE, // "Note: you will be able to create user accounts with restricted permissions from the Web UI"
	WEB_ACCOUNT_INCOMPLETE, // "Please enter both username and password"
	WEB_UI_ACCESS_URL, // "Web user interface can be viewed at %1%"
	WEB_USERNAME_APLHANUM, // "The username should contain only alphanumeric characters"
	STOPPING, // "Stopping..."
	ADMIN_ACCOUNTS, // "Administrator accounts"
	SERVER_SETTINGS, // "Server settings"
	WEDNESDAY, // "Wednesday"
	WEEK, // "Week"
	WEEKS, // "Weeks"
	WHATS_THIS, // "What's this?"
	WHOLE_QUEUE, // "Whole queue"
	WHO_IS, // "Whois "
	WILDCARD, // "Wildcard"
	WILDCARDS, // "Wildcards"
	WINAMP_ARTIST, // "Artist"
	WINAMP_HELP, // "/winamp - Works with 1.x, 2.x, 5.x (no WinAmp 3 support)\r\n- %[version]	Numerical version (ex: 2.91)\r\n- %[state]	Playing state (ex: stopped/paused/playing)\r\n- %[title]		Window title from Winamp - if you want to change this for mp3s, Winamp > Pref > Input > MPEG > Title\r\n- %[rawtitle]	Window title from Winamp (if %[title] not working propertly)\r\n- %[percent]	Percentage (ex. 40%)\r\n- %[length]	Length in minutes:seconds (ex: 04:09)\r\n- %[elapsed]	Time elapsed in minutes:seconds (ex. 03:51)\r\n- %[bar]		ASCII progress bar, 10 characters wide no including brackets (ex. [----|-----])\r\n- %[bitrate]	Bitrate (ex. 128kbps)\r\n- %[sample]	Sample frequency (ex. 22kHz)\r\n- %[channels]	Number of channels (ex. stereo / mono)\r\n- %[path]	Playing full Filepath\r\n- %[directory]	Playing directoryname\r\n- %[filename]	Playing filename\r\n- %[parentdir]	Parent directory name of %[directory]\r\n Empty = Default string -> winamp(%[version]) %[state](%[title]) stats(%[percent] of %[length] %[bar])"
	WINAMP_HELP_DESC, // "Winamp help"
	WINAMP_LENGTH, // "Length"
	WINAMP_MENU, // "Winamp"
	WINAMP_PLAY, // "Play"
	WINAMP_SPAM, // "Post media spam to main chat"
	WINAMP_START, // "Start Media player"
	WINAMP_TITLE, // "Title"
	WINAMP_VOL_DOWN, // "Volume down"
	WINAMP_VOL_HALF, // "Volume 50%"
	WINAMP_VOL_UP, // "Volume up"
	WIZARD, // "Settings Wizard"
	WIZARD_AUTO_CONNECTIVITY_INTRO, // "Configure the network settings so transfers will work."
	WIZARD_CONNECTION_SPEED_INTRO, // "Choose your download and upload speed. You may also type in custom values if your speed isn't listed. Please be as accurate as possible and set the ACTUAL speed of your connection."
	WIZARD_FINISHED_INTRO, // "The wizard has been completed successfully. After exiting the wizard, you are ready to connect to hubs. The following methods can be used:\r\n\r\n\r\n1. Open public hublist (\"View\" -> \"Public hubs\" and choose the hub that you wish to connect\r\n\r\n2. If you already have the address that you want to connect, you can add it in favorite hubs (\"View\" -> \"Favorite hubs\") or connect directly by using quick connect (\"File\" -> \"Quick connect\")\r\n\r\n\r\nIf you want more information about the client features or you have questions to ask, see the \"Help\" menu."
	WIZARD_FINISHED_TITLE, // "Wizard completed"
	WIZARD_GENERAL_INTRO, // "Please enter some general information that you want to be displayed to other users"
	WIZARD_MANUAL_CONNECTIVITY_INTRO, // "Configure the network settings so transfers will work."
	WIZARD_PROFILE_INTRO, // "Choose how you will use the client. This will optimize various client options to be most suitable for your usage case."
	WIZARD_SHARING_INTRO, // "Choose the folders that you want to share to other users. This step isn't mandatory, but sharing files to other users will allow joining more hubs."
	WIZARD_SHARING_SP_NOTE, // "The folders are added in the default share profile. Note that you may create additional share profiles later from the settings to allow sharing different files in different hubs."
	WMP_HELP, // "/wmp - Works with Windows Media Player 9+\r\n- %[version]	Version of Windows Media Player\r\n- %[fullversion]	Full version of Windows Media Player\r\n- %[status]	Pre-formatted status string from Windows Media Player\r\n- %[title]		Name of the currently playing item\r\n- %[elapsed]	Time elapsed in (HH:)MM:SS\r\n- %[percent]	Time elapsed presented as percentage from total length\r\n- %[bar]		ASCII progress bar, 10 characters wide no including brackets (ex. [----|-----])\r\n- %[length]	Full length of the current item in (HH:)MM:SS\r\n- %[artist]	Name of the artist for the currently playing item\r\n- %[album]	Name of the album the current song is from\r\n- %[genre]	Genre of the current media\r\n- %[bitrate]	Bitrate for the playing media\r\n- %[year]	Year of album publication (no WMP9 support)\r\n- %[size]		Size of the currently playing file\r\n- %[rating]	Users rating, represented with *'s (if available)\r\n\r\nEmpty = Default String -> +me %[title] at %[bitrate] <Windows Media Player %[version]>"
	WMP_HELP_DESC, // "Windows Media Player help"
	WRITE_FAILED_X, // "Failed to write into %1%: %2%"
	WRONG_PASS, // "Wrong password"
	X_BUNDLES, // "%1% bundles"
	X_BUNDLES_QUEUED, // "%1% bundles queued"
	X_BUNDLE_ITEMS_ADDED, // "%1% items were added into an existing bundle %2%"
	X_BYTES_FREE, // "%1% (%2% free)"
	X_CONNECTIONS, // "%1% connection(s)"
	X_DOWNLOAD_FAILED_X, // "%1%: download failed (%2%)"
	X_DIRECTORIES_REFRESHED, // "%1% directories have been refreshed"
	X_DUPE_FOLDERS, // "%1% duplicate folders"
	X_EMPTY_FOLDERS, // "%1% empty folders"
	X_FAILED_SHARING, // "%1% (failed sharing)"
	X_FILES, // "%1% files"
	X_FILES_ADDED_FOR_HASH, // "%1% files (%2%) from the directory %3% have been added for hashing; they won't be visible in the file list until they have finished hashing"
	X_FILES_FAILED_HASHING, // "%1% files failed to hash"
	X_FILE_COUNT, // "%1% (%2% out of %3% files were affected)"
	X_FILE_NAMES, // "%1% (affected file(s): %2%)"
	X_FINISHED_BUNDLES, // "%1% finished bundle(s)"
	X_FOLDERS, // "%1% folders"
	X_MISSING_FILES, // "%1% (missing files)"
	X_PARSING_FAILED_X, // "%1%: parsing failed (%2%)"
	X_PROFILE_DIRS_EXISTS, // "This directory also exists in %1% other profile(s)"
	X_RESULTS_FOUND, // "Results were found from %1% directories"
	X_THREADS, // "%1% threads"
	X_USERS, // "%1% users"
	X_USERS_WAITING, // "%1% user(s) (%2% waiting)"
	X_REQUESTS_SECONDS, // "%1% requests were received within %2% seconds"
	YEAR, // "Year"
	YEARS, // "Years"
	YES, // "Yes"
	ZERO_BYTE_QUEUE, // "0-bytes items can't be queued"
	ZERO_BYTE_SHARE, // "0-bytes items are not shared"

	WEB_SERVER_SETUP_FAILED, // "Failed to set up %1% server on port %2%: %3% (is the port in use by another application?)"
	WEB_SERVER_MULTIPLE_FAILED_ATTEMPTS, // "Multiple failed login attempts detected from IP %1%"
	WEB_SERVER_SHUTTING_DOWN, // "Shutting down"

	WEB_SESSIONS_INVALID_USER_PW, // "Invalid username or password"
	WEB_SESSIONS_TOO_MANY_ATTEMPTS, // "Too many failed login attempts detected (wait for a while before retrying)"
	WEB_SESSIONS_INVALID_TOKEN, // "Invalid authorization token (session expired?)"

	WEB_CFG_PORT, // "Port"
	WEB_CFG_BIND_ADDRESS, // "Bind address"
	WEB_CFG_CERT_PATH, // "Certificate path"
	WEB_CFG_CERT_KEY_PATH, // "Certificate key path"

	WEB_CFG_SERVER_THREADS, // "Server threads"
	WEB_CFG_EXTENSION_ENGINES, // "Extension engines"
	WEB_CFG_EXTENSION_ENGINES_COMMAND_HELP, // "Multiple commands can specified, separate with \";\". Application will use the first command that is available on the system."
	WEB_CFG_EXTENSION_ENGINES_ARGS_HELP, // "Startup arguments to be passed to the engine"

	WEB_CFG_IDLE_TIMEOUT, // "Default session inactivity timeout"
	WEB_CFG_PING_INTERVAL, // "Socket ping interval"
	WEB_CFG_PING_TIMEOUT, // "Socket ping timeout"
	WEB_CFG_EXTENSIONS_DEBUG_MODE, // "Run extensions in debug mode"
	WEB_CFG_EXTENSIONS_INIT_TIMEOUT, // "Initialization timeout for extensions"
	WEB_CFG_EXTENSIONS_AUTO_UPDATE, // "Update extensions automatically"

	WEB_CFG_SHARE_FILE_VALIDATION_HOOK_TIMEOUT, // "Share file validation"
	WEB_CFG_SHARE_DIRECTORY_VALIDATION_HOOK_TIMEOUT, // "Share directory validation"
	WEB_CFG_NEW_SHARE_FILE_VALIDATION_HOOK_TIMEOUT, // "New share file validation"
	WEB_CFG_NEW_SHARE_DIRECTORY_VALIDATION_HOOK_TIMEOUT, // "New share directory validation"

	WEB_CFG_OUTGOING_CHAT_MESSAGE_HOOK_TIMEOUT, // "Outgoing chat message"
	WEB_CFG_INCOMING_CHAT_MESSAGE_HOOK_TIMEOUT, // "Incoming chat message"

	WEB_CFG_OUTGOING_HUB_COMMAND_HOOK_TIMEOUT, // "Outgoing hub command"
	WEB_CFG_OUTGOING_UDP_COMMAND_HOOK_TIMEOUT, // "Outgoing UDP command"
	WEB_CFG_OUTGOING_TCP_COMMAND_HOOK_TIMEOUT, // "Outgoing TCP command"

	WEB_CFG_QUEUE_ADD_BUNDLE_FILE_HOOK_TIMEOUT, // "Add bundle file"
	WEB_CFG_QUEUE_ADD_BUNDLE_HOOK_TIMEOUT, // "Add bundle"
	WEB_CFG_QUEUE_ADD_SOURCE_HOOK_TIMEOUT, // "Add queue source"
	WEB_CFG_QUEUE_BUNDLE_FINISHED_HOOK_TIMEOUT, // "Bundle downloaded"
	WEB_CFG_QUEUE_FILE_FINISHED_HOOK_TIMEOUT, // "File downloaded"

	WEB_CFG_FILELIST_LOAD_DIRECTORY_HOOK_TIMEOUT, // "Load filelist directory"
	WEB_CFG_FILELIST_LOAD_FILE_HOOK_TIMEOUT, // "Load filelist file"

	WEB_CFG_SEARCH_INCOMING_USER_RESULT_HOOK_TIMEOUT, // "Incoming search result"

	WEB_CFG_LIST_MENUITEMS_HOOK_TIMEOUT, // "List menu items"

	X_EXTENSIONS_LOADED, // "%1% extensions were loaded"
	X_DEBUG_MODE, // "%1% (debug mode)"

	WEB_EXTENSION_INIT_TIMED_OUT, // "Initialization timed out for an extension %1%"
	WEB_EXTENSION_LOAD_ERROR_X, // "Failed to load the extension %1%: %2%"
	WEB_EXTENSION_LOAD_ERROR, // "Failed to load the extension"
	WEB_EXTENSION_START_ERROR, // "Failed to start the extension %1%: %2%"
	WEB_EXTENSION_INSTALLED, // "Extension %1% was installed successfully"
	WEB_EXTENSION_UNINSTALLED, // "Extension %1% was uninstalled"
	WEB_EXTENSION_UNINSTALL_BLOCKED, // "Uninstalling a blocked extension %1% (%2%)..."
	WEB_EXTENSION_UPDATED, // "Extension %1% was updated successfully"
	WEB_EXTENSION_INSTALLATION_FAILED, // "Failed to install the extension %1%: %2%"
	WEB_EXTENSION_EXISTS, // "Extension with the same name exists already"
	WEB_EXTENSION_EXITED, // "Extension %1% has exited (see the extension log %2% for error details)"
	WEB_EXTENSION_TIMED_OUT, // "Extension %1% timed out and was restarted"
	WEB_EXTENSION_TERMINATE_PROCESS_FAILED, // "Failed to terminate the extension process (%1%)"
	WEB_EXTENSION_STOP_FAILED, // "Failed to stop the extension %1%: %2%"
	WEB_EXTENSION_ENGINE_NO_CONFIG, // "Scripting engine %1% is not configured in application settings"
	WEB_EXTENSION_ENGINE_NOT_INSTALLED, // "Scripting engine %1% is not installed on the system (tested commands: %2%)"
	WEB_EXTENSION_SERVER_NOT_RUNNING, // "Web server is not running"
	WEB_EXTENSION_HTTP_NOT_ENABLED, // "Extensions require the (plain) HTTP protocol to be enabled"
	WEB_EXTENSION_OS_UNSUPPORTED, // "Extension is not compatible with your operating system (check the extension documentation for more information)"
	WEB_EXTENSION_API_VERSION_UNSUPPORTED, // "Extension requires API version %1% while the application uses version %2%"
	WEB_EXTENSION_API_FEATURES_UNSUPPORTED, // "Extension requires API feature level %1% or newer while the application supports feature level %2%"

	WEB_EXTENSION_MAJOR_UPDATE, // "A new major version %1% is available for an extension %2%. It needs to be installed manually."
	WEB_EXTENSION_UPDATE_CHECK_FAILED, // "Could not check updates for an extension %1%: %2%"

	WEB_EXTENSION_CHECKSUM_MISMATCH, // "Checksum validation mismatch"
	WEB_EXTENSION_DOWNLOAD_FAILED, // "Download failed"
	WEB_EXTENSION_INSTALL_BLOCKED, // "Extension has been blocked"
	WEB_EXTENSION_PACKAGE_EXTRACT_FAILED, // "Failed to extract the package"
	WEB_EXTENSION_PACKAGE_SAVE_FAILED, // "Failed to save the package"
	WEB_EXTENSION_PACKAGE_MALFORMED_CONTENT, // "Malformed package content"

	API_SHARE_REFRESH_PENDING, // "Refresh pending"
	API_SHARE_REFRESHING, // "Refreshing"

	LAST // @DontAdd
};
