/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.core;

import java.awt.Robot;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.function.Function;
import org.assertj.core.util.VisibleForTesting;
import org.assertj.swing.core.ComponentLookupScope;
import org.assertj.swing.core.MouseButton;
import org.assertj.swing.dependency.jsr305.Nonnull;
import org.assertj.swing.util.Platform;

public class Settings {
    private static final int DEFAULT_TIMEOUT_VISIBILITY;
    private static final int DEFAULT_TIMEOUT_POPUP;
    private static final int DEFAULT_TIMEOUT_SUBMENU;
    private static final int DEFAULT_DELAY_BETWEEN_EVENTS;
    private static final int DEFAULT_DELAY_DRAG;
    private static final int DEFAULT_DELAY_DROP;
    private static final int DEFAULT_DELAY_POSTING_EVENTS;
    private static final ComponentLookupScope DEFAULT_LOOKUP_SCOPE;
    private static final int DEFAULT_TIMEOUT_IDLE;
    private static final boolean DEFAULT_CLICK_ON_DISABLED;
    private static final MouseButton DEFAULT_DRAG_BUTTON;
    private static final boolean PRESERVE_SCREENSHOTS;
    private ComponentLookupScope componentLookupScope;
    private int timeoutToBeVisible;
    private int timeoutToFindPopup;
    private int timeoutToFindSubMenu;
    private int delayBetweenEvents;
    private int dragDelay;
    private int dropDelay;
    private int eventPostingDelay;
    private int idleTimeout;
    private boolean simpleWaitForIdle;
    private boolean allowClickOnDisabled;
    private MouseButton dragButton;
    private Robot robot;

    private static <T> T getGeneric(Properties p, String suffix, Function<String, T> convert, T defaultValue) {
        String key = "org.assertj.swing." + suffix;
        String systemProperty = System.getProperty(key);
        if (systemProperty != null) {
            return convert.apply(systemProperty);
        }
        String property = p.getProperty(key);
        if (property != null) {
            return convert.apply(property);
        }
        return defaultValue;
    }

    private static int get(Properties p, String suffix, int defaultValue) {
        return Settings.getGeneric(p, suffix, t -> Integer.parseInt(t), defaultValue);
    }

    private static boolean get(Properties p, String suffix, boolean defaultValue) {
        return Settings.getGeneric(p, suffix, t -> Boolean.parseBoolean(t), defaultValue);
    }

    public Settings() {
        this.timeoutToBeVisible(DEFAULT_TIMEOUT_VISIBILITY);
        this.timeoutToFindPopup(DEFAULT_TIMEOUT_POPUP);
        this.timeoutToFindSubMenu(DEFAULT_TIMEOUT_SUBMENU);
        this.delayBetweenEvents(DEFAULT_DELAY_BETWEEN_EVENTS);
        this.dragDelay(DEFAULT_DELAY_DRAG);
        this.dropDelay(DEFAULT_DELAY_DROP);
        this.eventPostingDelay(DEFAULT_DELAY_POSTING_EVENTS);
        this.componentLookupScope(DEFAULT_LOOKUP_SCOPE);
        this.idleTimeout(DEFAULT_TIMEOUT_IDLE);
        this.clickOnDisabledComponentsAllowed(DEFAULT_CLICK_ON_DISABLED);
        this.dragButton(DEFAULT_DRAG_BUTTON);
    }

    public static boolean shouldPreserveScreenshots() {
        return PRESERVE_SCREENSHOTS;
    }

    void attachTo(@Nonnull Robot newRobot) {
        this.robot = newRobot;
        if (this.delayBetweenEvents < 0) {
            this.delayBetweenEvents = this.robot.getAutoDelay();
        } else {
            this.updateRobotAutoDelay();
        }
    }

    @Nonnull
    @VisibleForTesting
    Robot robot() {
        return this.robot;
    }

    public int delayBetweenEvents() {
        return this.delayBetweenEvents;
    }

    public void delayBetweenEvents(int ms) {
        this.delayBetweenEvents = this.valueToUpdate(ms, -1, 60000);
        if (this.robot != null) {
            this.updateRobotAutoDelay();
        }
    }

    private void updateRobotAutoDelay() {
        this.robot.setAutoDelay(this.delayBetweenEvents);
    }

    public int timeoutToBeVisible() {
        return this.timeoutToBeVisible;
    }

    public void timeoutToBeVisible(int ms) {
        this.timeoutToBeVisible = this.valueToUpdate(ms, 0, 60000);
    }

    public int timeoutToFindPopup() {
        return this.timeoutToFindPopup;
    }

    public void timeoutToFindPopup(int ms) {
        this.timeoutToFindPopup = this.valueToUpdate(ms, 0, 60000);
    }

    public int timeoutToFindSubMenu() {
        return this.timeoutToFindSubMenu;
    }

    public void timeoutToFindSubMenu(int ms) {
        this.timeoutToFindSubMenu = this.valueToUpdate(ms, 0, 10000);
    }

    public int dragDelay() {
        return this.dragDelay;
    }

    public void dragDelay(int ms) {
        int min = Platform.isX11() || Platform.isOSX() ? 100 : 0;
        this.dragDelay = this.valueToUpdate(ms, min, 60000);
    }

    public int eventPostingDelay() {
        return this.eventPostingDelay;
    }

    public void eventPostingDelay(int ms) {
        this.eventPostingDelay = this.valueToUpdate(ms, 0, 1000);
    }

    public int dropDelay() {
        return this.dropDelay;
    }

    public void dropDelay(int ms) {
        int min = Platform.isWindows() ? 200 : 0;
        this.dropDelay = this.valueToUpdate(ms, min, 60000);
    }

    @Nonnull
    public ComponentLookupScope componentLookupScope() {
        return this.componentLookupScope;
    }

    public void componentLookupScope(@Nonnull ComponentLookupScope scope) {
        this.componentLookupScope = scope;
    }

    public int idleTimeout() {
        return this.idleTimeout;
    }

    public void idleTimeout(int ms) {
        this.idleTimeout = this.valueToUpdate(ms, 0, Integer.MAX_VALUE);
    }

    private int valueToUpdate(int value, int min, int max) {
        return Math.max(min, Math.min(max, value));
    }

    public boolean simpleWaitForIdle() {
        return this.simpleWaitForIdle;
    }

    public void simpleWaitForIdle(boolean simpleWaitForIdle) {
        this.simpleWaitForIdle = simpleWaitForIdle;
    }

    public boolean clickOnDisabledComponentsAllowed() {
        return this.allowClickOnDisabled;
    }

    public void clickOnDisabledComponentsAllowed(boolean allow) {
        this.allowClickOnDisabled = allow;
    }

    public MouseButton dragButton() {
        return this.dragButton;
    }

    public void dragButton(MouseButton button2) {
        this.dragButton = button2;
    }

    static {
        Properties p = new Properties();
        try {
            InputStream stream = Settings.class.getResourceAsStream("/assertj-swing.properties");
            if (stream != null) {
                p.load(stream);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        DEFAULT_TIMEOUT_VISIBILITY = Settings.get(p, "timeout.visibility", 30000);
        DEFAULT_TIMEOUT_POPUP = Settings.get(p, "timeout.popup", 30000);
        DEFAULT_TIMEOUT_SUBMENU = Settings.get(p, "timeout.submenu", 100);
        DEFAULT_DELAY_BETWEEN_EVENTS = Settings.get(p, "delay.between_events", 60);
        DEFAULT_DELAY_DRAG = Settings.get(p, "delay.drag", 0);
        DEFAULT_DELAY_DROP = Settings.get(p, "delay.drop", 0);
        DEFAULT_DELAY_POSTING_EVENTS = Settings.get(p, "delay.posting_events", 100);
        DEFAULT_LOOKUP_SCOPE = Settings.getGeneric(p, "lookup_scope", t -> ComponentLookupScope.valueOf(t), ComponentLookupScope.DEFAULT);
        DEFAULT_TIMEOUT_IDLE = Settings.get(p, "timeout.idle", 10000);
        DEFAULT_CLICK_ON_DISABLED = Settings.get(p, "allow_click_on_disabled_component", true);
        DEFAULT_DRAG_BUTTON = Settings.getGeneric(p, "drag.button", t -> MouseButton.valueOf(t), MouseButton.LEFT_BUTTON);
        PRESERVE_SCREENSHOTS = Settings.get(p, "preserve_screenshots", false);
    }
}

