/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.patch.tool;

import com.intellij.codeInsight.hint.HintManager;
import com.intellij.diff.DiffContentFactory;
import com.intellij.diff.DiffContentFactoryEx;
import com.intellij.diff.DiffContext;
import com.intellij.diff.DiffDialogHints;
import com.intellij.diff.DiffManager;
import com.intellij.diff.actions.ProxyUndoRedoAction;
import com.intellij.diff.actions.impl.FocusOppositePaneAction;
import com.intellij.diff.actions.impl.SetEditorSettingsAction;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.merge.MergeModelBase;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.SimpleDiffRequest;
import com.intellij.diff.tools.fragmented.LineNumberConvertor;
import com.intellij.diff.tools.holders.TextEditorHolder;
import com.intellij.diff.tools.util.DiffDataKeys;
import com.intellij.diff.tools.util.DiffSplitter;
import com.intellij.diff.tools.util.FocusTrackerSupport;
import com.intellij.diff.tools.util.FoldingModelSupport;
import com.intellij.diff.tools.util.PrevNextDifferenceIterableBase;
import com.intellij.diff.tools.util.SimpleDiffPanel;
import com.intellij.diff.tools.util.StatusPanel;
import com.intellij.diff.tools.util.SyncScrollSupport;
import com.intellij.diff.tools.util.base.TextDiffSettingsHolder;
import com.intellij.diff.tools.util.base.TextDiffViewerUtil;
import com.intellij.diff.tools.util.side.TwosideContentPanel;
import com.intellij.diff.util.DiffDividerDrawUtil;
import com.intellij.diff.util.DiffDrawUtil;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.LineRange;
import com.intellij.diff.util.Side;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CompositeShortcutSet;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.LineNumberConverter;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.event.VisibleAreaListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorGutterFreePainterAreaState;
import com.intellij.openapi.editor.ex.EditorMarkupModel;
import com.intellij.openapi.editor.impl.LineNumberConverterAdapter;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.patch.AppliedTextPatch;
import com.intellij.openapi.vcs.changes.patch.tool.ApplyPatchChange;
import com.intellij.openapi.vcs.changes.patch.tool.ApplyPatchRequest;
import com.intellij.openapi.vcs.changes.patch.tool.PatchChangeBuilder;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.concurrency.annotations.RequiresWriteLock;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ApplyPatchViewer
implements Disposable {
    @Nullable
    private final Project myProject;
    @NotNull
    private final DiffContext myContext;
    @NotNull
    private final ApplyPatchRequest myPatchRequest;
    @NotNull
    private final TextEditorHolder myResultHolder;
    @NotNull
    private final TextEditorHolder myPatchHolder;
    @NotNull
    private final EditorEx myResultEditor;
    @NotNull
    private final EditorEx myPatchEditor;
    @NotNull
    private final SimpleDiffPanel myPanel;
    @NotNull
    private final TwosideContentPanel myContentPanel;
    @NotNull
    private final MyModel myModel;
    @NotNull
    private final FocusTrackerSupport<Side> myFocusTrackerSupport;
    @NotNull
    private final MyPrevNextDifferenceIterable myPrevNextDifferenceIterable;
    @NotNull
    private final StatusPanel myStatusPanel;
    @NotNull
    private final MyFoldingModel myFoldingModel;
    @NotNull
    private final SetEditorSettingsAction myEditorSettingsAction;
    @NotNull
    private final List<ApplyPatchChange> myResultChanges;
    @NotNull
    private final List<ApplyPatchChange> myPatchChanges;
    @NotNull
    private final List<ApplyPatchChange> myModelChanges;
    private boolean myDisposed;

    ApplyPatchViewer(@NotNull DiffContext context, @NotNull ApplyPatchRequest request) {
        if (context == null) {
            ApplyPatchViewer.$$$reportNull$$$0(0);
        }
        if (request == null) {
            ApplyPatchViewer.$$$reportNull$$$0(1);
        }
        this.myResultChanges = new ArrayList<ApplyPatchChange>();
        this.myPatchChanges = new ArrayList<ApplyPatchChange>();
        this.myModelChanges = new ArrayList<ApplyPatchChange>();
        this.myProject = context.getProject();
        this.myContext = context;
        this.myPatchRequest = request;
        DocumentContent resultContent = request.getResultContent();
        DocumentContent patchContent = DiffContentFactory.getInstance().create(EditorFactory.getInstance().createDocument((CharSequence)""), resultContent);
        this.myResultHolder = TextEditorHolder.create((Project)this.myProject, (DocumentContent)resultContent);
        this.myPatchHolder = TextEditorHolder.create((Project)this.myProject, (DocumentContent)patchContent);
        this.myResultEditor = this.myResultHolder.getEditor();
        this.myPatchEditor = this.myPatchHolder.getEditor();
        if (this.isReadOnly()) {
            this.myResultEditor.setViewer(true);
        }
        this.myPatchEditor.setViewer(true);
        DiffUtil.disableBlitting((EditorEx)this.myResultEditor);
        DiffUtil.disableBlitting((EditorEx)this.myPatchEditor);
        ((EditorMarkupModel)this.myResultEditor.getMarkupModel()).setErrorStripeVisible(false);
        this.myResultEditor.setVerticalScrollbarOrientation(0);
        this.myPatchEditor.getGutterComponentEx().setRightFreePaintersAreaState(EditorGutterFreePainterAreaState.SHOW);
        ((EditorMarkupModel)this.myPatchEditor.getMarkupModel()).setErrorStripeVisible(false);
        List<TextEditorHolder> holders = Arrays.asList(this.myResultHolder, this.myPatchHolder);
        List<EditorEx> editors = Arrays.asList(this.myResultEditor, this.myPatchEditor);
        JComponent resultTitle = DiffUtil.createTitle((String)this.myPatchRequest.getResultTitle());
        JComponent patchTitle = DiffUtil.createTitle((String)this.myPatchRequest.getPatchTitle());
        List<JComponent> titleComponents = Arrays.asList(resultTitle, patchTitle);
        this.myContentPanel = TwosideContentPanel.createFromHolders(holders);
        this.myContentPanel.setTitles(titleComponents);
        this.myPanel = new SimpleDiffPanel((JComponent)this.myContentPanel, this.myContext){

            public void uiDataSnapshot(@NotNull DataSink sink) {
                if (sink == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.uiDataSnapshot(sink);
                sink.set(CommonDataKeys.PROJECT, (Object)this.myProject);
                sink.set(DiffDataKeys.PREV_NEXT_DIFFERENCE_ITERABLE, (Object)ApplyPatchViewer.this.myPrevNextDifferenceIterable);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sink", "com/intellij/openapi/vcs/changes/patch/tool/ApplyPatchViewer$1", "uiDataSnapshot"));
            }
        };
        this.myModel = new MyModel(this.myProject, (Document)this.myResultEditor.getDocument());
        this.myFocusTrackerSupport = new FocusTrackerSupport.Twoside(holders);
        this.myFocusTrackerSupport.setCurrentSide((Object)Side.LEFT);
        this.myPrevNextDifferenceIterable = new MyPrevNextDifferenceIterable();
        this.myStatusPanel = new MyStatusPanel();
        this.myFoldingModel = new MyFoldingModel(this.myProject, this.myResultEditor, this);
        DiffUtil.installLineConvertor((EditorEx)this.myResultEditor, (FoldingModelSupport)this.myFoldingModel);
        new MyFocusOppositePaneAction().install((JComponent)this.myPanel);
        new TextDiffViewerUtil.EditorActionsPopup(this.createEditorPopupActions()).install(editors, (JComponent)this.myPanel);
        new TextDiffViewerUtil.EditorFontSizeSynchronizer(editors).install((Disposable)this);
        this.myEditorSettingsAction = new SetEditorSettingsAction(this.getTextSettings(), editors);
        this.myEditorSettingsAction.applyDefaults();
        ProxyUndoRedoAction.register((Project)this.myProject, (Editor)this.myResultEditor, (JComponent)this.myContentPanel);
    }

    @NotNull
    protected List<AnAction> createToolbarActions() {
        ArrayList<AnAction> group = new ArrayList<AnAction>();
        if (!this.isReadOnly()) {
            group.add((AnAction)new MyToggleExpandByDefaultAction());
            group.add((AnAction)this.myEditorSettingsAction);
            group.add((AnAction)Separator.getInstance());
            group.add((AnAction)new ShowDiffWithLocalAction());
            group.add((AnAction)new ApplyNonConflictsAction());
        }
        ArrayList<AnAction> arrayList = group;
        if (arrayList == null) {
            ApplyPatchViewer.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    @NotNull
    private List<AnAction> createEditorPopupActions() {
        ArrayList<AnAction> group = new ArrayList<AnAction>();
        if (!this.isReadOnly()) {
            group.add((AnAction)new ApplySelectedChangesAction());
            group.add((AnAction)new IgnoreSelectedChangesAction());
        }
        group.add((AnAction)Separator.getInstance());
        group.addAll(TextDiffViewerUtil.createEditorPopupActions());
        ArrayList<AnAction> arrayList = group;
        if (arrayList == null) {
            ApplyPatchViewer.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    public void dispose() {
        if (this.myDisposed) {
            return;
        }
        this.myDisposed = true;
        Disposer.dispose((Disposable)this.myModel);
        Disposer.dispose((Disposable)this.myResultHolder);
        Disposer.dispose((Disposable)this.myPatchHolder);
    }

    public boolean isReadOnly() {
        return !DiffUtil.canMakeWritable((Document)this.myResultEditor.getDocument());
    }

    @NotNull
    public MyModel getModel() {
        MyModel myModel = this.myModel;
        if (myModel == null) {
            ApplyPatchViewer.$$$reportNull$$$0(4);
        }
        return myModel;
    }

    @NotNull
    public List<ApplyPatchChange> getModelChanges() {
        List<ApplyPatchChange> list = this.myModelChanges;
        if (list == null) {
            ApplyPatchViewer.$$$reportNull$$$0(5);
        }
        return list;
    }

    public boolean isDisposed() {
        return this.myDisposed;
    }

    @NotNull
    public StatusPanel getStatusPanel() {
        StatusPanel statusPanel = this.myStatusPanel;
        if (statusPanel == null) {
            ApplyPatchViewer.$$$reportNull$$$0(6);
        }
        return statusPanel;
    }

    @NotNull
    public JComponent getComponent() {
        SimpleDiffPanel simpleDiffPanel = this.myPanel;
        if (simpleDiffPanel == null) {
            ApplyPatchViewer.$$$reportNull$$$0(7);
        }
        return simpleDiffPanel;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myResultEditor.getContentComponent();
    }

    @NotNull
    public EditorEx getResultEditor() {
        EditorEx editorEx = this.myResultEditor;
        if (editorEx == null) {
            ApplyPatchViewer.$$$reportNull$$$0(8);
        }
        return editorEx;
    }

    @NotNull
    public EditorEx getPatchEditor() {
        EditorEx editorEx = this.myPatchEditor;
        if (editorEx == null) {
            ApplyPatchViewer.$$$reportNull$$$0(9);
        }
        return editorEx;
    }

    @NotNull
    public Side getCurrentSide() {
        Side side = (Side)this.myFocusTrackerSupport.getCurrentSide();
        if (side == null) {
            ApplyPatchViewer.$$$reportNull$$$0(10);
        }
        return side;
    }

    @NotNull
    public List<ApplyPatchChange> getPatchChanges() {
        List<ApplyPatchChange> list = this.myPatchChanges;
        if (list == null) {
            ApplyPatchViewer.$$$reportNull$$$0(11);
        }
        return list;
    }

    @NotNull
    public TextDiffSettingsHolder.TextDiffSettings getTextSettings() {
        TextDiffSettingsHolder.TextDiffSettings textDiffSettings = TextDiffSettingsHolder.TextDiffSettings.getSettings((String)"ApplyPatch");
        if (textDiffSettings == null) {
            ApplyPatchViewer.$$$reportNull$$$0(12);
        }
        return textDiffSettings;
    }

    @NotNull
    public FoldingModelSupport.Settings getFoldingModelSettings() {
        TextDiffSettingsHolder.TextDiffSettings settings = this.getTextSettings();
        return new FoldingModelSupport.Settings(settings.getContextRange(), settings.isExpandByDefault());
    }

    protected void initPatchViewer() {
        this.myPanel.setPersistentNotifications(DiffUtil.createCustomNotifications(null, (UserDataHolder)this.myContext, (UserDataHolder)this.myPatchRequest));
        DocumentEx outputDocument = this.myResultEditor.getDocument();
        boolean success = DiffUtil.executeWriteCommand((Document)outputDocument, (Project)this.myProject, (String)DiffBundle.message((String)"message.init.merge.content.command", (Object[])new Object[0]), () -> this.lambda$initPatchViewer$0((Document)outputDocument));
        if (!success && !StringUtil.equals((CharSequence)outputDocument.getText(), (CharSequence)this.myPatchRequest.getLocalContent())) {
            this.myPanel.setErrorContent(VcsBundle.message((String)"patch.apply.display.local.content.was.modified.error", (Object[])new Object[0]));
            return;
        }
        PatchChangeBuilder.AppliedPatchState state = new PatchChangeBuilder().buildFromApplied(this.myPatchRequest.getPatch().getHunks());
        DocumentEx patchDocument = this.myPatchEditor.getDocument();
        WriteAction.run(() -> ApplyPatchViewer.lambda$initPatchViewer$1((Document)patchDocument, state));
        LineNumberConvertor convertor1 = state.getLineConvertor1();
        LineNumberConvertor convertor2 = state.getLineConvertor2();
        this.myPatchEditor.getGutter().setLineNumberConverter((LineNumberConverter)new LineNumberConverterAdapter(convertor1.createConvertor()), (LineNumberConverter)new LineNumberConverterAdapter(convertor2.createConvertor()));
        state.getSeparatorLines().forEach(arg_0 -> this.lambda$initPatchViewer$2((Document)patchDocument, arg_0));
        List<PatchChangeBuilder.AppliedHunk> hunks = state.getHunks();
        int[] modelToPatchIndexes = DiffUtil.getSortedIndexes(hunks, (h1, h2) -> {
            LineRange lines1 = h1.getAppliedToLines();
            LineRange lines2 = h2.getAppliedToLines();
            if (lines1 == null && lines2 == null) {
                return 0;
            }
            if (lines1 == null) {
                return -1;
            }
            if (lines2 == null) {
                return 1;
            }
            return lines1.start - lines2.start;
        });
        int[] patchToModelIndexes = DiffUtil.invertIndexes((int[])modelToPatchIndexes);
        ArrayList<LineRange> modelRanges = new ArrayList<LineRange>();
        for (int modelIndex = 0; modelIndex < hunks.size(); ++modelIndex) {
            int patchIndex = modelToPatchIndexes[modelIndex];
            PatchChangeBuilder.AppliedHunk hunk = hunks.get(patchIndex);
            LineRange resultRange = hunk.getAppliedToLines();
            ApplyPatchChange change = new ApplyPatchChange(hunk, modelIndex, this);
            this.myModelChanges.add(change);
            if (resultRange != null) {
                this.myResultChanges.add(change);
            }
            modelRanges.add(resultRange != null ? resultRange : new LineRange(-1, -1));
        }
        this.myModel.setChanges(modelRanges);
        for (int index : patchToModelIndexes) {
            this.myPatchChanges.add(this.myModelChanges.get(index));
        }
        this.myFoldingModel.install(this.myResultChanges, this.getFoldingModelSettings());
        Object modelIndex = this.myModelChanges.iterator();
        while (modelIndex.hasNext()) {
            ApplyPatchChange change = (ApplyPatchChange)modelIndex.next();
            change.reinstallHighlighters();
        }
        this.myStatusPanel.update();
        this.myContentPanel.setPainter((DiffSplitter.Painter)new MyDividerPainter());
        VisibleAreaListener areaListener = e -> this.myContentPanel.repaint();
        this.myResultEditor.getScrollingModel().addVisibleAreaListener(areaListener);
        this.myPatchEditor.getScrollingModel().addVisibleAreaListener(areaListener);
        this.myPatchEditor.getGutterComponentEx().revalidateMarkup();
        if (this.myResultChanges.size() > 0) {
            this.scrollToChange(this.myResultChanges.get(0), Side.LEFT, true);
        }
    }

    public void scrollToChange(@NotNull ApplyPatchChange change, @NotNull Side masterSide, boolean forceScroll) {
        if (change == null) {
            ApplyPatchViewer.$$$reportNull$$$0(13);
        }
        if (masterSide == null) {
            ApplyPatchViewer.$$$reportNull$$$0(14);
        }
        if (change.getResultRange() == null) {
            DiffUtil.moveCaret((Editor)this.myPatchEditor, (int)change.getPatchRange().start);
            this.myPatchEditor.getScrollingModel().scrollToCaret(forceScroll ? ScrollType.CENTER : ScrollType.MAKE_VISIBLE);
        } else {
            LineRange resultRange = change.getResultRange();
            LineRange patchRange = change.getPatchAffectedRange();
            int topShift = -1;
            if (!forceScroll) {
                int masterLine = masterSide.select(resultRange.start, patchRange.start);
                EditorEx masterEditor = (EditorEx)masterSide.select((Object)this.myResultEditor, (Object)this.myPatchEditor);
                int targetY = masterEditor.logicalPositionToXY((LogicalPosition)new LogicalPosition((int)masterLine, (int)0)).y;
                int scrollOffset = masterEditor.getScrollingModel().getVerticalScrollOffset();
                topShift = targetY - scrollOffset;
            }
            int[] offsets = SyncScrollSupport.getTargetOffsets((Editor)this.myResultEditor, (Editor)this.myPatchEditor, (int)resultRange.start, (int)resultRange.end, (int)patchRange.start, (int)patchRange.end, (int)topShift);
            DiffUtil.moveCaret((Editor)this.myResultEditor, (int)resultRange.start);
            DiffUtil.moveCaret((Editor)this.myPatchEditor, (int)patchRange.start);
            DiffUtil.scrollToPoint((Editor)this.myResultEditor, (Point)new Point(0, offsets[0]), (boolean)false);
            DiffUtil.scrollToPoint((Editor)this.myPatchEditor, (Point)new Point(0, offsets[1]), (boolean)false);
        }
    }

    public void repaintDivider() {
        this.myContentPanel.repaintDivider();
    }

    public boolean executeCommand(@Nullable @NlsContexts.Command String commandName, @NotNull Runnable task2) {
        if (task2 == null) {
            ApplyPatchViewer.$$$reportNull$$$0(15);
        }
        return this.myModel.executeMergeCommand(commandName, null, UndoConfirmationPolicy.DEFAULT, false, null, task2);
    }

    protected void onChangeResolved() {
        if (this.isDisposed()) {
            return;
        }
        this.myStatusPanel.update();
    }

    public void markChangeResolved(@NotNull ApplyPatchChange change) {
        if (change == null) {
            ApplyPatchViewer.$$$reportNull$$$0(16);
        }
        if (change.isResolved()) {
            return;
        }
        change.setResolved(true);
        this.myModel.invalidateHighlighters(change.getIndex());
        this.onChangeResolved();
    }

    public void replaceChange(@NotNull ApplyPatchChange change) {
        if (change == null) {
            ApplyPatchViewer.$$$reportNull$$$0(17);
        }
        LineRange resultRange = change.getResultRange();
        LineRange patchRange = change.getPatchInsertionRange();
        if (resultRange == null || change.isResolved()) {
            return;
        }
        if (change.getStatus() != AppliedTextPatch.HunkStatus.EXACTLY_APPLIED) {
            return;
        }
        List newContent = DiffUtil.getLines((Document)this.myPatchEditor.getDocument(), (int)patchRange.start, (int)patchRange.end);
        this.myModel.replaceChange(change.getIndex(), newContent);
        this.markChangeResolved(change);
    }

    public void copyChangeToClipboard(@NotNull ApplyPatchChange change) {
        if (change == null) {
            ApplyPatchViewer.$$$reportNull$$$0(18);
        }
        LineRange patchRange = change.getPatchInsertionRange();
        CharSequence newContent = DiffUtil.getLinesContent((Document)this.myPatchEditor.getDocument(), (int)patchRange.start, (int)patchRange.end);
        CopyPasteManager.copyTextToClipboard((String)newContent.toString());
        this.myPatchEditor.getCaretModel().moveToOffset(this.myPatchEditor.getDocument().getLineStartOffset(patchRange.start));
        HintManager.getInstance().showInformationHint((Editor)this.myPatchEditor, DiffBundle.message((String)"patch.dialog.copy.change.command.balloon", (Object[])new Object[0]), (short)2);
    }

    private /* synthetic */ void lambda$initPatchViewer$2(Document patchDocument, int line) {
        int offset = patchDocument.getLineStartOffset(line);
        DiffDrawUtil.createLineSeparatorHighlighter((Editor)this.myPatchEditor, (int)offset, (int)offset);
    }

    private static /* synthetic */ void lambda$initPatchViewer$1(Document patchDocument, PatchChangeBuilder.AppliedPatchState state) throws RuntimeException {
        patchDocument.setText(state.getPatchContent());
    }

    private /* synthetic */ void lambda$initPatchViewer$0(Document outputDocument) {
        outputDocument.setText((CharSequence)this.myPatchRequest.getLocalContent());
        if (!this.isReadOnly()) {
            DiffUtil.putNonundoableOperation((Project)this.myProject, (Document)outputDocument);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/patch/tool/ApplyPatchViewer";
                break;
            }
            case 13: 
            case 16: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "change";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "masterSide";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/patch/tool/ApplyPatchViewer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createToolbarActions";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditorPopupActions";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getModel";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getModelChanges";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatusPanel";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getResultEditor";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getPatchEditor";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentSide";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getPatchChanges";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextSettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "scrollToChange";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "executeCommand";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "markChangeResolved";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "replaceChange";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "copyChangeToClipboard";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12 -> new IllegalStateException(string);
        };
    }

    class MyModel
    extends MergeModelBase<ApplyPatchChange.State> {
        MyModel(@NotNull Project project, Document document) {
            if (document == null) {
                MyModel.$$$reportNull$$$0(0);
            }
            super(project, document);
        }

        protected void reinstallHighlighters(int index) {
            ApplyPatchChange change = ApplyPatchViewer.this.myModelChanges.get(index);
            change.reinstallHighlighters();
        }

        @NotNull
        protected ApplyPatchChange.State storeChangeState(int index) {
            ApplyPatchChange change = ApplyPatchViewer.this.myModelChanges.get(index);
            ApplyPatchChange.State state = change.storeState();
            if (state == null) {
                MyModel.$$$reportNull$$$0(1);
            }
            return state;
        }

        protected void restoreChangeState(@NotNull ApplyPatchChange.State state) {
            if (state == null) {
                MyModel.$$$reportNull$$$0(2);
            }
            super.restoreChangeState((MergeModelBase.State)state);
            ApplyPatchChange change = ApplyPatchViewer.this.myModelChanges.get(state.myIndex);
            boolean wasResolved = change.isResolved();
            change.restoreState(state);
            if (wasResolved != change.isResolved()) {
                ApplyPatchViewer.this.onChangeResolved();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "document";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/patch/tool/ApplyPatchViewer$MyModel";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "state";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/patch/tool/ApplyPatchViewer$MyModel";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "storeChangeState";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "restoreChangeState";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    private class MyPrevNextDifferenceIterable
    extends PrevNextDifferenceIterableBase<ApplyPatchChange> {
        private MyPrevNextDifferenceIterable() {
        }

        @NotNull
        protected List<ApplyPatchChange> getChanges() {
            List list = ContainerUtil.filter((Collection)((Collection)ApplyPatchViewer.this.getCurrentSide().select(ApplyPatchViewer.this.myResultChanges, ApplyPatchViewer.this.myPatchChanges)), it -> !it.isResolved());
            if (list == null) {
                MyPrevNextDifferenceIterable.$$$reportNull$$$0(0);
            }
            return list;
        }

        @NotNull
        protected EditorEx getEditor() {
            EditorEx editorEx = (EditorEx)ApplyPatchViewer.this.getCurrentSide().select((Object)ApplyPatchViewer.this.myResultEditor, (Object)ApplyPatchViewer.this.myPatchEditor);
            if (editorEx == null) {
                MyPrevNextDifferenceIterable.$$$reportNull$$$0(1);
            }
            return editorEx;
        }

        protected int getStartLine(@NotNull ApplyPatchChange change) {
            if (change == null) {
                MyPrevNextDifferenceIterable.$$$reportNull$$$0(2);
            }
            return ((LineRange)ApplyPatchViewer.this.getCurrentSide().select((Object)change.getResultRange(), (Object)change.getPatchAffectedRange())).start;
        }

        protected int getEndLine(@NotNull ApplyPatchChange change) {
            if (change == null) {
                MyPrevNextDifferenceIterable.$$$reportNull$$$0(3);
            }
            return ((LineRange)ApplyPatchViewer.this.getCurrentSide().select((Object)change.getResultRange(), (Object)change.getPatchAffectedRange())).end;
        }

        protected void scrollToChange(@NotNull ApplyPatchChange change) {
            if (change == null) {
                MyPrevNextDifferenceIterable.$$$reportNull$$$0(4);
            }
            ApplyPatchViewer.this.scrollToChange(change, ApplyPatchViewer.this.getCurrentSide(), true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3, 4 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/patch/tool/ApplyPatchViewer$MyPrevNextDifferenceIterable";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "change";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChanges";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getEditor";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/patch/tool/ApplyPatchViewer$MyPrevNextDifferenceIterable";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getStartLine";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getEndLine";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "scrollToChange";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3, 4 -> new IllegalArgumentException(string);
            };
        }
    }

    private class MyStatusPanel
    extends StatusPanel {
        private MyStatusPanel() {
        }

        @Nullable
        protected String getMessage() {
            int totalUnresolved = 0;
            int alreadyApplied = 0;
            int notApplied = 0;
            for (ApplyPatchChange change : ApplyPatchViewer.this.myPatchChanges) {
                if (change.isResolved()) continue;
                ++totalUnresolved;
                switch (change.getStatus()) {
                    case ALREADY_APPLIED: {
                        ++alreadyApplied;
                        break;
                    }
                    case NOT_APPLIED: {
                        ++notApplied;
                        break;
                    }
                }
            }
            if (totalUnresolved == 0) {
                return DiffBundle.message((String)"apply.somehow.status.message.all.applied", (Object[])new Object[]{notApplied});
            }
            if (totalUnresolved == notApplied) {
                return DiffBundle.message((String)"apply.somehow.status.message.cant.apply", (Object[])new Object[]{notApplied});
            }
            String message = DiffBundle.message((String)"apply.somehow.status.message.cant.apply.some", (Object[])new Object[]{notApplied, totalUnresolved});
            if (alreadyApplied == 0) {
                return message;
            }
            return message + ". " + DiffBundle.message((String)"apply.somehow.status.message.already.applied", (Object[])new Object[]{alreadyApplied});
        }
    }

    private static class MyFoldingModel
    extends FoldingModelSupport {
        MyFoldingModel(@Nullable Project project, @NotNull EditorEx editor, @NotNull Disposable disposable) {
            if (editor == null) {
                MyFoldingModel.$$$reportNull$$$0(0);
            }
            if (disposable == null) {
                MyFoldingModel.$$$reportNull$$$0(1);
            }
            super(project, new EditorEx[]{editor}, disposable);
        }

        /*
         * Exception decompiling
         */
        public void install(@Nullable List<ApplyPatchChange> changes, @NotNull FoldingModelSupport.Settings settings) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * java.lang.UnsupportedOperationException
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.applyExpressionRewriter(CastExpression.java:128)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriterToArgs(StaticFunctionInvokation.java:103)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriter(StaticFunctionInvokation.java:90)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
             *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "disposable";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "settings";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vcs/changes/patch/tool/ApplyPatchViewer$MyFoldingModel";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "install";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MyFocusOppositePaneAction
    extends FocusOppositePaneAction {
        MyFocusOppositePaneAction() {
            super(false);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                MyFocusOppositePaneAction.$$$reportNull$$$0(0);
            }
            EditorEx targetEditor = (EditorEx)ApplyPatchViewer.this.getCurrentSide().other().select((Object)ApplyPatchViewer.this.myResultEditor, (Object)ApplyPatchViewer.this.myPatchEditor);
            DiffUtil.requestFocus((Project)ApplyPatchViewer.this.myProject, (Component)targetEditor.getContentComponent());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/vcs/changes/patch/tool/ApplyPatchViewer$MyFocusOppositePaneAction", "actionPerformed"));
        }
    }

    private class MyToggleExpandByDefaultAction
    extends TextDiffViewerUtil.ToggleExpandByDefaultAction {
        MyToggleExpandByDefaultAction() {
            super(ApplyPatchViewer.this.getTextSettings(), (FoldingModelSupport)ApplyPatchViewer.this.myFoldingModel);
        }
    }

    private class ShowDiffWithLocalAction
    extends DumbAwareAction {
        ShowDiffWithLocalAction() {
            super(VcsBundle.messagePointer((String)"action.DumbAwareAction.text.compare.with.local.content", (Object[])new Object[0]), AllIcons.Actions.Diff);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ShowDiffWithLocalAction.$$$reportNull$$$0(0);
            }
            DocumentContent resultContent = ApplyPatchViewer.this.myPatchRequest.getResultContent();
            DocumentContent localContent = DiffContentFactoryEx.getInstanceEx().documentContent(ApplyPatchViewer.this.myProject, true).contextByReferent(resultContent).buildFromText(ApplyPatchViewer.this.myPatchRequest.getLocalContent(), false);
            SimpleDiffRequest request = new SimpleDiffRequest(ApplyPatchViewer.this.myPatchRequest.getTitle(), (DiffContent)localContent, (DiffContent)resultContent, ApplyPatchViewer.this.myPatchRequest.getLocalTitle(), ApplyPatchViewer.this.myPatchRequest.getResultTitle());
            LogicalPosition currentPosition = DiffUtil.getCaretPosition((Editor)ApplyPatchViewer.this.myResultEditor);
            request.putUserData(DiffUserDataKeys.SCROLL_TO_LINE, (Object)Pair.create((Object)Side.RIGHT, (Object)currentPosition.line));
            DiffManager.getInstance().showDiff(ApplyPatchViewer.this.myProject, (DiffRequest)request, new DiffDialogHints(null, (Component)ApplyPatchViewer.this.myPanel));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/vcs/changes/patch/tool/ApplyPatchViewer$ShowDiffWithLocalAction", "actionPerformed"));
        }
    }

    private class ApplyNonConflictsAction
    extends DumbAwareAction {
        ApplyNonConflictsAction() {
            ActionUtil.copyFrom((AnAction)this, (String)"Diff.ApplyNonConflicts");
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                ApplyNonConflictsAction.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ApplyNonConflictsAction.$$$reportNull$$$0(1);
            }
            boolean enabled = ContainerUtil.exists(ApplyPatchViewer.this.myModelChanges, c -> {
                if (c.isResolved()) {
                    return false;
                }
                return c.getStatus() != AppliedTextPatch.HunkStatus.NOT_APPLIED;
            });
            e.getPresentation().setEnabled(enabled);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            List<ApplyPatchChange> changes;
            if (e == null) {
                ApplyNonConflictsAction.$$$reportNull$$$0(2);
            }
            if ((changes = ApplyPatchViewer.this.myModelChanges).isEmpty()) {
                return;
            }
            ApplyPatchViewer.this.executeCommand(DiffBundle.message((String)"merge.dialog.apply.non.conflicted.changes.command", (Object[])new Object[0]), () -> {
                block4: for (int i = changes.size() - 1; i >= 0; --i) {
                    ApplyPatchChange change = (ApplyPatchChange)changes.get(i);
                    switch (change.getStatus()) {
                        case ALREADY_APPLIED: {
                            ApplyPatchViewer.this.markChangeResolved(change);
                            continue block4;
                        }
                        case EXACTLY_APPLIED: {
                            ApplyPatchViewer.this.replaceChange(change);
                            continue block4;
                        }
                    }
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/patch/tool/ApplyPatchViewer$ApplyNonConflictsAction";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/patch/tool/ApplyPatchViewer$ApplyNonConflictsAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }

    private final class ApplySelectedChangesAction
    extends ApplySelectedChangesActionBase {
        private ApplySelectedChangesAction() {
            this.getTemplatePresentation().setText(VcsBundle.messagePointer((String)"action.presentation.ApplySelectedChangesAction.text", (Object[])new Object[0]));
            this.getTemplatePresentation().setIcon(AllIcons.Actions.Checked);
            this.copyShortcutFrom(ActionManager.getInstance().getAction("Diff.ApplyRightSide"));
        }

        @Override
        protected boolean isEnabled(@NotNull ApplyPatchChange change) {
            if (change == null) {
                ApplySelectedChangesAction.$$$reportNull$$$0(0);
            }
            return !change.isResolved() && change.getStatus() == AppliedTextPatch.HunkStatus.EXACTLY_APPLIED;
        }

        @Override
        protected void apply(@NotNull List<? extends ApplyPatchChange> changes) {
            if (changes == null) {
                ApplySelectedChangesAction.$$$reportNull$$$0(1);
            }
            for (int i = changes.size() - 1; i >= 0; --i) {
                ApplyPatchViewer.this.replaceChange(changes.get(i));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "change";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "changes";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vcs/changes/patch/tool/ApplyPatchViewer$ApplySelectedChangesAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isEnabled";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "apply";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private final class IgnoreSelectedChangesAction
    extends ApplySelectedChangesActionBase {
        private IgnoreSelectedChangesAction() {
            this.getTemplatePresentation().setText(VcsBundle.messagePointer((String)"action.presentation.IgnoreSelectedChangesAction.text", (Object[])new Object[0]));
            this.getTemplatePresentation().setIcon(AllIcons.Diff.Remove);
            this.setShortcutSet((ShortcutSet)new CompositeShortcutSet(new ShortcutSet[]{ActionManager.getInstance().getAction("Diff.IgnoreRightSide").getShortcutSet(), ActionManager.getInstance().getAction("Diff.ApplyLeftSide").getShortcutSet()}));
        }

        @Override
        protected boolean isEnabled(@NotNull ApplyPatchChange change) {
            if (change == null) {
                IgnoreSelectedChangesAction.$$$reportNull$$$0(0);
            }
            return !change.isResolved();
        }

        @Override
        protected void apply(@NotNull List<? extends ApplyPatchChange> changes) {
            if (changes == null) {
                IgnoreSelectedChangesAction.$$$reportNull$$$0(1);
            }
            for (ApplyPatchChange applyPatchChange : changes) {
                ApplyPatchViewer.this.markChangeResolved(applyPatchChange);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "change";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "changes";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vcs/changes/patch/tool/ApplyPatchViewer$IgnoreSelectedChangesAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isEnabled";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "apply";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MyDividerPainter
    implements DiffSplitter.Painter,
    DiffDividerDrawUtil.DividerPaintable {
        private MyDividerPainter() {
        }

        public void paint(@NotNull Graphics g, @NotNull JComponent divider) {
            if (g == null) {
                MyDividerPainter.$$$reportNull$$$0(0);
            }
            if (divider == null) {
                MyDividerPainter.$$$reportNull$$$0(1);
            }
            Graphics2D gg = DiffDividerDrawUtil.getDividerGraphics((Graphics)g, (Component)divider, (Component)ApplyPatchViewer.this.myPatchEditor.getComponent());
            gg.setColor(DiffDrawUtil.getDividerColor((Editor)ApplyPatchViewer.this.myPatchEditor));
            gg.fill(gg.getClipBounds());
            DiffDividerDrawUtil.paintPolygons((Graphics2D)gg, (int)divider.getWidth(), (Editor)ApplyPatchViewer.this.myResultEditor, (Editor)ApplyPatchViewer.this.myPatchEditor, (DiffDividerDrawUtil.DividerPaintable)this);
            gg.dispose();
        }

        public void process(@NotNull DiffDividerDrawUtil.DividerPaintable.Handler handler) {
            if (handler == null) {
                MyDividerPainter.$$$reportNull$$$0(2);
            }
            for (ApplyPatchChange change : ApplyPatchViewer.this.myResultChanges) {
                LineRange resultRange = change.getResultRange();
                LineRange patchRange = change.getPatchRange();
                assert (resultRange != null);
                handler.processResolvable(resultRange.start, resultRange.end, patchRange.start, patchRange.end, change.getDiffType(), change.isResolved());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "g";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "divider";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "handler";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vcs/changes/patch/tool/ApplyPatchViewer$MyDividerPainter";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "paint";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "process";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private abstract class ApplySelectedChangesActionBase
    extends DumbAwareAction {
        private ApplySelectedChangesActionBase() {
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                ApplySelectedChangesActionBase.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ApplySelectedChangesActionBase.$$$reportNull$$$0(1);
            }
            if (DiffUtil.isFromShortcut((AnActionEvent)e)) {
                e.getPresentation().setEnabledAndVisible(true);
                return;
            }
            Presentation presentation = e.getPresentation();
            Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
            Side side = Side.fromValue(Arrays.asList(ApplyPatchViewer.this.myResultEditor, ApplyPatchViewer.this.myPatchEditor), (Object)editor);
            if (side == null) {
                presentation.setEnabledAndVisible(false);
                return;
            }
            presentation.setVisible(true);
            presentation.setEnabled(this.isSomeChangeSelected(side));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ApplySelectedChangesActionBase.$$$reportNull$$$0(2);
            }
            Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
            Side side = Side.fromValue(Arrays.asList(ApplyPatchViewer.this.myResultEditor, ApplyPatchViewer.this.myPatchEditor), (Object)editor);
            if (editor == null || side == null) {
                return;
            }
            List<ApplyPatchChange> selectedChanges = this.getSelectedChanges(side);
            if (selectedChanges.isEmpty()) {
                return;
            }
            String title = VcsBundle.message((String)"patch.apply.changes.in.patch.resolve", (Object[])new Object[]{e.getPresentation().getText()});
            ApplyPatchViewer.this.executeCommand(title, () -> this.apply(selectedChanges));
        }

        private boolean isSomeChangeSelected(@NotNull Side side) {
            if (side == null) {
                ApplySelectedChangesActionBase.$$$reportNull$$$0(3);
            }
            EditorEx editor = (EditorEx)side.select((Object)ApplyPatchViewer.this.myResultEditor, (Object)ApplyPatchViewer.this.myPatchEditor);
            return DiffUtil.isSomeRangeSelected((Editor)editor, lines -> ContainerUtil.exists(ApplyPatchViewer.this.myModelChanges, change -> this.isChangeSelected((ApplyPatchChange)change, (BitSet)lines, side)));
        }

        @NotNull
        @RequiresEdt
        private List<ApplyPatchChange> getSelectedChanges(@NotNull Side side) {
            if (side == null) {
                ApplySelectedChangesActionBase.$$$reportNull$$$0(4);
            }
            ThreadingAssertions.assertEventDispatchThread();
            EditorEx editor = (EditorEx)side.select((Object)ApplyPatchViewer.this.myResultEditor, (Object)ApplyPatchViewer.this.myPatchEditor);
            BitSet lines = DiffUtil.getSelectedLines((Editor)editor);
            List list = ContainerUtil.filter(ApplyPatchViewer.this.myModelChanges, change -> this.isChangeSelected((ApplyPatchChange)change, lines, side));
            if (list == null) {
                ApplySelectedChangesActionBase.$$$reportNull$$$0(5);
            }
            return list;
        }

        private boolean isChangeSelected(@NotNull ApplyPatchChange change, @NotNull BitSet lines, @NotNull Side side) {
            if (change == null) {
                ApplySelectedChangesActionBase.$$$reportNull$$$0(6);
            }
            if (lines == null) {
                ApplySelectedChangesActionBase.$$$reportNull$$$0(7);
            }
            if (side == null) {
                ApplySelectedChangesActionBase.$$$reportNull$$$0(8);
            }
            if (!this.isEnabled(change)) {
                return false;
            }
            LineRange range = (LineRange)side.select((Object)change.getResultRange(), (Object)change.getPatchRange());
            if (range == null) {
                return false;
            }
            return DiffUtil.isSelectedByLine((BitSet)lines, (int)range.start, (int)range.end);
        }

        protected abstract boolean isEnabled(@NotNull ApplyPatchChange var1);

        @RequiresWriteLock
        protected abstract void apply(@NotNull List<? extends ApplyPatchChange> var1);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3, 4, 6, 7, 8 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/patch/tool/ApplyPatchViewer$ApplySelectedChangesActionBase";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 3: 
                case 4: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "side";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "change";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "lines";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/patch/tool/ApplyPatchViewer$ApplySelectedChangesActionBase";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSelectedChanges";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "isSomeChangeSelected";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getSelectedChanges";
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "isChangeSelected";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3, 4, 6, 7, 8 -> new IllegalArgumentException(string);
            };
        }
    }
}

