/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.emmet;

import com.intellij.application.options.emmet.EmmetOptions;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.template.CustomLiveTemplateBase;
import com.intellij.codeInsight.template.CustomTemplateCallback;
import com.intellij.codeInsight.template.LiveTemplateBuilder;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateActionContext;
import com.intellij.codeInsight.template.emmet.CollectCustomTemplateCallback;
import com.intellij.codeInsight.template.emmet.EmmetAbbreviationBalloon;
import com.intellij.codeInsight.template.emmet.EmmetException;
import com.intellij.codeInsight.template.emmet.EmmetLexer;
import com.intellij.codeInsight.template.emmet.EmmetParser;
import com.intellij.codeInsight.template.emmet.filters.SingleLineEmmetFilter;
import com.intellij.codeInsight.template.emmet.filters.ZenCodingFilter;
import com.intellij.codeInsight.template.emmet.generators.XmlZenCodingGenerator;
import com.intellij.codeInsight.template.emmet.generators.ZenCodingGenerator;
import com.intellij.codeInsight.template.emmet.nodes.FilterNode;
import com.intellij.codeInsight.template.emmet.nodes.GenerationNode;
import com.intellij.codeInsight.template.emmet.nodes.TemplateNode;
import com.intellij.codeInsight.template.emmet.nodes.TextNode;
import com.intellij.codeInsight.template.emmet.nodes.ZenCodingNode;
import com.intellij.codeInsight.template.emmet.tokens.TemplateToken;
import com.intellij.codeInsight.template.emmet.tokens.TextToken;
import com.intellij.codeInsight.template.emmet.tokens.ZenCodingToken;
import com.intellij.codeInsight.template.impl.CustomLiveTemplateLookupElement;
import com.intellij.codeInsight.template.impl.LiveTemplateCompletionContributor;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.codeInsight.template.impl.TemplateSettings;
import com.intellij.diagnostic.CoreAttachmentFactory;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtilEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.DocumentUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.XmlBundle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadPoolExecutor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ZenCodingTemplate
extends CustomLiveTemplateBase {
    private static final ThreadPoolExecutor EMMET_EXECUTOR = ConcurrencyUtil.newSingleThreadExecutor((String)"Emmet expander");
    public static final char MARKER = '\u0000';
    private static final String EMMET_RECENT_WRAP_ABBREVIATIONS_KEY = "emmet.recent.wrap.abbreviations";
    private static final String EMMET_LAST_WRAP_ABBREVIATIONS_KEY = "emmet.last.wrap.abbreviations";
    private static final Logger LOG = Logger.getInstance(ZenCodingTemplate.class);
    private static final EmmetAbbreviationBalloon.EmmetContextHelp CONTEXT_HELP = new EmmetAbbreviationBalloon.EmmetContextHelp(XmlBundle.messagePointer((String)"zen.coding.context.help.tooltip", (Object[])new Object[0]), XmlBundle.messagePointer((String)"zen.coding.context.help.link", (Object[])new Object[0]), "https://docs.emmet.io/actions/wrap-with-abbreviation/");

    @Nullable
    public static ZenCodingGenerator findApplicableDefaultGenerator(@NotNull CustomTemplateCallback callback, boolean wrapping) {
        PsiElement context;
        if (callback == null) {
            ZenCodingTemplate.$$$reportNull$$$0(0);
        }
        if (!(context = callback.getContext()).isValid()) {
            return null;
        }
        for (ZenCodingGenerator generator : ZenCodingGenerator.getInstances()) {
            if (!generator.isMyContext(callback, wrapping) || !generator.isAppliedByDefault(context)) continue;
            return generator;
        }
        return null;
    }

    @Nullable
    public static ZenCodingNode parse(@NotNull String text, @NotNull CustomTemplateCallback callback, @NotNull ZenCodingGenerator generator, @Nullable String surroundedText) {
        List<ZenCodingToken> tokens;
        if (text == null) {
            ZenCodingTemplate.$$$reportNull$$$0(1);
        }
        if (callback == null) {
            ZenCodingTemplate.$$$reportNull$$$0(2);
        }
        if (generator == null) {
            ZenCodingTemplate.$$$reportNull$$$0(3);
        }
        if ((tokens = new EmmetLexer().lex(text)) == null) {
            return null;
        }
        if (!ZenCodingTemplate.validate(tokens, generator)) {
            return null;
        }
        EmmetParser parser = generator.createParser(tokens, callback, generator, surroundedText != null);
        ZenCodingNode node = parser.parse();
        if (parser.getIndex() != tokens.size() || node instanceof TextNode) {
            return null;
        }
        return node;
    }

    private static boolean validate(@NotNull List<ZenCodingToken> tokens, @NotNull ZenCodingGenerator generator) {
        if (tokens == null) {
            ZenCodingTemplate.$$$reportNull$$$0(4);
        }
        if (generator == null) {
            ZenCodingTemplate.$$$reportNull$$$0(5);
        }
        for (ZenCodingToken token : tokens) {
            if (!(token instanceof TextToken) || generator instanceof XmlZenCodingGenerator) continue;
            return false;
        }
        return true;
    }

    public static boolean checkTemplateKey(@NotNull String key, CustomTemplateCallback callback, @NotNull ZenCodingGenerator generator) {
        if (key == null) {
            ZenCodingTemplate.$$$reportNull$$$0(6);
        }
        if (generator == null) {
            ZenCodingTemplate.$$$reportNull$$$0(7);
        }
        return ZenCodingTemplate.parse(key, callback, generator, null) != null;
    }

    public final void expand(@NotNull String key, @NotNull CustomTemplateCallback callback) {
        if (key == null) {
            ZenCodingTemplate.$$$reportNull$$$0(8);
        }
        if (callback == null) {
            ZenCodingTemplate.$$$reportNull$$$0(9);
        }
        ZenCodingGenerator defaultGenerator = ZenCodingTemplate.findApplicableDefaultGenerator(callback, false);
        Editor editor = callback.getEditor();
        if (defaultGenerator == null) {
            LOG.error("Cannot find defaultGenerator for key `" + key + "` at " + editor.getCaretModel().getOffset() + " offset", new Attachment[]{CoreAttachmentFactory.createAttachment((Document)editor.getDocument())});
            return;
        }
        PsiFile file = callback.getFile();
        CaretModel caretModel = editor.getCaretModel();
        Project project2 = callback.getProject();
        Caret startCaret = caretModel.getCurrentCaret();
        ReadAction.nonBlocking(() -> {
            Ref result2 = Ref.create();
            ZenCodingTemplate.runForCaret(startCaret, editor, () -> {
                try {
                    CollectCustomTemplateCallback collectCallback = new CollectCustomTemplateCallback(editor, file);
                    ZenCodingTemplate.expand(key, collectCallback, defaultGenerator, Collections.emptyList(), true, Registry.intValue((String)"emmet.segments.limit"));
                    result2.set((Object)collectCallback);
                }
                catch (EmmetException e) {
                    CommonRefactoringUtil.showErrorHint((Project)project2, (Editor)editor, (String)e.getMessage(), (String)XmlBundle.message((String)"emmet.error", (Object[])new Object[0]), (String)"");
                }
            });
            return (CollectCustomTemplateCallback)((Object)((Object)result2.get()));
        }).finishOnUiThread(ModalityState.current(), collectCallback -> {
            if (collectCallback == null) {
                return;
            }
            TemplateImpl template = collectCallback.getGeneratedTemplate();
            if (template == null) {
                return;
            }
            ZenCodingTemplate.writeActionForCaret(startCaret, editor, file, () -> {
                callback.deleteTemplateKey(key);
                callback.startTemplate((Template)template, null, null);
                PsiDocumentManager.getInstance((Project)project2).commitDocument(editor.getDocument());
            });
        }).expireWhen(() -> editor.isDisposed() || !file.isValid() || !startCaret.isValid()).submit((Executor)EMMET_EXECUTOR);
    }

    private static void writeActionForCaret(Caret startCaret, @NotNull Editor editor, @NotNull PsiFile file, @NotNull Runnable command) {
        if (editor == null) {
            ZenCodingTemplate.$$$reportNull$$$0(10);
        }
        if (file == null) {
            ZenCodingTemplate.$$$reportNull$$$0(11);
        }
        if (command == null) {
            ZenCodingTemplate.$$$reportNull$$$0(12);
        }
        ZenCodingTemplate.runForCaret(startCaret, editor, () -> {
            CaretModel model2 = editor.getCaretModel();
            if (model2.getCaretCount() == 0) {
                WriteCommandAction.writeCommandAction((Project)editor.getProject(), (PsiFile[])new PsiFile[]{file}).run(() -> command.run());
            } else {
                DocumentUtil.writeInRunUndoTransparentAction((Runnable)command);
            }
        });
    }

    private static void runForCaret(@NotNull Caret caret, Editor editor, Runnable runnable) {
        if (caret == null) {
            ZenCodingTemplate.$$$reportNull$$$0(13);
        }
        editor.getCaretModel().runForEachCaret(candidate -> {
            if (candidate != caret) {
                return;
            }
            runnable.run();
        });
    }

    @Nullable
    private static ZenCodingGenerator findApplicableGenerator(ZenCodingNode node, CustomTemplateCallback callback, boolean wrapping) {
        ZenCodingGenerator defaultGenerator = null;
        List<ZenCodingGenerator> generators = ZenCodingGenerator.getInstances();
        PsiElement context = callback.getContext();
        for (ZenCodingGenerator generator : generators) {
            if (!generator.isMyContext(callback, wrapping) || !generator.isAppliedByDefault(context)) continue;
            defaultGenerator = generator;
            break;
        }
        while (node instanceof FilterNode) {
            FilterNode filterNode = (FilterNode)node;
            String suffix = filterNode.getFilter();
            for (ZenCodingGenerator generator : generators) {
                if (!generator.isMyContext(callback, wrapping) || suffix == null || !suffix.equals(generator.getSuffix())) continue;
                return generator;
            }
            node = filterNode.getNode();
        }
        return defaultGenerator;
    }

    @NotNull
    private static List<ZenCodingFilter> getFilters(ZenCodingNode node, PsiElement context) {
        ArrayList<ZenCodingFilter> result2 = new ArrayList<ZenCodingFilter>();
        while (node instanceof FilterNode) {
            FilterNode filterNode = (FilterNode)node;
            String filterSuffix = filterNode.getFilter();
            for (ZenCodingFilter filter : ZenCodingFilter.getInstances()) {
                if (!filter.isMyContext(context) || !filter.getSuffix().equals(filterSuffix)) continue;
                result2.add(filter);
            }
            node = filterNode.getNode();
        }
        for (ZenCodingFilter filter : ZenCodingFilter.getInstances()) {
            if (!filter.isMyContext(context) || !filter.isAppliedByDefault(context)) continue;
            result2.add(filter);
        }
        Collections.reverse(result2);
        ArrayList<ZenCodingFilter> arrayList = result2;
        if (arrayList == null) {
            ZenCodingTemplate.$$$reportNull$$$0(14);
        }
        return arrayList;
    }

    public static void expand(@NotNull String key, @NotNull CustomTemplateCallback callback, @NotNull ZenCodingGenerator defaultGenerator, @NotNull Collection<? extends ZenCodingFilter> extraFilters, boolean expandPrimitiveAbbreviations, int segmentsLimit) throws EmmetException {
        if (key == null) {
            ZenCodingTemplate.$$$reportNull$$$0(15);
        }
        if (callback == null) {
            ZenCodingTemplate.$$$reportNull$$$0(16);
        }
        if (defaultGenerator == null) {
            ZenCodingTemplate.$$$reportNull$$$0(17);
        }
        if (extraFilters == null) {
            ZenCodingTemplate.$$$reportNull$$$0(18);
        }
        ApplicationManager.getApplication().assertIsNonDispatchThread();
        ZenCodingNode node = ZenCodingTemplate.parse(key, callback, defaultGenerator, null);
        if (node == null) {
            return;
        }
        if (node instanceof TemplateNode && key.equals(((TemplateNode)node).getTemplateToken().getKey()) && callback.findApplicableTemplates(key).size() > 1) {
            Map template2Argument;
            TemplateManagerImpl templateManager = (TemplateManagerImpl)callback.getTemplateManager();
            Runnable runnable = templateManager.startNonCustomTemplates(template2Argument = templateManager.findMatchingTemplates(callback.getFile(), callback.getEditor(), null, TemplateSettings.getInstance()), callback.getEditor(), null);
            if (runnable != null) {
                ApplicationManager.getApplication().invokeLater(runnable);
            }
            return;
        }
        PsiElement context = callback.getContext();
        ZenCodingGenerator generator = (ZenCodingGenerator)ObjectUtils.notNull((Object)ZenCodingTemplate.findApplicableGenerator(node, callback, false), (Object)defaultGenerator);
        List<ZenCodingFilter> filters = ZenCodingTemplate.getFilters(node, context);
        filters.addAll(extraFilters);
        ZenCodingTemplate.checkTemplateOutputLength(node, callback);
        callback.deleteTemplateKey(key);
        ZenCodingTemplate.expand(node, generator, filters, null, callback, expandPrimitiveAbbreviations, segmentsLimit);
    }

    private static void expand(ZenCodingNode node, ZenCodingGenerator generator, List<ZenCodingFilter> filters, String surroundedText, CustomTemplateCallback callback, boolean expandPrimitiveAbbreviations, int segmentsLimit) throws EmmetException {
        ZenCodingTemplate.checkTemplateOutputLength(node, callback);
        GenerationNode fakeParentNode = new GenerationNode(TemplateToken.EMPTY_TEMPLATE_TOKEN, -1, 1, surroundedText, true, null);
        node.expand(-1, 1, surroundedText, callback, true, fakeParentNode);
        if (!expandPrimitiveAbbreviations && ZenCodingTemplate.isPrimitiveNode(node)) {
            return;
        }
        List<GenerationNode> genNodes = fakeParentNode.getChildren();
        LiveTemplateBuilder builder2 = new LiveTemplateBuilder(EmmetOptions.getInstance().isAddEditPointAtTheEndOfTemplate(), segmentsLimit);
        int end = -1;
        int genNodesSize = genNodes.size();
        for (int i = 0; i < genNodesSize; ++i) {
            GenerationNode genNode = genNodes.get(i);
            TemplateImpl template = genNode.generate(callback, generator, filters, true, segmentsLimit);
            int e = builder2.insertTemplate(builder2.length(), template, null);
            if (i < genNodesSize - 1 && genNode.isInsertNewLineBetweenNodes()) {
                builder2.insertText(e, "\n", false);
                ++e;
            }
            if (end != -1 || end >= builder2.length()) continue;
            end = e;
        }
        for (ZenCodingFilter filter : filters) {
            if (!(filter instanceof SingleLineEmmetFilter)) continue;
            builder2.setIsToReformat(false);
            break;
        }
        callback.startTemplate((Template)builder2.buildTemplate(), null, null);
    }

    private static void checkTemplateOutputLength(ZenCodingNode node, CustomTemplateCallback callback) throws EmmetException {
        int predictedOutputLength = node.getApproximateOutputLength(callback);
        if (predictedOutputLength > 15360) {
            throw new EmmetException();
        }
    }

    private static boolean isPrimitiveNode(@NotNull ZenCodingNode node) {
        TemplateToken token;
        if (node == null) {
            ZenCodingTemplate.$$$reportNull$$$0(19);
        }
        if (node instanceof TemplateNode && (token = ((TemplateNode)node).getTemplateToken()) != null) {
            Map<String, String> attributes = token.getAttributes();
            return attributes.isEmpty() || attributes.containsKey("class") && StringUtil.isEmpty((String)attributes.get("class"));
        }
        return false;
    }

    public void wrap(@NotNull String selection, final @NotNull CustomTemplateCallback callback) {
        if (selection == null) {
            ZenCodingTemplate.$$$reportNull$$$0(20);
        }
        if (callback == null) {
            ZenCodingTemplate.$$$reportNull$$$0(21);
        }
        new EmmetAbbreviationBalloon(EMMET_RECENT_WRAP_ABBREVIATIONS_KEY, EMMET_LAST_WRAP_ABBREVIATIONS_KEY, new EmmetAbbreviationBalloon.Callback(){

            @Override
            public void onEnter(@NotNull String abbreviation) {
                if (abbreviation == null) {
                    1.$$$reportNull$$$0(0);
                }
                ZenCodingTemplate.doWrap(abbreviation, callback);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "abbreviation", "com/intellij/codeInsight/template/emmet/ZenCodingTemplate$1", "onEnter"));
            }
        }, CONTEXT_HELP).show(callback);
    }

    public static boolean checkTemplateKey(String inputString, CustomTemplateCallback callback) {
        ZenCodingGenerator generator = ZenCodingTemplate.findApplicableDefaultGenerator(callback, true);
        if (generator == null) {
            int offset = callback.getEditor().getCaretModel().getOffset();
            LOG.error("Emmet is disabled for context for file " + callback.getFileType().getName() + " in offset: " + offset, new Attachment[]{CoreAttachmentFactory.createAttachment((Document)callback.getEditor().getDocument())});
            return false;
        }
        return ZenCodingTemplate.checkTemplateKey(inputString, callback, generator);
    }

    public boolean isApplicable(@NotNull CustomTemplateCallback callback, int offset, boolean wrapping) {
        ZenCodingGenerator applicableGenerator;
        if (callback == null) {
            ZenCodingTemplate.$$$reportNull$$$0(22);
        }
        return (applicableGenerator = ZenCodingTemplate.findApplicableDefaultGenerator(callback, wrapping)) != null && applicableGenerator.isEnabled();
    }

    public boolean hasCompletionItem(@NotNull CustomTemplateCallback callback, int offset) {
        ZenCodingGenerator applicableGenerator;
        if (callback == null) {
            ZenCodingTemplate.$$$reportNull$$$0(23);
        }
        return (applicableGenerator = ZenCodingTemplate.findApplicableDefaultGenerator(callback, false)) != null && applicableGenerator.isEnabled() && applicableGenerator.hasCompletionItem();
    }

    public static void doWrap(@NotNull String abbreviation, @NotNull CustomTemplateCallback callback) {
        if (abbreviation == null) {
            ZenCodingTemplate.$$$reportNull$$$0(24);
        }
        if (callback == null) {
            ZenCodingTemplate.$$$reportNull$$$0(25);
        }
        ZenCodingGenerator defaultGenerator = ZenCodingTemplate.findApplicableDefaultGenerator(callback, true);
        assert (defaultGenerator != null);
        Editor editor = callback.getEditor();
        CaretModel model2 = editor.getCaretModel();
        model2.runForEachCaret(caret -> ZenCodingTemplate.doWrapForCaret(abbreviation, callback, caret, defaultGenerator));
    }

    private static void doWrapForCaret(@NotNull String abbreviation, @NotNull CustomTemplateCallback callback, @NotNull Caret startCaret, @NotNull ZenCodingGenerator defaultGenerator) {
        if (abbreviation == null) {
            ZenCodingTemplate.$$$reportNull$$$0(26);
        }
        if (callback == null) {
            ZenCodingTemplate.$$$reportNull$$$0(27);
        }
        if (startCaret == null) {
            ZenCodingTemplate.$$$reportNull$$$0(28);
        }
        if (defaultGenerator == null) {
            ZenCodingTemplate.$$$reportNull$$$0(29);
        }
        CollectCustomTemplateCallback collect2 = new CollectCustomTemplateCallback(callback.getEditor(), callback.getFile());
        Editor editor = callback.getEditor();
        ReadAction.nonBlocking(() -> {
            Ref result2 = Ref.create((Object)Boolean.FALSE);
            ZenCodingTemplate.runForCaret(startCaret, editor, () -> {
                String selectedText = editor.getSelectionModel().getSelectedText();
                if (selectedText == null) {
                    return;
                }
                ZenCodingNode node = ZenCodingTemplate.parse(abbreviation, callback, defaultGenerator, selectedText);
                assert (node != null);
                PsiElement context = callback.getContext();
                ZenCodingGenerator generator = ZenCodingTemplate.findApplicableGenerator(node, callback, true);
                List<ZenCodingFilter> filters = ZenCodingTemplate.getFilters(node, context);
                try {
                    ZenCodingTemplate.expand(node, generator, filters, selectedText, collect2, true, Registry.intValue((String)"emmet.segments.limit"));
                    result2.set((Object)true);
                }
                catch (EmmetException e) {
                    CommonRefactoringUtil.showErrorHint((Project)callback.getProject(), (Editor)editor, (String)e.getMessage(), (String)XmlBundle.message((String)"emmet.error", (Object[])new Object[0]), (String)"");
                }
            });
            return (Boolean)result2.get() != false ? collect2 : null;
        }).finishOnUiThread(ModalityState.current(), result2 -> {
            if (result2 == null) {
                return;
            }
            TemplateImpl template = result2.getGeneratedTemplate();
            if (template == null) {
                return;
            }
            ZenCodingTemplate.writeActionForCaret(startCaret, editor, callback.getFile(), () -> {
                EditorModificationUtilEx.deleteSelectedText((Editor)editor);
                PsiDocumentManager.getInstance((Project)callback.getProject()).commitDocument(editor.getDocument());
                callback.startTemplate((Template)template, null, null);
            });
        }).submit((Executor)EMMET_EXECUTOR);
    }

    @NotNull
    public String getTitle() {
        String string = XmlBundle.message((String)"emmet.title", (Object[])new Object[0]);
        if (string == null) {
            ZenCodingTemplate.$$$reportNull$$$0(30);
        }
        return string;
    }

    public char getShortcut() {
        return (char)EmmetOptions.getInstance().getEmmetExpandShortcut();
    }

    public String computeTemplateKey(@NotNull CustomTemplateCallback callback) {
        ZenCodingGenerator generator;
        if (callback == null) {
            ZenCodingTemplate.$$$reportNull$$$0(31);
        }
        if ((generator = ZenCodingTemplate.findApplicableDefaultGenerator(callback, false)) == null) {
            return null;
        }
        return generator.computeTemplateKey(callback);
    }

    public boolean supportsWrapping() {
        return true;
    }

    public void addCompletions(CompletionParameters parameters, CompletionResultSet result2) {
        if (!parameters.isAutoPopup()) {
            return;
        }
        PsiFile file = parameters.getPosition().getContainingFile();
        int offset = parameters.getOffset();
        Editor editor = parameters.getEditor();
        CollectCustomTemplateCallback callback = new CollectCustomTemplateCallback(editor, file);
        ZenCodingGenerator generator = ZenCodingTemplate.findApplicableDefaultGenerator(callback, false);
        if (generator != null && generator.addToCompletion()) {
            String templatePrefix = this.computeTemplateKeyWithoutContextChecking(callback);
            if (templatePrefix != null) {
                List regularTemplates = TemplateManagerImpl.listApplicableTemplates((TemplateActionContext)TemplateActionContext.expanding((PsiFile)file, (int)offset));
                boolean regularTemplateWithSamePrefixExists = !ContainerUtil.filter((Collection)regularTemplates, template -> templatePrefix.equals(template.getKey())).isEmpty();
                result2 = result2.withPrefixMatcher(result2.getPrefixMatcher().cloneWithPrefix(templatePrefix));
                result2.restartCompletionOnPrefixChange((ElementPattern)StandardPatterns.string().startsWith(templatePrefix));
                if (!regularTemplateWithSamePrefixExists) {
                    LinkedList extraFilters = ContainerUtil.newLinkedList((Object[])new SingleLineEmmetFilter[]{new SingleLineEmmetFilter()});
                    try {
                        ZenCodingTemplate.expand(templatePrefix, callback, generator, extraFilters, false, 0);
                    }
                    catch (EmmetException emmetException) {
                        // empty catch block
                    }
                    TemplateImpl template2 = callback.getGeneratedTemplate();
                    if (template2 != null) {
                        template2.setKey(templatePrefix);
                        template2.setDescription(template2.getTemplateText());
                        CustomLiveTemplateLookupElement lookupElement = new CustomLiveTemplateLookupElement(this, template2.getKey(), template2.getKey(), template2.getDescription(), !LiveTemplateCompletionContributor.shouldShowAllTemplates(), true){

                            public void renderElement(@NotNull LookupElementPresentation presentation) {
                                if (presentation == null) {
                                    2.$$$reportNull$$$0(0);
                                }
                                super.renderElement(presentation);
                                presentation.setTailText("\t Emmet abbreviation", true);
                            }

                            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentation", "com/intellij/codeInsight/template/emmet/ZenCodingTemplate$2", "renderElement"));
                            }
                        };
                        result2.addElement((LookupElement)lookupElement);
                    }
                }
            } else if (result2.getPrefixMatcher().getPrefix().isEmpty()) {
                result2.restartCompletionOnPrefixChange((ElementPattern)StandardPatterns.string().longerThan(0));
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 14, 30 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generator";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokens";
                break;
            }
            case 6: 
            case 8: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caret";
                break;
            }
            case 14: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/template/emmet/ZenCodingTemplate";
                break;
            }
            case 17: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultGenerator";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extraFilters";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selection";
                break;
            }
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "abbreviation";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startCaret";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/template/emmet/ZenCodingTemplate";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilters";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getTitle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findApplicableDefaultGenerator";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "validate";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "checkTemplateKey";
                break;
            }
            case 8: 
            case 9: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "expand";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "writeActionForCaret";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "runForCaret";
                break;
            }
            case 14: 
            case 30: {
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isPrimitiveNode";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "wrap";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isApplicable";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "hasCompletionItem";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "doWrap";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "doWrapForCaret";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "computeTemplateKey";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 14, 30 -> new IllegalStateException(string);
        };
    }
}

