/**
 * Mandelbulber v2, a 3D fractal generator  _%}}i*<.        ____                _______
 * Copyright (C) 2021 Mandelbulber Team   _>]|=||i=i<,     / __ \___  ___ ___  / ___/ /
 *                                        \><||i|=>>%)    / /_/ / _ \/ -_) _ \/ /__/ /__
 * This file is part of Mandelbulber.     )<=i=]=|=i<>    \____/ .__/\__/_//_/\___/____/
 * The project is licensed under GPLv3,   -<>>=|><|||`        /_/
 * see also COPYING file in this folder.    ~+{i%+++
 *
 * Isosurface invented and shared by Alex Kluchikov (22 Aug 2003).
 * Based on darkbeams version @reference
 * http://www.fractalforums.com/mandelbulb-3d/custom-formulas-and-transforms-release-t17106/

 * This file has been autogenerated by tools/populateUiInformation.php
 * from the file "fractal_transf_difs_heart.cpp" in the folder formula/definition
 * D O    N O T    E D I T    T H I S    F I L E !
 */

REAL4 TransfDIFSHeartIteration(REAL4 z, __constant sFractalCl *fractal, sExtendedAuxCl *aux)
{
	if (fractal->transformCommon.functionEnabledFalse)
	{
		if (fractal->transformCommon.functionEnabledxFalse) z.x = fabs(z.x);
		if (fractal->transformCommon.functionEnabledyFalse) z.y = fabs(z.y);
		if (fractal->transformCommon.functionEnabledzFalse) z.z = fabs(z.z);
		z += fractal->transformCommon.offsetA000;
		z = Matrix33MulFloat4(fractal->transformCommon.rotationMatrix, z);
		z *= fractal->transformCommon.scale1;
		aux->DE *= fractal->transformCommon.scale1;
	}

	REAL4 zc = z;
	if (fractal->transformCommon.functionEnabledDFalse)
	{
		zc.y = fabs(zc.y);
		REAL psi = M_PI_F / fractal->transformCommon.int8Z;
		psi = fabs(fmod(atan2(zc.y, zc.x) + psi, 2.0f * psi) - psi);
		REAL len = native_sqrt(zc.y * zc.y + zc.x * zc.x);
		if (!fractal->transformCommon.functionEnabledEFalse)
		{
			zc.x = native_cos(psi) * len;
			zc.y = native_sin(psi) * len;
		}
		else
		{
			REAL cz = native_cos(psi) * len;
			REAL sz = native_sin(psi) * len;
			zc.x = sz + (cz - sz) * fractal->transformCommon.scaleF1;
			zc.y = cz + (sz - cz) * fractal->transformCommon.scaleG1;
		}
	}

	if (fractal->transformCommon.rotation2EnabledFalse)
	{
		zc = Matrix33MulFloat4(fractal->transformCommon.rotationMatrix2, zc);
	}

	REAL p = (zc.z + fractal->transformCommon.offset105);
	p *= p;
	p = zc.x * zc.x
			+ fractal->transformCommon.scale025 * zc.y * zc.y
					/ (p * p + fractal->transformCommon.offsetp01);
	p = fabs(zc.z * fractal->transformCommon.scale1p1
					 - fractal->transformCommon.scale08 * native_sqrt(native_sqrt(p)));

	aux->DE0 = (native_sqrt(fractal->transformCommon.scale4 * zc.y * zc.y + zc.x * zc.x + p * p)
							 - fractal->transformCommon.offset1)
						 / (aux->DE + fractal->analyticDE.offset1);

	REAL col = aux->dist;

	if (!fractal->analyticDE.enabledFalse)
		aux->dist = min(aux->dist, aux->DE0);
	else
		aux->dist = aux->DE0;

	if (fractal->foldColor.auxColorEnabled)
	{
		REAL colorAdd = 0.0f;
		if (aux->dist == col) colorAdd += fractal->foldColor.difs0000.x;
		colorAdd += fractal->foldColor.difs0000.y * zc.z;
		colorAdd += fractal->foldColor.difs0000.z * fabs(zc.x);
		colorAdd += fractal->foldColor.difs0000.w * fabs(zc.y);
		if (!fractal->foldColor.auxColorEnabledFalse)
			aux->color = colorAdd;
		else
			aux->color += colorAdd;
	}
	if (fractal->transformCommon.functionEnabledYFalse) z = zc;
	return z;
}