/**
 * Mandelbulber v2, a 3D fractal generator  _%}}i*<.        ____                _______
 * Copyright (C) 2023 Mandelbulber Team   _>]|=||i=i<,     / __ \___  ___ ___  / ___/ /
 *                                        \><||i|=>>%)    / /_/ / _ \/ -_) _ \/ /__/ /__
 * This file is part of Mandelbulber.     )<=i=]=|=i<>    \____/ .__/\__/_//_/\___/____/
 * The project is licensed under GPLv3,   -<>>=|><|||`        /_/
 * see also COPYING file in this folder.    ~+{i%+++
 *
 * mandelbulbPupuku
 * @reference polar cartesian variation be Pupukuusikko
 * https://https://fractalforums.org/share-a-fractal/22/mandelbulb-fixed/5099

 * This file has been autogenerated by tools/populateUiInformation.php
 * from the file "fractal_mandelbulb_pupuku.cpp" in the folder formula/definition
 * D O    N O T    E D I T    T H I S    F I L E !
 */

REAL4 MandelbulbPupukuIteration(REAL4 z, __constant sFractalCl *fractal, sExtendedAuxCl *aux)
{
	REAL t; // temp
	if (fractal->transformCommon.functionEnabledPFalse
			&& aux->i >= fractal->transformCommon.startIterationsP
			&& aux->i < fractal->transformCommon.stopIterationsP)
	{
		if (fractal->transformCommon.functionEnabledCxFalse) z.x = fabs(z.x);
		if (fractal->transformCommon.functionEnabledCyFalse) z.y = fabs(z.y);
		if (fractal->transformCommon.functionEnabledCzFalse) z.z = fabs(z.z);
		z += fractal->transformCommon.offsetA000;

		if (fractal->transformCommon.functionEnabledTFalse)
		{
			aux->r = length(z);
		}
	}

	if (!fractal->transformCommon.functionEnabledSwFalse)
		t = asin(z.z / aux->r);
	else
		t = acos(z.z / aux->r);
	REAL th =
		(t + fractal->bulb.betaAngleOffset) * fractal->bulb.power * fractal->transformCommon.scaleA1;
	REAL ph = (atan2(z.y, z.x) + fractal->bulb.alphaAngleOffset) * fractal->bulb.power
						* fractal->transformCommon.scaleB1;
	REAL rp = pow(aux->r, fractal->bulb.power - fractal->transformCommon.offset1);

	if (fractal->transformCommon.functionEnabledXFalse
			&& aux->i >= fractal->transformCommon.startIterationsX
			&& aux->i < fractal->transformCommon.stopIterationsX)
	{
		if (native_cos(th) < 0.0f) ph = ph + M_PI_F;
	}

	aux->DE = rp * aux->DE * fabs(fractal->bulb.power) + fractal->analyticDE.offset1;
	rp *= aux->r;

	// polar to cartesian
	REAL zth;
	if (!fractal->transformCommon.functionEnabledDFalse)
	{
		t = native_cos(th);
		zth = native_sin(th);
	}
	else
	{
		t = native_sin(th);
		zth = native_cos(th);
	}
	if (fractal->transformCommon.functionEnabledBFalse
			&& aux->i >= fractal->transformCommon.startIterationsB
			&& aux->i < fractal->transformCommon.stopIterationsB)
	{
		z.x = (1.0f + (t - 1.0f) * fractal->transformCommon.scaleB0) * native_cos(ph);
	}
	else
	{
		z.x = t * native_cos(ph);
	}
	if (fractal->transformCommon.functionEnabledAFalse
			&& aux->i >= fractal->transformCommon.startIterationsA
			&& aux->i < fractal->transformCommon.stopIterationsA)
	{
		z.y = (1.0f + (t - 1.0f) * fractal->transformCommon.scaleA0) * native_sin(ph);
	}
	else
	{
		z.y = t * native_sin(ph);
	}
	z.z = zth;
	z *= rp;

	if (fractal->transformCommon.functionEnabledBzFalse)
		z.y = min(z.y, fractal->transformCommon.offset0 - z.y);

	z += fractal->transformCommon.offset000;

	if (aux->i >= fractal->transformCommon.startIterationsS
			&& aux->i < fractal->transformCommon.stopIterationsS)
	{
		z *= fractal->transformCommon.scaleC1;
		aux->DE *= fabs(fractal->transformCommon.scaleC1);
	}

	if (fractal->analyticDE.enabledFalse)
		aux->DE = aux->DE * fractal->analyticDE.scale1 + fractal->analyticDE.offset0;

	if (fractal->transformCommon.functionEnabledCFalse)
	{
		aux->DE0 = length(z);

		if (aux->DE0 > 1.0f)
		{
			aux->DE0 = 0.5f * log(aux->DE0) * aux->DE0 / aux->DE;
		}
		else
		{
			aux->DE0 = 0.0f; // 0.01f artifacts in openCL
		}

		if (!fractal->transformCommon.functionEnabledEFalse)
		{
			aux->dist = aux->DE0;
		}
		else
		{
			if (aux->i >= fractal->transformCommon.startIterationsE
					&& aux->i < fractal->transformCommon.stopIterationsE)
			{
				aux->dist = min(aux->dist, aux->DE0);
			}
			else
			{
				aux->dist = aux->DE0;
			}
		}
	}
	return z;
}