/*
 * Decompiled with CFR 0.152.
 */
package mill.main.client;

import java.io.Console;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Util {
    public static boolean isWindows = Util.lowerCaseOsName().startsWith("windows");
    public static boolean isLinux = Util.lowerCaseOsName().equals("linux");
    public static boolean isJava9OrAbove = !System.getProperty("java.specification.version").startsWith("1.");
    private static Charset utf8 = Charset.forName("UTF-8");
    private static Pattern envInterpolatorPattern = Pattern.compile("\\$\\{(\\$|[A-Z_][A-Z0-9_]*)\\}");

    public static final int ExitClientCodeCannotReadFromExitCodeFile() {
        return 1;
    }

    public static final int ExitServerCodeWhenIdle() {
        return 0;
    }

    public static final int ExitServerCodeWhenVersionMismatch() {
        return 101;
    }

    private static String lowerCaseOsName() {
        return System.getProperty("os.name").toLowerCase();
    }

    public static boolean hasConsole() {
        Console console = System.console();
        if (console != null) {
            try {
                Method method = console.getClass().getMethod("isTerminal", new Class[0]);
                return (Boolean)method.invoke((Object)console, new Object[0]);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
                return true;
            }
        }
        return false;
    }

    public static String[] parseArgs(InputStream inputStream) throws IOException {
        int n = Util.readInt(inputStream);
        String[] stringArray = new String[n];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = Util.readString(inputStream);
        }
        return stringArray;
    }

    public static void writeArgs(String[] stringArray, OutputStream outputStream) throws IOException {
        Util.writeInt(outputStream, stringArray.length);
        for (String string : stringArray) {
            Util.writeString(outputStream, string);
        }
    }

    public static void writeMap(Map<String, String> map, OutputStream outputStream) throws IOException {
        Util.writeInt(outputStream, map.size());
        for (Map.Entry<String, String> entry : map.entrySet()) {
            Util.writeString(outputStream, entry.getKey());
            Util.writeString(outputStream, entry.getValue());
        }
    }

    public static Map<String, String> parseMap(InputStream inputStream) throws IOException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        int n = Util.readInt(inputStream);
        for (int i = 0; i < n; ++i) {
            String string = Util.readString(inputStream);
            String string2 = Util.readString(inputStream);
            hashMap.put(string, string2);
        }
        return hashMap;
    }

    public static String readString(InputStream inputStream) throws IOException {
        int n;
        int n2 = Util.readInt(inputStream);
        byte[] byArray = new byte[n2];
        for (int i = 0; i < n2; i += n) {
            n = inputStream.read(byArray, i, n2 - i);
            if (n != -1) continue;
            throw new IOException("Incomplete String");
        }
        return new String(byArray, utf8);
    }

    public static void writeString(OutputStream outputStream, String string) throws IOException {
        byte[] byArray = string.getBytes(utf8);
        Util.writeInt(outputStream, byArray.length);
        outputStream.write(byArray);
    }

    public static void writeInt(OutputStream outputStream, int n) throws IOException {
        outputStream.write((byte)(n >>> 24));
        outputStream.write((byte)(n >>> 16));
        outputStream.write((byte)(n >>> 8));
        outputStream.write((byte)n);
    }

    public static int readInt(InputStream inputStream) throws IOException {
        return ((inputStream.read() & 0xFF) << 24) + ((inputStream.read() & 0xFF) << 16) + ((inputStream.read() & 0xFF) << 8) + (inputStream.read() & 0xFF);
    }

    public static String md5hex(String string) throws NoSuchAlgorithmException {
        return Util.hexArray(MessageDigest.getInstance("md5").digest(string.getBytes(StandardCharsets.UTF_8)));
    }

    private static String hexArray(byte[] byArray) {
        return String.format("%0" + (byArray.length << 1) + "x", new BigInteger(1, byArray));
    }

    public static String sha1Hash(String string) throws NoSuchAlgorithmException {
        MessageDigest messageDigest = MessageDigest.getInstance("SHA1");
        messageDigest.reset();
        byte[] byArray = string.getBytes(StandardCharsets.UTF_8);
        messageDigest.update(byArray);
        byte[] byArray2 = messageDigest.digest();
        return Util.hexArray(byArray2);
    }

    public static List<String> readOptsFileLines(Path path) throws Exception {
        LinkedList<String> linkedList = new LinkedList<String>();
        try (Scanner scanner = new Scanner(path.toFile());){
            Map<String, String> map = System.getenv();
            while (scanner.hasNextLine()) {
                String string = scanner.nextLine();
                String string2 = string.trim();
                if (string2.isEmpty() || string2.startsWith("#")) continue;
                linkedList.add(Util.interpolateEnvVars(string, map));
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        return linkedList;
    }

    public static String interpolateEnvVars(String string, Map<String, String> map) throws Exception {
        Matcher matcher = envInterpolatorPattern.matcher(string);
        StringBuffer stringBuffer = new StringBuffer();
        while (matcher.find()) {
            String string2 = matcher.group(1);
            if (string2.equals("$")) {
                matcher.appendReplacement(stringBuffer, "\\$");
                continue;
            }
            String string3 = string2.equals("PWD") ? new File(".").getAbsoluteFile().getCanonicalPath() : (map.containsKey(string2) ? map.get(string2) : "");
            matcher.appendReplacement(stringBuffer, string3);
        }
        matcher.appendTail(stringBuffer);
        return stringBuffer.toString();
    }
}

