/*
 * Decompiled with CFR 0.152.
 */
package coursierapi.shaded.commonsio;

import coursierapi.shaded.commonsio.StandardLineSeparator;
import coursierapi.shaded.commonsio.function.IOConsumer;
import coursierapi.shaded.commonsio.function.IOTriFunction;
import coursierapi.shaded.commonsio.output.ThresholdingOutputStream;
import coursierapi.shaded.commonsio.output.UnsynchronizedByteArrayOutputStream;
import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class IOUtils {
    public static final char DIR_SEPARATOR = File.separatorChar;
    public static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    @Deprecated
    public static final String LINE_SEPARATOR = System.lineSeparator();
    public static final String LINE_SEPARATOR_UNIX = StandardLineSeparator.LF.getString();
    public static final String LINE_SEPARATOR_WINDOWS = StandardLineSeparator.CRLF.getString();
    private static final ThreadLocal<byte[]> SCRATCH_BYTE_BUFFER_RW = ThreadLocal.withInitial(IOUtils::byteArray);
    private static final byte[] SCRATCH_BYTE_BUFFER_WO = IOUtils.byteArray();
    private static final ThreadLocal<char[]> SCRATCH_CHAR_BUFFER_RW = ThreadLocal.withInitial(IOUtils::charArray);
    private static final char[] SCRATCH_CHAR_BUFFER_WO = IOUtils.charArray();

    public static byte[] byteArray() {
        return IOUtils.byteArray(8192);
    }

    public static byte[] byteArray(int size2) {
        return new byte[size2];
    }

    private static char[] charArray() {
        return IOUtils.charArray(8192);
    }

    private static char[] charArray(int size2) {
        return new char[size2];
    }

    public static void close(Closeable closeable, IOConsumer<IOException> consumer) throws IOException {
        block3: {
            if (closeable != null) {
                try {
                    closeable.close();
                }
                catch (IOException e) {
                    if (consumer == null) break block3;
                    consumer.accept(e);
                }
            }
        }
    }

    public static void closeQuietly(Closeable closeable) {
        IOUtils.closeQuietly(closeable, null);
    }

    public static void closeQuietly(Closeable closeable, Consumer<IOException> consumer) {
        block3: {
            if (closeable != null) {
                try {
                    closeable.close();
                }
                catch (IOException e) {
                    if (consumer == null) break block3;
                    consumer.accept(e);
                }
            }
        }
    }

    public static int copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        long count = IOUtils.copyLarge(inputStream, outputStream);
        return count > Integer.MAX_VALUE ? -1 : (int)count;
    }

    public static long copy(InputStream inputStream, OutputStream outputStream, int bufferSize) throws IOException {
        return IOUtils.copyLarge(inputStream, outputStream, IOUtils.byteArray(bufferSize));
    }

    public static long copyLarge(InputStream inputStream, OutputStream outputStream) throws IOException {
        return IOUtils.copy(inputStream, outputStream, 8192);
    }

    public static long copyLarge(InputStream inputStream, OutputStream outputStream, byte[] buffer) throws IOException {
        int n;
        Objects.requireNonNull(inputStream, "inputStream");
        Objects.requireNonNull(outputStream, "outputStream");
        long count = 0L;
        while (-1 != (n = inputStream.read(buffer))) {
            outputStream.write(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }

    public static long copyLarge(InputStream input, OutputStream output, long inputOffset, long length) throws IOException {
        return IOUtils.copyLarge(input, output, inputOffset, length, IOUtils.getScratchByteArray());
    }

    public static long copyLarge(InputStream input, OutputStream output, long inputOffset, long length, byte[] buffer) throws IOException {
        int read2;
        int bufferLength;
        if (inputOffset > 0L) {
            IOUtils.skipFully(input, inputOffset);
        }
        if (length == 0L) {
            return 0L;
        }
        int bytesToRead = bufferLength = buffer.length;
        if (length > 0L && length < (long)bufferLength) {
            bytesToRead = (int)length;
        }
        long totalRead = 0L;
        while (bytesToRead > 0 && -1 != (read2 = input.read(buffer, 0, bytesToRead))) {
            output.write(buffer, 0, read2);
            totalRead += (long)read2;
            if (length <= 0L) continue;
            bytesToRead = (int)Math.min(length - totalRead, (long)bufferLength);
        }
        return totalRead;
    }

    private static byte[] fill0(byte[] arr) {
        Arrays.fill(arr, (byte)0);
        return arr;
    }

    static byte[] getScratchByteArray() {
        return IOUtils.fill0(SCRATCH_BYTE_BUFFER_RW.get());
    }

    static byte[] getScratchByteArrayWriteOnly() {
        return IOUtils.fill0(SCRATCH_BYTE_BUFFER_WO);
    }

    public static int length(byte[] array) {
        return array == null ? 0 : array.length;
    }

    public static int read(InputStream input, byte[] buffer, int offset, int length) throws IOException {
        if (length == 0) {
            return 0;
        }
        return IOUtils.read(input::read, buffer, offset, length);
    }

    static int read(IOTriFunction<byte[], Integer, Integer, Integer> input, byte[] buffer, int offset, int length) throws IOException {
        int location;
        int remaining;
        int count;
        if (length < 0) {
            throw new IllegalArgumentException("Length must not be negative: " + length);
        }
        for (remaining = length; remaining > 0 && -1 != (count = input.apply(buffer, offset + (location = length - remaining), remaining).intValue()); remaining -= count) {
        }
        return length - remaining;
    }

    public static int read(ReadableByteChannel input, ByteBuffer buffer) throws IOException {
        int count;
        int length = buffer.remaining();
        while (buffer.remaining() > 0 && -1 != (count = input.read(buffer))) {
        }
        return length - buffer.remaining();
    }

    public static long skip(InputStream input, long toSkip) throws IOException {
        return IOUtils.skip(input, toSkip, IOUtils::getScratchByteArrayWriteOnly);
    }

    public static long skip(InputStream input, long toSkip, Supplier<byte[]> skipBufferSupplier) throws IOException {
        byte[] skipBuffer;
        long remain;
        long n;
        if (toSkip < 0L) {
            throw new IllegalArgumentException("Skip count must be non-negative, actual: " + toSkip);
        }
        for (remain = toSkip; remain > 0L && (n = (long)input.read(skipBuffer = skipBufferSupplier.get(), 0, (int)Math.min(remain, (long)skipBuffer.length))) >= 0L; remain -= n) {
        }
        return toSkip - remain;
    }

    public static void skipFully(InputStream input, long toSkip) throws IOException {
        long skipped = IOUtils.skip(input, toSkip, IOUtils::getScratchByteArrayWriteOnly);
        if (skipped != toSkip) {
            throw new EOFException("Bytes to skip: " + toSkip + " actual: " + skipped);
        }
    }

    public static byte[] toByteArray(InputStream inputStream) throws IOException {
        try (UnsynchronizedByteArrayOutputStream ubaOutput = UnsynchronizedByteArrayOutputStream.builder().get();){
            byte[] byArray;
            try (ThresholdingOutputStream thresholdOutput = new ThresholdingOutputStream(Integer.MAX_VALUE, os -> {
                throw new IllegalArgumentException(String.format("Cannot read more than %,d into a byte array", Integer.MAX_VALUE));
            }, os -> ubaOutput);){
                IOUtils.copy(inputStream, thresholdOutput);
                byArray = ubaOutput.toByteArray();
            }
            return byArray;
        }
    }
}

