/*
 * Decompiled with CFR 0.152.
 */
package org.signal.libsignal.metadata.certificate;

import org.signal.libsignal.internal.Native;
import org.signal.libsignal.internal.NativeHandleGuard;
import org.signal.libsignal.metadata.certificate.InvalidCertificateException;
import org.signal.libsignal.metadata.certificate.SenderCertificate;
import org.signal.libsignal.metadata.certificate.ServerCertificate;
import org.signal.libsignal.protocol.InvalidKeyException;
import org.signal.libsignal.protocol.ecc.Curve;
import org.signal.libsignal.protocol.ecc.ECPublicKey;

public class CertificateValidator {
    private final ECPublicKey trustRoot;

    public CertificateValidator(ECPublicKey trustRoot) {
        this.trustRoot = trustRoot;
    }

    public ECPublicKey getTrustRoot() {
        return this.trustRoot;
    }

    public void validate(SenderCertificate certificate, long validationTime) throws InvalidCertificateException {
        try (NativeHandleGuard certificateGuard = new NativeHandleGuard(certificate);
             NativeHandleGuard trustRootGuard = new NativeHandleGuard(this.trustRoot);){
            if (!Native.SenderCertificate_Validate(certificateGuard.nativeHandle(), trustRootGuard.nativeHandle(), validationTime)) {
                throw new InvalidCertificateException("Validation failed");
            }
        }
        catch (Exception e) {
            throw new InvalidCertificateException(e);
        }
    }

    void validate(ServerCertificate certificate) throws InvalidCertificateException {
        try {
            if (!Curve.verifySignature(this.trustRoot, certificate.getCertificate(), certificate.getSignature())) {
                throw new InvalidCertificateException("Signature failed");
            }
        }
        catch (InvalidKeyException e) {
            throw new InvalidCertificateException(e);
        }
    }
}

