/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.api.groupsv2;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.signal.storageservice.protos.groups.local.DecryptedGroup;
import org.signal.storageservice.protos.groups.local.DecryptedGroupChange;
import org.whispersystems.signalservice.api.groupsv2.InvalidGroupStateException;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u000b\u0010\u000f\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u0010\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J!\u0010\u0011\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\fH\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0018"}, d2={"Lorg/whispersystems/signalservice/api/groupsv2/DecryptedGroupChangeLog;", "", "group", "Lorg/signal/storageservice/protos/groups/local/DecryptedGroup;", "change", "Lorg/signal/storageservice/protos/groups/local/DecryptedGroupChange;", "(Lorg/signal/storageservice/protos/groups/local/DecryptedGroup;Lorg/signal/storageservice/protos/groups/local/DecryptedGroupChange;)V", "getChange", "()Lorg/signal/storageservice/protos/groups/local/DecryptedGroupChange;", "getGroup", "()Lorg/signal/storageservice/protos/groups/local/DecryptedGroup;", "revision", "", "getRevision", "()I", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "signal-service-java"})
public final class DecryptedGroupChangeLog {
    @Nullable
    private final DecryptedGroup group;
    @Nullable
    private final DecryptedGroupChange change;

    public DecryptedGroupChangeLog(@Nullable DecryptedGroup group, @Nullable DecryptedGroupChange change) {
        this.group = group;
        this.change = change;
        if (this.group == null && this.change == null) {
            throw new InvalidGroupStateException("group and change are both null");
        }
        if (this.group != null && this.change != null && this.group.revision != this.change.revision) {
            throw new InvalidGroupStateException("group revision != change revision");
        }
    }

    @Nullable
    public final DecryptedGroup getGroup() {
        return this.group;
    }

    @Nullable
    public final DecryptedGroupChange getChange() {
        return this.change;
    }

    public final int getRevision() {
        int n;
        DecryptedGroup decryptedGroup = this.group;
        if (decryptedGroup != null) {
            n = decryptedGroup.revision;
        } else {
            DecryptedGroupChange decryptedGroupChange = this.change;
            Intrinsics.checkNotNull((Object)((Object)decryptedGroupChange));
            n = decryptedGroupChange.revision;
        }
        return n;
    }

    @Nullable
    public final DecryptedGroup component1() {
        return this.group;
    }

    @Nullable
    public final DecryptedGroupChange component2() {
        return this.change;
    }

    @NotNull
    public final DecryptedGroupChangeLog copy(@Nullable DecryptedGroup group, @Nullable DecryptedGroupChange change) {
        return new DecryptedGroupChangeLog(group, change);
    }

    public static /* synthetic */ DecryptedGroupChangeLog copy$default(DecryptedGroupChangeLog decryptedGroupChangeLog, DecryptedGroup decryptedGroup, DecryptedGroupChange decryptedGroupChange, int n, Object object) {
        if ((n & 1) != 0) {
            decryptedGroup = decryptedGroupChangeLog.group;
        }
        if ((n & 2) != 0) {
            decryptedGroupChange = decryptedGroupChangeLog.change;
        }
        return decryptedGroupChangeLog.copy(decryptedGroup, decryptedGroupChange);
    }

    @NotNull
    public String toString() {
        return "DecryptedGroupChangeLog(group=" + this.group + ", change=" + this.change + ")";
    }

    public int hashCode() {
        int result2 = this.group == null ? 0 : this.group.hashCode();
        result2 = result2 * 31 + (this.change == null ? 0 : this.change.hashCode());
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DecryptedGroupChangeLog)) {
            return false;
        }
        DecryptedGroupChangeLog decryptedGroupChangeLog = (DecryptedGroupChangeLog)other;
        if (!Intrinsics.areEqual((Object)((Object)this.group), (Object)((Object)decryptedGroupChangeLog.group))) {
            return false;
        }
        return Intrinsics.areEqual((Object)((Object)this.change), (Object)((Object)decryptedGroupChangeLog.change));
    }
}

