/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.manager.util;

import java.io.IOException;
import java.util.Locale;
import java.util.function.Consumer;
import org.asamk.signal.manager.api.CaptchaRequiredException;
import org.asamk.signal.manager.api.IncorrectPinException;
import org.asamk.signal.manager.api.NonNormalizedPhoneNumberException;
import org.asamk.signal.manager.api.Pair;
import org.asamk.signal.manager.api.PinLockedException;
import org.asamk.signal.manager.api.RateLimitException;
import org.asamk.signal.manager.api.VerificationMethodNotAvailableException;
import org.asamk.signal.manager.helper.PinHelper;
import org.asamk.signal.manager.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.whispersystems.signalservice.api.NetworkResult;
import org.whispersystems.signalservice.api.kbs.MasterKey;
import org.whispersystems.signalservice.api.push.exceptions.NoSuchSessionException;
import org.whispersystems.signalservice.api.push.exceptions.NonSuccessfulResponseCodeException;
import org.whispersystems.signalservice.api.push.exceptions.PushChallengeRequiredException;
import org.whispersystems.signalservice.api.push.exceptions.TokenNotAcceptedException;
import org.whispersystems.signalservice.api.registration.RegistrationApi;
import org.whispersystems.signalservice.api.svr.SecureValueRecovery;
import org.whispersystems.signalservice.internal.push.LockedException;
import org.whispersystems.signalservice.internal.push.PushServiceSocket;
import org.whispersystems.signalservice.internal.push.RegistrationSessionMetadataResponse;
import org.whispersystems.signalservice.internal.push.VerifyAccountResponse;

public class NumberVerificationUtils {
    private static final Logger logger = LoggerFactory.getLogger(NumberVerificationUtils.class);

    public static String handleVerificationSession(RegistrationApi registrationApi, String sessionId, Consumer<String> sessionIdSaver, boolean voiceVerification, String captcha) throws CaptchaRequiredException, IOException, RateLimitException, VerificationMethodNotAvailableException {
        Integer nextAttempt;
        RegistrationSessionMetadataResponse sessionResponse;
        try {
            sessionResponse = NumberVerificationUtils.getValidSession(registrationApi, sessionId);
        }
        catch (org.whispersystems.signalservice.api.push.exceptions.CaptchaRequiredException | PushChallengeRequiredException e) {
            if (captcha != null) {
                sessionResponse = NumberVerificationUtils.submitCaptcha(registrationApi, sessionId, captcha);
            }
            throw new CaptchaRequiredException("Captcha Required");
        }
        sessionId = sessionResponse.getBody().getId();
        sessionIdSaver.accept(sessionId);
        if (sessionResponse.getBody().getVerified()) {
            return sessionId;
        }
        if (sessionResponse.getBody().getAllowedToRequestCode()) {
            return sessionId;
        }
        Integer n = nextAttempt = voiceVerification ? sessionResponse.getBody().getNextCall() : sessionResponse.getBody().getNextSms();
        if (nextAttempt == null) {
            throw new VerificationMethodNotAvailableException();
        }
        if (nextAttempt > 0) {
            long timestamp = sessionResponse.getHeaders().getTimestamp() + (long)(nextAttempt * 1000);
            throw new RateLimitException(timestamp);
        }
        Integer nextVerificationAttempt = sessionResponse.getBody().getNextVerificationAttempt();
        if (nextVerificationAttempt != null && nextVerificationAttempt > 0) {
            long timestamp = sessionResponse.getHeaders().getTimestamp() + (long)(nextVerificationAttempt * 1000);
            throw new CaptchaRequiredException(timestamp);
        }
        if (sessionResponse.getBody().getRequestedInformation().contains("captcha")) {
            if (captcha != null) {
                sessionResponse = NumberVerificationUtils.submitCaptcha(registrationApi, sessionId, captcha);
            }
            if (!sessionResponse.getBody().getAllowedToRequestCode()) {
                throw new CaptchaRequiredException("Captcha Required");
            }
        }
        return sessionId;
    }

    public static void requestVerificationCode(RegistrationApi registrationApi, String sessionId, boolean voiceVerification) throws IOException, CaptchaRequiredException, NonNormalizedPhoneNumberException {
        Locale locale = Utils.getDefaultLocale(Locale.US);
        NetworkResult response = registrationApi.requestSmsVerificationCode(sessionId, locale, false, voiceVerification ? PushServiceSocket.VerificationCodeTransport.VOICE : PushServiceSocket.VerificationCodeTransport.SMS);
        try {
            Utils.handleResponseException(response);
        }
        catch (org.whispersystems.signalservice.api.push.exceptions.CaptchaRequiredException e) {
            throw new CaptchaRequiredException(e.getMessage(), e);
        }
        catch (org.whispersystems.signalservice.api.push.exceptions.NonNormalizedPhoneNumberException e) {
            throw new NonNormalizedPhoneNumberException("Phone number is not normalized (" + e.getMessage() + "). Expected normalized: " + e.getNormalizedNumber(), e);
        }
    }

    public static Pair<VerifyAccountResponse, MasterKey> verifyNumber(String sessionId, String verificationCode, String pin, PinHelper pinHelper, Verifier verifier) throws IOException, PinLockedException, IncorrectPinException {
        verificationCode = verificationCode.replace("-", "");
        try {
            VerifyAccountResponse response = verifier.verify(sessionId, verificationCode, null);
            return new Pair<VerifyAccountResponse, Object>(response, null);
        }
        catch (LockedException e) {
            VerifyAccountResponse response;
            if (pin == null) {
                throw new PinLockedException(e.getTimeRemaining());
            }
            SecureValueRecovery.RestoreResponse.Success registrationLockData = pinHelper.getRegistrationLockData(pin, e);
            if (registrationLockData == null) {
                throw e;
            }
            String registrationLock = registrationLockData.getMasterKey().deriveRegistrationLock();
            try {
                response = verifier.verify(sessionId, verificationCode, registrationLock);
            }
            catch (LockedException _e) {
                throw new AssertionError((Object)"KBS Pin appeared to matched but reg lock still failed!");
            }
            return new Pair<VerifyAccountResponse, MasterKey>(response, registrationLockData.getMasterKey());
        }
    }

    private static RegistrationSessionMetadataResponse validateSession(RegistrationApi registrationApi, String sessionId) throws IOException {
        if (sessionId == null || sessionId.isEmpty()) {
            throw new NoSuchSessionException();
        }
        return (RegistrationSessionMetadataResponse)Utils.handleResponseException(registrationApi.getRegistrationSessionStatus(sessionId));
    }

    private static RegistrationSessionMetadataResponse requestValidSession(RegistrationApi registrationApi) throws IOException {
        return (RegistrationSessionMetadataResponse)Utils.handleResponseException(registrationApi.createRegistrationSession(null, "", ""));
    }

    private static RegistrationSessionMetadataResponse getValidSession(RegistrationApi registrationApi, String sessionId) throws IOException {
        try {
            return NumberVerificationUtils.validateSession(registrationApi, sessionId);
        }
        catch (NoSuchSessionException e) {
            logger.debug("No registration session, creating new one.");
            return NumberVerificationUtils.requestValidSession(registrationApi);
        }
    }

    private static RegistrationSessionMetadataResponse submitCaptcha(RegistrationApi registrationApi, String sessionId, String captcha) throws IOException, CaptchaRequiredException {
        captcha = captcha == null ? null : captcha.replace("signalcaptcha://", "");
        try {
            return (RegistrationSessionMetadataResponse)Utils.handleResponseException(registrationApi.submitCaptchaToken(sessionId, captcha));
        }
        catch (org.whispersystems.signalservice.api.push.exceptions.CaptchaRequiredException | PushChallengeRequiredException | TokenNotAcceptedException _e) {
            throw new CaptchaRequiredException("Captcha not accepted");
        }
        catch (NonSuccessfulResponseCodeException e) {
            if (e.getCode() == 400) {
                throw new CaptchaRequiredException("Captcha has invalid format");
            }
            throw e;
        }
    }

    public static interface Verifier {
        public VerifyAccountResponse verify(String var1, String var2, String var3) throws IOException;
    }
}

