//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
use objc2_foundation::*;

use crate::*;

/// [Apple's documentation](https://developer.apple.com/documentation/uikit/uicellconfigurationdragstate?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct UICellConfigurationDragState(pub NSInteger);
impl UICellConfigurationDragState {
    /// The cell is not associated with a drag session.
    #[doc(alias = "UICellConfigurationDragStateNone")]
    pub const None: Self = Self(0);
    /// The cell is being lifted, before has joined a drag session.
    #[doc(alias = "UICellConfigurationDragStateLifting")]
    pub const Lifting: Self = Self(1);
    /// The cell is part of an active drag session.
    #[doc(alias = "UICellConfigurationDragStateDragging")]
    pub const Dragging: Self = Self(2);
}

unsafe impl Encode for UICellConfigurationDragState {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for UICellConfigurationDragState {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/uikit/uicellconfigurationdropstate?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct UICellConfigurationDropState(pub NSInteger);
impl UICellConfigurationDropState {
    /// The cell is not associated with a drag session.
    #[doc(alias = "UICellConfigurationDropStateNone")]
    pub const None: Self = Self(0);
    /// A drag session is active and may perform a drop in the cell's container, but the cell itself
    /// is not the drop target.
    #[doc(alias = "UICellConfigurationDropStateNotTargeted")]
    pub const NotTargeted: Self = Self(1);
    /// The cell is the drop target for a drag session.
    #[doc(alias = "UICellConfigurationDropStateTargeted")]
    pub const Targeted: Self = Self(2);
}

unsafe impl Encode for UICellConfigurationDropState {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for UICellConfigurationDropState {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uicellconfigurationstate?language=objc)
    #[unsafe(super(UIViewConfigurationState, NSObject))]
    #[thread_kind = MainThreadOnly]
    #[derive(Debug, PartialEq, Eq, Hash)]
    #[cfg(feature = "UIViewConfigurationState")]
    pub struct UICellConfigurationState;
);

#[cfg(feature = "UIViewConfigurationState")]
extern_conformance!(
    unsafe impl NSCoding for UICellConfigurationState {}
);

#[cfg(feature = "UIViewConfigurationState")]
extern_conformance!(
    unsafe impl NSCopying for UICellConfigurationState {}
);

#[cfg(feature = "UIViewConfigurationState")]
unsafe impl CopyingHelper for UICellConfigurationState {
    type Result = Self;
}

#[cfg(feature = "UIViewConfigurationState")]
extern_conformance!(
    unsafe impl NSObjectProtocol for UICellConfigurationState {}
);

#[cfg(feature = "UIViewConfigurationState")]
extern_conformance!(
    unsafe impl NSSecureCoding for UICellConfigurationState {}
);

#[cfg(all(feature = "UIConfigurationState", feature = "UIViewConfigurationState"))]
extern_conformance!(
    unsafe impl UIConfigurationState for UICellConfigurationState {}
);

#[cfg(feature = "UIViewConfigurationState")]
impl UICellConfigurationState {
    extern_methods!(
        #[unsafe(method(isEditing))]
        #[unsafe(method_family = none)]
        pub fn isEditing(&self) -> bool;

        /// Setter for [`isEditing`][Self::isEditing].
        #[unsafe(method(setEditing:))]
        #[unsafe(method_family = none)]
        pub fn setEditing(&self, editing: bool);

        #[unsafe(method(isExpanded))]
        #[unsafe(method_family = none)]
        pub fn isExpanded(&self) -> bool;

        /// Setter for [`isExpanded`][Self::isExpanded].
        #[unsafe(method(setExpanded:))]
        #[unsafe(method_family = none)]
        pub fn setExpanded(&self, expanded: bool);

        #[unsafe(method(isSwiped))]
        #[unsafe(method_family = none)]
        pub fn isSwiped(&self) -> bool;

        /// Setter for [`isSwiped`][Self::isSwiped].
        #[unsafe(method(setSwiped:))]
        #[unsafe(method_family = none)]
        pub fn setSwiped(&self, swiped: bool);

        #[unsafe(method(isReordering))]
        #[unsafe(method_family = none)]
        pub fn isReordering(&self) -> bool;

        /// Setter for [`isReordering`][Self::isReordering].
        #[unsafe(method(setReordering:))]
        #[unsafe(method_family = none)]
        pub fn setReordering(&self, reordering: bool);

        #[unsafe(method(cellDragState))]
        #[unsafe(method_family = none)]
        pub fn cellDragState(&self) -> UICellConfigurationDragState;

        /// Setter for [`cellDragState`][Self::cellDragState].
        #[unsafe(method(setCellDragState:))]
        #[unsafe(method_family = none)]
        pub fn setCellDragState(&self, cell_drag_state: UICellConfigurationDragState);

        #[unsafe(method(cellDropState))]
        #[unsafe(method_family = none)]
        pub fn cellDropState(&self) -> UICellConfigurationDropState;

        /// Setter for [`cellDropState`][Self::cellDropState].
        #[unsafe(method(setCellDropState:))]
        #[unsafe(method_family = none)]
        pub fn setCellDropState(&self, cell_drop_state: UICellConfigurationDropState);
    );
}

/// Methods declared on superclass `UIViewConfigurationState`.
#[cfg(feature = "UIViewConfigurationState")]
impl UICellConfigurationState {
    extern_methods!(
        #[cfg(feature = "UITraitCollection")]
        /// Returns a new instance with the specified trait collection.
        #[unsafe(method(initWithTraitCollection:))]
        #[unsafe(method_family = init)]
        pub fn initWithTraitCollection(
            this: Allocated<Self>,
            trait_collection: &UITraitCollection,
        ) -> Retained<Self>;

        /// # Safety
        ///
        /// `coder` possibly has further requirements.
        #[unsafe(method(initWithCoder:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithCoder(
            this: Allocated<Self>,
            coder: &NSCoder,
        ) -> Option<Retained<Self>>;

        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new(mtm: MainThreadMarker) -> Retained<Self>;
    );
}
