//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
use objc2_foundation::*;

use crate::*;

extern_protocol!(
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/nstextlocation?language=objc)
    pub unsafe trait NSTextLocation: NSObjectProtocol {
        #[unsafe(method(compare:))]
        #[unsafe(method_family = none)]
        fn compare(&self, location: &ProtocolObject<dyn NSTextLocation>) -> NSComparisonResult;
    }
);

extern_class!(
    /// A class that represents a contiguous range between two locations inside document contents.
    ///
    /// An `NSTextRange` consists of the starting and terminating locations. There
    /// the two basic properties: ``location`` and ``endLocation``, respectively.
    /// The terminating ``location``, ``endLocation``, is directly following the
    /// last location in the range. For example, a location contains a range if
    /// `(range.location
    /// <
    /// = location)
    /// &
    /// &
    /// (location
    /// <
    /// range.endLocation)` is `true`.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/uikit/nstextrange?language=objc)
    #[unsafe(super(NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct NSTextRange;
);

extern_conformance!(
    unsafe impl NSObjectProtocol for NSTextRange {}
);

impl NSTextRange {
    extern_methods!(
        /// Creates a new text range with the starting and ending locations you specify.
        ///
        /// - Parameters:
        /// - location: The starting location.
        /// - endLocation: The ending location.
        #[unsafe(method(initWithLocation:endLocation:))]
        #[unsafe(method_family = init)]
        pub fn initWithLocation_endLocation(
            this: Allocated<Self>,
            location: &ProtocolObject<dyn NSTextLocation>,
            end_location: Option<&ProtocolObject<dyn NSTextLocation>>,
        ) -> Option<Retained<Self>>;

        /// Creates a new text range at the location you specify.
        ///
        /// - Parameters:
        /// - location: An ``NSTextLocation``.
        #[unsafe(method(initWithLocation:))]
        #[unsafe(method_family = init)]
        pub fn initWithLocation(
            this: Allocated<Self>,
            location: &ProtocolObject<dyn NSTextLocation>,
        ) -> Retained<Self>;

        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new() -> Retained<Self>;

        /// Returns whether the text range is empty.
        #[unsafe(method(isEmpty))]
        #[unsafe(method_family = none)]
        pub fn isEmpty(&self) -> bool;

        /// The starting location of the text range.
        #[unsafe(method(location))]
        #[unsafe(method_family = none)]
        pub fn location(&self) -> Retained<ProtocolObject<dyn NSTextLocation>>;

        /// The ending location of the text range.
        #[unsafe(method(endLocation))]
        #[unsafe(method_family = none)]
        pub fn endLocation(&self) -> Retained<ProtocolObject<dyn NSTextLocation>>;

        /// Compares two text ranges.
        ///
        /// - Parameters:
        /// - textRange: The range used to compare against the current range to evaluate for differences.
        ///
        /// - Returns: Returns `true` if the ranges are equal.
        #[unsafe(method(isEqualToTextRange:))]
        #[unsafe(method_family = none)]
        pub fn isEqualToTextRange(&self, text_range: &NSTextRange) -> bool;

        /// Determines if the text location you specify is in the current text range.
        ///
        /// - Parameters:
        /// - location: An ``NSTextLocation``.
        ///
        /// - Returns: Returns `true` if the location is in the range otherwise `false` .
        #[unsafe(method(containsLocation:))]
        #[unsafe(method_family = none)]
        pub fn containsLocation(&self, location: &ProtocolObject<dyn NSTextLocation>) -> bool;

        /// Determines if the text range you specify is in the current text range.
        ///
        /// - Parameters:
        /// - textRange: An ``NSTextRange``.
        ///
        /// - Returns: Returns `true` if the range you provide is in the current range; otherwise `false`.
        #[unsafe(method(containsRange:))]
        #[unsafe(method_family = none)]
        pub fn containsRange(&self, text_range: &NSTextRange) -> bool;

        /// Determines if two ranges intersect.
        ///
        /// - Parameters:
        /// - textRange: The range used to compare against the current range to evaluate for differences.
        ///
        /// - Returns: Returns `true` if the ranges intersect.
        #[unsafe(method(intersectsWithTextRange:))]
        #[unsafe(method_family = none)]
        pub fn intersectsWithTextRange(&self, text_range: &NSTextRange) -> bool;

        /// Returns the range, if any, where two text ranges intersect.
        ///
        /// - Parameters:
        /// - textRange: The range used to compare against the current range to evaluate for differences.
        ///
        /// - Returns: An
        /// <doc
        /// ://com.apple.documentation/documentation/foundation/nsrange> that
        /// represents the intersection of the ranges, or `nil` if they don't
        /// intersect.
        #[unsafe(method(textRangeByIntersectingWithTextRange:))]
        #[unsafe(method_family = none)]
        pub fn textRangeByIntersectingWithTextRange(
            &self,
            text_range: &NSTextRange,
        ) -> Option<Retained<Self>>;

        /// Returns a new text range by forming the union with the text range you provide.
        ///
        /// - Parameters:
        /// - textRange: The range to use to create the union.
        ///
        /// - Returns: An ``NSTextRange`` that represent the union of the two ranges.
        #[unsafe(method(textRangeByFormingUnionWithTextRange:))]
        #[unsafe(method_family = none)]
        pub fn textRangeByFormingUnionWithTextRange(
            &self,
            text_range: &NSTextRange,
        ) -> Retained<Self>;
    );
}
