/*
 * Decompiled with CFR 0.152.
 */
package java_cup.runtime;

import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java_cup.runtime.ComplexSymbolFactory;
import java_cup.runtime.ScannerBuffer;
import java_cup.runtime.Symbol;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public abstract class XMLElement {
    protected String tagname;

    public abstract List<XMLElement> selectById(String var1);

    public static void dump(XMLStreamWriter writer, XMLElement elem, String ... blacklist) throws XMLStreamException {
        XMLElement.dump(null, writer, elem, blacklist);
    }

    public static void dump(ScannerBuffer buffer, XMLStreamWriter writer, XMLElement elem, String ... blacklist) throws XMLStreamException {
        writer.writeStartDocument("utf-8", "1.0");
        writer.writeProcessingInstruction("xml-stylesheet", "href=\"tree.xsl\" type=\"text/xsl\"");
        writer.writeStartElement("document");
        if (blacklist.length > 0) {
            writer.writeStartElement("blacklist");
            for (String s : blacklist) {
                writer.writeStartElement("symbol");
                writer.writeCharacters(s);
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
        writer.writeStartElement("parsetree");
        elem.dump(writer);
        writer.writeEndElement();
        if (buffer != null) {
            writer.writeStartElement("tokensequence");
            for (Symbol s : buffer.getBuffered()) {
                if (s instanceof ComplexSymbolFactory.ComplexSymbol) {
                    ComplexSymbolFactory.ComplexSymbol cs = (ComplexSymbolFactory.ComplexSymbol)s;
                    if (cs.value != null) {
                        writer.writeStartElement("token");
                        writer.writeAttribute("name", cs.getName());
                        cs.getLeft().toXML(writer, "left");
                        writer.writeCharacters(cs.value + "");
                        cs.getRight().toXML(writer, "right");
                        writer.writeEndElement();
                        continue;
                    }
                    writer.writeStartElement("keyword");
                    writer.writeAttribute("left", cs.getLeft() + "");
                    writer.writeAttribute("right", cs.getRight() + "");
                    writer.writeCharacters(cs.getName() + "");
                    writer.writeEndElement();
                    continue;
                }
                if (!(s instanceof Symbol)) continue;
                writer.writeStartElement("token");
                writer.writeCharacters(s.toString());
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
        writer.writeEndElement();
        writer.writeEndDocument();
        writer.flush();
        writer.close();
    }

    public String getTagname() {
        return this.tagname;
    }

    public abstract ComplexSymbolFactory.Location right();

    public abstract ComplexSymbolFactory.Location left();

    protected abstract void dump(XMLStreamWriter var1) throws XMLStreamException;

    public List<XMLElement> getChildren() {
        return new LinkedList<XMLElement>();
    }

    public boolean hasChildren() {
        return false;
    }

    public static class Terminal
    extends XMLElement {
        ComplexSymbolFactory.Location l;
        ComplexSymbolFactory.Location r;
        Object value;

        @Override
        public boolean hasChildren() {
            return false;
        }

        @Override
        public List<XMLElement> selectById(String s) {
            LinkedList<XMLElement> ret = new LinkedList<XMLElement>();
            if (this.tagname.equals(s)) {
                ret.add(this);
            }
            return ret;
        }

        public Terminal(ComplexSymbolFactory.Location l, String symbolname, ComplexSymbolFactory.Location r) {
            this(l, symbolname, null, r);
        }

        public Terminal(ComplexSymbolFactory.Location l, String symbolname, Object i, ComplexSymbolFactory.Location r) {
            this.l = l;
            this.r = r;
            this.value = i;
            this.tagname = symbolname;
        }

        public Object value() {
            return this.value;
        }

        @Override
        public ComplexSymbolFactory.Location left() {
            return this.l;
        }

        @Override
        public ComplexSymbolFactory.Location right() {
            return this.r;
        }

        public String toString() {
            return this.value == null ? "<terminal id=\"" + this.tagname + "\"/>" : "<terminal id=\"" + this.tagname + "\" left=\"" + this.l + "\" right=\"" + this.r + "\">" + this.value + "</terminal>";
        }

        @Override
        protected void dump(XMLStreamWriter writer) throws XMLStreamException {
            writer.writeStartElement("terminal");
            writer.writeAttribute("id", this.tagname);
            writer.writeAttribute("left", this.left() + "");
            writer.writeAttribute("right", this.right() + "");
            if (this.value != null) {
                writer.writeCharacters(this.value + "");
            }
            writer.writeEndElement();
        }
    }

    public static class Error
    extends XMLElement {
        ComplexSymbolFactory.Location l;
        ComplexSymbolFactory.Location r;

        @Override
        public boolean hasChildren() {
            return false;
        }

        @Override
        public List<XMLElement> selectById(String s) {
            return new LinkedList<XMLElement>();
        }

        public Error(ComplexSymbolFactory.Location l, ComplexSymbolFactory.Location r) {
            this.l = l;
            this.r = r;
        }

        @Override
        public ComplexSymbolFactory.Location left() {
            return this.l;
        }

        @Override
        public ComplexSymbolFactory.Location right() {
            return this.r;
        }

        public String toString() {
            return "<error left=\"" + this.l + "\" right=\"" + this.r + "\"/>";
        }

        @Override
        protected void dump(XMLStreamWriter writer) throws XMLStreamException {
            writer.writeStartElement("error");
            writer.writeAttribute("left", this.left() + "");
            writer.writeAttribute("right", this.right() + "");
            writer.writeEndElement();
        }
    }

    public static class NonTerminal
    extends XMLElement {
        private int variant;
        LinkedList<XMLElement> list;

        @Override
        public boolean hasChildren() {
            return !this.list.isEmpty();
        }

        @Override
        public List<XMLElement> getChildren() {
            return this.list;
        }

        @Override
        public List<XMLElement> selectById(String s) {
            LinkedList<XMLElement> response = new LinkedList<XMLElement>();
            if (this.tagname.equals(s)) {
                response.add(this);
            }
            for (XMLElement e : this.list) {
                List<XMLElement> selection = e.selectById(s);
                response.addAll(selection);
            }
            return response;
        }

        public int getVariant() {
            return this.variant;
        }

        public NonTerminal(String tagname, int variant, XMLElement ... l) {
            this.tagname = tagname;
            this.variant = variant;
            this.list = new LinkedList<XMLElement>(Arrays.asList(l));
        }

        @Override
        public ComplexSymbolFactory.Location left() {
            for (XMLElement e : this.list) {
                ComplexSymbolFactory.Location loc = e.left();
                if (loc == null) continue;
                return loc;
            }
            return null;
        }

        @Override
        public ComplexSymbolFactory.Location right() {
            Iterator<XMLElement> it = this.list.descendingIterator();
            while (it.hasNext()) {
                ComplexSymbolFactory.Location loc = it.next().right();
                if (loc == null) continue;
                return loc;
            }
            return null;
        }

        public String toString() {
            if (this.list.isEmpty()) {
                return "<nonterminal id=\"" + this.tagname + "\" variant=\"" + this.variant + "\" />";
            }
            String ret = "<nonterminal id=\"" + this.tagname + "\" left=\"" + this.left() + "\" right=\"" + this.right() + "\" variant=\"" + this.variant + "\">";
            for (XMLElement e : this.list) {
                ret = ret + e.toString();
            }
            return ret + "</nonterminal>";
        }

        @Override
        protected void dump(XMLStreamWriter writer) throws XMLStreamException {
            writer.writeStartElement("nonterminal");
            writer.writeAttribute("id", this.tagname);
            writer.writeAttribute("variant", this.variant + "");
            ComplexSymbolFactory.Location loc = this.left();
            if (loc != null) {
                loc.toXML(writer, "left");
            }
            for (XMLElement e : this.list) {
                e.dump(writer);
            }
            loc = this.right();
            if (loc != null) {
                loc.toXML(writer, "right");
            }
            writer.writeEndElement();
        }
    }
}

