package postgresqlflexibleservers

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/postgresql/mgmt/2021-06-01/postgresqlflexibleservers"

// AzureEntityResource the resource model definition for an Azure Resource Manager resource with an etag.
type AzureEntityResource struct {
	// Etag - READ-ONLY; Resource Etag.
	Etag *string `json:"etag,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureEntityResource.
func (aer AzureEntityResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// Backup backup properties of a server
type Backup struct {
	// BackupRetentionDays - Backup retention days for the server.
	BackupRetentionDays *int32 `json:"backupRetentionDays,omitempty"`
	// GeoRedundantBackup - A value indicating whether Geo-Redundant backup is enabled on the server. Possible values include: 'GeoRedundantBackupEnumEnabled', 'GeoRedundantBackupEnumDisabled'
	GeoRedundantBackup GeoRedundantBackupEnum `json:"geoRedundantBackup,omitempty"`
	// EarliestRestoreDate - READ-ONLY; The earliest restore point time (ISO8601 format) for server.
	EarliestRestoreDate *date.Time `json:"earliestRestoreDate,omitempty"`
}

// MarshalJSON is the custom marshaler for Backup.
func (b Backup) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if b.BackupRetentionDays != nil {
		objectMap["backupRetentionDays"] = b.BackupRetentionDays
	}
	if b.GeoRedundantBackup != "" {
		objectMap["geoRedundantBackup"] = b.GeoRedundantBackup
	}
	return json.Marshal(objectMap)
}

// CapabilitiesListResult location capability
type CapabilitiesListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; A list of supported capabilities.
	Value *[]CapabilityProperties `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for CapabilitiesListResult.
func (clr CapabilitiesListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// CapabilitiesListResultIterator provides access to a complete listing of CapabilityProperties values.
type CapabilitiesListResultIterator struct {
	i    int
	page CapabilitiesListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *CapabilitiesListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/CapabilitiesListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *CapabilitiesListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter CapabilitiesListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter CapabilitiesListResultIterator) Response() CapabilitiesListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter CapabilitiesListResultIterator) Value() CapabilityProperties {
	if !iter.page.NotDone() {
		return CapabilityProperties{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the CapabilitiesListResultIterator type.
func NewCapabilitiesListResultIterator(page CapabilitiesListResultPage) CapabilitiesListResultIterator {
	return CapabilitiesListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (clr CapabilitiesListResult) IsEmpty() bool {
	return clr.Value == nil || len(*clr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (clr CapabilitiesListResult) hasNextLink() bool {
	return clr.NextLink != nil && len(*clr.NextLink) != 0
}

// capabilitiesListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (clr CapabilitiesListResult) capabilitiesListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !clr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(clr.NextLink)))
}

// CapabilitiesListResultPage contains a page of CapabilityProperties values.
type CapabilitiesListResultPage struct {
	fn  func(context.Context, CapabilitiesListResult) (CapabilitiesListResult, error)
	clr CapabilitiesListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *CapabilitiesListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/CapabilitiesListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.clr)
		if err != nil {
			return err
		}
		page.clr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *CapabilitiesListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page CapabilitiesListResultPage) NotDone() bool {
	return !page.clr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page CapabilitiesListResultPage) Response() CapabilitiesListResult {
	return page.clr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page CapabilitiesListResultPage) Values() []CapabilityProperties {
	if page.clr.IsEmpty() {
		return nil
	}
	return *page.clr.Value
}

// Creates a new instance of the CapabilitiesListResultPage type.
func NewCapabilitiesListResultPage(cur CapabilitiesListResult, getNextPage func(context.Context, CapabilitiesListResult) (CapabilitiesListResult, error)) CapabilitiesListResultPage {
	return CapabilitiesListResultPage{
		fn:  getNextPage,
		clr: cur,
	}
}

// CapabilityProperties location capabilities.
type CapabilityProperties struct {
	// Zone - READ-ONLY; zone name
	Zone *string `json:"zone,omitempty"`
	// GeoBackupSupported - READ-ONLY; A value indicating whether a new server in this region can have geo-backups to paired region.
	GeoBackupSupported *bool `json:"geoBackupSupported,omitempty"`
	// ZoneRedundantHaSupported - READ-ONLY; A value indicating whether a new server in this region can support multi zone HA.
	ZoneRedundantHaSupported *bool `json:"zoneRedundantHaSupported,omitempty"`
	// ZoneRedundantHaAndGeoBackupSupported - READ-ONLY; A value indicating whether a new server in this region can have geo-backups to paired region.
	ZoneRedundantHaAndGeoBackupSupported *bool `json:"zoneRedundantHaAndGeoBackupSupported,omitempty"`
	// SupportedFlexibleServerEditions - READ-ONLY
	SupportedFlexibleServerEditions *[]FlexibleServerEditionCapability `json:"supportedFlexibleServerEditions,omitempty"`
	// SupportedHyperscaleNodeEditions - READ-ONLY
	SupportedHyperscaleNodeEditions *[]HyperscaleNodeEditionCapability `json:"supportedHyperscaleNodeEditions,omitempty"`
	// Status - READ-ONLY; The status
	Status *string `json:"status,omitempty"`
}

// MarshalJSON is the custom marshaler for CapabilityProperties.
func (cp CapabilityProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// CloudError an error response from the Batch service.
type CloudError struct {
	Error *ErrorResponse `json:"error,omitempty"`
}

// Configuration represents a Configuration.
type Configuration struct {
	autorest.Response `json:"-"`
	// ConfigurationProperties - The properties of a configuration.
	*ConfigurationProperties `json:"properties,omitempty"`
	// SystemData - READ-ONLY; The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Configuration.
func (c Configuration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if c.ConfigurationProperties != nil {
		objectMap["properties"] = c.ConfigurationProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Configuration struct.
func (c *Configuration) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var configurationProperties ConfigurationProperties
				err = json.Unmarshal(*v, &configurationProperties)
				if err != nil {
					return err
				}
				c.ConfigurationProperties = &configurationProperties
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				c.SystemData = &systemData
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				c.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				c.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				c.Type = &typeVar
			}
		}
	}

	return nil
}

// ConfigurationListResult a list of server configurations.
type ConfigurationListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of server configurations.
	Value *[]Configuration `json:"value,omitempty"`
	// NextLink - The link used to get the next page of operations.
	NextLink *string `json:"nextLink,omitempty"`
}

// ConfigurationListResultIterator provides access to a complete listing of Configuration values.
type ConfigurationListResultIterator struct {
	i    int
	page ConfigurationListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ConfigurationListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ConfigurationListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ConfigurationListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ConfigurationListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ConfigurationListResultIterator) Response() ConfigurationListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ConfigurationListResultIterator) Value() Configuration {
	if !iter.page.NotDone() {
		return Configuration{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ConfigurationListResultIterator type.
func NewConfigurationListResultIterator(page ConfigurationListResultPage) ConfigurationListResultIterator {
	return ConfigurationListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (clr ConfigurationListResult) IsEmpty() bool {
	return clr.Value == nil || len(*clr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (clr ConfigurationListResult) hasNextLink() bool {
	return clr.NextLink != nil && len(*clr.NextLink) != 0
}

// configurationListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (clr ConfigurationListResult) configurationListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !clr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(clr.NextLink)))
}

// ConfigurationListResultPage contains a page of Configuration values.
type ConfigurationListResultPage struct {
	fn  func(context.Context, ConfigurationListResult) (ConfigurationListResult, error)
	clr ConfigurationListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ConfigurationListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ConfigurationListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.clr)
		if err != nil {
			return err
		}
		page.clr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ConfigurationListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ConfigurationListResultPage) NotDone() bool {
	return !page.clr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ConfigurationListResultPage) Response() ConfigurationListResult {
	return page.clr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ConfigurationListResultPage) Values() []Configuration {
	if page.clr.IsEmpty() {
		return nil
	}
	return *page.clr.Value
}

// Creates a new instance of the ConfigurationListResultPage type.
func NewConfigurationListResultPage(cur ConfigurationListResult, getNextPage func(context.Context, ConfigurationListResult) (ConfigurationListResult, error)) ConfigurationListResultPage {
	return ConfigurationListResultPage{
		fn:  getNextPage,
		clr: cur,
	}
}

// ConfigurationProperties the properties of a configuration.
type ConfigurationProperties struct {
	// Value - Value of the configuration.
	Value *string `json:"value,omitempty"`
	// Description - READ-ONLY; Description of the configuration.
	Description *string `json:"description,omitempty"`
	// DefaultValue - READ-ONLY; Default value of the configuration.
	DefaultValue *string `json:"defaultValue,omitempty"`
	// DataType - READ-ONLY; Data type of the configuration. Possible values include: 'ConfigurationDataTypeBoolean', 'ConfigurationDataTypeNumeric', 'ConfigurationDataTypeInteger', 'ConfigurationDataTypeEnumeration'
	DataType ConfigurationDataType `json:"dataType,omitempty"`
	// AllowedValues - READ-ONLY; Allowed values of the configuration.
	AllowedValues *string `json:"allowedValues,omitempty"`
	// Source - Source of the configuration.
	Source *string `json:"source,omitempty"`
}

// MarshalJSON is the custom marshaler for ConfigurationProperties.
func (cp ConfigurationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cp.Value != nil {
		objectMap["value"] = cp.Value
	}
	if cp.Source != nil {
		objectMap["source"] = cp.Source
	}
	return json.Marshal(objectMap)
}

// ConfigurationsPutFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ConfigurationsPutFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ConfigurationsClient) (Configuration, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ConfigurationsPutFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ConfigurationsPutFuture.Result.
func (future *ConfigurationsPutFuture) result(client ConfigurationsClient) (c Configuration, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "postgresqlflexibleservers.ConfigurationsPutFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		c.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("postgresqlflexibleservers.ConfigurationsPutFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if c.Response.Response, err = future.GetResult(sender); err == nil && c.Response.Response.StatusCode != http.StatusNoContent {
		c, err = client.PutResponder(c.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "postgresqlflexibleservers.ConfigurationsPutFuture", "Result", c.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ConfigurationsUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ConfigurationsUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ConfigurationsClient) (Configuration, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ConfigurationsUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ConfigurationsUpdateFuture.Result.
func (future *ConfigurationsUpdateFuture) result(client ConfigurationsClient) (c Configuration, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "postgresqlflexibleservers.ConfigurationsUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		c.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("postgresqlflexibleservers.ConfigurationsUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if c.Response.Response, err = future.GetResult(sender); err == nil && c.Response.Response.StatusCode != http.StatusNoContent {
		c, err = client.UpdateResponder(c.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "postgresqlflexibleservers.ConfigurationsUpdateFuture", "Result", c.Response.Response, "Failure responding to request")
		}
	}
	return
}

// Database represents a Database.
type Database struct {
	autorest.Response `json:"-"`
	// DatabaseProperties - The properties of a database.
	*DatabaseProperties `json:"properties,omitempty"`
	// SystemData - READ-ONLY; The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Database.
func (d Database) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if d.DatabaseProperties != nil {
		objectMap["properties"] = d.DatabaseProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Database struct.
func (d *Database) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var databaseProperties DatabaseProperties
				err = json.Unmarshal(*v, &databaseProperties)
				if err != nil {
					return err
				}
				d.DatabaseProperties = &databaseProperties
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				d.SystemData = &systemData
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				d.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				d.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				d.Type = &typeVar
			}
		}
	}

	return nil
}

// DatabaseListResult a List of databases.
type DatabaseListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of databases housed in a server
	Value *[]Database `json:"value,omitempty"`
	// NextLink - The link used to get the next page of databases.
	NextLink *string `json:"nextLink,omitempty"`
}

// DatabaseListResultIterator provides access to a complete listing of Database values.
type DatabaseListResultIterator struct {
	i    int
	page DatabaseListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *DatabaseListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DatabaseListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *DatabaseListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter DatabaseListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter DatabaseListResultIterator) Response() DatabaseListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter DatabaseListResultIterator) Value() Database {
	if !iter.page.NotDone() {
		return Database{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the DatabaseListResultIterator type.
func NewDatabaseListResultIterator(page DatabaseListResultPage) DatabaseListResultIterator {
	return DatabaseListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (dlr DatabaseListResult) IsEmpty() bool {
	return dlr.Value == nil || len(*dlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (dlr DatabaseListResult) hasNextLink() bool {
	return dlr.NextLink != nil && len(*dlr.NextLink) != 0
}

// databaseListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (dlr DatabaseListResult) databaseListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !dlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(dlr.NextLink)))
}

// DatabaseListResultPage contains a page of Database values.
type DatabaseListResultPage struct {
	fn  func(context.Context, DatabaseListResult) (DatabaseListResult, error)
	dlr DatabaseListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *DatabaseListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DatabaseListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.dlr)
		if err != nil {
			return err
		}
		page.dlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *DatabaseListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page DatabaseListResultPage) NotDone() bool {
	return !page.dlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page DatabaseListResultPage) Response() DatabaseListResult {
	return page.dlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page DatabaseListResultPage) Values() []Database {
	if page.dlr.IsEmpty() {
		return nil
	}
	return *page.dlr.Value
}

// Creates a new instance of the DatabaseListResultPage type.
func NewDatabaseListResultPage(cur DatabaseListResult, getNextPage func(context.Context, DatabaseListResult) (DatabaseListResult, error)) DatabaseListResultPage {
	return DatabaseListResultPage{
		fn:  getNextPage,
		dlr: cur,
	}
}

// DatabaseProperties the properties of a database.
type DatabaseProperties struct {
	// Charset - The charset of the database.
	Charset *string `json:"charset,omitempty"`
	// Collation - The collation of the database.
	Collation *string `json:"collation,omitempty"`
}

// DatabasesCreateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type DatabasesCreateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DatabasesClient) (Database, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DatabasesCreateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DatabasesCreateFuture.Result.
func (future *DatabasesCreateFuture) result(client DatabasesClient) (d Database, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "postgresqlflexibleservers.DatabasesCreateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		d.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("postgresqlflexibleservers.DatabasesCreateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if d.Response.Response, err = future.GetResult(sender); err == nil && d.Response.Response.StatusCode != http.StatusNoContent {
		d, err = client.CreateResponder(d.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "postgresqlflexibleservers.DatabasesCreateFuture", "Result", d.Response.Response, "Failure responding to request")
		}
	}
	return
}

// DatabasesDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type DatabasesDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DatabasesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DatabasesDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DatabasesDeleteFuture.Result.
func (future *DatabasesDeleteFuture) result(client DatabasesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "postgresqlflexibleservers.DatabasesDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("postgresqlflexibleservers.DatabasesDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// DelegatedSubnetUsage delegated subnet usage data.
type DelegatedSubnetUsage struct {
	// SubnetName - READ-ONLY; name of the subnet
	SubnetName *string `json:"subnetName,omitempty"`
	// Usage - READ-ONLY; Number of used delegated subnets
	Usage *int64 `json:"usage,omitempty"`
}

// MarshalJSON is the custom marshaler for DelegatedSubnetUsage.
func (dsu DelegatedSubnetUsage) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ErrorAdditionalInfo the resource management error additional info.
type ErrorAdditionalInfo struct {
	// Type - READ-ONLY; The additional info type.
	Type *string `json:"type,omitempty"`
	// Info - READ-ONLY; The additional info.
	Info interface{} `json:"info,omitempty"`
}

// MarshalJSON is the custom marshaler for ErrorAdditionalInfo.
func (eai ErrorAdditionalInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ErrorResponse common error response for all Azure Resource Manager APIs to return error details for
// failed operations. (This also follows the OData error response format.)
type ErrorResponse struct {
	// Code - READ-ONLY; The error code.
	Code *string `json:"code,omitempty"`
	// Message - READ-ONLY; The error message.
	Message *string `json:"message,omitempty"`
	// Target - READ-ONLY; The error target.
	Target *string `json:"target,omitempty"`
	// Details - READ-ONLY; The error details.
	Details *[]ErrorResponse `json:"details,omitempty"`
	// AdditionalInfo - READ-ONLY; The error additional info.
	AdditionalInfo *[]ErrorAdditionalInfo `json:"additionalInfo,omitempty"`
}

// MarshalJSON is the custom marshaler for ErrorResponse.
func (er ErrorResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// FirewallRule represents a server firewall rule.
type FirewallRule struct {
	autorest.Response `json:"-"`
	// FirewallRuleProperties - The properties of a firewall rule.
	*FirewallRuleProperties `json:"properties,omitempty"`
	// SystemData - READ-ONLY; The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for FirewallRule.
func (fr FirewallRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if fr.FirewallRuleProperties != nil {
		objectMap["properties"] = fr.FirewallRuleProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for FirewallRule struct.
func (fr *FirewallRule) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var firewallRuleProperties FirewallRuleProperties
				err = json.Unmarshal(*v, &firewallRuleProperties)
				if err != nil {
					return err
				}
				fr.FirewallRuleProperties = &firewallRuleProperties
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				fr.SystemData = &systemData
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				fr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				fr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				fr.Type = &typeVar
			}
		}
	}

	return nil
}

// FirewallRuleListResult a list of firewall rules.
type FirewallRuleListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of firewall rules in a server.
	Value *[]FirewallRule `json:"value,omitempty"`
	// NextLink - The link used to get the next page of operations.
	NextLink *string `json:"nextLink,omitempty"`
}

// FirewallRuleListResultIterator provides access to a complete listing of FirewallRule values.
type FirewallRuleListResultIterator struct {
	i    int
	page FirewallRuleListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *FirewallRuleListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/FirewallRuleListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *FirewallRuleListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter FirewallRuleListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter FirewallRuleListResultIterator) Response() FirewallRuleListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter FirewallRuleListResultIterator) Value() FirewallRule {
	if !iter.page.NotDone() {
		return FirewallRule{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the FirewallRuleListResultIterator type.
func NewFirewallRuleListResultIterator(page FirewallRuleListResultPage) FirewallRuleListResultIterator {
	return FirewallRuleListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (frlr FirewallRuleListResult) IsEmpty() bool {
	return frlr.Value == nil || len(*frlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (frlr FirewallRuleListResult) hasNextLink() bool {
	return frlr.NextLink != nil && len(*frlr.NextLink) != 0
}

// firewallRuleListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (frlr FirewallRuleListResult) firewallRuleListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !frlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(frlr.NextLink)))
}

// FirewallRuleListResultPage contains a page of FirewallRule values.
type FirewallRuleListResultPage struct {
	fn   func(context.Context, FirewallRuleListResult) (FirewallRuleListResult, error)
	frlr FirewallRuleListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *FirewallRuleListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/FirewallRuleListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.frlr)
		if err != nil {
			return err
		}
		page.frlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *FirewallRuleListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page FirewallRuleListResultPage) NotDone() bool {
	return !page.frlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page FirewallRuleListResultPage) Response() FirewallRuleListResult {
	return page.frlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page FirewallRuleListResultPage) Values() []FirewallRule {
	if page.frlr.IsEmpty() {
		return nil
	}
	return *page.frlr.Value
}

// Creates a new instance of the FirewallRuleListResultPage type.
func NewFirewallRuleListResultPage(cur FirewallRuleListResult, getNextPage func(context.Context, FirewallRuleListResult) (FirewallRuleListResult, error)) FirewallRuleListResultPage {
	return FirewallRuleListResultPage{
		fn:   getNextPage,
		frlr: cur,
	}
}

// FirewallRuleProperties the properties of a server firewall rule.
type FirewallRuleProperties struct {
	// StartIPAddress - The start IP address of the server firewall rule. Must be IPv4 format.
	StartIPAddress *string `json:"startIpAddress,omitempty"`
	// EndIPAddress - The end IP address of the server firewall rule. Must be IPv4 format.
	EndIPAddress *string `json:"endIpAddress,omitempty"`
}

// FirewallRulesCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type FirewallRulesCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(FirewallRulesClient) (FirewallRule, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *FirewallRulesCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for FirewallRulesCreateOrUpdateFuture.Result.
func (future *FirewallRulesCreateOrUpdateFuture) result(client FirewallRulesClient) (fr FirewallRule, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "postgresqlflexibleservers.FirewallRulesCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		fr.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("postgresqlflexibleservers.FirewallRulesCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if fr.Response.Response, err = future.GetResult(sender); err == nil && fr.Response.Response.StatusCode != http.StatusNoContent {
		fr, err = client.CreateOrUpdateResponder(fr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "postgresqlflexibleservers.FirewallRulesCreateOrUpdateFuture", "Result", fr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// FirewallRulesDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type FirewallRulesDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(FirewallRulesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *FirewallRulesDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for FirewallRulesDeleteFuture.Result.
func (future *FirewallRulesDeleteFuture) result(client FirewallRulesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "postgresqlflexibleservers.FirewallRulesDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("postgresqlflexibleservers.FirewallRulesDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// FlexibleServerEditionCapability flexible server edition capabilities.
type FlexibleServerEditionCapability struct {
	// Name - READ-ONLY; Server edition name
	Name *string `json:"name,omitempty"`
	// SupportedStorageEditions - READ-ONLY; The list of editions supported by this server edition.
	SupportedStorageEditions *[]StorageEditionCapability `json:"supportedStorageEditions,omitempty"`
	// SupportedServerVersions - READ-ONLY; The list of server versions supported by this server edition.
	SupportedServerVersions *[]ServerVersionCapability `json:"supportedServerVersions,omitempty"`
	// Status - READ-ONLY; The status
	Status *string `json:"status,omitempty"`
}

// MarshalJSON is the custom marshaler for FlexibleServerEditionCapability.
func (fsec FlexibleServerEditionCapability) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// HighAvailability high availability properties of a server
type HighAvailability struct {
	// Mode - The HA mode for the server. Possible values include: 'HighAvailabilityModeDisabled', 'HighAvailabilityModeZoneRedundant'
	Mode HighAvailabilityMode `json:"mode,omitempty"`
	// State - READ-ONLY; A state of a HA server that is visible to user. Possible values include: 'ServerHAStateNotEnabled', 'ServerHAStateCreatingStandby', 'ServerHAStateReplicatingData', 'ServerHAStateFailingOver', 'ServerHAStateHealthy', 'ServerHAStateRemovingStandby'
	State ServerHAState `json:"state,omitempty"`
	// StandbyAvailabilityZone - availability zone information of the standby.
	StandbyAvailabilityZone *string `json:"standbyAvailabilityZone,omitempty"`
}

// MarshalJSON is the custom marshaler for HighAvailability.
func (ha HighAvailability) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ha.Mode != "" {
		objectMap["mode"] = ha.Mode
	}
	if ha.StandbyAvailabilityZone != nil {
		objectMap["standbyAvailabilityZone"] = ha.StandbyAvailabilityZone
	}
	return json.Marshal(objectMap)
}

// HyperscaleNodeEditionCapability hyperscale node edition capabilities.
type HyperscaleNodeEditionCapability struct {
	// Name - READ-ONLY; Server edition name
	Name *string `json:"name,omitempty"`
	// SupportedStorageEditions - READ-ONLY; The list of editions supported by this server edition.
	SupportedStorageEditions *[]StorageEditionCapability `json:"supportedStorageEditions,omitempty"`
	// SupportedServerVersions - READ-ONLY; The list of server versions supported by this server edition.
	SupportedServerVersions *[]ServerVersionCapability `json:"supportedServerVersions,omitempty"`
	// SupportedNodeTypes - READ-ONLY; The list of Node Types supported by this server edition.
	SupportedNodeTypes *[]NodeTypeCapability `json:"supportedNodeTypes,omitempty"`
	// Status - READ-ONLY; The status
	Status *string `json:"status,omitempty"`
}

// MarshalJSON is the custom marshaler for HyperscaleNodeEditionCapability.
func (hnec HyperscaleNodeEditionCapability) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// MaintenanceWindow maintenance window properties of a server.
type MaintenanceWindow struct {
	// CustomWindow - indicates whether custom window is enabled or disabled
	CustomWindow *string `json:"customWindow,omitempty"`
	// StartHour - start hour for maintenance window
	StartHour *int32 `json:"startHour,omitempty"`
	// StartMinute - start minute for maintenance window
	StartMinute *int32 `json:"startMinute,omitempty"`
	// DayOfWeek - day of week for maintenance window
	DayOfWeek *int32 `json:"dayOfWeek,omitempty"`
}

// NameAvailability represents a resource name availability.
type NameAvailability struct {
	autorest.Response `json:"-"`
	// Message - Error Message.
	Message *string `json:"message,omitempty"`
	// NameAvailable - Indicates whether the resource name is available.
	NameAvailable *bool `json:"nameAvailable,omitempty"`
	// Name - name of the PostgreSQL server.
	Name *string `json:"name,omitempty"`
	// Type - type of the server
	Type *string `json:"type,omitempty"`
}

// NameAvailabilityRequest request from client to check resource name availability.
type NameAvailabilityRequest struct {
	// Name - Resource name to verify.
	Name *string `json:"name,omitempty"`
	// Type - Resource type used for verification.
	Type *string `json:"type,omitempty"`
}

// Network network properties of a server
type Network struct {
	// PublicNetworkAccess - READ-ONLY; public network access is enabled or not. Possible values include: 'ServerPublicNetworkAccessStateEnabled', 'ServerPublicNetworkAccessStateDisabled'
	PublicNetworkAccess ServerPublicNetworkAccessState `json:"publicNetworkAccess,omitempty"`
	// DelegatedSubnetResourceID - delegated subnet arm resource id.
	DelegatedSubnetResourceID *string `json:"delegatedSubnetResourceId,omitempty"`
	// PrivateDNSZoneArmResourceID - private dns zone arm resource id.
	PrivateDNSZoneArmResourceID *string `json:"privateDnsZoneArmResourceId,omitempty"`
}

// MarshalJSON is the custom marshaler for Network.
func (n Network) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if n.DelegatedSubnetResourceID != nil {
		objectMap["delegatedSubnetResourceId"] = n.DelegatedSubnetResourceID
	}
	if n.PrivateDNSZoneArmResourceID != nil {
		objectMap["privateDnsZoneArmResourceId"] = n.PrivateDNSZoneArmResourceID
	}
	return json.Marshal(objectMap)
}

// NodeTypeCapability node type capability
type NodeTypeCapability struct {
	// Name - READ-ONLY; note type name
	Name *string `json:"name,omitempty"`
	// NodeType - READ-ONLY; note type
	NodeType *string `json:"nodeType,omitempty"`
	// Status - READ-ONLY; The status
	Status *string `json:"status,omitempty"`
}

// MarshalJSON is the custom marshaler for NodeTypeCapability.
func (ntc NodeTypeCapability) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// Operation REST API operation definition.
type Operation struct {
	// Name - READ-ONLY; The name of the operation being performed on this particular object.
	Name *string `json:"name,omitempty"`
	// Display - READ-ONLY; The localized display information for this particular operation or action.
	Display *OperationDisplay `json:"display,omitempty"`
	// IsDataAction - Indicates whether the operation is a data action
	IsDataAction *bool `json:"isDataAction,omitempty"`
	// Origin - READ-ONLY; The intended executor of the operation. Possible values include: 'OperationOriginNotSpecified', 'OperationOriginUser', 'OperationOriginSystem'
	Origin OperationOrigin `json:"origin,omitempty"`
	// Properties - READ-ONLY; Additional descriptions for the operation.
	Properties map[string]interface{} `json:"properties"`
}

// MarshalJSON is the custom marshaler for Operation.
func (o Operation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if o.IsDataAction != nil {
		objectMap["isDataAction"] = o.IsDataAction
	}
	return json.Marshal(objectMap)
}

// OperationDisplay display metadata associated with the operation.
type OperationDisplay struct {
	// Provider - READ-ONLY; Operation resource provider name.
	Provider *string `json:"provider,omitempty"`
	// Resource - READ-ONLY; Resource on which the operation is performed.
	Resource *string `json:"resource,omitempty"`
	// Operation - READ-ONLY; Localized friendly name for the operation.
	Operation *string `json:"operation,omitempty"`
	// Description - READ-ONLY; Operation description.
	Description *string `json:"description,omitempty"`
}

// MarshalJSON is the custom marshaler for OperationDisplay.
func (od OperationDisplay) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// OperationListResult a list of resource provider operations.
type OperationListResult struct {
	autorest.Response `json:"-"`
	// Value - Collection of available operation details
	Value *[]Operation `json:"value,omitempty"`
	// NextLink - URL client should use to fetch the next page (per server side paging).
	// It's null for now, added for future use.
	NextLink *string `json:"nextLink,omitempty"`
}

// ProxyResource the resource model definition for a Azure Resource Manager proxy resource. It will not
// have tags and a location
type ProxyResource struct {
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ProxyResource.
func (pr ProxyResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// Resource common fields that are returned in the response for all Azure Resource Manager resources
type Resource struct {
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// RestartParameter represents server restart parameters.
type RestartParameter struct {
	// RestartWithFailover - Indicates whether to restart the server with failover.
	RestartWithFailover *bool `json:"restartWithFailover,omitempty"`
	// FailoverMode - Failover mode. Possible values include: 'FailoverModePlannedFailover', 'FailoverModeForcedFailover', 'FailoverModePlannedSwitchover', 'FailoverModeForcedSwitchover'
	FailoverMode FailoverMode `json:"failoverMode,omitempty"`
}

// Server represents a server.
type Server struct {
	autorest.Response `json:"-"`
	// Sku - The SKU (pricing tier) of the server.
	Sku *Sku `json:"sku,omitempty"`
	// ServerProperties - Properties of the server.
	*ServerProperties `json:"properties,omitempty"`
	// SystemData - READ-ONLY; The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// Location - The geo-location where the resource lives
	Location *string `json:"location,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Server.
func (s Server) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if s.Sku != nil {
		objectMap["sku"] = s.Sku
	}
	if s.ServerProperties != nil {
		objectMap["properties"] = s.ServerProperties
	}
	if s.Tags != nil {
		objectMap["tags"] = s.Tags
	}
	if s.Location != nil {
		objectMap["location"] = s.Location
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Server struct.
func (s *Server) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "sku":
			if v != nil {
				var sku Sku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				s.Sku = &sku
			}
		case "properties":
			if v != nil {
				var serverProperties ServerProperties
				err = json.Unmarshal(*v, &serverProperties)
				if err != nil {
					return err
				}
				s.ServerProperties = &serverProperties
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				s.SystemData = &systemData
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				s.Tags = tags
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				s.Location = &location
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				s.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				s.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				s.Type = &typeVar
			}
		}
	}

	return nil
}

// ServerForUpdate represents a server to be updated.
type ServerForUpdate struct {
	// Location - The location the resource resides in.
	Location *string `json:"location,omitempty"`
	// Sku - The SKU (pricing tier) of the server.
	Sku *Sku `json:"sku,omitempty"`
	// ServerPropertiesForUpdate - Properties of the server.
	*ServerPropertiesForUpdate `json:"properties,omitempty"`
	// Tags - Application-specific metadata in the form of key-value pairs.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ServerForUpdate.
func (sfu ServerForUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sfu.Location != nil {
		objectMap["location"] = sfu.Location
	}
	if sfu.Sku != nil {
		objectMap["sku"] = sfu.Sku
	}
	if sfu.ServerPropertiesForUpdate != nil {
		objectMap["properties"] = sfu.ServerPropertiesForUpdate
	}
	if sfu.Tags != nil {
		objectMap["tags"] = sfu.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ServerForUpdate struct.
func (sfu *ServerForUpdate) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				sfu.Location = &location
			}
		case "sku":
			if v != nil {
				var sku Sku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				sfu.Sku = &sku
			}
		case "properties":
			if v != nil {
				var serverPropertiesForUpdate ServerPropertiesForUpdate
				err = json.Unmarshal(*v, &serverPropertiesForUpdate)
				if err != nil {
					return err
				}
				sfu.ServerPropertiesForUpdate = &serverPropertiesForUpdate
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				sfu.Tags = tags
			}
		}
	}

	return nil
}

// ServerListResult a list of servers.
type ServerListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of flexible servers
	Value *[]Server `json:"value,omitempty"`
	// NextLink - The link used to get the next page of operations.
	NextLink *string `json:"nextLink,omitempty"`
}

// ServerListResultIterator provides access to a complete listing of Server values.
type ServerListResultIterator struct {
	i    int
	page ServerListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ServerListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServerListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ServerListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ServerListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ServerListResultIterator) Response() ServerListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ServerListResultIterator) Value() Server {
	if !iter.page.NotDone() {
		return Server{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ServerListResultIterator type.
func NewServerListResultIterator(page ServerListResultPage) ServerListResultIterator {
	return ServerListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (slr ServerListResult) IsEmpty() bool {
	return slr.Value == nil || len(*slr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (slr ServerListResult) hasNextLink() bool {
	return slr.NextLink != nil && len(*slr.NextLink) != 0
}

// serverListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (slr ServerListResult) serverListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !slr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(slr.NextLink)))
}

// ServerListResultPage contains a page of Server values.
type ServerListResultPage struct {
	fn  func(context.Context, ServerListResult) (ServerListResult, error)
	slr ServerListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ServerListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServerListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.slr)
		if err != nil {
			return err
		}
		page.slr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ServerListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ServerListResultPage) NotDone() bool {
	return !page.slr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ServerListResultPage) Response() ServerListResult {
	return page.slr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ServerListResultPage) Values() []Server {
	if page.slr.IsEmpty() {
		return nil
	}
	return *page.slr.Value
}

// Creates a new instance of the ServerListResultPage type.
func NewServerListResultPage(cur ServerListResult, getNextPage func(context.Context, ServerListResult) (ServerListResult, error)) ServerListResultPage {
	return ServerListResultPage{
		fn:  getNextPage,
		slr: cur,
	}
}

// ServerProperties the properties of a server.
type ServerProperties struct {
	// AdministratorLogin - The administrator's login name of a server. Can only be specified when the server is being created (and is required for creation).
	AdministratorLogin *string `json:"administratorLogin,omitempty"`
	// AdministratorLoginPassword - The administrator login password (required for server creation).
	AdministratorLoginPassword *string `json:"administratorLoginPassword,omitempty"`
	// Version - PostgreSQL Server version. Possible values include: 'ServerVersionOneThree', 'ServerVersionOneTwo', 'ServerVersionOneOne'
	Version ServerVersion `json:"version,omitempty"`
	// MinorVersion - READ-ONLY; The minor version of the server.
	MinorVersion *string `json:"minorVersion,omitempty"`
	// State - READ-ONLY; A state of a server that is visible to user. Possible values include: 'ServerStateReady', 'ServerStateDropping', 'ServerStateDisabled', 'ServerStateStarting', 'ServerStateStopping', 'ServerStateStopped', 'ServerStateUpdating'
	State ServerState `json:"state,omitempty"`
	// FullyQualifiedDomainName - READ-ONLY; The fully qualified domain name of a server.
	FullyQualifiedDomainName *string `json:"fullyQualifiedDomainName,omitempty"`
	// Storage - Storage properties of a server.
	Storage *Storage `json:"storage,omitempty"`
	// Backup - Backup properties of a server.
	Backup *Backup `json:"backup,omitempty"`
	// Network - Network properties of a server.
	Network *Network `json:"network,omitempty"`
	// HighAvailability - High availability properties of a server.
	HighAvailability *HighAvailability `json:"highAvailability,omitempty"`
	// MaintenanceWindow - Maintenance window properties of a server.
	MaintenanceWindow *MaintenanceWindow `json:"maintenanceWindow,omitempty"`
	// SourceServerResourceID - The source server resource ID to restore from. It's required when 'createMode' is 'PointInTimeRestore'.
	SourceServerResourceID *string `json:"sourceServerResourceId,omitempty"`
	// PointInTimeUTC - Restore point creation time (ISO8601 format), specifying the time to restore from. It's required when 'createMode' is 'PointInTimeRestore'.
	PointInTimeUTC *date.Time `json:"pointInTimeUTC,omitempty"`
	// AvailabilityZone - availability zone information of the server.
	AvailabilityZone *string `json:"availabilityZone,omitempty"`
	// CreateMode - The mode to create a new PostgreSQL server. Possible values include: 'CreateModeDefault', 'CreateModeCreate', 'CreateModeUpdate', 'CreateModePointInTimeRestore'
	CreateMode CreateMode `json:"createMode,omitempty"`
	// Tags - Application-specific metadata in the form of key-value pairs.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ServerProperties.
func (sp ServerProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sp.AdministratorLogin != nil {
		objectMap["administratorLogin"] = sp.AdministratorLogin
	}
	if sp.AdministratorLoginPassword != nil {
		objectMap["administratorLoginPassword"] = sp.AdministratorLoginPassword
	}
	if sp.Version != "" {
		objectMap["version"] = sp.Version
	}
	if sp.Storage != nil {
		objectMap["storage"] = sp.Storage
	}
	if sp.Backup != nil {
		objectMap["backup"] = sp.Backup
	}
	if sp.Network != nil {
		objectMap["network"] = sp.Network
	}
	if sp.HighAvailability != nil {
		objectMap["highAvailability"] = sp.HighAvailability
	}
	if sp.MaintenanceWindow != nil {
		objectMap["maintenanceWindow"] = sp.MaintenanceWindow
	}
	if sp.SourceServerResourceID != nil {
		objectMap["sourceServerResourceId"] = sp.SourceServerResourceID
	}
	if sp.PointInTimeUTC != nil {
		objectMap["pointInTimeUTC"] = sp.PointInTimeUTC
	}
	if sp.AvailabilityZone != nil {
		objectMap["availabilityZone"] = sp.AvailabilityZone
	}
	if sp.CreateMode != "" {
		objectMap["createMode"] = sp.CreateMode
	}
	if sp.Tags != nil {
		objectMap["tags"] = sp.Tags
	}
	return json.Marshal(objectMap)
}

// ServerPropertiesForUpdate ...
type ServerPropertiesForUpdate struct {
	// AdministratorLoginPassword - The password of the administrator login.
	AdministratorLoginPassword *string `json:"administratorLoginPassword,omitempty"`
	// Storage - Storage properties of a server.
	Storage *Storage `json:"storage,omitempty"`
	// Backup - Backup properties of a server.
	Backup *Backup `json:"backup,omitempty"`
	// HighAvailability - High availability properties of a server.
	HighAvailability *HighAvailability `json:"highAvailability,omitempty"`
	// MaintenanceWindow - Maintenance window properties of a server.
	MaintenanceWindow *MaintenanceWindow `json:"maintenanceWindow,omitempty"`
	// CreateMode - The mode to update a new PostgreSQL server. Possible values include: 'CreateModeForUpdateDefault', 'CreateModeForUpdateUpdate'
	CreateMode CreateModeForUpdate `json:"createMode,omitempty"`
}

// ServersCreateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ServersCreateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ServersClient) (Server, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ServersCreateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ServersCreateFuture.Result.
func (future *ServersCreateFuture) result(client ServersClient) (s Server, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "postgresqlflexibleservers.ServersCreateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		s.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("postgresqlflexibleservers.ServersCreateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if s.Response.Response, err = future.GetResult(sender); err == nil && s.Response.Response.StatusCode != http.StatusNoContent {
		s, err = client.CreateResponder(s.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "postgresqlflexibleservers.ServersCreateFuture", "Result", s.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ServersDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ServersDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ServersClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ServersDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ServersDeleteFuture.Result.
func (future *ServersDeleteFuture) result(client ServersClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "postgresqlflexibleservers.ServersDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("postgresqlflexibleservers.ServersDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ServersRestartFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ServersRestartFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ServersClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ServersRestartFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ServersRestartFuture.Result.
func (future *ServersRestartFuture) result(client ServersClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "postgresqlflexibleservers.ServersRestartFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("postgresqlflexibleservers.ServersRestartFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ServersStartFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type ServersStartFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ServersClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ServersStartFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ServersStartFuture.Result.
func (future *ServersStartFuture) result(client ServersClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "postgresqlflexibleservers.ServersStartFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("postgresqlflexibleservers.ServersStartFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ServersStopFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type ServersStopFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ServersClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ServersStopFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ServersStopFuture.Result.
func (future *ServersStopFuture) result(client ServersClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "postgresqlflexibleservers.ServersStopFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("postgresqlflexibleservers.ServersStopFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ServersUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ServersUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ServersClient) (Server, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ServersUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ServersUpdateFuture.Result.
func (future *ServersUpdateFuture) result(client ServersClient) (s Server, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "postgresqlflexibleservers.ServersUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		s.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("postgresqlflexibleservers.ServersUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if s.Response.Response, err = future.GetResult(sender); err == nil && s.Response.Response.StatusCode != http.StatusNoContent {
		s, err = client.UpdateResponder(s.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "postgresqlflexibleservers.ServersUpdateFuture", "Result", s.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ServerVersionCapability server version capabilities.
type ServerVersionCapability struct {
	// Name - READ-ONLY; server version
	Name *string `json:"name,omitempty"`
	// SupportedVcores - READ-ONLY
	SupportedVcores *[]VcoreCapability `json:"supportedVcores,omitempty"`
	// Status - READ-ONLY; The status
	Status *string `json:"status,omitempty"`
}

// MarshalJSON is the custom marshaler for ServerVersionCapability.
func (svc ServerVersionCapability) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// Sku sku information related properties of a server.
type Sku struct {
	// Name - The name of the sku, typically, tier + family + cores, e.g. Standard_D4s_v3.
	Name *string `json:"name,omitempty"`
	// Tier - The tier of the particular SKU, e.g. Burstable. Possible values include: 'SkuTierBurstable', 'SkuTierGeneralPurpose', 'SkuTierMemoryOptimized'
	Tier SkuTier `json:"tier,omitempty"`
}

// Storage storage properties of a server
type Storage struct {
	// StorageSizeGB - Max storage allowed for a server.
	StorageSizeGB *int32 `json:"storageSizeGB,omitempty"`
}

// StorageEditionCapability storage edition capability
type StorageEditionCapability struct {
	// Name - READ-ONLY; storage edition name
	Name *string `json:"name,omitempty"`
	// SupportedStorageMB - READ-ONLY
	SupportedStorageMB *[]StorageMBCapability `json:"supportedStorageMB,omitempty"`
	// Status - READ-ONLY; The status
	Status *string `json:"status,omitempty"`
}

// MarshalJSON is the custom marshaler for StorageEditionCapability.
func (sec StorageEditionCapability) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// StorageMBCapability storage size in MB capability
type StorageMBCapability struct {
	// Name - READ-ONLY; storage MB name
	Name *string `json:"name,omitempty"`
	// SupportedIops - READ-ONLY; supported IOPS
	SupportedIops *int64 `json:"supportedIops,omitempty"`
	// StorageSizeMB - READ-ONLY; storage size in MB
	StorageSizeMB *int64 `json:"storageSizeMB,omitempty"`
	// Status - READ-ONLY; The status
	Status *string `json:"status,omitempty"`
}

// MarshalJSON is the custom marshaler for StorageMBCapability.
func (smc StorageMBCapability) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// String ...
type String struct {
	autorest.Response `json:"-"`
	Value             *string `json:"value,omitempty"`
}

// SystemData metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// CreatedBy - The identity that created the resource.
	CreatedBy *string `json:"createdBy,omitempty"`
	// CreatedByType - The type of identity that created the resource. Possible values include: 'CreatedByTypeUser', 'CreatedByTypeApplication', 'CreatedByTypeManagedIdentity', 'CreatedByTypeKey'
	CreatedByType CreatedByType `json:"createdByType,omitempty"`
	// CreatedAt - The timestamp of resource creation (UTC).
	CreatedAt *date.Time `json:"createdAt,omitempty"`
	// LastModifiedBy - The identity that last modified the resource.
	LastModifiedBy *string `json:"lastModifiedBy,omitempty"`
	// LastModifiedByType - The type of identity that last modified the resource. Possible values include: 'CreatedByTypeUser', 'CreatedByTypeApplication', 'CreatedByTypeManagedIdentity', 'CreatedByTypeKey'
	LastModifiedByType CreatedByType `json:"lastModifiedByType,omitempty"`
	// LastModifiedAt - The timestamp of resource last modification (UTC)
	LastModifiedAt *date.Time `json:"lastModifiedAt,omitempty"`
}

// TrackedResource the resource model definition for an Azure Resource Manager tracked top level resource
// which has 'tags' and a 'location'
type TrackedResource struct {
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// Location - The geo-location where the resource lives
	Location *string `json:"location,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for TrackedResource.
func (tr TrackedResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tr.Tags != nil {
		objectMap["tags"] = tr.Tags
	}
	if tr.Location != nil {
		objectMap["location"] = tr.Location
	}
	return json.Marshal(objectMap)
}

// VcoreCapability vcores capability
type VcoreCapability struct {
	// Name - READ-ONLY; vCore name
	Name *string `json:"name,omitempty"`
	// VCores - READ-ONLY; supported vCores
	VCores *int64 `json:"vCores,omitempty"`
	// SupportedIops - READ-ONLY; supported IOPS
	SupportedIops *int64 `json:"supportedIops,omitempty"`
	// SupportedMemoryPerVcoreMB - READ-ONLY; supported memory per vCore in MB
	SupportedMemoryPerVcoreMB *int64 `json:"supportedMemoryPerVcoreMB,omitempty"`
	// Status - READ-ONLY; The status
	Status *string `json:"status,omitempty"`
}

// MarshalJSON is the custom marshaler for VcoreCapability.
func (vc VcoreCapability) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// VirtualNetworkSubnetUsageParameter virtual network subnet usage parameter
type VirtualNetworkSubnetUsageParameter struct {
	// VirtualNetworkArmResourceID - Virtual network resource id.
	VirtualNetworkArmResourceID *string `json:"virtualNetworkArmResourceId,omitempty"`
}

// VirtualNetworkSubnetUsageResult virtual network subnet usage data.
type VirtualNetworkSubnetUsageResult struct {
	autorest.Response `json:"-"`
	// DelegatedSubnetsUsage - READ-ONLY
	DelegatedSubnetsUsage *[]DelegatedSubnetUsage `json:"delegatedSubnetsUsage,omitempty"`
}

// MarshalJSON is the custom marshaler for VirtualNetworkSubnetUsageResult.
func (vnsur VirtualNetworkSubnetUsageResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}
