package preload

// Code generated by cdproto-gen. DO NOT EDIT.

import (
	"fmt"
	"strings"

	"github.com/chromedp/cdproto/cdp"
	"github.com/chromedp/cdproto/network"
)

// RuleSetID unique id.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Preload#type-RuleSetId
type RuleSetID string

// String returns the RuleSetID as string value.
func (t RuleSetID) String() string {
	return string(t)
}

// RuleSet corresponds to SpeculationRuleSet.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Preload#type-RuleSet
type RuleSet struct {
	ID            RuleSetID         `json:"id"`
	LoaderID      cdp.LoaderID      `json:"loaderId"`                         // Identifies a document which the rule set is associated with.
	SourceText    string            `json:"sourceText"`                       // Source text of JSON representing the rule set. If it comes from <script> tag, it is the textContent of the node. Note that it is a JSON for valid case.  See also: - https://wicg.github.io/nav-speculation/speculation-rules.html - https://github.com/WICG/nav-speculation/blob/main/triggers.md
	BackendNodeID cdp.BackendNodeID `json:"backendNodeId,omitempty,omitzero"` // A speculation rule set is either added through an inline <script> tag or through an external resource via the 'Speculation-Rules' HTTP header. For the first case, we include the BackendNodeId of the relevant <script> tag. For the second case, we include the external URL where the rule set was loaded from, and also RequestId if Network domain is enabled.  See also: - https://wicg.github.io/nav-speculation/speculation-rules.html#speculation-rules-script - https://wicg.github.io/nav-speculation/speculation-rules.html#speculation-rules-header
	URL           string            `json:"url,omitempty,omitzero"`
	RequestID     network.RequestID `json:"requestId,omitempty,omitzero"`
	ErrorType     RuleSetErrorType  `json:"errorType,omitempty,omitzero"` // Error information errorMessage is null iff errorType is null.
}

// RuleSetErrorType [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Preload#type-RuleSetErrorType
type RuleSetErrorType string

// String returns the RuleSetErrorType as string value.
func (t RuleSetErrorType) String() string {
	return string(t)
}

// RuleSetErrorType values.
const (
	RuleSetErrorTypeSourceIsNotJSONObject  RuleSetErrorType = "SourceIsNotJsonObject"
	RuleSetErrorTypeInvalidRulesSkipped    RuleSetErrorType = "InvalidRulesSkipped"
	RuleSetErrorTypeInvalidRulesetLevelTag RuleSetErrorType = "InvalidRulesetLevelTag"
)

// UnmarshalJSON satisfies [json.Unmarshaler].
func (t *RuleSetErrorType) UnmarshalJSON(buf []byte) error {
	s := string(buf)
	s = strings.TrimSuffix(strings.TrimPrefix(s, `"`), `"`)

	switch RuleSetErrorType(s) {
	case RuleSetErrorTypeSourceIsNotJSONObject:
		*t = RuleSetErrorTypeSourceIsNotJSONObject
	case RuleSetErrorTypeInvalidRulesSkipped:
		*t = RuleSetErrorTypeInvalidRulesSkipped
	case RuleSetErrorTypeInvalidRulesetLevelTag:
		*t = RuleSetErrorTypeInvalidRulesetLevelTag
	default:
		return fmt.Errorf("unknown RuleSetErrorType value: %v", s)
	}
	return nil
}

// SpeculationAction the type of preloading attempted. It corresponds to
// mojom::SpeculationAction (although PrefetchWithSubresources is omitted as it
// isn't being used by clients).
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Preload#type-SpeculationAction
type SpeculationAction string

// String returns the SpeculationAction as string value.
func (t SpeculationAction) String() string {
	return string(t)
}

// SpeculationAction values.
const (
	SpeculationActionPrefetch  SpeculationAction = "Prefetch"
	SpeculationActionPrerender SpeculationAction = "Prerender"
)

// UnmarshalJSON satisfies [json.Unmarshaler].
func (t *SpeculationAction) UnmarshalJSON(buf []byte) error {
	s := string(buf)
	s = strings.TrimSuffix(strings.TrimPrefix(s, `"`), `"`)

	switch SpeculationAction(s) {
	case SpeculationActionPrefetch:
		*t = SpeculationActionPrefetch
	case SpeculationActionPrerender:
		*t = SpeculationActionPrerender
	default:
		return fmt.Errorf("unknown SpeculationAction value: %v", s)
	}
	return nil
}

// SpeculationTargetHint corresponds to mojom::SpeculationTargetHint. See
// https://github.com/WICG/nav-speculation/blob/main/triggers.md#window-name-targeting-hints.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Preload#type-SpeculationTargetHint
type SpeculationTargetHint string

// String returns the SpeculationTargetHint as string value.
func (t SpeculationTargetHint) String() string {
	return string(t)
}

// SpeculationTargetHint values.
const (
	SpeculationTargetHintBlank SpeculationTargetHint = "Blank"
	SpeculationTargetHintSelf  SpeculationTargetHint = "Self"
)

// UnmarshalJSON satisfies [json.Unmarshaler].
func (t *SpeculationTargetHint) UnmarshalJSON(buf []byte) error {
	s := string(buf)
	s = strings.TrimSuffix(strings.TrimPrefix(s, `"`), `"`)

	switch SpeculationTargetHint(s) {
	case SpeculationTargetHintBlank:
		*t = SpeculationTargetHintBlank
	case SpeculationTargetHintSelf:
		*t = SpeculationTargetHintSelf
	default:
		return fmt.Errorf("unknown SpeculationTargetHint value: %v", s)
	}
	return nil
}

// IngAttemptKey a key that identifies a preloading attempt. The url used is
// the url specified by the trigger (i.e. the initial URL), and not the final
// url that is navigated to. For example, prerendering allows same-origin main
// frame navigations during the attempt, but the attempt is still keyed with the
// initial URL.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Preload#type-PreloadingAttemptKey
type IngAttemptKey struct {
	LoaderID   cdp.LoaderID          `json:"loaderId"`
	Action     SpeculationAction     `json:"action"`
	URL        string                `json:"url"`
	TargetHint SpeculationTargetHint `json:"targetHint,omitempty,omitzero"`
}

// IngAttemptSource lists sources for a preloading attempt, specifically the
// ids of rule sets that had a speculation rule that triggered the attempt, and
// the BackendNodeIds of <a href> or <area href> elements that triggered the
// attempt (in the case of attempts triggered by a document rule). It is
// possible for multiple rule sets and links to trigger a single attempt.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Preload#type-PreloadingAttemptSource
type IngAttemptSource struct {
	Key        *IngAttemptKey      `json:"key"`
	RuleSetIDs []RuleSetID         `json:"ruleSetIds"`
	NodeIDs    []cdp.BackendNodeID `json:"nodeIds"`
}

// PipelineID chrome manages different types of preloads together using a
// concept of preloading pipeline. For example, if a site uses a
// SpeculationRules for prerender, Chrome first starts a prefetch and then
// upgrades it to prerender. CDP events for them are emitted separately but they
// share PreloadPipelineId.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Preload#type-PreloadPipelineId
type PipelineID string

// String returns the PipelineID as string value.
func (t PipelineID) String() string {
	return string(t)
}

// PrerenderFinalStatus list of FinalStatus reasons for Prerender2.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Preload#type-PrerenderFinalStatus
type PrerenderFinalStatus string

// String returns the PrerenderFinalStatus as string value.
func (t PrerenderFinalStatus) String() string {
	return string(t)
}

// PrerenderFinalStatus values.
const (
	PrerenderFinalStatusActivated                                                  PrerenderFinalStatus = "Activated"
	PrerenderFinalStatusDestroyed                                                  PrerenderFinalStatus = "Destroyed"
	PrerenderFinalStatusLowEndDevice                                               PrerenderFinalStatus = "LowEndDevice"
	PrerenderFinalStatusInvalidSchemeRedirect                                      PrerenderFinalStatus = "InvalidSchemeRedirect"
	PrerenderFinalStatusInvalidSchemeNavigation                                    PrerenderFinalStatus = "InvalidSchemeNavigation"
	PrerenderFinalStatusNavigationRequestBlockedByCsp                              PrerenderFinalStatus = "NavigationRequestBlockedByCsp"
	PrerenderFinalStatusMojoBinderPolicy                                           PrerenderFinalStatus = "MojoBinderPolicy"
	PrerenderFinalStatusRendererProcessCrashed                                     PrerenderFinalStatus = "RendererProcessCrashed"
	PrerenderFinalStatusRendererProcessKilled                                      PrerenderFinalStatus = "RendererProcessKilled"
	PrerenderFinalStatusDownload                                                   PrerenderFinalStatus = "Download"
	PrerenderFinalStatusTriggerDestroyed                                           PrerenderFinalStatus = "TriggerDestroyed"
	PrerenderFinalStatusNavigationNotCommitted                                     PrerenderFinalStatus = "NavigationNotCommitted"
	PrerenderFinalStatusNavigationBadHTTPStatus                                    PrerenderFinalStatus = "NavigationBadHttpStatus"
	PrerenderFinalStatusClientCertRequested                                        PrerenderFinalStatus = "ClientCertRequested"
	PrerenderFinalStatusNavigationRequestNetworkError                              PrerenderFinalStatus = "NavigationRequestNetworkError"
	PrerenderFinalStatusCancelAllHostsForTesting                                   PrerenderFinalStatus = "CancelAllHostsForTesting"
	PrerenderFinalStatusDidFailLoad                                                PrerenderFinalStatus = "DidFailLoad"
	PrerenderFinalStatusStop                                                       PrerenderFinalStatus = "Stop"
	PrerenderFinalStatusSslCertificateError                                        PrerenderFinalStatus = "SslCertificateError"
	PrerenderFinalStatusLoginAuthRequested                                         PrerenderFinalStatus = "LoginAuthRequested"
	PrerenderFinalStatusUaChangeRequiresReload                                     PrerenderFinalStatus = "UaChangeRequiresReload"
	PrerenderFinalStatusBlockedByClient                                            PrerenderFinalStatus = "BlockedByClient"
	PrerenderFinalStatusAudioOutputDeviceRequested                                 PrerenderFinalStatus = "AudioOutputDeviceRequested"
	PrerenderFinalStatusMixedContent                                               PrerenderFinalStatus = "MixedContent"
	PrerenderFinalStatusTriggerBackgrounded                                        PrerenderFinalStatus = "TriggerBackgrounded"
	PrerenderFinalStatusMemoryLimitExceeded                                        PrerenderFinalStatus = "MemoryLimitExceeded"
	PrerenderFinalStatusDataSaverEnabled                                           PrerenderFinalStatus = "DataSaverEnabled"
	PrerenderFinalStatusTriggerURLHasEffectiveURL                                  PrerenderFinalStatus = "TriggerUrlHasEffectiveUrl"
	PrerenderFinalStatusActivatedBeforeStarted                                     PrerenderFinalStatus = "ActivatedBeforeStarted"
	PrerenderFinalStatusInactivePageRestriction                                    PrerenderFinalStatus = "InactivePageRestriction"
	PrerenderFinalStatusStartFailed                                                PrerenderFinalStatus = "StartFailed"
	PrerenderFinalStatusTimeoutBackgrounded                                        PrerenderFinalStatus = "TimeoutBackgrounded"
	PrerenderFinalStatusCrossSiteRedirectInInitialNavigation                       PrerenderFinalStatus = "CrossSiteRedirectInInitialNavigation"
	PrerenderFinalStatusCrossSiteNavigationInInitialNavigation                     PrerenderFinalStatus = "CrossSiteNavigationInInitialNavigation"
	PrerenderFinalStatusSameSiteCrossOriginRedirectNotOptInInInitialNavigation     PrerenderFinalStatus = "SameSiteCrossOriginRedirectNotOptInInInitialNavigation"
	PrerenderFinalStatusSameSiteCrossOriginNavigationNotOptInInInitialNavigation   PrerenderFinalStatus = "SameSiteCrossOriginNavigationNotOptInInInitialNavigation"
	PrerenderFinalStatusActivationNavigationParameterMismatch                      PrerenderFinalStatus = "ActivationNavigationParameterMismatch"
	PrerenderFinalStatusActivatedInBackground                                      PrerenderFinalStatus = "ActivatedInBackground"
	PrerenderFinalStatusEmbedderHostDisallowed                                     PrerenderFinalStatus = "EmbedderHostDisallowed"
	PrerenderFinalStatusActivationNavigationDestroyedBeforeSuccess                 PrerenderFinalStatus = "ActivationNavigationDestroyedBeforeSuccess"
	PrerenderFinalStatusTabClosedByUserGesture                                     PrerenderFinalStatus = "TabClosedByUserGesture"
	PrerenderFinalStatusTabClosedWithoutUserGesture                                PrerenderFinalStatus = "TabClosedWithoutUserGesture"
	PrerenderFinalStatusPrimaryMainFrameRendererProcessCrashed                     PrerenderFinalStatus = "PrimaryMainFrameRendererProcessCrashed"
	PrerenderFinalStatusPrimaryMainFrameRendererProcessKilled                      PrerenderFinalStatus = "PrimaryMainFrameRendererProcessKilled"
	PrerenderFinalStatusActivationFramePolicyNotCompatible                         PrerenderFinalStatus = "ActivationFramePolicyNotCompatible"
	PrerenderFinalStatusPreloadingDisabled                                         PrerenderFinalStatus = "PreloadingDisabled"
	PrerenderFinalStatusBatterySaverEnabled                                        PrerenderFinalStatus = "BatterySaverEnabled"
	PrerenderFinalStatusActivatedDuringMainFrameNavigation                         PrerenderFinalStatus = "ActivatedDuringMainFrameNavigation"
	PrerenderFinalStatusPreloadingUnsupportedByWebContents                         PrerenderFinalStatus = "PreloadingUnsupportedByWebContents"
	PrerenderFinalStatusCrossSiteRedirectInMainFrameNavigation                     PrerenderFinalStatus = "CrossSiteRedirectInMainFrameNavigation"
	PrerenderFinalStatusCrossSiteNavigationInMainFrameNavigation                   PrerenderFinalStatus = "CrossSiteNavigationInMainFrameNavigation"
	PrerenderFinalStatusSameSiteCrossOriginRedirectNotOptInInMainFrameNavigation   PrerenderFinalStatus = "SameSiteCrossOriginRedirectNotOptInInMainFrameNavigation"
	PrerenderFinalStatusSameSiteCrossOriginNavigationNotOptInInMainFrameNavigation PrerenderFinalStatus = "SameSiteCrossOriginNavigationNotOptInInMainFrameNavigation"
	PrerenderFinalStatusMemoryPressureOnTrigger                                    PrerenderFinalStatus = "MemoryPressureOnTrigger"
	PrerenderFinalStatusMemoryPressureAfterTriggered                               PrerenderFinalStatus = "MemoryPressureAfterTriggered"
	PrerenderFinalStatusPrerenderingDisabledByDevTools                             PrerenderFinalStatus = "PrerenderingDisabledByDevTools"
	PrerenderFinalStatusSpeculationRuleRemoved                                     PrerenderFinalStatus = "SpeculationRuleRemoved"
	PrerenderFinalStatusActivatedWithAuxiliaryBrowsingContexts                     PrerenderFinalStatus = "ActivatedWithAuxiliaryBrowsingContexts"
	PrerenderFinalStatusMaxNumOfRunningEagerPrerendersExceeded                     PrerenderFinalStatus = "MaxNumOfRunningEagerPrerendersExceeded"
	PrerenderFinalStatusMaxNumOfRunningNonEagerPrerendersExceeded                  PrerenderFinalStatus = "MaxNumOfRunningNonEagerPrerendersExceeded"
	PrerenderFinalStatusMaxNumOfRunningEmbedderPrerendersExceeded                  PrerenderFinalStatus = "MaxNumOfRunningEmbedderPrerendersExceeded"
	PrerenderFinalStatusPrerenderingURLHasEffectiveURL                             PrerenderFinalStatus = "PrerenderingUrlHasEffectiveUrl"
	PrerenderFinalStatusRedirectedPrerenderingURLHasEffectiveURL                   PrerenderFinalStatus = "RedirectedPrerenderingUrlHasEffectiveUrl"
	PrerenderFinalStatusActivationURLHasEffectiveURL                               PrerenderFinalStatus = "ActivationUrlHasEffectiveUrl"
	PrerenderFinalStatusJavaScriptInterfaceAdded                                   PrerenderFinalStatus = "JavaScriptInterfaceAdded"
	PrerenderFinalStatusJavaScriptInterfaceRemoved                                 PrerenderFinalStatus = "JavaScriptInterfaceRemoved"
	PrerenderFinalStatusAllPrerenderingCanceled                                    PrerenderFinalStatus = "AllPrerenderingCanceled"
	PrerenderFinalStatusWindowClosed                                               PrerenderFinalStatus = "WindowClosed"
	PrerenderFinalStatusSlowNetwork                                                PrerenderFinalStatus = "SlowNetwork"
	PrerenderFinalStatusOtherPrerenderedPageActivated                              PrerenderFinalStatus = "OtherPrerenderedPageActivated"
	PrerenderFinalStatusV8optimizerDisabled                                        PrerenderFinalStatus = "V8OptimizerDisabled"
	PrerenderFinalStatusPrerenderFailedDuringPrefetch                              PrerenderFinalStatus = "PrerenderFailedDuringPrefetch"
	PrerenderFinalStatusBrowsingDataRemoved                                        PrerenderFinalStatus = "BrowsingDataRemoved"
)

// UnmarshalJSON satisfies [json.Unmarshaler].
func (t *PrerenderFinalStatus) UnmarshalJSON(buf []byte) error {
	s := string(buf)
	s = strings.TrimSuffix(strings.TrimPrefix(s, `"`), `"`)

	switch PrerenderFinalStatus(s) {
	case PrerenderFinalStatusActivated:
		*t = PrerenderFinalStatusActivated
	case PrerenderFinalStatusDestroyed:
		*t = PrerenderFinalStatusDestroyed
	case PrerenderFinalStatusLowEndDevice:
		*t = PrerenderFinalStatusLowEndDevice
	case PrerenderFinalStatusInvalidSchemeRedirect:
		*t = PrerenderFinalStatusInvalidSchemeRedirect
	case PrerenderFinalStatusInvalidSchemeNavigation:
		*t = PrerenderFinalStatusInvalidSchemeNavigation
	case PrerenderFinalStatusNavigationRequestBlockedByCsp:
		*t = PrerenderFinalStatusNavigationRequestBlockedByCsp
	case PrerenderFinalStatusMojoBinderPolicy:
		*t = PrerenderFinalStatusMojoBinderPolicy
	case PrerenderFinalStatusRendererProcessCrashed:
		*t = PrerenderFinalStatusRendererProcessCrashed
	case PrerenderFinalStatusRendererProcessKilled:
		*t = PrerenderFinalStatusRendererProcessKilled
	case PrerenderFinalStatusDownload:
		*t = PrerenderFinalStatusDownload
	case PrerenderFinalStatusTriggerDestroyed:
		*t = PrerenderFinalStatusTriggerDestroyed
	case PrerenderFinalStatusNavigationNotCommitted:
		*t = PrerenderFinalStatusNavigationNotCommitted
	case PrerenderFinalStatusNavigationBadHTTPStatus:
		*t = PrerenderFinalStatusNavigationBadHTTPStatus
	case PrerenderFinalStatusClientCertRequested:
		*t = PrerenderFinalStatusClientCertRequested
	case PrerenderFinalStatusNavigationRequestNetworkError:
		*t = PrerenderFinalStatusNavigationRequestNetworkError
	case PrerenderFinalStatusCancelAllHostsForTesting:
		*t = PrerenderFinalStatusCancelAllHostsForTesting
	case PrerenderFinalStatusDidFailLoad:
		*t = PrerenderFinalStatusDidFailLoad
	case PrerenderFinalStatusStop:
		*t = PrerenderFinalStatusStop
	case PrerenderFinalStatusSslCertificateError:
		*t = PrerenderFinalStatusSslCertificateError
	case PrerenderFinalStatusLoginAuthRequested:
		*t = PrerenderFinalStatusLoginAuthRequested
	case PrerenderFinalStatusUaChangeRequiresReload:
		*t = PrerenderFinalStatusUaChangeRequiresReload
	case PrerenderFinalStatusBlockedByClient:
		*t = PrerenderFinalStatusBlockedByClient
	case PrerenderFinalStatusAudioOutputDeviceRequested:
		*t = PrerenderFinalStatusAudioOutputDeviceRequested
	case PrerenderFinalStatusMixedContent:
		*t = PrerenderFinalStatusMixedContent
	case PrerenderFinalStatusTriggerBackgrounded:
		*t = PrerenderFinalStatusTriggerBackgrounded
	case PrerenderFinalStatusMemoryLimitExceeded:
		*t = PrerenderFinalStatusMemoryLimitExceeded
	case PrerenderFinalStatusDataSaverEnabled:
		*t = PrerenderFinalStatusDataSaverEnabled
	case PrerenderFinalStatusTriggerURLHasEffectiveURL:
		*t = PrerenderFinalStatusTriggerURLHasEffectiveURL
	case PrerenderFinalStatusActivatedBeforeStarted:
		*t = PrerenderFinalStatusActivatedBeforeStarted
	case PrerenderFinalStatusInactivePageRestriction:
		*t = PrerenderFinalStatusInactivePageRestriction
	case PrerenderFinalStatusStartFailed:
		*t = PrerenderFinalStatusStartFailed
	case PrerenderFinalStatusTimeoutBackgrounded:
		*t = PrerenderFinalStatusTimeoutBackgrounded
	case PrerenderFinalStatusCrossSiteRedirectInInitialNavigation:
		*t = PrerenderFinalStatusCrossSiteRedirectInInitialNavigation
	case PrerenderFinalStatusCrossSiteNavigationInInitialNavigation:
		*t = PrerenderFinalStatusCrossSiteNavigationInInitialNavigation
	case PrerenderFinalStatusSameSiteCrossOriginRedirectNotOptInInInitialNavigation:
		*t = PrerenderFinalStatusSameSiteCrossOriginRedirectNotOptInInInitialNavigation
	case PrerenderFinalStatusSameSiteCrossOriginNavigationNotOptInInInitialNavigation:
		*t = PrerenderFinalStatusSameSiteCrossOriginNavigationNotOptInInInitialNavigation
	case PrerenderFinalStatusActivationNavigationParameterMismatch:
		*t = PrerenderFinalStatusActivationNavigationParameterMismatch
	case PrerenderFinalStatusActivatedInBackground:
		*t = PrerenderFinalStatusActivatedInBackground
	case PrerenderFinalStatusEmbedderHostDisallowed:
		*t = PrerenderFinalStatusEmbedderHostDisallowed
	case PrerenderFinalStatusActivationNavigationDestroyedBeforeSuccess:
		*t = PrerenderFinalStatusActivationNavigationDestroyedBeforeSuccess
	case PrerenderFinalStatusTabClosedByUserGesture:
		*t = PrerenderFinalStatusTabClosedByUserGesture
	case PrerenderFinalStatusTabClosedWithoutUserGesture:
		*t = PrerenderFinalStatusTabClosedWithoutUserGesture
	case PrerenderFinalStatusPrimaryMainFrameRendererProcessCrashed:
		*t = PrerenderFinalStatusPrimaryMainFrameRendererProcessCrashed
	case PrerenderFinalStatusPrimaryMainFrameRendererProcessKilled:
		*t = PrerenderFinalStatusPrimaryMainFrameRendererProcessKilled
	case PrerenderFinalStatusActivationFramePolicyNotCompatible:
		*t = PrerenderFinalStatusActivationFramePolicyNotCompatible
	case PrerenderFinalStatusPreloadingDisabled:
		*t = PrerenderFinalStatusPreloadingDisabled
	case PrerenderFinalStatusBatterySaverEnabled:
		*t = PrerenderFinalStatusBatterySaverEnabled
	case PrerenderFinalStatusActivatedDuringMainFrameNavigation:
		*t = PrerenderFinalStatusActivatedDuringMainFrameNavigation
	case PrerenderFinalStatusPreloadingUnsupportedByWebContents:
		*t = PrerenderFinalStatusPreloadingUnsupportedByWebContents
	case PrerenderFinalStatusCrossSiteRedirectInMainFrameNavigation:
		*t = PrerenderFinalStatusCrossSiteRedirectInMainFrameNavigation
	case PrerenderFinalStatusCrossSiteNavigationInMainFrameNavigation:
		*t = PrerenderFinalStatusCrossSiteNavigationInMainFrameNavigation
	case PrerenderFinalStatusSameSiteCrossOriginRedirectNotOptInInMainFrameNavigation:
		*t = PrerenderFinalStatusSameSiteCrossOriginRedirectNotOptInInMainFrameNavigation
	case PrerenderFinalStatusSameSiteCrossOriginNavigationNotOptInInMainFrameNavigation:
		*t = PrerenderFinalStatusSameSiteCrossOriginNavigationNotOptInInMainFrameNavigation
	case PrerenderFinalStatusMemoryPressureOnTrigger:
		*t = PrerenderFinalStatusMemoryPressureOnTrigger
	case PrerenderFinalStatusMemoryPressureAfterTriggered:
		*t = PrerenderFinalStatusMemoryPressureAfterTriggered
	case PrerenderFinalStatusPrerenderingDisabledByDevTools:
		*t = PrerenderFinalStatusPrerenderingDisabledByDevTools
	case PrerenderFinalStatusSpeculationRuleRemoved:
		*t = PrerenderFinalStatusSpeculationRuleRemoved
	case PrerenderFinalStatusActivatedWithAuxiliaryBrowsingContexts:
		*t = PrerenderFinalStatusActivatedWithAuxiliaryBrowsingContexts
	case PrerenderFinalStatusMaxNumOfRunningEagerPrerendersExceeded:
		*t = PrerenderFinalStatusMaxNumOfRunningEagerPrerendersExceeded
	case PrerenderFinalStatusMaxNumOfRunningNonEagerPrerendersExceeded:
		*t = PrerenderFinalStatusMaxNumOfRunningNonEagerPrerendersExceeded
	case PrerenderFinalStatusMaxNumOfRunningEmbedderPrerendersExceeded:
		*t = PrerenderFinalStatusMaxNumOfRunningEmbedderPrerendersExceeded
	case PrerenderFinalStatusPrerenderingURLHasEffectiveURL:
		*t = PrerenderFinalStatusPrerenderingURLHasEffectiveURL
	case PrerenderFinalStatusRedirectedPrerenderingURLHasEffectiveURL:
		*t = PrerenderFinalStatusRedirectedPrerenderingURLHasEffectiveURL
	case PrerenderFinalStatusActivationURLHasEffectiveURL:
		*t = PrerenderFinalStatusActivationURLHasEffectiveURL
	case PrerenderFinalStatusJavaScriptInterfaceAdded:
		*t = PrerenderFinalStatusJavaScriptInterfaceAdded
	case PrerenderFinalStatusJavaScriptInterfaceRemoved:
		*t = PrerenderFinalStatusJavaScriptInterfaceRemoved
	case PrerenderFinalStatusAllPrerenderingCanceled:
		*t = PrerenderFinalStatusAllPrerenderingCanceled
	case PrerenderFinalStatusWindowClosed:
		*t = PrerenderFinalStatusWindowClosed
	case PrerenderFinalStatusSlowNetwork:
		*t = PrerenderFinalStatusSlowNetwork
	case PrerenderFinalStatusOtherPrerenderedPageActivated:
		*t = PrerenderFinalStatusOtherPrerenderedPageActivated
	case PrerenderFinalStatusV8optimizerDisabled:
		*t = PrerenderFinalStatusV8optimizerDisabled
	case PrerenderFinalStatusPrerenderFailedDuringPrefetch:
		*t = PrerenderFinalStatusPrerenderFailedDuringPrefetch
	case PrerenderFinalStatusBrowsingDataRemoved:
		*t = PrerenderFinalStatusBrowsingDataRemoved
	default:
		return fmt.Errorf("unknown PrerenderFinalStatus value: %v", s)
	}
	return nil
}

// IngStatus preloading status values, see also PreloadingTriggeringOutcome.
// This status is shared by prefetchStatusUpdated and prerenderStatusUpdated.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Preload#type-PreloadingStatus
type IngStatus string

// String returns the IngStatus as string value.
func (t IngStatus) String() string {
	return string(t)
}

// IngStatus values.
const (
	IngStatusPending      IngStatus = "Pending"
	IngStatusRunning      IngStatus = "Running"
	IngStatusReady        IngStatus = "Ready"
	IngStatusSuccess      IngStatus = "Success"
	IngStatusFailure      IngStatus = "Failure"
	IngStatusNotSupported IngStatus = "NotSupported"
)

// UnmarshalJSON satisfies [json.Unmarshaler].
func (t *IngStatus) UnmarshalJSON(buf []byte) error {
	s := string(buf)
	s = strings.TrimSuffix(strings.TrimPrefix(s, `"`), `"`)

	switch IngStatus(s) {
	case IngStatusPending:
		*t = IngStatusPending
	case IngStatusRunning:
		*t = IngStatusRunning
	case IngStatusReady:
		*t = IngStatusReady
	case IngStatusSuccess:
		*t = IngStatusSuccess
	case IngStatusFailure:
		*t = IngStatusFailure
	case IngStatusNotSupported:
		*t = IngStatusNotSupported
	default:
		return fmt.Errorf("unknown IngStatus value: %v", s)
	}
	return nil
}

// PrefetchStatus tODO(https://crbug.com/1384419): revisit the list of
// PrefetchStatus and filter out the ones that aren't necessary to the
// developers.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Preload#type-PrefetchStatus
type PrefetchStatus string

// String returns the PrefetchStatus as string value.
func (t PrefetchStatus) String() string {
	return string(t)
}

// PrefetchStatus values.
const (
	PrefetchStatusPrefetchAllowed                                             PrefetchStatus = "PrefetchAllowed"
	PrefetchStatusPrefetchFailedIneligibleRedirect                            PrefetchStatus = "PrefetchFailedIneligibleRedirect"
	PrefetchStatusPrefetchFailedInvalidRedirect                               PrefetchStatus = "PrefetchFailedInvalidRedirect"
	PrefetchStatusPrefetchFailedMIMENotSupported                              PrefetchStatus = "PrefetchFailedMIMENotSupported"
	PrefetchStatusPrefetchFailedNetError                                      PrefetchStatus = "PrefetchFailedNetError"
	PrefetchStatusPrefetchFailedNon2xX                                        PrefetchStatus = "PrefetchFailedNon2XX"
	PrefetchStatusPrefetchEvictedAfterBrowsingDataRemoved                     PrefetchStatus = "PrefetchEvictedAfterBrowsingDataRemoved"
	PrefetchStatusPrefetchEvictedAfterCandidateRemoved                        PrefetchStatus = "PrefetchEvictedAfterCandidateRemoved"
	PrefetchStatusPrefetchEvictedForNewerPrefetch                             PrefetchStatus = "PrefetchEvictedForNewerPrefetch"
	PrefetchStatusPrefetchHeldback                                            PrefetchStatus = "PrefetchHeldback"
	PrefetchStatusPrefetchIneligibleRetryAfter                                PrefetchStatus = "PrefetchIneligibleRetryAfter"
	PrefetchStatusPrefetchIsPrivacyDecoy                                      PrefetchStatus = "PrefetchIsPrivacyDecoy"
	PrefetchStatusPrefetchIsStale                                             PrefetchStatus = "PrefetchIsStale"
	PrefetchStatusPrefetchNotEligibleBrowserContextOffTheRecord               PrefetchStatus = "PrefetchNotEligibleBrowserContextOffTheRecord"
	PrefetchStatusPrefetchNotEligibleDataSaverEnabled                         PrefetchStatus = "PrefetchNotEligibleDataSaverEnabled"
	PrefetchStatusPrefetchNotEligibleExistingProxy                            PrefetchStatus = "PrefetchNotEligibleExistingProxy"
	PrefetchStatusPrefetchNotEligibleHostIsNonUnique                          PrefetchStatus = "PrefetchNotEligibleHostIsNonUnique"
	PrefetchStatusPrefetchNotEligibleNonDefaultStoragePartition               PrefetchStatus = "PrefetchNotEligibleNonDefaultStoragePartition"
	PrefetchStatusPrefetchNotEligibleSameSiteCrossOriginPrefetchRequiredProxy PrefetchStatus = "PrefetchNotEligibleSameSiteCrossOriginPrefetchRequiredProxy"
	PrefetchStatusPrefetchNotEligibleSchemeIsNotHTTPS                         PrefetchStatus = "PrefetchNotEligibleSchemeIsNotHttps"
	PrefetchStatusPrefetchNotEligibleUserHasCookies                           PrefetchStatus = "PrefetchNotEligibleUserHasCookies"
	PrefetchStatusPrefetchNotEligibleUserHasServiceWorker                     PrefetchStatus = "PrefetchNotEligibleUserHasServiceWorker"
	PrefetchStatusPrefetchNotEligibleUserHasServiceWorkerNoFetchHandler       PrefetchStatus = "PrefetchNotEligibleUserHasServiceWorkerNoFetchHandler"
	PrefetchStatusPrefetchNotEligibleRedirectFromServiceWorker                PrefetchStatus = "PrefetchNotEligibleRedirectFromServiceWorker"
	PrefetchStatusPrefetchNotEligibleRedirectToServiceWorker                  PrefetchStatus = "PrefetchNotEligibleRedirectToServiceWorker"
	PrefetchStatusPrefetchNotEligibleBatterySaverEnabled                      PrefetchStatus = "PrefetchNotEligibleBatterySaverEnabled"
	PrefetchStatusPrefetchNotEligiblePreloadingDisabled                       PrefetchStatus = "PrefetchNotEligiblePreloadingDisabled"
	PrefetchStatusPrefetchNotFinishedInTime                                   PrefetchStatus = "PrefetchNotFinishedInTime"
	PrefetchStatusPrefetchNotStarted                                          PrefetchStatus = "PrefetchNotStarted"
	PrefetchStatusPrefetchNotUsedCookiesChanged                               PrefetchStatus = "PrefetchNotUsedCookiesChanged"
	PrefetchStatusPrefetchProxyNotAvailable                                   PrefetchStatus = "PrefetchProxyNotAvailable"
	PrefetchStatusPrefetchResponseUsed                                        PrefetchStatus = "PrefetchResponseUsed"
	PrefetchStatusPrefetchSuccessfulButNotUsed                                PrefetchStatus = "PrefetchSuccessfulButNotUsed"
	PrefetchStatusPrefetchNotUsedProbeFailed                                  PrefetchStatus = "PrefetchNotUsedProbeFailed"
)

// UnmarshalJSON satisfies [json.Unmarshaler].
func (t *PrefetchStatus) UnmarshalJSON(buf []byte) error {
	s := string(buf)
	s = strings.TrimSuffix(strings.TrimPrefix(s, `"`), `"`)

	switch PrefetchStatus(s) {
	case PrefetchStatusPrefetchAllowed:
		*t = PrefetchStatusPrefetchAllowed
	case PrefetchStatusPrefetchFailedIneligibleRedirect:
		*t = PrefetchStatusPrefetchFailedIneligibleRedirect
	case PrefetchStatusPrefetchFailedInvalidRedirect:
		*t = PrefetchStatusPrefetchFailedInvalidRedirect
	case PrefetchStatusPrefetchFailedMIMENotSupported:
		*t = PrefetchStatusPrefetchFailedMIMENotSupported
	case PrefetchStatusPrefetchFailedNetError:
		*t = PrefetchStatusPrefetchFailedNetError
	case PrefetchStatusPrefetchFailedNon2xX:
		*t = PrefetchStatusPrefetchFailedNon2xX
	case PrefetchStatusPrefetchEvictedAfterBrowsingDataRemoved:
		*t = PrefetchStatusPrefetchEvictedAfterBrowsingDataRemoved
	case PrefetchStatusPrefetchEvictedAfterCandidateRemoved:
		*t = PrefetchStatusPrefetchEvictedAfterCandidateRemoved
	case PrefetchStatusPrefetchEvictedForNewerPrefetch:
		*t = PrefetchStatusPrefetchEvictedForNewerPrefetch
	case PrefetchStatusPrefetchHeldback:
		*t = PrefetchStatusPrefetchHeldback
	case PrefetchStatusPrefetchIneligibleRetryAfter:
		*t = PrefetchStatusPrefetchIneligibleRetryAfter
	case PrefetchStatusPrefetchIsPrivacyDecoy:
		*t = PrefetchStatusPrefetchIsPrivacyDecoy
	case PrefetchStatusPrefetchIsStale:
		*t = PrefetchStatusPrefetchIsStale
	case PrefetchStatusPrefetchNotEligibleBrowserContextOffTheRecord:
		*t = PrefetchStatusPrefetchNotEligibleBrowserContextOffTheRecord
	case PrefetchStatusPrefetchNotEligibleDataSaverEnabled:
		*t = PrefetchStatusPrefetchNotEligibleDataSaverEnabled
	case PrefetchStatusPrefetchNotEligibleExistingProxy:
		*t = PrefetchStatusPrefetchNotEligibleExistingProxy
	case PrefetchStatusPrefetchNotEligibleHostIsNonUnique:
		*t = PrefetchStatusPrefetchNotEligibleHostIsNonUnique
	case PrefetchStatusPrefetchNotEligibleNonDefaultStoragePartition:
		*t = PrefetchStatusPrefetchNotEligibleNonDefaultStoragePartition
	case PrefetchStatusPrefetchNotEligibleSameSiteCrossOriginPrefetchRequiredProxy:
		*t = PrefetchStatusPrefetchNotEligibleSameSiteCrossOriginPrefetchRequiredProxy
	case PrefetchStatusPrefetchNotEligibleSchemeIsNotHTTPS:
		*t = PrefetchStatusPrefetchNotEligibleSchemeIsNotHTTPS
	case PrefetchStatusPrefetchNotEligibleUserHasCookies:
		*t = PrefetchStatusPrefetchNotEligibleUserHasCookies
	case PrefetchStatusPrefetchNotEligibleUserHasServiceWorker:
		*t = PrefetchStatusPrefetchNotEligibleUserHasServiceWorker
	case PrefetchStatusPrefetchNotEligibleUserHasServiceWorkerNoFetchHandler:
		*t = PrefetchStatusPrefetchNotEligibleUserHasServiceWorkerNoFetchHandler
	case PrefetchStatusPrefetchNotEligibleRedirectFromServiceWorker:
		*t = PrefetchStatusPrefetchNotEligibleRedirectFromServiceWorker
	case PrefetchStatusPrefetchNotEligibleRedirectToServiceWorker:
		*t = PrefetchStatusPrefetchNotEligibleRedirectToServiceWorker
	case PrefetchStatusPrefetchNotEligibleBatterySaverEnabled:
		*t = PrefetchStatusPrefetchNotEligibleBatterySaverEnabled
	case PrefetchStatusPrefetchNotEligiblePreloadingDisabled:
		*t = PrefetchStatusPrefetchNotEligiblePreloadingDisabled
	case PrefetchStatusPrefetchNotFinishedInTime:
		*t = PrefetchStatusPrefetchNotFinishedInTime
	case PrefetchStatusPrefetchNotStarted:
		*t = PrefetchStatusPrefetchNotStarted
	case PrefetchStatusPrefetchNotUsedCookiesChanged:
		*t = PrefetchStatusPrefetchNotUsedCookiesChanged
	case PrefetchStatusPrefetchProxyNotAvailable:
		*t = PrefetchStatusPrefetchProxyNotAvailable
	case PrefetchStatusPrefetchResponseUsed:
		*t = PrefetchStatusPrefetchResponseUsed
	case PrefetchStatusPrefetchSuccessfulButNotUsed:
		*t = PrefetchStatusPrefetchSuccessfulButNotUsed
	case PrefetchStatusPrefetchNotUsedProbeFailed:
		*t = PrefetchStatusPrefetchNotUsedProbeFailed
	default:
		return fmt.Errorf("unknown PrefetchStatus value: %v", s)
	}
	return nil
}

// PrerenderMismatchedHeaders information of headers to be displayed when the
// header mismatch occurred.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Preload#type-PrerenderMismatchedHeaders
type PrerenderMismatchedHeaders struct {
	HeaderName      string `json:"headerName"`
	InitialValue    string `json:"initialValue,omitempty,omitzero"`
	ActivationValue string `json:"activationValue,omitempty,omitzero"`
}
