/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.base.Preconditions;
import com.google.common.truth.ComparableSubject;
import com.google.common.truth.Fact;
import com.google.common.truth.FailureMetadata;
import com.google.common.truth.MathUtil;
import org.jspecify.annotations.Nullable;

public class IntegerSubject
extends ComparableSubject<Integer> {
    private final @Nullable Integer actual;

    protected IntegerSubject(FailureMetadata metadata, @Nullable Integer actual) {
        super(metadata, actual);
        this.actual = actual;
    }

    public TolerantIntegerComparison isWithin(final int tolerance) {
        return new TolerantIntegerComparison(){

            @Override
            public void of(int expected) {
                Integer actual = IntegerSubject.this.actual;
                Preconditions.checkNotNull((Object)actual, (String)"actual value cannot be null. tolerance=%s expected=%s", (int)tolerance, (int)expected);
                IntegerSubject.checkTolerance(tolerance);
                if (!MathUtil.equalWithinTolerance(actual, expected, tolerance)) {
                    IntegerSubject.this.failWithoutActual(Fact.fact("expected", Integer.toString(expected)), IntegerSubject.this.butWas(), Fact.fact("outside tolerance", Integer.toString(tolerance)));
                }
            }
        };
    }

    public TolerantIntegerComparison isNotWithin(final int tolerance) {
        return new TolerantIntegerComparison(){

            @Override
            public void of(int expected) {
                Integer actual = IntegerSubject.this.actual;
                Preconditions.checkNotNull((Object)actual, (String)"actual value cannot be null. tolerance=%s expected=%s", (int)tolerance, (int)expected);
                IntegerSubject.checkTolerance(tolerance);
                if (MathUtil.equalWithinTolerance(actual, expected, tolerance)) {
                    IntegerSubject.this.failWithoutActual(Fact.fact("expected not to be", Integer.toString(expected)), IntegerSubject.this.butWas(), Fact.fact("within tolerance", Integer.toString(tolerance)));
                }
            }
        };
    }

    @Override
    @Deprecated
    public final void isEquivalentAccordingToCompareTo(@Nullable Integer other) {
        super.isEquivalentAccordingToCompareTo(other);
    }

    private static void checkTolerance(int tolerance) {
        Preconditions.checkArgument((tolerance >= 0 ? 1 : 0) != 0, (String)"tolerance (%s) cannot be negative", (int)tolerance);
    }

    public static abstract class TolerantIntegerComparison {
        private TolerantIntegerComparison() {
        }

        public abstract void of(int var1);

        @Deprecated
        public boolean equals(@Nullable Object o) {
            throw new UnsupportedOperationException("If you meant to compare ints, use .of(int) instead.");
        }

        @Deprecated
        public int hashCode() {
            throw new UnsupportedOperationException("Subject.hashCode() is not supported.");
        }
    }
}

