/*
 * Decompiled with CFR 0.152.
 */
package git4idea.ui.branch.dashboard;

import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsLogUserFilter;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.data.DataPack;
import com.intellij.vcs.log.data.RefsModel;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.data.VcsLogStorage;
import com.intellij.vcs.log.data.index.IndexDataGetter;
import com.intellij.vcs.log.impl.VcsProjectLog;
import com.intellij.vcs.log.util.DataPackUtilKt;
import com.intellij.vcs.log.visible.filters.VcsLogFilterObject;
import git4idea.GitBranch;
import git4idea.GitLocalBranch;
import git4idea.GitReference;
import git4idea.GitRemoteBranch;
import git4idea.GitTag;
import git4idea.branch.GitBranchIncomingOutgoingManager;
import git4idea.branch.GitRefType;
import git4idea.branch.IncomingOutgoingState;
import git4idea.repo.GitRefUtil;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.ui.branch.GitBranchManager;
import git4idea.ui.branch.dashboard.BranchInfo;
import git4idea.ui.branch.dashboard.TagInfo;
import git4idea.ui.branch.tree.GitBranchesTreeModelUtilKt;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u000e\u0010\t\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\u0005J$\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u000e\u0010\t\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\u0005J$\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u00052\u0006\u0010\u0007\u001a\u00020\b2\u000e\u0010\t\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\u0005J&\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J4\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0007\u001a\u00020\b2\u000e\u0010\t\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\u00052\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00180\u001aH\u0002J*\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u001c\u001a\u00020\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00060\u00112\u0006\u0010\u001f\u001a\u00020 J\u0016\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\u00052\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J.\u0010#\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u00122\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\"0\u0005H\u0002J\"\u0010(\u001a\u0004\u0018\u00010)2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u0012H\u0002\u00a8\u0006*"}, d2={"Lgit4idea/ui/branch/dashboard/BranchesDashboardUtil;", "", "<init>", "()V", "getLocalBranches", "", "Lgit4idea/ui/branch/dashboard/BranchInfo;", "project", "Lcom/intellij/openapi/project/Project;", "rootsToFilter", "Lcom/intellij/openapi/vfs/VirtualFile;", "getRemoteBranches", "getTags", "Lgit4idea/ui/branch/dashboard/TagInfo;", "isFavoriteInAnyRepo", "", "repos", "", "Lgit4idea/repo/GitRepository;", "gitBranchManager", "Lgit4idea/ui/branch/GitBranchManager;", "ref", "Lgit4idea/GitReference;", "forEachRepo", "", "consumer", "Lkotlin/Function1;", "checkIsMyBranchesSynchronously", "log", "Lcom/intellij/vcs/log/impl/VcsProjectLog;", "branchesToCheck", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "findMyCommits", "", "isMyBranch", "branchName", "", "repo", "myCommits", "findExclusiveCommits", "Lit/unimi/dsi/fastutil/ints/IntSet;", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nBranchesDashboardUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BranchesDashboardUtil.kt\ngit4idea/ui/branch/dashboard/BranchesDashboardUtil\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,147:1\n31#2,2:148\n31#2,2:157\n31#2,2:163\n126#3:150\n153#3,2:151\n155#3:156\n126#3:159\n153#3,3:160\n153#3,2:165\n155#3:170\n1755#4,3:153\n1755#4,3:167\n1755#4,3:171\n*S KotlinDebug\n*F\n+ 1 BranchesDashboardUtil.kt\ngit4idea/ui/branch/dashboard/BranchesDashboardUtil\n*L\n39#1:148,2\n58#1:157,2\n74#1:163,2\n41#1:150\n41#1:151,2\n41#1:156\n59#1:159\n59#1:160,3\n75#1:165,2\n75#1:170\n42#1:153,3\n76#1:167,3\n82#1:171,3\n*E\n"})
public final class BranchesDashboardUtil {
    @NotNull
    public static final BranchesDashboardUtil INSTANCE = new BranchesDashboardUtil();

    private BranchesDashboardUtil() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<BranchInfo> getLocalBranches(@NotNull Project project, @Nullable Set<? extends VirtualFile> rootsToFilter) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Map localMap = new LinkedHashMap();
        this.forEachRepo(project, rootsToFilter, (Function1<? super GitRepository, Unit>)((Function1)arg_0 -> BranchesDashboardUtil.getLocalBranches$lambda$4(localMap, arg_0)));
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Class<GitBranchManager> serviceClass$iv = GitBranchManager.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        GitBranchManager gitBranchManager = (GitBranchManager)((Object)object);
        GitBranchIncomingOutgoingManager gitBranchIncomingOutgoingManager = GitBranchIncomingOutgoingManager.getInstance(project);
        Intrinsics.checkNotNullExpressionValue((Object)gitBranchIncomingOutgoingManager, (String)"getInstance(...)");
        GitBranchIncomingOutgoingManager incomingOutgoingManager = gitBranchIncomingOutgoingManager;
        Map $this$map$iv = localMap;
        boolean $i$f$map = false;
        Map map2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            IncomingOutgoingState incomingOutgoingState;
            boolean bl;
            GitBranch gitBranch;
            Set repos;
            GitLocalBranch branch;
            Collection collection;
            block5: {
                void $this$any$iv;
                Map.Entry item$iv$iv;
                Map.Entry entry = item$iv$iv = iterator.next();
                collection = destination$iv$iv;
                boolean bl2 = false;
                branch = (GitLocalBranch)entry.getKey();
                repos = (Set)entry.getValue();
                Iterable iterable = repos;
                gitBranch = branch;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        GitRepository it = (GitRepository)element$iv;
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual((Object)it.getCurrentBranch(), (Object)branch)) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
            }
            boolean bl4 = bl;
            boolean bl5 = INSTANCE.isFavoriteInAnyRepo(repos, gitBranchManager, branch);
            Intrinsics.checkNotNullExpressionValue((Object)incomingOutgoingManager.getIncomingOutgoingState(repos, branch), (String)"getIncomingOutgoingState(...)");
            List list = CollectionsKt.toList((Iterable)repos);
            boolean bl6 = bl5;
            boolean bl7 = bl4;
            GitBranch gitBranch2 = gitBranch;
            collection.add(new BranchInfo(gitBranch2, bl7, bl6, incomingOutgoingState, list));
        }
        HashSet local = CollectionsKt.toHashSet((Iterable)((List)destination$iv$iv));
        return local;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<BranchInfo> getRemoteBranches(@NotNull Project project, @Nullable Set<? extends VirtualFile> rootsToFilter) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Map remoteMap = new LinkedHashMap();
        this.forEachRepo(project, rootsToFilter, (Function1<? super GitRepository, Unit>)((Function1)arg_0 -> BranchesDashboardUtil.getRemoteBranches$lambda$9(remoteMap, arg_0)));
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Object serviceClass$iv = GitBranchManager.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        GitBranchManager gitBranchManager = (GitBranchManager)((Object)object);
        Map $this$map$iv = remoteMap;
        boolean $i$f$map = false;
        serviceClass$iv = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            GitBranch branch = (GitBranch)entry.getKey();
            List repos = (List)entry.getValue();
            collection.add(new BranchInfo(branch, false, INSTANCE.isFavoriteInAnyRepo(repos, gitBranchManager, branch), IncomingOutgoingState.EMPTY, repos));
        }
        return CollectionsKt.toHashSet((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<TagInfo> getTags(@NotNull Project project, @Nullable Set<? extends VirtualFile> rootsToFilter) {
        void destination$iv;
        void $this$mapTo$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Map tags2 = new LinkedHashMap();
        this.forEachRepo(project, rootsToFilter, (Function1<? super GitRepository, Unit>)((Function1)arg_0 -> BranchesDashboardUtil.getTags$lambda$13(tags2, arg_0)));
        Object $this$service$iv = (ComponentManager)project;
        boolean $i$f$service22 = false;
        Class<GitBranchManager> serviceClass$iv = GitBranchManager.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        GitBranchManager gitBranchManager = (GitBranchManager)((Object)object);
        $this$service$iv = tags2;
        Collection $i$f$service22 = new LinkedHashSet();
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            boolean bl;
            GitTag gitTag;
            List repos;
            GitTag tag;
            void var22_24;
            block5: {
                void $this$any$iv;
                Map.Entry item$iv;
                Map.Entry entry = item$iv = iterator.next();
                var22_24 = destination$iv;
                boolean bl2 = false;
                tag = (GitTag)entry.getKey();
                repos = (List)entry.getValue();
                Iterable iterable = repos;
                gitTag = tag;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        GitRepository it = (GitRepository)element$iv;
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual((Object)GitRefUtil.getCurrentTag(it), (Object)tag)) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
            }
            boolean bl4 = bl;
            List list = repos;
            boolean bl5 = INSTANCE.isFavoriteInAnyRepo(repos, gitBranchManager, tag);
            boolean bl6 = bl4;
            GitTag gitTag2 = gitTag;
            var22_24.add(new TagInfo(gitTag2, bl6, bl5, list));
        }
        return (Set)destination$iv;
    }

    private final boolean isFavoriteInAnyRepo(Collection<? extends GitRepository> repos, GitBranchManager gitBranchManager, GitReference ref) {
        boolean bl;
        block3: {
            GitRefType refType = GitRefType.Companion.of$default(GitRefType.Companion, ref, false, 2, null);
            Iterable $this$any$iv = repos;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    GitRepository it = (GitRepository)element$iv;
                    boolean bl2 = false;
                    if (!gitBranchManager.isFavorite(refType, it, ref.getName())) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final void forEachRepo(Project project, Set<? extends VirtualFile> rootsToFilter, Function1<? super GitRepository, Unit> consumer) {
        for (GitRepository repo2 : GitRepositoryManager.getInstance(project).getRepositories()) {
            if (rootsToFilter != null && !rootsToFilter.contains(repo2.getRoot())) continue;
            Intrinsics.checkNotNull((Object)repo2);
            consumer.invoke((Object)repo2);
        }
    }

    @NotNull
    public final Set<BranchInfo> checkIsMyBranchesSynchronously(@NotNull VcsProjectLog log, @NotNull Collection<BranchInfo> branchesToCheck, @NotNull ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        Intrinsics.checkNotNullParameter(branchesToCheck, (String)"branchesToCheck");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        Set<Integer> myCommits = this.findMyCommits(log);
        if (myCommits.isEmpty()) {
            return SetsKt.emptySet();
        }
        indicator.setIndeterminate(false);
        HashSet<BranchInfo> myBranches = new HashSet<BranchInfo>();
        Iterator iterator = ((Iterable)branchesToCheck).iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int step = n++;
            BranchInfo branch = (BranchInfo)iterator.next();
            indicator.setFraction((double)step / (double)branchesToCheck.size());
            for (GitRepository repo2 : branch.getRepositories()) {
                indicator.checkCanceled();
                if (!this.isMyBranch(log, branch.getBranchName(), repo2, myCommits)) continue;
                myBranches.add(branch);
            }
        }
        return myBranches;
    }

    private final Set<Integer> findMyCommits(VcsProjectLog log) {
        Collection collection = CollectionsKt.listOf((Object)"*");
        VcsLogData vcsLogData = log.getDataManager();
        Intrinsics.checkNotNull((Object)vcsLogData);
        VcsLogUserFilter filterByMe = VcsLogFilterObject.fromUserNames((Collection)collection, (VcsLogData)vcsLogData);
        VcsLogData vcsLogData2 = log.getDataManager();
        Intrinsics.checkNotNull((Object)vcsLogData2);
        IndexDataGetter indexDataGetter = vcsLogData2.getIndex().getDataGetter();
        Intrinsics.checkNotNull((Object)indexDataGetter);
        IntSet intSet = indexDataGetter.filter(CollectionsKt.listOf((Object)filterByMe));
        Intrinsics.checkNotNullExpressionValue((Object)intSet, (String)"filter(...)");
        return (Set)intSet;
    }

    private final boolean isMyBranch(VcsProjectLog log, String branchName, GitRepository repo2, Set<Integer> myCommits) {
        IntSet intSet = this.findExclusiveCommits(log, branchName, repo2);
        if (intSet == null) {
            return false;
        }
        IntSet exclusiveCommits = intSet;
        if (exclusiveCommits.isEmpty()) {
            return false;
        }
        IntIterator intIterator = exclusiveCommits.iterator();
        Intrinsics.checkNotNullExpressionValue((Object)intIterator, (String)"iterator(...)");
        IntIterator intIterator2 = intIterator;
        while (intIterator2.hasNext()) {
            Integer commit = intIterator2.next();
            if (myCommits.contains(commit)) continue;
            return false;
        }
        return true;
    }

    private final IntSet findExclusiveCommits(VcsProjectLog log, String branchName, GitRepository repo2) {
        VcsLogData vcsLogData = log.getDataManager();
        Intrinsics.checkNotNull((Object)vcsLogData);
        DataPack dataPack = vcsLogData.getDataPack();
        Intrinsics.checkNotNullExpressionValue((Object)dataPack, (String)"getDataPack(...)");
        DataPack dataPack2 = dataPack;
        VirtualFile virtualFile = repo2.getRoot();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getRoot(...)");
        VcsRef vcsRef = DataPackUtilKt.findBranch((DataPack)dataPack2, (String)branchName, (VirtualFile)virtualFile);
        if (vcsRef == null) {
            return null;
        }
        VcsRef ref = vcsRef;
        if (!ref.getType().isBranch()) {
            return null;
        }
        RefsModel refsModel = dataPack2.getRefsModel();
        Intrinsics.checkNotNullExpressionValue((Object)refsModel, (String)"getRefsModel(...)");
        VcsLogData vcsLogData2 = log.getDataManager();
        Intrinsics.checkNotNull((Object)vcsLogData2);
        VcsLogStorage vcsLogStorage = vcsLogData2.getStorage();
        Intrinsics.checkNotNullExpressionValue((Object)vcsLogStorage, (String)"getStorage(...)");
        return DataPackUtilKt.exclusiveCommits((DataPack)dataPack2, (VcsRef)ref, (RefsModel)refsModel, (VcsLogStorage)vcsLogStorage);
    }

    private static final Set getLocalBranches$lambda$4$lambda$0(GitLocalBranch it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new HashSet();
    }

    private static final Set getLocalBranches$lambda$4$lambda$1(Function1 $tmp0, Object p0) {
        return (Set)$tmp0.invoke(p0);
    }

    private static final Set getLocalBranches$lambda$4$lambda$2(GitLocalBranch it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new HashSet();
    }

    private static final Set getLocalBranches$lambda$4$lambda$3(Function1 $tmp0, Object p0) {
        return (Set)$tmp0.invoke(p0);
    }

    private static final Unit getLocalBranches$lambda$4(Map $localMap, GitRepository repo2) {
        Intrinsics.checkNotNullParameter((Object)repo2, (String)"repo");
        for (GitLocalBranch branch : repo2.getBranches().getLocalBranches()) {
            $localMap.computeIfAbsent(branch, arg_0 -> BranchesDashboardUtil.getLocalBranches$lambda$4$lambda$1(BranchesDashboardUtil::getLocalBranches$lambda$4$lambda$0, arg_0)).add(repo2);
        }
        GitLocalBranch currentBranch = repo2.getCurrentBranch();
        if (currentBranch != null) {
            $localMap.computeIfAbsent(currentBranch, arg_0 -> BranchesDashboardUtil.getLocalBranches$lambda$4$lambda$3(BranchesDashboardUtil::getLocalBranches$lambda$4$lambda$2, arg_0)).add(repo2);
        }
        return Unit.INSTANCE;
    }

    private static final List getRemoteBranches$lambda$9$lambda$7(GitBranch it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new ArrayList();
    }

    private static final List getRemoteBranches$lambda$9$lambda$8(Function1 $tmp0, Object p0) {
        return (List)$tmp0.invoke(p0);
    }

    private static final Unit getRemoteBranches$lambda$9(Map $remoteMap, GitRepository repo2) {
        Intrinsics.checkNotNullParameter((Object)repo2, (String)"repo");
        for (GitRemoteBranch remoteBranch : repo2.getBranches().getRemoteBranches()) {
            $remoteMap.computeIfAbsent(remoteBranch, arg_0 -> BranchesDashboardUtil.getRemoteBranches$lambda$9$lambda$8(BranchesDashboardUtil::getRemoteBranches$lambda$9$lambda$7, arg_0)).add(repo2);
        }
        return Unit.INSTANCE;
    }

    private static final List getTags$lambda$13$lambda$11(GitTag it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new ArrayList();
    }

    private static final List getTags$lambda$13$lambda$12(Function1 $tmp0, Object p0) {
        return (List)$tmp0.invoke(p0);
    }

    private static final Unit getTags$lambda$13(Map $tags, GitRepository repo2) {
        Intrinsics.checkNotNullParameter((Object)repo2, (String)"repo");
        for (Map.Entry<GitTag, Hash> tag : GitBranchesTreeModelUtilKt.getTags(repo2).entrySet()) {
            $tags.computeIfAbsent(tag.getKey(), arg_0 -> BranchesDashboardUtil.getTags$lambda$13$lambda$12(BranchesDashboardUtil::getTags$lambda$13$lambda$11, arg_0)).add(repo2);
        }
        return Unit.INSTANCE;
    }
}

