/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.text;

import com.intellij.openapi.util.text.Strings;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.Arrays;
import java.util.function.IntPredicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StringSearcher {
    private final String myPattern;
    private final char[] myPatternArray;
    private final int myPatternLength;
    private final int[] mySearchTable;
    private final boolean myCaseSensitive;
    private final boolean myLowercaseTransform;
    private final boolean myForwardDirection;
    private final boolean myJavaIdentifier;
    private final boolean myHandleEscapeSequences;

    public int getPatternLength() {
        return this.myPatternLength;
    }

    public StringSearcher(@NotNull String pattern, boolean caseSensitive, boolean forwardDirection) {
        if (pattern == null) {
            StringSearcher.$$$reportNull$$$0(0);
        }
        this(pattern, caseSensitive, forwardDirection, false);
    }

    public StringSearcher(@NotNull String pattern, boolean caseSensitive, boolean forwardDirection, boolean handleEscapeSequences) {
        if (pattern == null) {
            StringSearcher.$$$reportNull$$$0(1);
        }
        this(pattern, caseSensitive, forwardDirection, handleEscapeSequences, true);
    }

    public StringSearcher(@NotNull String pattern, boolean caseSensitive, boolean forwardDirection, boolean handleEscapeSequences, boolean lookForJavaIdentifiersOnlyIfPossible) {
        char[] chars;
        if (pattern == null) {
            StringSearcher.$$$reportNull$$$0(2);
        }
        this.mySearchTable = new int[128];
        this.myHandleEscapeSequences = handleEscapeSequences;
        if (pattern.isEmpty()) {
            throw new IllegalArgumentException("pattern is empty");
        }
        this.myPattern = pattern;
        this.myCaseSensitive = caseSensitive;
        this.myForwardDirection = forwardDirection;
        char[] cArray = chars = this.myCaseSensitive ? this.myPattern.toCharArray() : Strings.toLowerCase(this.myPattern).toCharArray();
        if (chars.length != this.myPattern.length()) {
            this.myLowercaseTransform = false;
            chars = Strings.toUpperCase(this.myPattern).toCharArray();
        } else {
            this.myLowercaseTransform = true;
        }
        this.myPatternArray = chars;
        this.myPatternLength = this.myPatternArray.length;
        Arrays.fill(this.mySearchTable, -1);
        this.myJavaIdentifier = lookForJavaIdentifiersOnlyIfPossible && Character.isJavaIdentifierPart(pattern.charAt(0)) && Character.isJavaIdentifierPart(pattern.charAt(pattern.length() - 1));
    }

    @NotNull
    public String getPattern() {
        String string = this.myPattern;
        if (string == null) {
            StringSearcher.$$$reportNull$$$0(3);
        }
        return string;
    }

    public boolean isCaseSensitive() {
        return this.myCaseSensitive;
    }

    public boolean isJavaIdentifier() {
        return this.myJavaIdentifier;
    }

    public boolean isHandleEscapeSequences() {
        return this.myHandleEscapeSequences;
    }

    public int scan(@NotNull CharSequence text) {
        if (text == null) {
            StringSearcher.$$$reportNull$$$0(4);
        }
        return this.scan(text, 0, text.length());
    }

    public int scan(@NotNull CharSequence text, int _start, int _end) {
        if (text == null) {
            StringSearcher.$$$reportNull$$$0(5);
        }
        return this.scan(text, null, _start, _end);
    }

    public int @NotNull [] findAllOccurrences(@NotNull CharSequence text) {
        if (text == null) {
            StringSearcher.$$$reportNull$$$0(6);
        }
        int end = text.length();
        IntArrayList result2 = new IntArrayList();
        for (int index = 0; index < end && (index = this.scan(text, index, end)) >= 0; ++index) {
            result2.add(index);
        }
        int[] nArray = result2.toIntArray();
        if (nArray == null) {
            StringSearcher.$$$reportNull$$$0(7);
        }
        return nArray;
    }

    public boolean processOccurrences(@NotNull CharSequence text, @NotNull IntPredicate consumer2) {
        if (text == null) {
            StringSearcher.$$$reportNull$$$0(8);
        }
        if (consumer2 == null) {
            StringSearcher.$$$reportNull$$$0(9);
        }
        int end = text.length();
        for (int index = 0; index < end && (index = this.scan(text, index, end)) >= 0; ++index) {
            if (consumer2.test(index)) continue;
            return false;
        }
        return true;
    }

    public int scan(@NotNull CharSequence text, char @Nullable [] textArray, int _start, int _end) {
        if (text == null) {
            StringSearcher.$$$reportNull$$$0(10);
        }
        if (_start > _end) {
            throw new AssertionError((Object)("start > end, " + _start + ">" + _end));
        }
        int textLength = text.length();
        if (_end > textLength) {
            throw new AssertionError((Object)("end > length, " + _end + ">" + textLength));
        }
        if (this.myForwardDirection) {
            int step;
            if (this.myPatternLength == 1) {
                return Strings.indexOf(text, this.myPatternArray[0], _start, _end, this.myCaseSensitive);
            }
            int end = _end - this.myPatternLength;
            for (int start = _start; start <= end; start += step) {
                int index;
                int i = this.myPatternLength - 1;
                char lastChar = this.normalizedCharAt(text, textArray, start + i);
                if (this.isSameChar(this.myPatternArray[i], lastChar)) {
                    --i;
                    while (i >= 0) {
                        char c;
                        char c2 = c = textArray != null ? textArray[start + i] : text.charAt(start + i);
                        if (!this.isSameChar(this.myPatternArray[i], c)) break;
                        --i;
                    }
                    if (i < 0) {
                        return start;
                    }
                }
                int n = step = lastChar < '\u0080' ? this.mySearchTable[lastChar] : 1;
                if (step > 0) continue;
                for (index = this.myPatternLength - 2; index >= 0 && this.myPatternArray[index] != lastChar; --index) {
                }
                this.mySearchTable[lastChar] = step = this.myPatternLength - index - 1;
            }
        } else {
            int step;
            for (int start = 1; start <= _end - this.myPatternLength + 1; start += step) {
                int index;
                int i = this.myPatternLength - 1;
                char lastChar = this.normalizedCharAt(text, textArray, _end - (start + i));
                if (this.isSameChar(this.myPatternArray[this.myPatternLength - 1 - i], lastChar)) {
                    --i;
                    while (i >= 0) {
                        char c;
                        char c3 = c = textArray != null ? textArray[_end - (start + i)] : text.charAt(_end - (start + i));
                        if (!this.isSameChar(this.myPatternArray[this.myPatternLength - 1 - i], c)) break;
                        --i;
                    }
                    if (i < 0) {
                        return _end - start - this.myPatternLength + 1;
                    }
                }
                int n = step = lastChar < '\u0080' ? this.mySearchTable[lastChar] : 1;
                if (step > 0) continue;
                for (index = this.myPatternLength - 2; index >= 0 && this.myPatternArray[this.myPatternLength - 1 - index] != lastChar; --index) {
                }
                this.mySearchTable[lastChar] = step = this.myPatternLength - index - 1;
            }
        }
        return -1;
    }

    private char normalizedCharAt(@NotNull CharSequence text, char @Nullable [] textArray, int index) {
        char lastChar;
        if (text == null) {
            StringSearcher.$$$reportNull$$$0(11);
        }
        char c = lastChar = textArray != null ? textArray[index] : text.charAt(index);
        if (this.myCaseSensitive) {
            return lastChar;
        }
        return this.myLowercaseTransform ? Strings.toLowerCase(lastChar) : Strings.toUpperCase(lastChar);
    }

    private boolean isSameChar(char charInPattern, char charInText) {
        boolean sameChar;
        boolean bl = sameChar = charInPattern == charInText;
        if (!sameChar && !this.myCaseSensitive) {
            return Strings.charsEqualIgnoreCase(charInPattern, charInText);
        }
        return sameChar;
    }

    public String toString() {
        return "pattern " + this.myPattern;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StringSearcher searcher = (StringSearcher)o;
        if (this.myCaseSensitive != searcher.myCaseSensitive) {
            return false;
        }
        if (this.myLowercaseTransform != searcher.myLowercaseTransform) {
            return false;
        }
        if (this.myForwardDirection != searcher.myForwardDirection) {
            return false;
        }
        if (this.myJavaIdentifier != searcher.myJavaIdentifier) {
            return false;
        }
        if (this.myHandleEscapeSequences != searcher.myHandleEscapeSequences) {
            return false;
        }
        return this.myPattern.equals(searcher.myPattern);
    }

    public int hashCode() {
        int result2 = this.myPattern.hashCode();
        result2 = 31 * result2 + (this.myCaseSensitive ? 1 : 0);
        result2 = 31 * result2 + (this.myLowercaseTransform ? 1 : 0);
        result2 = 31 * result2 + (this.myForwardDirection ? 1 : 0);
        result2 = 31 * result2 + (this.myJavaIdentifier ? 1 : 0);
        result2 = 31 * result2 + (this.myHandleEscapeSequences ? 1 : 0);
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/text/StringSearcher";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/text/StringSearcher";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPattern";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "findAllOccurrences";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 7: {
                break;
            }
            case 4: 
            case 5: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "scan";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findAllOccurrences";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "processOccurrences";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "normalizedCharAt";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

