/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.changes;

import com.intellij.ide.projectView.ProjectView;
import com.intellij.ide.projectView.impl.AbstractProjectViewPane;
import com.intellij.ide.scopeView.ScopeViewPane;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListAdapter;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.LocalChangeListsLoadedListener;
import com.intellij.packageDependencies.DependencyValidationManager;
import com.intellij.vcs.changes.ChangeListScope;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0000\u0018\u0000 \u00112\u00020\u0001:\u0002\u0010\u0011B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\u000b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u0007H\u0016J\b\u0010\u000f\u001a\u00020\u0007H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/vcs/changes/ChangeListScopeViewUpdater;", "Lcom/intellij/openapi/vcs/changes/ChangeListAdapter;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "changeListAdded", "", "list", "Lcom/intellij/openapi/vcs/changes/ChangeList;", "changeListRemoved", "changeListRenamed", "oldName", "", "changeListAvailabilityChanged", "changeListsChanged", "InitialRefresh", "Companion", "intellij.platform.vcs.impl"})
public final class ChangeListScopeViewUpdater
extends ChangeListAdapter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;

    public ChangeListScopeViewUpdater(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    public void changeListAdded(@NotNull ChangeList list) {
        Intrinsics.checkNotNullParameter((Object)list, (String)"list");
        ChangeListScopeViewUpdater.Companion.updateAvailableScopesList(this.project);
    }

    public void changeListRemoved(@NotNull ChangeList list) {
        Intrinsics.checkNotNullParameter((Object)list, (String)"list");
        ChangeListScopeViewUpdater.Companion.updateAvailableScopesList(this.project);
    }

    public void changeListRenamed(@NotNull ChangeList list, @NotNull String oldName) {
        Intrinsics.checkNotNullParameter((Object)list, (String)"list");
        Intrinsics.checkNotNullParameter((Object)oldName, (String)"oldName");
        ChangeListScopeViewUpdater.Companion.updateAvailableScopesList(this.project);
    }

    public void changeListAvailabilityChanged() {
        ChangeListScopeViewUpdater.Companion.updateAvailableScopesList(this.project);
    }

    public void changeListsChanged() {
        ChangeListScopeViewUpdater.Companion.updateActiveScope(this.project);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\t"}, d2={"Lcom/intellij/vcs/changes/ChangeListScopeViewUpdater$Companion;", "", "<init>", "()V", "updateActiveScope", "", "project", "Lcom/intellij/openapi/project/Project;", "updateAvailableScopesList", "intellij.platform.vcs.impl"})
    @SourceDebugExtension(value={"SMAP\nChangeListScopeViewUpdater.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChangeListScopeViewUpdater.kt\ncom/intellij/vcs/changes/ChangeListScopeViewUpdater$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,62:1\n59#2:63\n*S KotlinDebug\n*F\n+ 1 ChangeListScopeViewUpdater.kt\ncom/intellij/vcs/changes/ChangeListScopeViewUpdater$Companion\n*L\n46#1:63\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final void updateActiveScope(Project project) {
            ApplicationManager.getApplication().invokeLater(() -> Companion.updateActiveScope$lambda$0(project));
        }

        private final void updateAvailableScopesList(Project project) {
            ApplicationManager.getApplication().invokeLater(() -> Companion.updateAvailableScopesList$lambda$1(project));
        }

        private static final void updateActiveScope$lambda$0(Project $project) {
            if ($project.isDisposed()) {
                return;
            }
            ComponentManager $this$serviceIfCreated$iv = (ComponentManager)$project;
            boolean $i$f$serviceIfCreated = false;
            ProjectView projectView = (ProjectView)$this$serviceIfCreated$iv.getServiceIfCreated(ProjectView.class);
            if (projectView == null) {
                return;
            }
            ProjectView projectView2 = projectView;
            AbstractProjectViewPane abstractProjectViewPane = projectView2.getProjectViewPaneById("Scope");
            ScopeViewPane scopeViewPane = abstractProjectViewPane instanceof ScopeViewPane ? (ScopeViewPane)abstractProjectViewPane : null;
            if (scopeViewPane == null) {
                return;
            }
            ScopeViewPane pane = scopeViewPane;
            if (pane.getSelectedScope() instanceof ChangeListScope) {
                pane.updateSelectedScope();
            }
        }

        private static final void updateAvailableScopesList$lambda$1(Project $project) {
            if ($project.isDisposed()) {
                return;
            }
            DependencyValidationManager.getInstance((Project)$project).fireScopeListeners();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/vcs/changes/ChangeListScopeViewUpdater$InitialRefresh;", "Lcom/intellij/openapi/vcs/changes/LocalChangeListsLoadedListener;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "processLoadedLists", "", "lists", "", "Lcom/intellij/openapi/vcs/changes/LocalChangeList;", "intellij.platform.vcs.impl"})
    public static final class InitialRefresh
    implements LocalChangeListsLoadedListener {
        @NotNull
        private final Project project;

        public InitialRefresh(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            this.project = project;
        }

        public void processLoadedLists(@NotNull List<LocalChangeList> lists) {
            Intrinsics.checkNotNullParameter(lists, (String)"lists");
            Companion.updateAvailableScopesList(this.project);
        }
    }
}

