/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.smartUpdate;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.updateSettings.impl.PluginDownloader;
import com.intellij.openapi.updateSettings.impl.PluginUpdateFacadeKt;
import com.intellij.openapi.updateSettings.impl.UpdateChecker;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.smartUpdate.IdeUpdateStepKt;
import com.intellij.smartUpdate.SmartUpdateBundle;
import com.intellij.smartUpdate.SmartUpdateDialogKt;
import com.intellij.smartUpdate.SmartUpdateStep;
import com.intellij.ui.SpinningProgressIcon;
import com.intellij.ui.components.JBLabel;
import java.awt.Component;
import java.util.Collection;
import javax.swing.Icon;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u0014\u001a\u00020\u0005H\u0003R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\u0015"}, d2={"Lcom/intellij/smartUpdate/PluginsUpdateStep;", "Lcom/intellij/smartUpdate/SmartUpdateStep;", "<init>", "()V", "id", "", "getId", "()Ljava/lang/String;", "stepName", "getStepName", "performUpdateStep", "", "project", "Lcom/intellij/openapi/project/Project;", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "onSuccess", "Lkotlin/Function0;", "getDetailsComponent", "Ljavax/swing/JComponent;", "getDescription", "intellij.smart.update"})
public final class PluginsUpdateStep
implements SmartUpdateStep {
    @NotNull
    private final String id;
    @NotNull
    private final String stepName = SmartUpdateBundle.INSTANCE.message("update.plugins", new Object[0]);

    public PluginsUpdateStep() {
        this.id = "plugins.update";
    }

    @Override
    @NotNull
    public String getId() {
        return this.id;
    }

    @Override
    @NotNull
    public String getStepName() {
        return this.stepName;
    }

    @Override
    public void performUpdateStep(@NotNull Project project, @Nullable AnActionEvent e, @NotNull Function0<Unit> onSuccess) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(onSuccess, (String)"onSuccess");
        Function0 doUpdate = () -> PluginsUpdateStep.performUpdateStep$lambda$2(onSuccess, e, project);
        if (e == null) {
            ActionCallback actionCallback = UpdateChecker.INSTANCE.getUpdates().doWhenProcessed(() -> PluginsUpdateStep.performUpdateStep$lambda$3(doUpdate));
            Intrinsics.checkNotNull((Object)actionCallback);
        } else {
            doUpdate.invoke();
        }
    }

    @Override
    @NotNull
    public JComponent getDetailsComponent(@NotNull Project project) {
        JBLabel jBLabel;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        JBLabel $this$getDetailsComponent_u24lambda_u244 = jBLabel = SmartUpdateDialogKt.hintLabel(SmartUpdateBundle.INSTANCE.message("checking.for.updates", new Object[0]));
        boolean bl = false;
        $this$getDetailsComponent_u24lambda_u244.setIcon((Icon)new SpinningProgressIcon(null, 0, 3, null));
        JBLabel label = jBLabel;
        UpdateChecker.INSTANCE.getUpdates().doWhenProcessed(() -> PluginsUpdateStep.getDetailsComponent$lambda$5(label, this));
        return (JComponent)label;
    }

    @Nls
    private final String getDescription() {
        String string;
        Object[] updates = PluginUpdateFacadeKt.getPendingUpdates();
        Object[] objectArray = updates;
        if (objectArray == null || objectArray.isEmpty()) {
            return SmartUpdateBundle.INSTANCE.message("no.updates.available", new Object[0]);
        }
        if (updates.size() == 1) {
            objectArray = new Object[]{((PluginDownloader)CollectionsKt.first((Iterable)((Iterable)updates))).getPluginName()};
            string = SmartUpdateBundle.INSTANCE.message("update.plugin", objectArray);
        } else {
            objectArray = new Object[]{updates.size()};
            string = SmartUpdateBundle.INSTANCE.message("update.several.plugins", objectArray);
        }
        return string;
    }

    private static final Unit performUpdateStep$lambda$2$lambda$1$lambda$0() {
        ApplicationManagerEx.getApplicationEx().restart(true);
        return Unit.INSTANCE;
    }

    private static final void performUpdateStep$lambda$2$lambda$1(Project $project, Function0 $onSuccess, Boolean restartRequired) {
        Intrinsics.checkNotNullParameter((Object)restartRequired, (String)"restartRequired");
        if (restartRequired.booleanValue()) {
            IdeUpdateStepKt.restartIde($project, SmartUpdateBundle.INSTANCE.message("dialog.title.plugin.updates.ready.to.install", new Object[0]), (Function0<Unit>)((Function0)PluginsUpdateStep::performUpdateStep$lambda$2$lambda$1$lambda$0));
        } else {
            $onSuccess.invoke();
        }
    }

    private static final Unit performUpdateStep$lambda$2(Function0 $onSuccess, AnActionEvent $e, Project $project) {
        Collection updates = PluginUpdateFacadeKt.getPendingUpdates();
        Collection collection = updates;
        if (collection == null || collection.isEmpty()) {
            $onSuccess.invoke();
        } else {
            AnActionEvent anActionEvent = $e;
            Component component = anActionEvent != null && (anActionEvent = anActionEvent.getDataContext()) != null ? (Component)anActionEvent.getData(PlatformDataKeys.CONTEXT_COMPONENT) : null;
            JComponent component2 = component instanceof JComponent ? (JComponent)component : null;
            PluginUpdateFacadeKt.installUpdates((Collection)updates, (JComponent)component2, arg_0 -> PluginsUpdateStep.performUpdateStep$lambda$2$lambda$1($project, $onSuccess, arg_0));
        }
        return Unit.INSTANCE;
    }

    private static final void performUpdateStep$lambda$3(Function0 $tmp0) {
        $tmp0.invoke();
    }

    private static final void getDetailsComponent$lambda$5(JBLabel $label, PluginsUpdateStep this$0) {
        $label.setText(this$0.getDescription());
        $label.setIcon(null);
    }
}

