# Format-bytes

This crate exposes a procedural macro that allows you to format bytestrings.
For more background on why you would want to do that,
[read this article](https://octobus.net/blog/2020-06-05-not-everything-is-utf8.html).

## Usage

Add this to your `Cargo.toml`:

```toml
[dependencies]
format-bytes = "0.2"
```

then use the macro like so:

```rust
use format_bytes::format_bytes;

fn main() {
    assert_eq!(
        format_bytes!(b"look at those {} bytes", &[0u8, 1, 2]),
        b"look at those \x00\x01\x02 bytes"
    );
}
```

See more examples of how it works on the documentation of
[`format_bytes!` itself](https://docs.rs/format-bytes/*/format_bytes/macro.format_bytes.html).

## Missing features

* Named arguments, but they should be added in a future version
* Python-like "f-string" functionality is not planned because of its more
complex implementation and limited actual benefit
* ``format!``-like padding helpers: if the need manifests itself, they might
appear
* ``#[no_std]`` support


## Why not 1.0?

Not until named arguments have landed and the macro gets a bit of mileage (it
will be used in [Mercurial](https://www.mercurial-scm.org)).
