/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.sandbox.util;

import com.jgoodies.components.JGFormattedTextField;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.ParseException;
import java.util.Date;
import java.util.EventObject;
import javax.swing.AbstractAction;
import javax.swing.JFormattedTextField;
import javax.swing.JPopupMenu;

public abstract class AbstractOpenMonthViewPopupAction
extends AbstractAction {
    private final JFormattedTextField textField;
    private JPopupMenu popup;
    private EventHandler handler;
    private Component invoker;
    private boolean oldIconVisibleAlways;
    private boolean oldButtonPaintedAlways;

    protected AbstractOpenMonthViewPopupAction(JFormattedTextField textField) {
        this.textField = textField;
        this.configureAction();
    }

    private void buildPopup(EventObject e) {
        this.handler = new EventHandler();
        this.textField.addPropertyChangeListener(this.handler);
        this.popup = new JPopupMenu();
        this.popup.addPropertyChangeListener(this.handler);
        this.initMonthView();
        this.configurePopup(this.popup);
        this.invoker = (Component)e.getSource();
        if (this.invoker instanceof JFormattedTextField) {
            try {
                ((JFormattedTextField)this.invoker).commitEdit();
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        this.initializeSelection();
        if (this.invoker instanceof JGFormattedTextField) {
            JGFormattedTextField field = (JGFormattedTextField)this.invoker;
            this.oldIconVisibleAlways = field.isIconVisibleAlways();
            this.oldButtonPaintedAlways = field.isButtonPaintedAlways();
            field.setIconVisibleAlways(true);
            field.setButtonPaintedAlways(true);
        }
    }

    protected abstract void initMonthView();

    protected abstract void configurePopup(JPopupMenu var1);

    protected abstract void configureAction();

    protected abstract void postVisible();

    protected abstract Date getDate();

    protected abstract void setDate(Date var1);

    protected void cleanup() {
        this.textField.removePropertyChangeListener(this.handler);
        this.popup.removePropertyChangeListener(this.handler);
        if (this.invoker instanceof JGFormattedTextField) {
            JGFormattedTextField field = (JGFormattedTextField)this.invoker;
            field.setIconVisibleAlways(this.oldIconVisibleAlways);
            field.setButtonPaintedAlways(this.oldButtonPaintedAlways);
        }
        this.invoker = null;
        this.popup = null;
        this.handler = null;
    }

    protected void initializeSelection() {
        this.updateSelection();
    }

    protected final void setToday() {
        this.setDate(new Date());
    }

    protected final EventHandler getHandler() {
        return this.handler;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.popup == null) {
            this.buildPopup(e);
        }
        if (this.popup.isVisible()) {
            this.popup.setVisible(false);
        } else {
            this.popup.show(this.invoker, 0, this.invoker.getHeight());
        }
    }

    private void updateSelection() {
        Date date = (Date)this.textField.getValue();
        if (date != null) {
            this.setDate(date);
        }
    }

    protected final void commitAndClose() {
        try {
            this.textField.setValue(this.getDate());
        }
        finally {
            if (this.popup != null) {
                this.popup.setVisible(false);
            }
        }
    }

    private final class EventHandler
    implements ActionListener,
    FocusListener,
    PropertyChangeListener {
        private EventHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            AbstractOpenMonthViewPopupAction.this.commitAndClose();
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            switch (evt.getPropertyName()) {
                case "visible": {
                    JPopupMenu thePopup = (JPopupMenu)evt.getSource();
                    boolean visible = thePopup.isVisible();
                    if (visible) {
                        AbstractOpenMonthViewPopupAction.this.postVisible();
                        break;
                    }
                    AbstractOpenMonthViewPopupAction.this.cleanup();
                    break;
                }
                case "value": {
                    AbstractOpenMonthViewPopupAction.this.updateSelection();
                    break;
                }
            }
        }

        @Override
        public void focusGained(FocusEvent e) {
        }

        @Override
        public void focusLost(FocusEvent e) {
            AbstractOpenMonthViewPopupAction.this.popup.setVisible(false);
        }
    }
}

