/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.navigation;

import com.jgoodies.common.base.Preconditions;
import com.jgoodies.common.promise.Promise;
import com.jgoodies.navigation.NavigationEventArgs;
import com.jgoodies.navigation.NavigationMode;
import com.jgoodies.navigation.Page;
import com.jgoodies.navigation.internal.BackStack;
import com.jgoodies.navigation.internal.Navigation;
import com.jgoodies.navigation.views.AbstractViewModel;
import java.awt.Component;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Stack;
import java.util.stream.Collectors;

public final class PageModel
extends AbstractViewModel<Page>
implements BackStack {
    private final Stack<PageEntry> backStack = new Stack();
    private PageEntry currentPageEntry;
    private Promise<Boolean> pendingNavigatingPromise;

    @Override
    public Page getCurrentPage() {
        return this.currentPageEntry == null ? null : this.currentPageEntry.getSourcePage();
    }

    @Override
    public Page getPreviousPage() {
        PageEntry entry = this.backStack.peek();
        return entry.getSourcePage();
    }

    public List<Page> getPages() {
        List pages = this.backStack.stream().map(PageEntry::getSourcePage).collect(Collectors.toList());
        Collections.reverse(pages);
        pages.add(0, this.getCurrentPage());
        return Collections.unmodifiableList(pages);
    }

    @Override
    public boolean canGoBack() {
        return !this.backStack.isEmpty();
    }

    public void clearBackStack() {
        this.backStack.clear();
        this.firePropertyChange("canGoBack", null, (Object)this.canGoBack());
    }

    @Override
    public Promise<Boolean> goBack(EventObject evt) {
        boolean oldCanGoBack = this.canGoBack();
        Preconditions.checkState(oldCanGoBack, "Back is not possible");
        PageEntry mostRecentEntry = this.backStack.peek();
        return this.navigate0(evt, mostRecentEntry.getSourcePage(), mostRecentEntry.getParameter(), NavigationMode.BACK);
    }

    public Promise<Boolean> navigate(EventObject evt, Page page) {
        return this.navigate(evt, page, null);
    }

    public Promise<Boolean> navigate(EventObject evt, Page page, Object parameter) {
        Preconditions.checkNotNull(page, "The %s must not be null.", "page");
        NavigationMode mode = page.getPageModel() == null ? NavigationMode.NEW : NavigationMode.FORWARD;
        return this.navigate0(evt, page, parameter, mode);
    }

    public Promise<Boolean> navigate(Component owner, Page page) {
        return this.navigate(new EventObject(owner), page);
    }

    public Promise<Boolean> navigate(Component owner, Page page, Object parameter) {
        return this.navigate(new EventObject(owner), page, parameter);
    }

    public void initialPage(Page page) {
        this.initialPage(page, null);
    }

    public void initialPage(Page page, Object parameter) {
        Preconditions.checkState(!this.canGoBack(), "When setting the initial page, the back stack must be empty.");
        this.navigate0(null, page, parameter, NavigationMode.NEW);
        this.clearBackStack();
    }

    public void refreshCurrentPage() {
        this.refreshCurrentPage(null);
    }

    public void refreshCurrentPage(Object parameter) {
        Preconditions.checkNotNull(this.getCurrentPage(), "The %s must not be null.", "current page");
        Page currentPage = this.currentPageEntry.getSourcePage();
        Object params = parameter != null ? parameter : this.currentPageEntry.getParameter();
        this.navigate0(null, currentPage, params, null);
    }

    private Promise<Boolean> navigate0(EventObject evt, Page page, Object parameter, NavigationMode mode) {
        Promise<Boolean> promise;
        Page oldPage;
        NavigationEventArgs args = new NavigationEventArgs(evt, page, parameter, mode);
        Preconditions.checkState(!Navigation.getCheckPendingNavigatingPromise() || this.pendingNavigatingPromise == null, "Illegal state: a navigating Promise is still pending. Page#onNavigatingFrom(NavigationEventArgs) implementations that want to cancel the navigation from the page shall resolve the returned Promise to false.\nPromise=" + this.pendingNavigatingPromise + "\nNavigationEventArgs=" + args);
        PageEntry newPageEntry = new PageEntry(page, parameter);
        PageEntry oldPageEntry = this.currentPageEntry;
        Page page2 = oldPage = oldPageEntry == null ? null : oldPageEntry.getSourcePage();
        if (oldPage != null && oldPage.isRefresh(page, parameter)) {
            NavigationEventArgs refreshArgs = new NavigationEventArgs(evt, page, parameter, NavigationMode.REFRESH);
            page.onNavigatedTo(refreshArgs);
            page.onLoaded(refreshArgs);
            this.currentPageEntry = newPageEntry;
            return Promise.of(true);
        }
        if (oldPage != null) {
            this.pendingNavigatingPromise = oldPage.onNavigatingFrom(args);
            promise = this.pendingNavigatingPromise;
        } else {
            promise = Promise.of(true);
        }
        Promise<Boolean> navigatingFromOldPage = promise;
        return navigatingFromOldPage.thenApply(accepted -> {
            this.pendingNavigatingPromise = null;
            if (!accepted.booleanValue()) {
                return false;
            }
            boolean oldCanGoBack = this.canGoBack();
            if (oldPage != null) {
                if (mode == NavigationMode.BACK && this.canGoBack()) {
                    this.backStack.pop();
                }
                oldPage.onNavigatedFrom(args);
            }
            if (this.currentPageEntry != null && mode != NavigationMode.BACK) {
                this.backStack.push(this.currentPageEntry);
            }
            this.currentPageEntry = newPageEntry;
            page.setPageModel(this);
            page.onNavigatedTo(args);
            this.firePropertyChange("canGoBack", oldCanGoBack, this.canGoBack());
            this.firePropertyChange("currentPage", oldPage, page);
            this.firePropertyChange("selectedView", oldPage, page);
            page.onLoaded(args);
            return true;
        });
    }

    @Override
    protected Page getSelectedView() {
        return this.getCurrentPage();
    }

    static final class PageEntry {
        private final Page sourcePage;
        private final Object parameter;

        PageEntry(Page sourcePage, Object parameter) {
            this.sourcePage = sourcePage;
            this.parameter = parameter;
        }

        Page getSourcePage() {
            return this.sourcePage;
        }

        Object getParameter() {
            return this.parameter;
        }
    }
}

