/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.navigation;

import com.jgoodies.common.base.Strings;
import com.jgoodies.common.bean.Bean;
import com.jgoodies.common.display.Displayable;
import com.jgoodies.common.display.IconDisplayable;
import com.jgoodies.common.jsdl.icon.DynamicIconValue;
import com.jgoodies.common.promise.Promise;
import com.jgoodies.navigation.IAppBar;
import com.jgoodies.navigation.NavigationEventArgs;
import com.jgoodies.navigation.PageModel;
import com.jgoodies.navigation.TabFeatures;
import com.jgoodies.navigation.internal.FocusTrackerSupport;
import com.jgoodies.navigation.internal.LazyValue;
import com.jgoodies.navigation.views.FocusTracker;
import com.jgoodies.navigation.views.View;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.EventObject;
import java.util.Objects;
import java.util.function.Supplier;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;

public interface Page
extends TabFeatures,
View,
Displayable {
    public static final String PROPERTY_PAGE_MODEL = "pageModel";

    public PageModel getPageModel();

    public void setPageModel(PageModel var1);

    public IAppBar getTopAppBar();

    public JComponent getContent();

    public IAppBar getBottomAppBar();

    @Override
    public JComponent getPanel();

    public void onNavigatedTo(NavigationEventArgs var1);

    public void onLoaded(NavigationEventArgs var1);

    public Promise<Boolean> onNavigatingFrom(NavigationEventArgs var1);

    public void onNavigatedFrom(NavigationEventArgs var1);

    default public void navigate(EventObject evt, Page page) {
        this.navigate(evt, page, null);
    }

    default public void navigate(EventObject evt, Page page, Object params) {
        this.getPageModel().navigate(evt, page, params);
    }

    default public void refresh() {
        if (this.isCurrent()) {
            this.getPageModel().refreshCurrentPage();
        }
    }

    default public boolean isCurrent() {
        return this.getPageModel() != null && this.getPageModel().getCurrentPage() == this;
    }

    default public boolean isRefresh(Page newPage, Object newParams) {
        return this.equalsPage(newPage);
    }

    default public boolean equalsPage(Page newPage) {
        return Objects.equals(this, newPage);
    }

    default public boolean equalsPageClass(Page other) {
        return other != null && this.getClass().equals(other.getClass());
    }

    default public String getPersistentPageName() {
        return this.getClass().getName();
    }

    default public String getPersistentPageParameter() {
        return null;
    }

    public static abstract class AbstractBuilder<B extends AbstractBuilder<B, P>, P extends BasicPage> {
        protected final P target;

        protected AbstractBuilder(P target) {
            this.target = target;
        }

        public B icon(Icon icon) {
            ((BasicPage)this.target).setIcon(icon);
            return (B)this;
        }

        public B icon(DynamicIconValue icon) {
            ((BasicPage)this.target).setIcon(icon);
            return (B)this;
        }

        public B displayString(String str, Object ... args) {
            ((BasicPage)this.target).setDisplayString(str, args);
            return (B)this;
        }

        public B topAppBar(IAppBar appBar) {
            ((BasicPage)this.target).setTopAppBar(appBar);
            return (B)this;
        }

        public B topAppBar(Supplier<IAppBar> appBarSupplier) {
            ((BasicPage)this.target).setTopAppBar(appBarSupplier);
            return (B)this;
        }

        public B content(JComponent content) {
            ((BasicPage)this.target).setContent(content);
            return (B)this;
        }

        public B content(Supplier<JComponent> contentSupplier) {
            ((BasicPage)this.target).setContent(contentSupplier);
            return (B)this;
        }

        public B bottomAppBar(IAppBar appBar) {
            ((BasicPage)this.target).setBottomAppBar(appBar);
            return (B)this;
        }

        public B bottomAppBar(Supplier<IAppBar> appBarSupplier) {
            ((BasicPage)this.target).setBottomAppBar(appBarSupplier);
            return (B)this;
        }

        public B initialFocusRequested(boolean b) {
            ((AbstractPage)this.target).setInitialFocusRequested(b);
            return (B)this;
        }

        protected final P buildPage() {
            return this.target;
        }
    }

    public static abstract class AbstractPage
    extends Bean
    implements Page,
    IconDisplayable,
    FocusTracker {
        private final LazyValue<IAppBar> topAppBarHolder = new LazyValue();
        private final LazyValue<JComponent> contentHolder = new LazyValue();
        private final LazyValue<IAppBar> bottomAppBarHolder = new LazyValue();
        private final FocusTrackerSupport focusTrackerSupport = new FocusTrackerSupport();
        private PageModel pageModel;
        private Icon icon;
        private String displayString;
        private JPanel panel;

        @Override
        public final PageModel getPageModel() {
            return this.pageModel;
        }

        @Override
        public final void setPageModel(PageModel newValue) {
            this.pageModel = newValue;
            this.firePropertyChange(Page.PROPERTY_PAGE_MODEL, this.pageModel, this.pageModel);
        }

        @Override
        public final Icon getIcon() {
            return this.icon;
        }

        protected void setIcon(Icon icon) {
            this.icon = icon;
            this.firePropertyChange("icon", this.icon, this.icon);
        }

        protected void setIcon(DynamicIconValue icon) {
            this.setIcon(icon.toIcon(16));
        }

        @Override
        public final String getDisplayString() {
            return this.displayString;
        }

        protected void setDisplayString(String str, Object ... args) {
            this.displayString = Strings.get(str, args);
            this.firePropertyChange("displayString", this.displayString, this.displayString);
        }

        @Override
        public final IAppBar getTopAppBar() {
            return this.topAppBarHolder.get();
        }

        protected void setTopAppBar(IAppBar appBar) {
            this.setTopAppBar(() -> appBar);
        }

        protected void setTopAppBar(Supplier<IAppBar> appBarSupplier) {
            Supplier<IAppBar> supplier = () -> {
                IAppBar appBar = (IAppBar)appBarSupplier.get();
                appBar.setLocation(IAppBar.Location.TOP);
                return appBar;
            };
            this.topAppBarHolder.set(supplier);
            this.rebuildPanel();
        }

        @Override
        public final JComponent getContent() {
            return this.contentHolder.get();
        }

        protected void setContent(JComponent content) {
            this.setContent(() -> content);
        }

        protected void setContent(Supplier<JComponent> contentSupplier) {
            this.contentHolder.set(contentSupplier);
            this.rebuildPanel();
        }

        @Override
        public final IAppBar getBottomAppBar() {
            return this.bottomAppBarHolder.get();
        }

        protected void setBottomAppBar(IAppBar appBar) {
            appBar.setLocation(IAppBar.Location.BOTTOM);
            this.setBottomAppBar(() -> appBar);
        }

        protected void setBottomAppBar(Supplier<IAppBar> appBarSupplier) {
            Supplier<IAppBar> supplier = () -> {
                IAppBar appBar = (IAppBar)appBarSupplier.get();
                appBar.setLocation(IAppBar.Location.BOTTOM);
                return appBar;
            };
            this.bottomAppBarHolder.set(supplier);
            this.rebuildPanel();
        }

        @Override
        public final JPanel getPanel() {
            if (this.panel == null) {
                this.panel = new JPanel(new BorderLayout());
                this.panel.setOpaque(false);
                this.rebuildPanel();
            }
            return this.panel;
        }

        @Override
        public void onNavigatedTo(NavigationEventArgs args) {
        }

        @Override
        public Promise<Boolean> onNavigatingFrom(NavigationEventArgs args) {
            return Promise.of(true);
        }

        @Override
        public void onLoaded(NavigationEventArgs args) {
        }

        @Override
        public void onNavigatedFrom(NavigationEventArgs event) {
        }

        @Override
        public final void navigate(EventObject evt, Page page) {
            this.navigate(evt, page, null);
        }

        @Override
        public final void requestInitialFocus() {
            this.focusTrackerSupport.requestInitialFocus(this.getContent());
        }

        public final void setInitialFocusRequested(boolean b) {
            FocusTrackerSupport.setInitialFocusRequested(this.getContent(), b);
        }

        @Override
        public final void setMostRecentFocusOwner(Component newFocusOwner) {
            if (!this.contentHolder.isEvaluated()) {
                return;
            }
            this.focusTrackerSupport.setMostRecentFocusOwner(this.getContent(), newFocusOwner);
        }

        protected final void rebuildPanel() {
            if (this.panel == null) {
                return;
            }
            this.panel.removeAll();
            this.buildInto(this.panel);
            this.panel.revalidate();
            this.panel.repaint();
        }

        protected void buildInto(JPanel panel) {
            if (this.getTopAppBar() != null) {
                panel.add((Component)this.getTopAppBar().buildPanel(), "North");
            }
            if (this.getContent() != null) {
                panel.add((Component)this.getContent(), "Center");
            }
            if (this.getBottomAppBar() != null) {
                panel.add((Component)this.getBottomAppBar().buildPanel(), "South");
            }
        }
    }

    public static class BasicPage
    extends AbstractPage {
        @Override
        public final void setIcon(Icon newValue) {
            super.setIcon(newValue);
        }

        @Override
        public final void setIcon(DynamicIconValue icon) {
            super.setIcon(icon);
        }

        @Override
        public final void setDisplayString(String str, Object ... args) {
            super.setDisplayString(str, args);
        }

        @Override
        public final void setTopAppBar(IAppBar appBar) {
            super.setTopAppBar(appBar);
        }

        @Override
        public final void setTopAppBar(Supplier<IAppBar> appBarSupplier) {
            super.setTopAppBar(appBarSupplier);
        }

        @Override
        public final void setContent(JComponent content) {
            super.setContent(content);
        }

        @Override
        public final void setContent(Supplier<JComponent> contentSupplier) {
            super.setContent(contentSupplier);
        }

        @Override
        public final void setBottomAppBar(IAppBar appBar) {
            super.setBottomAppBar(appBar);
        }

        @Override
        public final void setBottomAppBar(Supplier<IAppBar> appBarSupplier) {
            super.setBottomAppBar(appBarSupplier);
        }
    }

    public static final class Builder
    extends AbstractBuilder<Builder, BasicPage> {
        public Builder() {
            super(new BasicPage());
        }

        public BasicPage build() {
            return this.buildPage();
        }
    }
}

