/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.framework.component;

import com.jgoodies.application.Task;
import com.jgoodies.application.TaskMonitor;
import java.awt.Color;
import java.beans.PropertyChangeEvent;
import javax.swing.JComponent;

public abstract class AbstractProgressView {
    private JComponent panel;

    protected AbstractProgressView(TaskMonitor taskMonitor) {
        taskMonitor.addPropertyChangeListener(this::onTaskPropertyChange);
    }

    public synchronized JComponent getPanel() {
        if (this.panel == null) {
            this.panel = this.buildPanel();
        }
        return this.panel;
    }

    protected abstract JComponent buildPanel();

    public abstract void setMessageForeground(Color var1);

    public abstract void progressMessage(String var1);

    public abstract void progressValue(int var1);

    public abstract void progressVisible(boolean var1);

    public abstract void progressIndeterminate(boolean var1);

    private void onTaskPropertyChange(PropertyChangeEvent evt) {
        switch (evt.getPropertyName()) {
            case "started": {
                Task task = (Task)evt.getSource();
                this.progressIndeterminate(task.isProgressIndeterminate());
                this.progressMessage(task.getTitle());
                this.progressVisible(true);
                break;
            }
            case "backgroundDone": {
                this.progressVisible(false);
                this.progressValue(0);
                break;
            }
            case "message": {
                String text = (String)evt.getNewValue();
                this.progressMessage(text);
                break;
            }
            case "progress": {
                this.progressVisible(true);
                this.progressIndeterminate(false);
                this.progressValue((Integer)evt.getNewValue());
                break;
            }
            case "progressIndeterminate": {
                this.progressIndeterminate((Boolean)evt.getNewValue());
                break;
            }
        }
    }
}

