/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.fluent.pivots;

import com.jgoodies.common.base.Preconditions;
import com.jgoodies.common.base.Strings;
import com.jgoodies.common.bean.Bean;
import com.jgoodies.common.bean.ObservableBean;
import com.jgoodies.common.swing.MnemonicUtils;
import com.jgoodies.components.JGComponentFactory;
import com.jgoodies.fluent.Badge;
import com.jgoodies.layout.builder.FormBuilder;
import com.jgoodies.layout.factories.Paddings;
import com.jgoodies.navigation.internal.FocusTrackerSupport;
import com.jgoodies.navigation.internal.LazyValue;
import com.jgoodies.navigation.views.Activatable;
import com.jgoodies.navigation.views.FocusTracker;
import com.jgoodies.navigation.views.View;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.text.JTextComponent;

public interface Pivot
extends View,
Activatable,
ObservableBean {
    public static final String PROPERTY_TEXT = "text";
    public static final String PROPERTY_TOOLTIP_TEXT = "toolTipText";
    public static final String PROPERTY_BADGE = "badge";
    public static final String PROPERTY_ACCELERATOR = "accelerator";
    public static final String PROPERTY_ACCESSIBLE_NAME = "accessibleName";

    public Object getId();

    public String getText();

    public String getToolTipText();

    public Badge getBadge();

    public KeyStroke getAccelerator();

    public String getAccessibleName();

    default public String getTextWithBadge() {
        return this.getBadge() != null && this.getBadge().isPositiveNumeric() ? String.format("%s (%s)", this.getText(), this.getBadge().displayString()) : this.getText();
    }

    public static abstract class AbstractBuilder<B extends AbstractBuilder<?>> {
        private final DefaultPivot target;
        private final JGComponentFactory factory = JGComponentFactory.getCurrent();

        public AbstractBuilder() {
            this.target = new DefaultPivot();
        }

        public B id(Object id) {
            this.target.setId(id);
            return (B)this;
        }

        public B text(String str, Object ... args) {
            String mnemonicText = Strings.get(str, args);
            this.target.setText(MnemonicUtils.plainText(mnemonicText));
            return (B)this;
        }

        public B toolTipText(String str, Object ... args) {
            this.target.setToolTipText(Strings.get(str, args));
            return (B)this;
        }

        public B badge(int number) {
            return this.badge(new Badge(number));
        }

        public B badge(Badge value) {
            this.target.setBadge(value);
            return (B)this;
        }

        public B accessibleName(String str, Object ... args) {
            this.target.setAccessibleName(Strings.get(str, args));
            return (B)this;
        }

        public B accelerator(KeyStroke value) {
            this.target.setAccelerator(value);
            return (B)this;
        }

        public B accelerator(String value) {
            this.target.setAccelerator(value);
            return (B)this;
        }

        public B content(JComponent value) {
            this.target.setPanel(value);
            return (B)this;
        }

        public B content(Supplier<JComponent> valueSupplier) {
            this.target.setPanel(valueSupplier);
            return (B)this;
        }

        public B content(String str, Object ... args) {
            return this.content(AbstractBuilder.createTabContent(Strings.get(str, args)));
        }

        public B scrolledContent(JComponent content) {
            JScrollPane scrollPane = this.factory.createStrippedScrollPane(content);
            scrollPane.setOpaque(false);
            scrollPane.getViewport().setOpaque(false);
            return this.content(scrollPane);
        }

        public B onContextMenu(Consumer<MouseEvent> value) {
            this.target.setOnContextMenu(value);
            return (B)this;
        }

        protected DefaultPivot build() {
            Preconditions.checkState(Strings.isNotBlank(this.target.getText()), "You must provide a text.");
            return this.target;
        }

        private static JComponent createTabContent(String text) {
            JTextComponent staticText = JGComponentFactory.getCurrent().createStaticText(text, new Object[0]);
            return ((FormBuilder)((FormBuilder)((FormBuilder)((FormBuilder)new FormBuilder().columns("fill:pref:grow", new Object[0])).rows("t:p:g", new Object[0])).padding(Paddings.DLU14)).add(staticText).xy(1, 1)).build();
        }
    }

    public static final class Adder<B>
    extends AbstractBuilder<Adder<B>> {
        private final Function<Pivot, B> addFunction;

        Adder(Function<Pivot, B> addFunction) {
            this.addFunction = addFunction;
        }

        public B endPivot() {
            return this.addFunction.apply(this.build());
        }
    }

    public static final class Builder
    extends AbstractBuilder<Builder> {
        @Override
        public DefaultPivot build() {
            return super.build();
        }
    }

    public static class DefaultPivot
    extends Bean
    implements Pivot,
    FocusTracker {
        private final LazyValue<JComponent> panelHolder = new LazyValue();
        private final FocusTrackerSupport focusTrackerSupport = new FocusTrackerSupport();
        private Object id;
        private String text;
        private String toolTipText;
        private Badge badge = Badge.NONE;
        private KeyStroke accelerator;
        private String accessibleName;
        private Consumer<MouseEvent> onContextMenu;

        @Override
        public final Object getId() {
            return this.id != null ? this.id : this.text;
        }

        public final void setId(Object id) {
            this.id = id;
        }

        @Override
        public final String getText() {
            return this.text;
        }

        public final void setText(String newValue) {
            this.text = newValue;
            this.firePropertyChange(Pivot.PROPERTY_TEXT, this.text, this.text);
        }

        @Override
        public final String getToolTipText() {
            return this.toolTipText;
        }

        public final void setToolTipText(String newValue) {
            this.toolTipText = newValue;
            this.firePropertyChange(Pivot.PROPERTY_TOOLTIP_TEXT, this.toolTipText, this.toolTipText);
        }

        @Override
        public final Badge getBadge() {
            return this.badge;
        }

        public final void setBadge(Badge newValue) {
            this.badge = Preconditions.checkNotNull(newValue, "The %s must not be null.", Pivot.PROPERTY_BADGE);
            this.firePropertyChange(Pivot.PROPERTY_BADGE, this.badge, this.badge);
        }

        @Override
        public final String getAccessibleName() {
            if (this.accessibleName != null) {
                return this.accessibleName;
            }
            if (this.toolTipText != null) {
                return this.toolTipText;
            }
            return this.text;
        }

        public final void setAccessibleName(String newValue) {
            this.accessibleName = newValue;
            this.firePropertyChange(Pivot.PROPERTY_ACCESSIBLE_NAME, this.accessibleName, this.accessibleName);
        }

        @Override
        public final KeyStroke getAccelerator() {
            return this.accelerator;
        }

        public final void setAccelerator(KeyStroke newValue) {
            this.accelerator = newValue;
            this.firePropertyChange(Pivot.PROPERTY_ACCELERATOR, this.accelerator, this.accelerator);
        }

        public final void setAccelerator(String keyStroke) {
            this.setAccelerator(KeyStroke.getKeyStroke(keyStroke));
        }

        @Override
        public final JComponent getPanel() {
            return this.panelHolder.get();
        }

        public final void setPanel(JComponent panel) {
            this.setPanel(() -> panel);
        }

        public final void setPanel(Supplier<JComponent> panelSupplier) {
            Preconditions.checkNotNull(panelSupplier, "The %s must not be null.", "panel supplier");
            this.panelHolder.set(panelSupplier);
        }

        public final Consumer<MouseEvent> getOnContextMenu() {
            return this.onContextMenu;
        }

        public final void setOnContextMenu(Consumer<MouseEvent> handler) {
            this.onContextMenu = handler;
        }

        @Override
        public void onActivating() {
        }

        @Override
        public void onActivated() {
        }

        @Override
        public void onDeactivating() {
        }

        @Override
        public final void requestInitialFocus() {
            this.focusTrackerSupport.requestInitialFocus(this.getPanel());
        }

        @Override
        public final void setMostRecentFocusOwner(Component newFocusOwner) {
            if (!this.panelHolder.isEvaluated()) {
                return;
            }
            this.focusTrackerSupport.setMostRecentFocusOwner(this.getPanel(), newFocusOwner);
        }
    }
}

